/*
 * 对三段式第二段表格数据的操作类
 * 
 * @author s00143960 2010-4-13
 * @see
 * @since 1.0
 */

/**
 * 用于封装VMT表格的同步数据操作
 * 
 * @author 孙雁行 00143960
 * @since iManager U2000 V1R3,2010-4-17
 * @param featureForm 特性相关参数
 * @param rowKeysLst 被选中同步的数据的key值
 * @param rowIds 被选中同步的数据的rowId
 * @param isSynchronizeAll 是否为同步所有表示
 */
function SynchronizeDataOperation(statusCtrl, deviceForm, featureForm, frameParam, dataCtrl)
{
    this._statusCtrl = statusCtrl;

    this._deviceForm = deviceForm;

    this._featureForm = featureForm;

    this._frameParam = frameParam;
    
    this._dataCtrl = dataCtrl;
}

// 对话框大小
SynchronizeDataOperation.prototype.PROMPTDIALOG_HEIGHT = 320;
SynchronizeDataOperation.prototype.PROMPTDIALOG_WIDTH = 150;

SynchronizeDataOperation.prototype.setFeatureForm = function(featureForm)
{
    this._featureForm = featureForm;
}
/**
 * 同步数据执行操作
 * 
 * @author 孙雁行 00143960
 * @since iManager U2000 V1R3,2010-4-17
 */
SynchronizeDataOperation.prototype.sysSelectedRecord = function(rowKeysLst, rowIds)
{
    // 同步选中数据
    var operResult = this.synchronizeSelectedData(rowKeysLst, rowIds);

    // 处理同步单条的返回结果
    if (operResult.resultType != GlobalConstants.OPER_OK)
    {
    	var selRowIds = null;
    	if (operResult.nextOperObjs.list)
    	{
    		selRowIds = rowIds;
    	}
    	else
    	{
    		selRowIds = operResult.nextOperObjs.list;
    	}
        CommonDlgReq.openRspErrorDialog(operResult, this.callBackShowErrorInfo, this, [selRowIds]);
        return false;
    }
    else
    {
        this._dataCtrl.getLinkageCtrl().processValueChangedLinkage();
    	this._dataCtrl.handleCurrentPageNavigate(operResult.nextOperObjs.list);
    	return true;
    }
}

/**
 * 同步选中数据方法
 * 
 * @author 孙雁行 00143960
 * @since iManager U2000 V1R3,2010-4-17
 */
SynchronizeDataOperation.prototype.synchronizeSelectedData = function(rowKeysLst, rowIds)
{
    var jsonRowIds = JsonUtil.changJsonList(rowIds);
    var jsonRowKeysLst = JsonUtil.changJsonListP(rowKeysLst);
    var jsonColumns = this._dataCtrl.getJonsColumnInfos();
    var operResult = jsonrpc.invoke("dataTableFactory", "synchronizeData", [ this._deviceForm, this._featureForm,
            this._frameParam, jsonRowKeysLst, jsonRowIds ,jsonColumns]);

    return operResult;
}

/**
 * 同步数据执行操作
 * 
 * @author 孙雁行 00143960
 * @since iManager U2000 V1R3,2010-4-17
 */
SynchronizeDataOperation.prototype.sysActionSelectedRecord = function(rowKeysLst, rowIds)
{
    // 同步选中数据
    var operResult = this.synchronizeActionSelectedData(rowKeysLst, rowIds);

    // 处理同步单条的返回结果
    if (operResult.resultType != GlobalConstants.OPER_OK)
    {
    	var selRowIds = rowIds;

        // 如果是查询到的数据为空
        var operErrorInfos = operResult.errors.list;

        if ((operErrorInfos.length == 1) && (operErrorInfos[0].errorCode == 1107525808))
        {
            this.callBackShowErrorInfo(selRowIds);
            return true;
        }
        else
        {
            CommonDlgReq.openRspErrorDialog(operResult, this.callBackShowErrorInfo, this, [ selRowIds ]);
            return false;
        }
    }
    else
    {
        this._dataCtrl.getLinkageCtrl().processValueChangedLinkage();
    	this._dataCtrl.handleCurrentPageNavigate(operResult.nextOperObjs.list);
    	return true;
    }
}

/**
 * 同步选中数据方法
 * 
 * @author 孙雁行 00143960
 * @since iManager U2000 V1R3,2010-4-17
 */
SynchronizeDataOperation.prototype.synchronizeActionSelectedData = function(rowKeysLst, rowIds)
{
    var jsonRowIds = JsonUtil.changJsonList(rowIds);
    var jsonRowKeysLst = JsonUtil.changJsonListP(rowKeysLst);
    var jsonColumns = this._dataCtrl.getJonsColumnInfos();

    var operResult = jsonrpc.invoke("actionSynDataTableFactory", "synchronizeData", [ this._deviceForm, this._featureForm,
            this._frameParam, jsonRowKeysLst, jsonRowIds ,jsonColumns]);

    return operResult;
}

/**
 * 同步选中数据方法
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-10-17
 */
SynchronizeDataOperation.prototype.callBackShowErrorInfo = function(selectRowIds)
{
	this._dataCtrl.handleCurrentPageNavigate(selectRowIds);
}
