/**
 * pingtrace配置初始化表格操作类
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 * @param treeTable 树表对象
 * @param treeModel 树表模型
 * @param treeTableStatus 树表中控件的状
 * @param linkageCtrl 联动对象
 * @param guiCustomizeProcessor 界面定制处理
 * @param featureData 全局数据
 * @return
 */
function PingTraceTreeInitOper(treeTable, treeModel, treeTableStatus, linkageCtrl, verifyCtrl, focuseOper,
        guiCustomizeProcessor, featureData, id, configCtrl)
{
    TreeTableInitOper.call(this, treeTable, treeModel, treeTableStatus, linkageCtrl, focuseOper, guiCustomizeProcessor);
    this._featureData = featureData;
    this._id = id;
    this._verifyCtrl = verifyCtrl;
    
    /**
     * 第二段数据模型
     */
    this._dataCtrl = null;
    
    this._configCtrl = configCtrl;
    
    this._configData = null;
    
    this._pingTraceDataModel = null;
}

PingTraceTreeInitOper.prototype = new TreeTableInitOper();

/**
 * 设置页面的焦点操
 * 
 * @author l00133618
 * @since iManager U2000 V2R1, 2013-5-20
 */
PingTraceTreeInitOper.prototype.setFocuseOper = function(focusOper)
{
    this._focusOper = focusOper;
}

/**
 * 初始化树
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 * @return
 */
PingTraceTreeInitOper.prototype.initTableTreeView = function(featureData)
{
    this._treeTable.removeAllRows();
    this._treeTable.setTableWidth();
    this.jsonInitTreeTableView();
}

/**
 * 请求配置树表的Json
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 * @return
 */
PingTraceTreeInitOper.prototype.jsonInitTreeTableView = function()
{
    var featureForm = this._featureData.getFeatureForm();
    var frameForm = this._featureData.getFrameParam();
    var deviceForm = this._featureData.getDeviceForm(); 
    
    var jsonSelectNodes = null;
    if(null != this._dataCtrl)
    {
    	jsonSelectNodes = this._dataCtrl.getJsonSelectedNodes();
    }
    jsonrpc.asynInvokeWaiting("pingTraceTreeTableViewFactory", "generateInitView", [ deviceForm, featureForm, featureForm,
            jsonSelectNodes, this._id, this._configCtrl._initParamInfo ], this._doCallBack, this, []);
}

/**
 * 
 * 处理后台返回内容
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 * @return
 */
PingTraceTreeInitOper.prototype._doCallBack = function(operResult)
{
    this._treeTable.removeAllRows();
    if (null == operResult)
    {
        return;
    }

    if (operResult.resultType != GlobalConstants.OPER_OK)
    {
        CommonDlgReq.openRspErrorDialog(operResult, null, null);
        return false;
    }

    if (null != this._linkageCtrl)
    {
        this._linkageCtrl.setLinkageTableColIds(this.getLinkageColIds());
    }

    this._doSuccessResult(operResult);
}

/**
 * 
 * 当返回值成功时处理,刷新表格
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 * @return
 */
PingTraceTreeInitOper.prototype._doSuccessResult = function(operResult)
{
    this._treeTable.removeAllRows();
    this._configCtrl._resultTable.removeAllRows();
    this._configCtrl._resultDetailTable.removeAllRows(); 
    
    var returnObj = operResult.returnObj; 
    this._pingTraceDataModel = returnObj;
    this._configCtrl._mainKeyId = returnObj.mainKeyId;
    var configData = returnObj.configData;
    this._configCtrl._configData = configData; 
    var testParmData = returnObj.testParmData;
    var resultDetailData = returnObj.resultDetailData;
    var resultData = returnObj.resultData;  
    
    var tableData = testParmData.tableRowsDataMap.map;
    var featureLst = testParmData.featureSequences.list;
    var guiData = configData.guiData; 
    
    this._configCtrl.initWidget();  
// this._treeModel.initMutilTreeTableModel(featureLst);
// this._refreshFeatureData(featureLst);
    this._initVerification(testParmData); 
    this._addTreeTableData(tableData, featureLst);
    this._setDefaultValue(testParmData); 
    this._setSupportComboItemsValue(guiData); 
    this._initResultDetailTable(resultDetailData, guiData);
    this._initResultTable(resultData, guiData);
}

/**
 * 设置combo值
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceTreeInitOper.prototype._setSupportComboItemsValue = function(guiData)
{
    var testParms = guiData.testParms.list;
    var colId = "value"
    for ( var i = 0; i < testParms.length; i++)
    {
        var testParm = testParms[i];
        var testParmAttrs = testParm.testParmAttrs.list;
        for ( var j = 0; j < testParmAttrs.length; j++)
        {
            var testParmAttr = testParmAttrs[j];
            var xpath = testParmAttr.attrXpath;
            var value = testParmAttr.supportComboItems;
            if(null == value || "" == value)
            {
                continue;
            }
            
            var operRowId = ConfigUtil.getRowId(xpath) + "@xp_la@_0";  
            var cell = this._treeTable.getCell(operRowId, colId); 
            var oldValue = this._treeTable.getCellValue(operRowId, "value");
            var newValue = "";
            var comboItems = value.split(",");
            var itemArray = new Array();
            var tem = null;
            
            var parentRowId = this._treeTable.getNodeIdFromAttributeId(operRowId);
            var comboItemMap = this._treeTable.getTableModel().getAttributeComboItemMap(operRowId, parentRowId,"value");
            if(null == comboItemMap)
            {
                return;        
            }
            
            var rowXpath = ConfigUtil.getNodeXpath(operRowId, SEPARATOR_XPATH_LABEL);
            
            for ( var i = 0; i < comboItems.length; i++)
            {
                var itemValue = comboItemMap.get(comboItems[i]);
                if(null == itemValue)
                {
                    continue;            
                }
                var itemText = FeaturesResourceMgr.getChoiceItemText(rowXpath, itemValue);
                var itemTooltip = FeaturesResourceMgr.getChoiceResTooltip(rowXpath, itemValue);
                tem =
                {
                    id :comboItems[i],
                    text :itemText,
                    tooltip :itemTooltip
                };

                itemArray.push(tem);
                if (oldValue == comboItems[i])
                {
                    newValue = oldValue;
                }
            }
            cell.items = itemArray;
            this._treeTable.setCell(operRowId, colId, cell)
            this._treeTable.setCellValue(operRowId, colId, newValue);
        }
    }
}


/**
 * 初始化汇总信息
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceTreeInitOper.prototype._setDefaultValue = function(testParmData)
{
    var treeTableDefaultValueMap = testParmData.treeTableDefaultValueMap.map;  
    for ( var xpath in treeTableDefaultValueMap)
    {
        var value = treeTableDefaultValueMap[xpath];
        if(null != value)
        {
            var rowId = ConfigUtil.getRowId(xpath) + "@xp_la@_0"; 
            this._treeTable.setCellValue(rowId, "value", value);    
        }
    }
}

/**
 * 初始化详细信息
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceTreeInitOper.prototype._initResultDetailTable = function(resultDetailData, guiData)
{
    var objXpath = guiData.resultDetail.objXpath; 
    var featureName = Resource.getFeatureNameFromObjXpath(objXpath);
    
    var featureForm = this._featureData.getFeatureForm();
    featureForm.featureName = featureName;
    featureForm.xpath = objXpath;
    this._featureData.setFeatureForm(featureForm);
    
    // 初始化列信息
    this._configCtrl._resultDetailTable.initColumns(resultDetailData.columns, featureName);  
}

/**
 * 初始化汇总信息
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceTreeInitOper.prototype._initResultTable = function(resultData, guiData)
{
    var objXpath = guiData.result.objXpath; 
    var rowDataMap = resultData.rowDataMap.map;  
    var resultAttrs = guiData.result.resultAttrs.list; 
    for ( var i = 0; i < resultAttrs.length; i++)
    {
        var resultAttr = resultAttrs[i];
        var xpath = resultAttr.attrXpath;
        var value = rowDataMap[xpath]; 
        if(null == value)
        {
            continue;
        }
        
        var res = FeaturesResourceMgr.getSchemaResource(xpath); 
        var rowId = ConfigUtil.getRowId(xpath);
        this._configCtrl._resultTable._table.addRow(rowId,
        {
            property :res, 
            value :""
        }); 
    }
}


/**
 * 清除汇总信息
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceTreeInitOper.prototype._clearResultTable = function(resultData, guiData)
{
    var objXpath = guiData.result.objXpath; 
    var rowDataMap = resultData.rowDataMap.map;  
    var resultAttrs = guiData.result.resultAttrs.list; 
    for ( var i = 0; i < resultAttrs.length; i++)
    {
        var resultAttr = resultAttrs[i];
        var xpath = resultAttr.attrXpath;
        var value = rowDataMap[xpath]; 
        if(null == value)
        {
            continue;
        }
        
        var res = FeaturesResourceMgr.getSchemaResource(xpath); 
        var rowId = ConfigUtil.getRowId(xpath);
        this._configCtrl._resultTable._table.setCell(rowId, "value", "");  
    }
}

/**
 * 刷新特性信
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 * @param featureLst 特性列
 */
PingTraceTreeInitOper.prototype._refreshFeatureData = function(featureLst)
{
    var featureFormMap = new Map();
    for ( var i = 0; i < featureLst.length; i++)
    {
        var featureForm = new FeatureForm();
        featureForm.featureName = featureLst[i];
        featureForm.xpath = "/" + featureForm.featureName;

        // 初始化featureMap
        featureFormMap.put(featureLst[i], featureForm);
    }
    this._featureData.setFeatureForm(featureFormMap);
    this._treeModel.initMutilFeatureData(this._featureData);
}

/**
 * 初始化校验信
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 * @param returnObj
 */
PingTraceTreeInitOper.prototype._initVerification = function(testParmData)
{
    var verificationMap = testParmData.verificationInfosMap.map;
    var verifications = [];

    for ( var member in verificationMap)
    {
        var featureItems = verificationMap[member];
        for ( var i = 0; i < featureItems.list.length; i++)
        {
            verifications.push(featureItems.list[i]);
        }
    }
    var verification = new Verifications();
    verification.init(verifications);

    // 设置校验信息
    this._verifyCtrl.setVerifications(verification);
}

/**
 * 
 * 当返回值成功时处理,刷新表格
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 * @return
 */
PingTraceTreeInitOper.prototype._addTreeTableData = function(tableData, featureLst)
{
    var index = 0;
    var task = null;

    for ( var member in featureLst)
    {
// this._treeModel.setCurrFeatureName(featureLst[member]);
// this._treeModel.add2FeatureLst(index, featureLst[member]);
// index++;
        for ( var i = 0; i < tableData[featureLst[member]].list.length; i++)
        {
            var rowData = tableData[featureLst[member]].list[i];

            // 插入查询结点
            var currentNode = this._treeModel.addTreeTableModeData(rowData, false, rowData.operationType);
            this._treeTable.addTreeTableNode(currentNode, false);
        }
    }
}

// ///////////////////////////////////////////////////////////////

/**
 * ping trace的下发操作类（树表界面）
 * 
 * @author l00133618
 * @since iManager U2000 V2R1, 2013-5-20
 */
function PingTraceTreeSendOper(treeTable, treeModel, featureData, modelNodeCloneStrategy, dataCtrl, modelChecker)
{
    TreeTableSendOper.call(this, treeTable, treeModel, featureData, modelNodeCloneStrategy, modelChecker);

    /**
     * 第二段数据模型
     */
    this._dataCtrl = dataCtrl;
    
    this._configCtrl = null;
    
    this._timeOut = PingTraceTreeSendOper.INVALID_TIME_OUT;
    
    this._interval = PingTraceTreeSendOper.DEFAULT_INTERVAL;  
    
    this._isStopTest = [];
}

/**
 * 继承TreeTableSendOper
 */
PingTraceTreeSendOper.prototype = new TreeTableSendOper();

PingTraceTreeSendOper.DEFAULT_TIME_OUT = 60;

PingTraceTreeSendOper.DEFAULT_INTERVAL = 3; 

PingTraceTreeSendOper.INVALID_TIME_OUT = -1;

PingTraceTreeSendOper.FINISHED_STATUS = "1";

/**
 * 下发数据
 * 
 * @author l00133618
 * @since iManager U2000 V2R1, 2013-5-20
 */
PingTraceTreeSendOper.prototype.jsonCommitConfig = function()
{
    var nodes = this._modelNodeCloneStrategy.getModelCloneNodes();
    var jNodes = JsonUtil.changJsonList(nodes);
    var jLabels = JsonUtil.changJsonList(this._commitLabels.getNodeLabels()); 
    var featureForm = this._featureData.getFeatureForm();
    var frameForm = this._featureData.getFrameParam();
    var deviceForm = this._featureData.getDeviceForm();
    
    var jsonSelectRowKeys = null;
    if(null != this._dataCtrl)
    {
        var selectRowKeys = this._dataCtrl.getTableModel().getSelectRowKeys();
        jsonSelectRowKeys = JsonUtil.changJsonListP(selectRowKeys);
    }
    
    var operResult = jsonrpc.invokeWithoutMask("pingTraceTreeTableViewFactory", "sendStartTest", 
            [ deviceForm, featureForm, frameForm, jsonSelectRowKeys, jNodes, jLabels, this._configCtrl._id, this._configCtrl._mainKeyId]);
   
    if(null == operResult)
    {
        return null;
    }
    
    if (operResult != null && operResult.resultType != GlobalConstants.OPER_OK)
    {
        return operResult;    
    }
    
    this._timeOut = operResult.returnObj.timeOutTime; 
    this._interval = operResult.returnObj.intervalTime;
    var index = this._isStopTest.length;
    this._isStopTest[index] = false;
	TimeOperation.doObjSetTimeout(this, this._queryTestResultInfo, [deviceForm, featureForm, frameForm, index], this._interval * 1000);

    return operResult;
}

/**
 * 通过定时器方式获取表格行数据
 * 
 * @author l00133618
 * @since iManager U2000 V2R1, 2013-5-20
 */
PingTraceTreeSendOper.prototype._queryTestResultInfo = function(deviceForm, featureForm, frameForm, index) 
{
    if(this._isStopTest[index])
    {
    	if(index == (this._isStopTest.length - 1))
    	{
        this._configCtrl.startEnableStatus(); 
    	}
        return; 
    }
    
    var operResult = jsonrpc.invokeWithoutMask("pingTraceTreeTableViewFactory", "queryTestResultInfo", 
            [ deviceForm, featureForm, frameForm,  this._configCtrl._id, this._configCtrl._mainKeyId, this._timeOut]); 
    
    this._timeOut = this._timeOut - this._interval; 
    
    if (operResult != null && operResult.resultType != GlobalConstants.OPER_OK)
    {
        this._configCtrl.startEnableStatus();
        
        CommonDlgReq.openRspErrorDialog(operResult, null, null);
        return;  
    }
    
    this.refreshView(operResult, index);     
    
    if(operResult.returnObj.resultData.status == PingTraceTreeSendOper.FINISHED_STATUS)
    {
        this._configCtrl.startEnableStatus();
        return;
    }
    
    TimeOperation.doObjSetTimeout(this, this._queryTestResultInfo, [deviceForm, featureForm, frameForm, index], this._interval * 1000);  
}

/**
 * 刷新界面
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceTreeSendOper.prototype.refreshView = function(operResult, index)
{
    if(null == operResult)
    {
        this._isStopTest[index] = true;
        return;
    }
    
    var pingTraceDataModel = operResult.returnObj;
    var resultDetailData = pingTraceDataModel.resultDetailData;
    var resultData = pingTraceDataModel.resultData;
    this._freshResultDetailTable(resultDetailData, this._configCtrl._configData.guiData);
    this._freshResultTable(resultData, this._configCtrl._configData.guiData); 
}

/**
 * 刷新汇总信息
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceTreeSendOper.prototype._freshResultTable = function(resultData, guiData)
{
    if(resultData.status != PingTraceTreeSendOper.FINISHED_STATUS)
    {
        return;
    }
    
    var rowDataMap = resultData.rowDataMap.map;  
    var resultAttrs = guiData.result.resultAttrs.list; 
    for ( var i = 0; i < resultAttrs.length; i++)
    {
        var resultAttr = resultAttrs[i];
        var xpath = resultAttr.attrXpath;
        var value = rowDataMap[xpath];
        if(null != value)
        {
            var rowId = ConfigUtil.getRowId(xpath);
            this._configCtrl._resultTable._table.setCell(rowId, "value", value); 
        }
    }
}

/**
 * 刷新详细信息表
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceTreeSendOper.prototype._freshResultDetailTable = function(resultDetailData, guiData)
{
    var TableResultDetail = window.xui.getWidget("TableResultDetail");
    var objXpath = guiData.resultDetail.objXpath; 
    var rowDatas = resultDetailData.rowDatas.list; 
    for ( var i = 0; i < rowDatas.length; i++)
    {
        eval('var row' + rowDatas[i].rowID + '= "' + rowDatas[i].rowID + '"');
        var rowData = 'TableResultDetail.addRow(' + 'row' + rowDatas[i].rowID + ', ' +  this._getResultDetailTableRowObj(rowDatas[i]) + ')';
        eval(rowData);
    }
    if(rowDatas.length > 0)
    {
        TableResultDetail.setCurrentSelection(rowDatas[rowDatas.length - 1].rowID); 
    }
}

/**
 * 获取详细信息列对象
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceTreeSendOper.prototype._getResultDetailTableRowObj = function(rowData)
{
    var columnCells = rowData.cells.list;
    var rowObj = '{';
    for ( var i = 0; i < columnCells.length; i++)
    {
        if(i == columnCells.length-1)
        {
            rowObj = rowObj + ( columnCells[i].columnId + ':' + columnCells[i].value);
        }
        else
        {
            rowObj = rowObj + ( columnCells[i].columnId + ':' + columnCells[i].value + ',' );  
        }
    }
    rowObj = rowObj + '}'; 
    return rowObj;
}


/**
 * 下发停止测试
 * 
 * @author l00133618
 * @since iManager U2000 V2R1, 2013-5-20
 */
PingTraceTreeSendOper.prototype.sendSopTest = function()
{
   var index = this._isStopTest.length;
   this._isStopTest[index - 1] = true;
   var nodes = this._modelNodeCloneStrategy.getModelCloneNodes();
   var jNodes = JsonUtil.changJsonList(nodes);
   
   var featureForm = this._featureData.getFeatureForm(); 
   var frameForm = this._featureData.getFrameParam();
   var deviceForm = this._featureData.getDeviceForm();
   
    var operResult = jsonrpc.invokeWithoutMask("pingTraceTreeTableViewFactory", "sendStopTest", 
            [ deviceForm, featureForm, frameForm, jNodes, this._configCtrl._id, this._configCtrl._mainKeyId]);
    
    if (null == operResult)
    {
        return false;
    }
    
    if (operResult != null && operResult.resultType != GlobalConstants.OPER_OK)
    {
        CommonDlgReq.openRspErrorDialog(operResult, null, null);
        return false;
    }
    this._queryTestResultInfo(deviceForm, featureForm, frameForm, index);
    
    jsonrpc.invokeWithoutMask("pingTraceTreeTableViewFactory", "sendClearTest", 
            [ deviceForm, featureForm, frameForm, this._configCtrl._id, this._configCtrl._mainKeyId, 1]);
    
    return true;
}


/**
 * 下发清除测试
 * 
 * @author l00133618
 * @since iManager U2000 V2R1, 2013-5-20
 */
PingTraceTreeSendOper.prototype.sendClearTest = function()
{
   var remainTime =  this._timeOut; 
   this._isStopTest = [];
   
   var featureForm = this._featureData.getFeatureForm(); 
   var frameForm = this._featureData.getFrameParam();
   var deviceForm = this._featureData.getDeviceForm();
   
    jsonrpc.invokeWithoutMask("pingTraceTreeTableViewFactory", "sendClearTest", 
            [ deviceForm, featureForm, frameForm, this._configCtrl._id, this._configCtrl._mainKeyId, remainTime]);
}

