////////////////////////////////////////////////////
/**
 * pingtrace配置界面的各种操作
 * 
* @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 * @return
 */
function PingTraceConfigController()
{
    ConfigController.call(this);
    
    /**
     * 底层页面事件处理类
     */
    this._configCtrl = null;
    
    /**
     * pingtrace id
     */
    this._id = null; 
    
    this._initParamInfo = null;
    
    this._mainKeyId = null; 
    
    this._configData = null;
    
    /**
     * 汇总信息表格模型
     */
    this._resultTableModel = null;
    
    /**
     * 汇总信息表格
     */
    this._resultTable = null; 
    
    /**
     * 详细信息表格模型
     */
    this._resultDetailTableModel = null;

    /**
     * 详细信息表格
     */
    this._resultDetailTable = null;    
    
    this._sendConfigOperation = null;
    
    this._configViewLoader = null;
}

/**
 * PingTraceConfigController类继承ConfigController
 * 
* @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 * @return
 */
PingTraceConfigController.prototype = new ConfigController();

/**
 * 设置底层页面事件处理类
 * 
* @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceConfigController.prototype.setConfigCtrl = function(configCtrl)
{
    this._configCtrl = configCtrl;
}


/**
 * 设置pingtrace id
 * 
* @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceConfigController.prototype.setId = function(id)
{
    this._id = id;
}

/**
 * 获取pingtrace id
 * 
* @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceConfigController.prototype.getId = function()
{
    return this._id; 
}


/**
 * 设置汇总信息表格模型
 * 
* @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceConfigController.prototype.setResultTableModel = function(resultTableModel)
{
    this._resultTableModel = resultTableModel;
}

/**
 * 获取汇总信息表格模型
 * 
* @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceConfigController.prototype.getResultTableModel = function()
{
    return this._resultTableModel; 
}


/**
 * 设置汇总信息表格
 * 
* @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceConfigController.prototype.setResultTable = function(resultTable)
{
    this._resultTable = resultTable;
}

/**
 * 获取汇总信息表格
 * 
* @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceConfigController.prototype.getResultTable = function()
{
    return this._resultTable; 
}


/**
 * 获取底层页面事件处理类
 * 
* @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 * @return
 */
PingTraceConfigController.prototype.getConfigCtrl = function()
{
    return this._configCtrl;
}


/**
 * 设置如下按钮状态
 * 
* @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 * @param status 状态
 */
PingTraceConfigController.prototype.setToolButtonStatus = function(status)
{
}

/**
 * 覆盖方法：获取硬件规格控制类,模板新建、修改、克隆界面不支持硬件规格
 * 
* @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 * @override
 */
PingTraceConfigController.prototype.getHardDiffCtrl = function()
{
    return null;
}

/**
 * 初始化树表
 * 
* @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceConfigController.prototype.initTableTree = function()
{
    var focuseOper = new NoKeyDefaultFocusOper(this._treeTable, this._treeModel, this._refSelectControler,
            this._treeTableStatus);
    
    this._initTreeTableView = new PingTraceTreeInitOper(this._treeTable, this._treeModel, this._treeTableStatus,
            this._linkageCtrl, this._verifyCtrl, focuseOper, this._guiCustomizeProcessor, this._featureData,
             this._id, this);   
    
    this._initTreeTableView._dataCtrl = this._dataCtrl;
    
    this._initTreeTableView.initTableTreeView(this._featureData);
}
/**
*点击另存为按钮
*/
PingTraceConfigController.prototype.doClickSaveas = function()
{
    var featureForm = this._featureData.getFeatureForm(); 
    var frameForm = this._featureData.getFrameParam();
    var deviceForm = this._featureData.getDeviceForm();
	
	var top = jse.topWin;
    deviceForm.deviceName = top.devName;
     var zoneInfo = 
    {
    	tzOffset: top.tzOffset+"",
    	tzId: top.tzId+"",
    	zonePattern: top.zonePattern.zonePattern+""
    
    }
    
    
    var resultObj = jsonrpc.invoke("pingTraceTreeTableViewFactory", "saveAsTest", [ deviceForm, featureForm, frameForm, zoneInfo,jse.getLanguage(), this._mainKeyId ]);
    if (null != resultObj)
    {
        openSaveDialog(resultObj);
    }
}

/**
 * export特性列表的回调函数.
 */
function openSaveDialog(operResult)
{
	if (operResult.resultType == GlobalConstants.OPER_OK)
	{
		var exportTmpFileName = operResult.returnObj;
	    var dailogTitle = jse.getI18nValue("qat:public", "dailog.downloadfile_d");
	    VMTExport(exportTmpFileName, dailogTitle);
	}
}

/**
 * 点击确定按钮进行下发
 * 
* @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 * @param isShow 为true时显示进度条，为false时不显示进度条
 */
PingTraceConfigController.prototype.clickStartTestBtn = function()
{
    this._resultDetailTable.removeAllRows();  
    var pingTraceDataModel = this._initTreeTableView._pingTraceDataModel;
    var resultData = pingTraceDataModel.resultData;
    var resultData = pingTraceDataModel.resultData;
    var guiData = pingTraceDataModel.configData.guiData;   
    this._initTreeTableView._clearResultTable(resultData, guiData); 
    
    this.stopEnableStatus();  
    var result = this.sendConfigData();
    if (!result)
    {
        this.startEnableStatus(); 
    }
}

/**
 * 启动测试可用状态
 * 
* @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceConfigController.prototype.startEnableStatus = function()
{
    this._configViewLoader._startTestBtn.setEnabled(true);
    
//    if(!this._configData.guiData.resData.stopTestSupport)
//    {
        this._configViewLoader._stopTestBtn.setEnabled(false); 
        this._configViewLoader._saveAsBtn.setEnabled(true);
//    }
}

/**
 * 停止测试可用状态
 * 
* @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceConfigController.prototype.stopEnableStatus = function()
{
    this._configViewLoader._startTestBtn.setEnabled(false);
    this._configViewLoader._saveAsBtn.setEnabled(false);
    
    this._configViewLoader._stopTestBtn.setEnabled(this._configData.guiData.resData.stopTestSupport);       
}


/**
 * 初始化界面控件widget
 * 
* @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceConfigController.prototype.initWidget = function()
{
    var resData = this._configData.guiData.resData;   
    var testParmCaption = null != resData.testParmCaption ? resData.testParmCaption : "lable_testparm_d";
    this._configViewLoader._testparmCap.setText(jse.getI18nValue("qat:public", testParmCaption)); 

    var resultDetailCaption = null != resData.resultDetailCaption ? resData.resultDetailCaption : "lable_resultdetail_d";
    this._configViewLoader._resultdetailCap.setText(jse.getI18nValue("qat:public", resultDetailCaption)); 
    
    var resultCaption = null != resData.resultCaption ? resData.resultCaption : "lable_result_d";
    this._configViewLoader._resultCap.setText(jse.getI18nValue("qat:public", resultCaption)); 
    
    var startTestBtnCaption = null != resData.startTestBtnCaption ? resData.startTestBtnCaption : "button.starttest_d";
    this._configViewLoader._startTestBtn.setText(jse.getI18nValue("qat:public", startTestBtnCaption));  
    
    var stopTestBtnCaption = null != resData.stopTestBtnCaption ? resData.stopTestBtnCaption : "button.stoptest_d";
    this._configViewLoader._stopTestBtn.setText(jse.getI18nValue("qat:public", stopTestBtnCaption));  
    
    var saveAsBtnCaption = null != resData.saveAsBtnCaption ? resData.saveAsBtnCaption : "button.saveas_d";
    this._configViewLoader._saveAsBtn.setText(jse.getI18nValue("qat:public", saveAsBtnCaption));  
    
    if(!resData.stopTestSupport) 
    {
        this._configViewLoader._stopTestBtn.setEnabled(false);       
    }
}



/**
 * 点击确定按钮进行下发
 * 
* @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 * @param isShow 为true时显示进度条，为false时不显示进度条
 */
PingTraceConfigController.prototype.clickStopTestBtn = function()
{
    this.startEnableStatus(); 
    var result = this._sendConfigOperation.sendSopTest();  
    if (!result)
    {
        this.stopEnableStatus(); 
    }
}

/**
 * 下发数据
 * 
* @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceConfigController.prototype.sendConfigData = function()
{
    if (null == this._sendConfigOperation)
    {
        var modelChecker = this._verifyCtrl.createNullAndKeyChecker();
        var modelNodeCloneStrategy = new CloneAllAttriStrategy(this._treeTable, this._treeModel, this._treeTable.VALUECOLID);
        this._sendConfigOperation = new PingTraceTreeSendOper(this._treeTable, this._treeModel, this._featureData,
                modelNodeCloneStrategy, this._dataCtrl, modelChecker);
        
        this._sendConfigOperation._configCtrl = this;
    }
    return this._sendConfigOperation.checkDataAndSendConfig(this._linkageCtrl, null, null);
}

/**
 * 校验数据
 * 
* @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceConfigController.prototype.checkData = function()
{
    return this._sendConfigOperation.checkData();
}

/**
 * 树表内属性行的值发生变化.
 * 
 * @param rowId 值发生变化的行Id
 * @param colId 值发生变化的列Id
 * @param value 值发生变化的单元格的值（资源值）
 */
PingTraceConfigController.prototype._valueChange = function(rowId, colId, value)
{
    this.processButtonStatus();
    // 校验是否合法
    var legal = this._verifyCtrl.verify(rowId, colId, value);
    //检验不通过弹出提示框
    if(!legal)
    {
        if(null != this._okButton)
        {
        this._okButton.setEnabled(false);
        this._okButton.button.blur();
        this._applyButton.setEnabled(false);
        this._applyButton.button.blur();
        }
        var rowXpath = ConfigUtil.getNodeXpath(rowId, SEPARATOR_XPATH_LABEL);
        var tempFeatureName = FeaturesResourceMgr.getFeatureNameFromXpath(rowXpath);
        var value = Resource.getXpathResource(tempFeatureName, rowXpath + "_d");
        var tempMess = value + jse.getI18nValue("qat:public", "label.invalid_d");
        CommonDlgReq.openAlertDialog(tempMess, this.alertClose, this, [this._treeTable, null, null, rowId, colId]);
        this._treeTable._tableGrid.setCellBackgroundColor(rowId, colId, NOTLEGAL_COLOR);
        return;
    }

//    this._treeTable.setCellLegalColor(rowId, colId, legal);
    // 处理硬件规格
    var hardDiffCtrl = this.getHardDiffCtrl();
    if (null != hardDiffCtrl)
    {
        hardDiffCtrl.processValueChangedEvent(rowId, value);
    }
    // 处理联动
    if (null != this._linkageCtrl)
    {
        this._linkageCtrl.processValueChangedLinkage(rowId, colId, value);
    }
    //处理自动填充
    var autofillCtrl = this.getAutofillCtrl();
    if(null != autofillCtrl)
    {
        autofillCtrl.processValueChangedAutofill(rowId, colId, value);
    }
}

/**
 * 关闭对话框调用方法,关闭前重置控件状态
 * 
* @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceConfigController.prototype.closeSelfView = function()
{
    var resultDetailColIds = this._resultDetailTable.getAllColumnIds();
    // 移除列信息
    this._resultDetailTable.removeColumns(resultDetailColIds); 
    
    if(null != this._sendConfigOperation)
    {
        this._sendConfigOperation.sendClearTest();    
    }
    
//    this._treeTableStatus.resetWidgetState(); 
    jse.closeSelfView();
}
