/**
 * ping trace配置界面的初始化类
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 * @return
 */
function PingTraceConfigViewLoader()
{
    LoaderTemplate.call(this);

    /**
     * 测试类id
     */
    this._id = null;

    this._initParamInfo = null;
    
    /**
     * 汇总信息表格模型
     */
    this._resultTableModel = null;

    /**
     * 汇总信息表格
     */
    this._resultTable = null;

    /**
     * 详细信息表格模型
     */
    this._resultDetailTableModel = null;

    /**
     * 详细信息表格
     */
    this._resultDetailTable = null;

    this._startTestBtn = null;
    this._stopTestBtn = null;
    this._saveAsBtn = null;

    this._testparmCap = null;
    this._resultdetailCap = null;
    this._resultCap = null;
}

PingTraceConfigViewLoader.prototype = new LoaderTemplate();

/**
 * 初始化特性数据
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceConfigViewLoader.prototype.initFeatureData = function()
{
	try 
	{
		// 从父窗口中获取公共变量
		if ("undefined" != typeof (jse.getFromWin) && null != jse.getFromWin()
				&& ("undefined" != typeof (jse.getFromWin().pub_getFeaturePubData))) 
		{
			this._featureData = jse.getFromWin().pub_getFeaturePubData();
		} else if (("undefined" != typeof (window.parent)) && (null != window.parent)
				&& ("undefined" != typeof (window.parent.pub_getPubData))) 
		{
			this._featureData = window.parent.pub_getPubData();
		} else if (true) 
		{
			this._featureData = pub_getFeatureGlobalData();
		} else 
		{
			this._featureData = pub_getFeaturePubData();
		}
	 } catch (ex) 
	 {
		this._featureData = pub_getFeatureGlobalData();
	 }
}

/**
 * 初始化三段式第二段控制类
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 * @param configCtrl 配置树表控制类
 */
PingTraceConfigViewLoader.prototype.initDataCtrl = function(configCtrl)
{
	try 
	{
		if ("undefined" != typeof (jse.getFromWin) && null != jse.getFromWin()
				&& ("undefined" != typeof (jse.getFromWin().pub_getDataController))) 
		{
			// 初始化三段式第二段控件类
			var dataCtrl = jse.getFromWin().pub_getDataController();
			configCtrl.setDataCtrl(dataCtrl);
		} else 
		{
			configCtrl.setDataCtrl(null);
		}
	} catch (ex) 
	{
		configCtrl.setDataCtrl(null);
	}
}

/**
 * 初始化树表校验信息
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceConfigViewLoader.prototype.initVerifyCtrl = function()
{
	try 
	{

		if ("undefined" != typeof (jse.getFromWin) && null != jse.getFromWin()
				&& ("undefined" != typeof (jse.getFromWin().pub_getDataController))) 
		{
			// 初始化三段式第二段控件类
			var verification = jse.getFromWin().pub_getDataController().getVerification();
			this._verifyCtrl = new VerifyCtrl(this._treeTable, verification);
		} else 
		{
			this._verifyCtrl = new VerifyCtrl(this._treeTable, null);
		}
	} catch (ex) 
	{
		this._verifyCtrl = new VerifyCtrl(this._treeTable, null);
	}
}

/**
 * 初始化树表事件
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 * @param tableGrid 树表
 * @override
 */
PingTraceConfigViewLoader.prototype.initTableHander = function(tableGrid)
{
    tableGrid.onselchanged = onSelChanged;
    tableGrid.onvaluechanged = onValueChanged;
    tableGrid.onvaluechanging = onValuechanging;
    tableGrid.oncellselchanged = onCellSelChanged;
    tableGrid.onlastcell = doLastCellFocus;
}

/**
 * 初始化树表tab健事件
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceConfigViewLoader.prototype.initTabKeyHander = function()
{
    // 空实现，覆写父类方法。
}

/**
 * 初始化查询树表
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceConfigViewLoader.prototype.initSearchProsor = function()
{
}

// /**
// * 初始化树表控件
// *
// * @author l00133618
// * @since iManager U2000 V2R1,2013-4-27
// * @return
// */
// PingTraceConfigViewLoader.prototype.initTreeTableModel = function()
// {
// // 初始化表格
// this._treeTableModel = new MutilTreeTableModel();
// }

/**
 * 设置配置页面类型
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 * @return
 */
PingTraceConfigViewLoader.prototype.setViewType = function()
{
    var frame = this._featureData.getFrameParam();
    frame.viewType = null;
}

/**
 * 初始化配置页面控制类
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 * @return
 */
PingTraceConfigViewLoader.prototype.initConfigCtrl = function(operCtrl)
{
    this._startTestBtn = window.xui.getWidget("startTestBtn");
    this._stopTestBtn = window.xui.getWidget("stopTestBtn");
    this._saveAsBtn = window.xui.getWidget("saveAsBtn");

    this._startTestBtn.setEnabled(true);
    this._stopTestBtn.setEnabled(false);
    this._saveAsBtn.setEnabled(false);
    
    this._testparmCap = window.xui.getWidget("Group3");
    this._resultdetailCap = window.xui.getWidget("Group2");
    this._resultCap = window.xui.getWidget("Group1");

    // 左下角的label控件对象
    var gridLabel = window.xui.getWidget("TooltipLabel");

    this._treeStauts = new PingTraceTreeTableStatus(this._treeTable, this._treeTableModel, null, gridLabel, null);

    // 初始化配置页面控制类
    operCtrl.setTreeTable(this._treeTable);
    operCtrl.setTreeModel(this._treeTableModel);
    // operCtrl.setAdvProgressBarCtrl(advProgressBarCtrl);
    operCtrl.setTableStatus(this._treeStauts);
    operCtrl.setVerifyCtrl(this._verifyCtrl);
    operCtrl.setFeatureData(this._featureData);
    operCtrl.setId(this._id);
    
    // 设置引用对象数据管理
    operCtrl.setRefObjDataCacheMgr(this._refObjDataCacheMgr);

    operCtrl._resultTableModel = this._resultTableModel;
    operCtrl._resultTable = this._resultTable;
    operCtrl._resultDetailTableModel = this._resultDetailTableModel;
    operCtrl._resultDetailTable = this._resultDetailTable;

    operCtrl._initParamInfo = this._initParamInfo;
    operCtrl._configViewLoader = this;
}

/**
 * 初始化其他控件
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceConfigViewLoader.prototype.initOtherWidget = function()
{
    this.initResultTable();

    this.initResultDetailTable();
}

/**
 * 获取特性名
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceConfigViewLoader.prototype.getPingTraceFeatureName = function()
{
    var deviceForm = this._featureData.getDeviceForm();
    if(null == deviceForm.deviceType || null == deviceForm.deviceVersion)
    {
    	deviceForm.deviceType = jse.topWin.devType;
    	deviceForm.deviceVersion = jse.topWin.devVersion;
    	var pnpForm = jse.topWin.pub_getClonePnpForm();
    	deviceForm.pnpForm = pnpForm;
    }
    var operResult = jsonrpc.invokeWithoutMask("pingTraceTreeTableViewFactory", "getPingTraceFeatureName", [
            deviceForm.deviceType, deviceForm.deviceVersion, this._id ]);

    if (operResult != null && operResult.resultType != GlobalConstants.OPER_OK)
    {
        CommonDlgReq.openRspErrorDialog(operResult, null, null);
        return;
    }
    return operResult.returnObj;
}

/**
 * 初始化汇总结果表格
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceConfigViewLoader.prototype.initResultTable = function()
{
    var table = window.xui.getWidget("TableResult");
    this._resultTableModel = new TableModel(this._resource, table);
    this._resultTable = new DataTable(table, this._resultTableModel, this._resource);
}

/**
 * 初始化信息信息表格
 * 
 * @author l00133618
 * @since iManager U2000 V2R1,2013-4-27
 */
PingTraceConfigViewLoader.prototype.initResultDetailTable = function()
{
    var table = window.xui.getWidget("TableResultDetail");
    this._resultDetailTableModel = new TableModel(this._resource, table);
    this._resultDetailTable = new PingtraceDetailTable(table, this._resultDetailTableModel, this._resource);
}