jse.require("vmt.extend.table_prototype");
/**
 * 事件注册
 */
var signalMap =
{
    on_load_ui : doLoad,
    onClickOkButton : doOK,
    onClickCancelButton : doCancel,
    doTableDbClick : doOK,
    doTableSelChanged : doSelChange,
    doClickQueryButton : popupFilterDialog,
    doConditionComboValueChanged : comboSelChange
};

/**
 * 表格数据控制类。类型为ParentDataController
 */
var g_parentDataController = {};

/**
 * 全局变量。类型为GlobalData
 */
var g_parentFeatureData = {};

/**
 * 分页控制器
 */
var g_pagedController = null;

/**
 * 过滤控制类
 */
var g_filterCtrl = null;

/**
 * 引用对话框控制类，用来进行对话框的处理
 */
var g_refDlgController = null;

/**
 * 筛选控件 
 */
var g_colFilterCtrl = null;

/**
 * 初始化XUI界面
 * 
 * @author j65716
 * @since iManager U2000 V1R5,2010-11-27
 * @return
 */
function init()
{
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/configframe/xui/parent/parent.xui", signalMap);
}

/**
 * 加载页面中的数据
 * 
 * @author j65716
 * @since iManager U2000 V1R5,2010-11-27
 * @return
 */
function doLoad()
{
    var table = window.xui.getWidget("ParentTable");
    table.onsort = doSort;
    table.setAllColSortable(true);

    //setOKBtnStatus(false);

    // 从父窗口中获取公共变量
    var configWin = jse.getFromWin();
    var configCtrl = configWin.pub_getConfigCtrl();
    var parentViewCtrl = configCtrl.getRefSelectCtrl().getParentViewCtrl();
    g_parentFeatureData = parentViewCtrl.getFeatureData().clone();

    var deviceForm = g_parentFeatureData.getDeviceForm();
    var featureForm = parentViewCtrl.getFeatureForm();
    g_parentFeatureData.setFeatureForm(featureForm);

    var frameForm = parentViewCtrl.getFrameForm()
    var nodeInfo = g_parentFeatureData.getNodeInfo();
    frameForm.viewType = "SELECT";

    var parentData = parentViewCtrl.getCurParentData();
    featureForm.attributeXpath = parentData.attrXpath;

    // 初始化表格和表格模型，用于构造第二段控制模型
    var tableModel = new TableModel(null, table);
    var vmtTable = new DataTable(table, tableModel, null);

    // 初始化第二段分页模型
    var pagedLabel = window.xui.getWidget("infoLabel");
    var pagedBar = window.xui.getWidget("checkTableNavigator");
    pagedBar.ondragmove = doNavigate;
    pagedBar.onvaluechanged = doNavigate;
    g_pagedController = new FeaturePageController(pagedLabel, pagedBar, vmtTable, deviceForm, featureForm, frameForm);

    var comboObject = window.xui.getWidget("ParentConditonCombo");
    g_filterCtrl = new FilterController(vmtTable, comboObject, null);
    
    g_parentDataController = new ParentDataController(vmtTable, tableModel, null, featureForm, frameForm, nodeInfo,
            deviceForm, g_pagedController, g_filterCtrl);
    g_colFilterCtrl = new ColumnFilterController(vmtTable, g_parentDataController);
    g_parentDataController.setColFilterCtrl(g_colFilterCtrl);
    
    g_refDlgController = new ParentRefDlgController(featureForm, g_parentDataController, vmtTable, tableModel,
            g_pagedController);
    g_refDlgController.setParentViewCtrl(configCtrl);

    pub_refreshLocalView();
}

/**
 * 加载动态信息
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R3,2010-6-30
 * @param isInitBySelf 区分该方法是内嵌页面还是组件的 show()调用的
 * @return
 */
function onshow(isInitBySelf)
{
    this.doLoad();
}

/**
 * 获取全局信息
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-5-14
 * @return 全局信息
 */
function pub_getFeaturePubData()
{
    return g_parentFeatureData;
}

/**
 * keyref联想关闭事件处理
 * 
 * @author x00211048
 * @since iManager U2000 V2R1,2013-4-25
 */
function doKeyRefCloseUp(evt)
{

}

/**
 * 获取三段式第一段的控制类
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-5-14
 * @return 全局信息
 */
function pub_getDataController()
{
    return g_parentDataController;
}

/**
 * 获取联动控制类
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 * @return 全局信息
 */
function pub_getFilterCtrl()
{
    return g_filterCtrl;
}

/**
 * 获取全局公共方法
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-5-14
 * @return 全局信息
 */
function pub_getResource()
{
    return g_filterCtrl._resource;
}

/**
 * 跳转到指定页
 * 
 * @author l00106357
 * @since iManager U2000 V1R3,2010-4-14
 * @return
 */
function doNavigate(evt)
{
    g_parentDataController.handleNavigate(evt.value - 1);
}

/**
 * 排序
 * 
 * @author l00106357
 * @since iManager U2000 V1R3,2010-4-14
 * @return
 */
function doSort(colId, sortType)
{
    // 获取当前选中行
    var rowIds = g_parentDataController.getTable().getSelection();

    g_parentDataController.sortColumn(colId, sortType);

    // 重新选中排序前的行
    g_parentDataController.getTable().setSelection(rowIds);
}

/**
 * 刷新可变控件的数据和界面.添加表的列和表中的数据
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-7
 * @return
 */
function pub_refreshLocalView()
{
    g_parentDataController.updateTable("SELECT");
}

/**
 * 用户点击确定按钮的事件处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-7
 * @return
 */
function doOK()
{
    g_refDlgController.doOK();
}

/**
 * 用户点击取消按钮的事件处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-7
 * @return
 */
function doCancel()
{
    g_refDlgController.closeSelfView();
}

/**
 * 表中行选择变化时的事件处理
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-5-19
 * @return
 */
function popupFilterDialog(evt)
{
//    var operation = Resource.getResource("qat:public", "dialog_filter_d");
//    g_refDlgController.createDialog(operation, g_parentFeatureData.getFeatureForm().xpath + "parentFilter",
//            CommonUtil.getRootPath() + "/vmt/ct/online/view/filter/filter.html");
    var xpath = g_parentFeatureData.getFeatureForm().xpath;
    g_parentDataController.doClickFilterButton(evt,"parentFilter" + xpath,"parentMethodFilter");
}

/**
 * 打开默认过滤界面
 */
function doClickNormalFilter()
{
    var xpath = g_parentFeatureData.getFeatureForm().xpath;
    g_parentDataController.openNormalFilterDialog("parentFilter" + xpath);
}

/**
 * 打开Method过滤界面
 * @param evt
 */
function doClickMethodFilter(evt)
{   
    g_parentDataController.doClickMethodFilter(evt,"parentMethodFilter");
}

/**
 * 用户触发过滤条件下拉框变化
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-5-19
 * @return
 */
function comboSelChange(evt)
{
    // 设置过滤条件
    var comboObject = window.xui.getWidget("featureConditonComboID");

    // 调用数据过滤接口
    g_parentDataController.initTableData("FEATURE");

    g_filterCtrl.doEvaluateCombo(evt.id);
}

/**
 * 表中行选择变化时的事件处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-8
 * @return
 */
function doSelChange()
{
    // 将确定按钮置为可用
    //setOKBtnStatus(true);
}

/**
 * 设置确定按钮状态
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-9
 * @param status 状态
 * @return
 */
function setOKBtnStatus(status)
{
    // 设置确定按钮状态
    var okBtn = window.xui.getWidget("OkButton");
    okBtn.setEnabled(status);
}

/**
 * 隐藏对话框时的处理方法
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-9-7
 * @return
 */
function pub_doHideDlg()
{
    g_refDlgController.closeSelfView();
}

/**
 * 添加列筛选条件
 * @author s00143960
 * @since iManager U2000 V1R7,2011-11-21
 * @return
 */
function doAddColumnFilterCondition(evt)
{
    g_colFilterCtrl.addFilterCondition(evt.target);
}

/**
 * 用户触发筛选操作
 * 
 * @author s00143960
 * @since iManager U2000 V1R7,2011-11-21
 * @return
 */
function doFilter(evt)
{
    g_colFilterCtrl.filterData(evt.target, evt.target.getSelection());
}
/**
 * 弹出设置密码对话框
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function doKeyPasswordClick(evt)
{
    
}

/**
 * 单击keyref按钮的事件处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-7
 */
function doKeyRefClick(evt)
{
    
}

/**
 * 用户在keyref输入框中输入值，进行联想
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-7
 */
function doKeyRefFilter(evt)
{
    
}

/**
 * 弹出设置密码对话框
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function doPasswordClick(evt)
{
    
}

/**
 * 值变化事件处理
 * @param evt
 */
function onValueChanged(evt)
{
    
}

/**
 * 值变化事件处理
 * @param evt
 */
function onValuechanging(evt)
{
    
}

function pub_getConfigCtrl()
{
    return pub_getDataController();
}
Event.observe(window, "load", init);