/**
 * 在线第三段子页面的分页处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-6-26
 */
function MultiOnlineChildPageController(pageLabel, pageBar, table, deviceForm, featureForm, frameParam)
{
    PagedController.call(this, pageLabel, pageBar, table, deviceForm, featureForm, frameParam);
}

MultiOnlineChildPageController.prototype = new PagedController();

/**
 * 查询某页_子类实现_应处理查询结果，并返回PageInfo<DataTableModel>
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-6-26
 */
MultiOnlineChildPageController.prototype.doQueryPageData = function(pageQueryParam)
{
    var result = jsonrpc.invoke("multiChildDataTableFactory", "queryDataByPage", [ this._deviceForm, this._featureForm,
            this._frameParam, this._table.getJonsColumnInfos(), pageQueryParam ]);

    return result;
}

MultiOnlineChildPageController.prototype.doAsynQueryPageData = function(pageQueryParam, callback, refrence, callbackParams)
{
    jsonrpc.asynInvokeWaiting("multiChildDataTableFactory", "queryDataByPage", [ this._deviceForm, this._featureForm,
            this._frameParam, this._table.getJonsColumnInfos(), pageQueryParam ], callback,refrence, callbackParams);
}

/**
 * 获取分页信息
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-6-26
 */
MultiOnlineChildPageController.prototype.doQueryPageInfo = function()
{
    var result = jsonrpc.invokeWithoutMask("multiChildDataTableFactory", "queryPageInfo", [this._queryId, this._featureForm]);

    return result;
}