jse.require("jse.widget.dialog");
jse.require("jse.widget.menu");
jse.require("jse.widget.table");
jse.require("vmt.extend.table_prototype");

var Child =
{
    /**
     * 第二段控制类
     */
    dataCtrl : new MultiPageTableDataController(),

    /**
     * 第二段控制模型
     */
    dataTable : null,

    /**
     * 全局变量
     */
    featureData : null,

    /**
     * 第三段右键菜单控制
     */
    menuCtrl : null,

    /**
     * 第二段控制模型
     */
    tableModel : null,

    /**
     * 子Dialog页面的横坐标
     */
    xChildRelative : null,

    /**
     * 子Dialog页面的纵坐标
     */
    yChildRelative : null,

    /**
     * 联动类
     */
    linkageCtrl : null,

    /**
     * 筛选控制类
     */
    colFilterCtrl : null,

    /**
     * 批量修改界面的节点信息
     */
    batchModifyNodeContent : null,

    /**
     * 批量新建条数
     */
    batchAddNum : 0,

    /**
     * 父页面的第二段控制类
     */
    parentDataCtrl : null
}

var signalMap =
{
    on_load_ui : doLoad,
    onClickToolButtonRefreshAll : doRefreshAll,
    onClickToolButtonNewCollect : doClickCreateCollect,
    
//    onClickToolButtonNew : doClickCreate,
//    onClickToolButtonClone : doClickClone,
//    onClickToolButtonBatchNew : doClickBatchAddNum,
    onClickToolButtonModify : doClickModify,
    onClickToolButtonDelete : doClickDelete,
    onClickToolButtonSaveas : doClickSaveas
};

/**
 * 初始化函数
 */
function init()
{
    logger.log("enter child init()");

    // 通过JSON获取控件的Handler
    window.xui = new jse.XUI();
    window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/configframe/xui/detail/child.xui", signalMap);

    logger.log("exit child init()");
}

/**
 * 用户载入页面.<br>
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 * @return
 */
function doLoad()
{
    logger.log("enter child doLoad()");
    var table = window.xui.getWidget("Table");
    table.onsort = doSort;
    // table.ondblclick = tableDblClick;
    table.oncontextmenu = popupContextMenu;
    table.onselchanged = doTableSelChange;
    table.setAllColSortable(true);
    table.onvaluechanged = onValueChanged;
    table.onvaluechanging = onValuechanging;

    // 从父窗口中获取公共变量
    Child.featureData = window.parent.pub_getFeaturePubData().clone();
    var featureForm = Child.featureData.getFeatureForm();
    var frame = Child.featureData.getFrameParam()
    var node = Child.featureData.getNodeInfo();
    var deviceForm = Child.featureData.getDeviceForm();

    var tabId = getCurrentTabId();
	var g_featureTabViewCtrl = window.parent.pub_getFeatureTabViewCtrl();
	var tabInfo = g_featureTabViewCtrl.getTabInfo(tabId);
    if (tabInfo != null)
    {
    	var currentTabType = tabInfo.tabType;
        featureForm.xpath = tabInfo.xpath;
        
    	if(currentTabType == "ATTRIBUTEGROUP")
    	{
    	    featureForm.xpath = tabInfo.moXpath;
    	    featureForm.groupXpath = tabInfo.xpath;
    	    featureForm.isAppearOnce = true;
    	    featureForm.featureNodeType = "ATTRIBUTEGROUP";
    	}
    	else  if(currentTabType == "OBJECT") 
    	{
    	    featureForm.xpath = tabInfo.xpath;
    	    featureForm.groupXpath = null;
    	    featureForm.isAppearOnce = false;
    	    featureForm.featureNodeType = "OBJECT";
    	}          
    }
    else
    {
        var tabIdsep = tabId.split(",");
        var childTabId = tabIdsep[tabIdsep.length - 1].split("]");
        featureForm.xpath = childTabId[1];
        featureForm.featureNodeType = "OBJECT";        
    }
    featureForm.tabId = tabId;
    featureForm.featureName = featureForm.xpath.split("/")[1];
    
    // 初始化表格和表格模型，用于构造第二段控制模型
    Child.tableModel = new MultiTableModel(null, table, featureForm.xpath);
    Child.dataTable = new MultiDataTable(table, Child.tableModel, null);
    // 注册表格对象，对其中的文本框进行前置限制
    Preconstraints.registTable(Child.dataTable.getTableObj());

    var pagedLabel = window.xui.getWidget("infoLabel");
    var pagedBar = window.xui.getWidget("tableNavigator");
    pagedBar.ondragmove = doNavigate;
    pagedBar.onvaluechanged = doNavigate;
    var pageCtrl = new MultiOnlineChildPageController(pagedLabel, pagedBar, Child.dataTable, deviceForm, featureForm, frame);
    var emptyFilterController = new EmptyFilterController(null, null, null);

    var configMenu = new ChildConfigMenu(null);
    logger.log("start child doLoad() ConfigPreAuthority");
    var perAuthority = new ConfigPreAuthority(deviceForm.deviceIp);
    perAuthority.init();
    var menuCtrl = new ChildMenuController(configMenu, Child.dataTable, perAuthority);

    var toolbar = new ToolBar();
    var toolbarCtrl = new ToolbarController(toolbar, Child.dataTable, perAuthority);
    pageCtrl.toolbarInit(toolbarCtrl);
    var statusCtrl = new StatusController(toolbarCtrl, menuCtrl, perAuthority);

    // 克隆node防止子节点信息覆盖父节点信息
    Child.dataCtrl = new MultiPageTableDataController(Child.dataTable, Child.tableModel, null, featureForm, frame, node
            .clone(), deviceForm, pageCtrl, emptyFilterController, statusCtrl);

    Child.dataCtrl.setRenovatorCtrl(window.parent.pub_getDataController().getRenovatorCtrl());

    Child.colFilterCtrl = new MultiFeatureColumnFilterController(Child.dataTable, Child.dataCtrl);
    Child.dataCtrl.setColFilterCtrl(Child.colFilterCtrl);

    // 初始化联动
    _initLinkageCtrl();

    var urlArray = [];
    urlArray[RefDlgUrlType.KEYREF] = CommonUtil.getRootPath() + "/vmt/ct/online/view/keyref/keyref.html";
    urlArray[RefDlgUrlType.KEY] = CommonUtil.getRootPath() + "/vmt/ct/common/dialog/keydialog/keydialog.html";
    urlArray[RefDlgUrlType.PASSWORD] = CommonUtil.getRootPath() + "/vmt/ct/common/dialog/passworddialog/passworddialog.html";

    // ref关系选择控制类
    var refSelectControler = new RefSelectControler(new KeyrefViewController(), null, new KeyPasswordViewCtrl(),
            new PasswordViewCtrl(), new AttrCustomInfoCtrl());
    refSelectControler
            .initParam(Child.dataTable, Child.featureData, urlArray, Child.linkageCtrl, Child.dataCtrl, false ,false);
    Child.dataCtrl.setRefSelectCtrl(refSelectControler);

    var emptyDetailController = new EmptyDetailController(null, null, null, null);
    Child.dataCtrl.setDetailCtrl(emptyDetailController);

    var isWorkspace = featureForm.isWorkspace;
    if (!isWorkspace)
    {
        // 子右键菜单和详细信息查询Dialog横纵坐标
        Child.xChildRelative = getXChildRelative();
        Child.yChildRelative = getYChildRelative();
    }

    logger.log("start child doLoad() intitTableView");
    Child.dataCtrl.intitTableView("FEATURE");
    refreshChildPage(false);
    window.parent.pub_getDetailController().setViewLoaded(tabId);  
    window.parent.pub_getDetailController().setTabViewIsFirstLoad(tabId,false);
}

/**
 * 同步所有
 */
function doRefreshAll()
{
    refreshChildPage(false);
}

/**
 * 刷新三段表格
 * 
 * @param isRefresh 
 * @returns
 */
function refreshChildPage(isRefresh)
{
    // 防止点击过快，将按钮设置为不可点击
    Child.dataCtrl._statusCtrl._toolbarController._toolBar.setRefreshAllBtnEnable(false);
    Child.dataCtrl._statusCtrl._toolbarController._toolBar.setSaveAsBtnEnable(0);
    logger.log("start child doLoad() initChildTableData");
    Child.dataCtrl.initChildTableData("FEATURE", pub_getSelectRowKeys(), getCurrentTabId(), isRefresh);
    logger.log("exit child doLoad()");    
}

/**
 * 清除表格中的动态数据信息
 */
function clearTableInfos()
{
    Child.dataCtrl._dataTable.removeAllRows();
}

/**
 * 返回表格对象
 * 
 * @author x00211048
 * @since iManager U2000 V2R1,2013-5-10
 */
function getDetailTable()
{
    return this.Child.dataTable;
}


/**
 * 初始化联动对象
 * 
 * @author j65716
 * @since iManager U2000 V1R5,2010-12-16
 */
function _initLinkageCtrl()
{
    var checkerUseData = new FeatureCheckerUseData(Child.dataTable, null);

    var checkerFactory = new FeatureTableCheckerFactory();
    var prosorUseData = new FeatureProsorUserData(Child.dataTable, null, null);

    var prosorFactory = new FeatureTableProsorFactory();
    var linkageTransactionCtrl = new FeatureLinkageTransactionCtrl(checkerFactory, prosorFactory);

    Child.linkageCtrl = new FeatureLinkageController(checkerUseData, linkageTransactionCtrl, prosorFactory,
            prosorUseData);

    Child.dataCtrl.setLinkageCtrl(Child.linkageCtrl);
}

/**
 * 用户切换table行,需要处理鉴权的联动
 * 
 * @author j65716
 * @since iManager U2000 V1R5,2010-12-16
 */
function doTableSelChange(evt)
{
    Child.dataCtrl.tableSelChange(evt);
}

/**
 * 跳转到指定页
 * 
 * @author l00106357
 * @since iManager U2000 V1R3,2010-4-14
 * @return
 */
function doNavigate(evt)
{
    Child.dataCtrl.handleNavigate(evt.value - 1);
}

/**
 * 右键菜单列定制触发事件,弹出查询详细信息对话框.<br>
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-10-12
 */
function doClickCustomColumn()
{
    Child.dataCtrl.setAutoRefreshEnable(false);
    Custom.clickCustomColumn(Child.featureData);
}

/**
 * 用户创建修改预览界面
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-12-02
 * @return
 */
function pub_createBatchModifyPreview(batchModifyNodeContent)
{
    Child.batchModifyNodeContent = batchModifyNodeContent;
    var operation = Resource.getResource("qat:public", "dialog_batchmodifyconfig_d");
    Child.dataCtrl.createBathModifyPreviewDialog(operation, "batchnewpreview",
            CommonUtil.getRootPath() + "/vmt/ct/online/view/config/batchmodifypreview/batchmodifypreview.html");
}

/**
 * 排序
 * 
 * @author l00106357
 * @since iManager U2000 V1R3,2010-4-14
 */
function doSort(colId, sortType)
{
    Child.dataCtrl.sortRecord(colId, sortType, this._detailController);
}

/**
 * 右键菜单查看详细信息触发事件,弹出查询详细信息对话框.<br>
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-10-12
 */
function doClickDetail()
{
    var detailUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/childdetail/childdetail.html";

    var dialogWith = window.screen.availWidth * 0.63;
    var dialogHeight = dialogWith * 3 / 4 - 16;

    var xChildRelative = (getXChildRelative() - dialogWith) / 2;
    var yChildRelative = (getYChildRelative() - dialogHeight) / 2;
    
    var tabId = getCurrentTabId();
    var tabIdArray = tabId.split(",");
    var nodeName = "";
    if (tabIdArray[1] != null && tabIdArray[1].indexOf("vmt]") == 0)
    {
        var xpaths = tabIdArray[1].split("vmt]");
        var xpath = xpaths[1];
        nodeName = FeaturesResourceMgr.getSchemaResource(xpath);
    }
    else
    {
        if (tabId.indexOf("@URL") > -1)
        {
            tabId.replace("_", "[").replace(".", "[");
        }        
        nodeName = Resource.getTabInfoResource(tabId);
    }
       
//	var pnpForm= jse.topWin.pub_getClonePnpForm();
//	var fileName = pnpForm.deviceType + "_" + pnpForm.deviceVersion + "_tabtitle";
//	var nodeName= jse.getI18nValue("tabtitle:" + fileName, getCurrentTabId());
//    
	
    Child.dataCtrl.creatDetailDialog(detailUrl, nodeName, dialogWith, dialogHeight, xChildRelative, yChildRelative);
}

/**
 * 用户点击新建菜单
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-9-27
 */
function doClickCreateCollect(evt)
{

    var moduleName = jse.topWin.moduleName;
    
    switch(moduleName)
    {
        case ModuleName.V8PTN:
        {
            doClickCreate();
            break;
        }
        case ModuleName.VMF:
        {
            var table = window.xui.getWidget("Table");
            Child.dataCtrl.doClickCreateCollect(evt, table);
            break;
        }
        default:
        {
            var table = window.xui.getWidget("Table");
            Child.dataCtrl.doClickCreateCollect(evt, table);
            break;
        }
    }       
}

/**
 * 用户点击新建菜单
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-9-27
 */
function doClickCreate()
{
    // 在打开树表配置对话框的时候预先请求配置界面数据
    var parentRowKeys = pub_getSelectRowKeys();
    var nodekey = parentRowKeys.getNodeKey();

    var initTreeTableView = new AddedTreeInitOper();
    Child.dataCtrl.addInitTreeTableViewOper(initTreeTableView);
    initTreeTableView.preRequestOperResult(Child.dataCtrl, nodekey);

    var operation = Resource.getResource("qat:public", "dialog_createconfig_d");
    var createDialogUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/config/add/add.html";
    Child.dataCtrl.createRecord(window.parent.pub_getDetailController(), operation, "new", createDialogUrl);
}

/**
 * 用户点击修改菜单
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-9-27
 */
function doClickModify()
{
    // //在打开树表配置对话框的时候预先请求配置界面数据
    // var initTreeTableView = (1 == Child.dataCtrl.getSelection().length) ? new ModifiedTreeInitOper() : new
    // BatchModifyTreeInitOper();
    // Child.dataCtrl.addInitTreeTableViewOper(initTreeTableView);
    // initTreeTableView.preRequestOperResult(Child.dataCtrl);
    //    
    // var modifySingleUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/config/modify/modify.html";
    // var modifyMultiUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/config/batchmodify/batchmodify.html";
    // Child.dataCtrl.modifyRecords(modifySingleUrl, modifyMultiUrl);
    Child.dataCtrl.directModifyRecordes();
}

/**
 * 获取批量修改界面的节点信息
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-12-1
 * @return
 */
function pub_getBatchModifyNodeContent()
{
    return Child.batchModifyNodeContent;
}

/**
 * 用户点击删除菜单
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-9-27
 */
function doClickDelete()
{
    var emptyDetailController = new EmptyDetailController(null, null, null, null);
    Child.dataCtrl.deleteRecord(emptyDetailController);
}

/**
 * 用户点击同步菜单
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-12-06
 */
function doClickSynchronizeData()
{
    Child.dataCtrl.sysSelectedRecord();
}

/**
 * 用户点击克隆菜单
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2010-11-10
 */
function doClickClone()
{
    // 在打开树表配置对话框的时候预先请求配置界面数据
    var initTreeTableView = new CloneTreeInitOper();
    Child.dataCtrl.addInitTreeTableViewOper(initTreeTableView);
    initTreeTableView.preRequestOperResult(Child.dataCtrl);

    var operation = Resource.getResource("qat:public", "dialog_cloneconfig_d");
    var cloneViewUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/config/clone/clone.html";
    Child.dataCtrl.cloneSingleRecord(Child.dataCtrl.getDetailCtrl(), operation, "clone", cloneViewUrl);
}

/**
 * 批量新建
 */
function doClickBatchAddOper()
{
    var keyType = Child.dataCtrl.getKeyType();
    if (keyType == BatchAddCustom.KEYTYPE_BATCHNUM)
    {
        doClickBatchAddNum();
    }
    else if (keyType == BatchAddCustom.KEYTYPE_KEYREF)
    {
        doClickBatchAddCustomView();
    }
    else if (keyType == BatchAddCustom.KEYTYPE_INTEGER)
    {
        doClickBatchAddCustomView();
    }
}

/**
 * 批量新建
 */
function doClickBatchAddCustomView()
{
    var parentRowKeys = pub_getSelectRowKeys();
    var nodekey = parentRowKeys.getNodeKey();

    // 在打开树表配置对话框的时候预先请求配置界面数据
    var initTreeTableView = new BatchAddCustomTreeInitOper();
    Child.dataCtrl.addInitTreeTableViewOper(initTreeTableView);
    initTreeTableView.preRequestOperResult(Child.dataCtrl, nodekey);

    // 打开界面前预先请求配置界面的数据
    var operation = Resource.getResource("qat:public", "dialog_batchcreateconfig_d");
    var createDialogUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/config/batchaddcustom/batchaddcustom.html";

    if (jse.topWin.isPopMaxdiaglogNUM())
    {
        return;
    }
    var dialogId = jse.topWin.constructDialogId("batchaddcustom");
    jse.topWin.pushDialogId(dialogId);

    Child.dataCtrl.createRecord(Child.dataCtrl.getDetailCtrl(), operation, dialogId, createDialogUrl);
}

/**
 * 用户点击批量新建菜单，弹出批量条数界面
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2010-11-10
 */
function doClickBatchAddNum()
{
    Child.dataCtrl.showBatchNumDialog();
}

/**
 * 弹出批量新建界面
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2010-12-06
 * @param batchAddNum 批量新建条数
 */
function doClickBatchAdd(batchAddNum)
{
    Child.batchAddNum = batchAddNum;
    // 在打开树表配置对话框的时候预先请求配置界面数据
    var parentRowKeys = pub_getSelectRowKeys();
    var nodekey = parentRowKeys.getNodeKey();

    var initTreeTableView = new BatchAddedTreeInitOper();
    Child.dataCtrl.addInitTreeTableViewOper(initTreeTableView);
    initTreeTableView.preRequestOperResult(Child.dataCtrl, batchAddNum, nodekey);

    var operation = Resource.getResource("qat:public", "dialog_batchcreateconfig_d");
    var createDialogUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/config/batchadd/batchadd.html";
    Child.dataCtrl.createRecord(Child.dataCtrl.getDetailCtrl(), operation, "batchadd", createDialogUrl);
}

/**
 * 另存为
 */
function doClickSaveas()
{
    saveasHandle(Child.featureData, Child.dataCtrl.getPagedCtrl(), Child.dataCtrl._filterCtrl);
}

/**
 * 获取批量条数
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2010-12-06
 * @return 批量条数
 */
function pub_getBatchAddNum()
{
    return Child.batchAddNum;
}

/**
 * 获取横坐标.<br>
 * 
 * @author 王莉 w00138446
 * @since iManager U2000 V1R3,2010-4-15
 * @return 弹出详细信息查询子页面的横坐标
 */
function getXChildRelative()
{
    var xChildRelative = null;

    if (null != window.parent.jse.getFromWin())
    {
        xChildRelative = window.parent.jse.getFromWin().pub_getXChildRelative();
    }
    else
    {
        xChildRelative = window.parent.parent.pub_getXChildRelative();
    }
    return xChildRelative;
}

/**
 * 获取纵坐标.<br>
 * 
 * @author 王莉 w00138446
 * @since iManager U2000 V1R3,2010-4-15
 * @return 弹出详细信息查询子页面的横坐标
 */
function getYChildRelative()
{
    var yChildRelative = null;

    if (null != window.parent.jse.getFromWin())
    {
        yChildRelative = window.parent.jse.getFromWin().pub_getYChildRelative();
    }
    else
    {
        yChildRelative = window.parent.parent.pub_getYChildRelative();
    }
    return yChildRelative;
}

/**
 * 获取tabId.<br>
 * 
 * @author 王莉 w00138446
 * @since iManager U2000 V1R3,2010-4-15
 * @return
 */
function getCurrentTabId()
{
    // 通过页面对象来获取ID，由于快速切换时可能此时已经切换到其它tab页，因而不使用原来的getCurrentTabId来获取
    var tabId = window.parent.pub_getDetailController().getTabIdByWin(this);
    return tabId;
}

/**
 * 获取详细信息控制类.<br>
 * 
 * @author 王莉 w00138446
 * @since iManager U2000 V1R3,2010-4-15
 * @return 详细信息控制类
 */
function pub_getChildDetailCtrl()
{
    jse.getFromWin().pub_getChildDetailCtrl()
}


/**
 * 显示弹出菜单.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-13
 */
function popupContextMenu(evt)
{
    Child.dataCtrl.popupContextMenu(evt);
}

/**
 * 双击表处理事件.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-15
 */
function tableDblClick(evt)
{
    doClickDetail();
}

/**
 * Action操作处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-10-19
 * @param evt
 * @return
 */
function doClickAction(evt)
{
    Child.dataCtrl.doAction(evt);
}

/**
 * 获取选中行Id.<br>
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 * @return 选中行Id.
 */
function pub_getRowId()
{
    return Child.tableModel.getCurrentSelectId();
}

/**
 * 获取子节点全局信息，其nodeInfo信息已经在查询处赋值
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 * @return 全局信息
 */
function pub_getFeaturePubData()
{
    var childGlobalData = Child.featureData.clone();
    childGlobalData.setNodeInfo(Child.dataCtrl.getNodeInfo());
    return childGlobalData;
}

/**
 * 获取子Dialog页面的横坐标.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-13
 * @return 子Dialog页面的横坐标
 */
function pub_getXChildRelative()
{
    return Child.xChildRelative + 30;
}

/**
 * 获取子Dialog页面的纵坐标.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-13
 * @return 子Dialog页面的纵坐标
 */
function pub_getYChildRelative()
{
    return Child.yChildRelative + 30;
}

/**
 * 获取选择行的key值<br>
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-4-13
 * @return
 */
function pub_getSelectRowKeys()
{
    var dataController = window.parent.pub_getDataController();
    var rowKey = dataController.getTableModel().getCurrentSelectRowKey();
    return rowKey;
}

/**
 * 获取二段控制类<br>
 * 
 * @since iManager U2000 V1R3,2010-4-13
 * @return
 */
function pub_getParentDataController()
{
    if (null == Child.parentDataCtrl)
    {
        Child.parentDataCtrl = window.parent.pub_getDataController();
    }
    return Child.parentDataCtrl;
}

/**
 * 获取控制类<br>
 * 
 * @since iManager U2000 V1R3,2010-4-13
 * @return
 */
function pub_getDataController()
{
    return Child.dataCtrl;
}

/**
 * 获取联动控制类
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 * @return 全局信息
 */
function pub_getLinkageCtrl()
{
    return null;
}

/**
 * 添加列筛选条件
 * 
 * @author s00143960
 * @since iManager U2000 V1R7,2011-11-21
 * @return
 */
function doAddColumnFilterCondition(evt)
{
    Child.colFilterCtrl.addFilterCondition(evt.target);
}

/**
 * 用户触发筛选操作
 * 
 * @author s00143960
 * @since iManager U2000 V1R7,2011-11-21
 * @return
 */
function doFilter(evt)
{
    Child.colFilterCtrl.filterData(evt.target, evt.target.getSelection());
}

/**
 * 列定制后，重新初始化列信息,重新布局和加载数据
 * 
 * @author s00143960
 * @since iManager U2000 V1R3,2010-5-28
 * @return
 */
function pub_column()
{
    Child.dataCtrl.initChildTableData("FEATURE", pub_getSelectRowKeys(), getCurrentTabId(), false);
}

/**
 * 单击bitMask按钮的事件处理
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-12-28
 */
function doBitMaskClick(evt)
{
    Child.dataCtrl.doBitMaskClick(evt);
}

/**
 * 单击keyref按钮的事件处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-7
 */
function doKeyRefClick(evt)
{
    Child.dataCtrl.doKeyRefClick(evt);
}

/**
 * 单击定制属性列按钮的事件处理
 * 
 * @author x00211048
 * @since iManager U2000 V2R1,2013-5-16
 */
function doCustomAttrClick(evt)
{
    Child.dataCtrl.doCustomAttrClick(evt);
}


/**
 * keyref联想关闭事件处理
 * 
 * @author x00211048
 * @since iManager U2000 V2R1,2013-4-25
 */
function doKeyRefCloseUp(evt)
{
}

/**
 * 用户在keyref输入框中输入值，进行联想
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-7
 */
function doKeyRefFilter(evt)
{
    Child.dataCtrl.doKeyRefFilter(evt);
}

/**
 * 获取当前选中结点的tooltip信息
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-4-1
 */
function pub_getCurNodeTooltip()
{
    return Child.dataCtrl.getCurNodeTooltip();
}

/**
 * 弹出设置密码对话框
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function doKeyPasswordClick(evt)
{
    Child.dataCtrl.doKeyPasswordClick(evt);
}

/**
 * 弹出设置密码对话框
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function doPasswordClick(evt)
{
    Child.dataCtrl.doPasswordClick(evt);
}

/**
 * 获取密码类型字段属性定义的最小长度
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function pub_getCurPwdMinLength()
{
    return Child.dataCtrl.getPwdCellMinLength();
}

/**
 * 获取密码类型字段属性定义的最大长度
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function pub_getCurPwdMaxLength()
{
    return Child.dataCtrl.getPwdCellMaxLength();
}

/**
 * 获取密码类型字段属性定义的不支持的正则表达式
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function pub_getUnsupportedPwdSet()
{
    return Child.dataCtrl.getPwdCellPattern();
}

/**
 * 获取密码类型字段属性定义的支持的正则表达式
 * 
 * @returns
 */
function pub_getSupportedPwdSet()
{
    return null;
}

/**
 * 设置密码类型字段属性的值
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function pub_setPasswordValue(password)
{
    Child.dataCtrl.setPasswordValue(password);
}

/**
 * 值变化事件处理
 * 
 * @param evt
 */
function onValueChanged(evt)
{
    Child.dataCtrl.valueChange(evt);
}

/**
 * 值变化事件处理
 * 
 * @param evt
 */
function onValuechanging(evt)
{
    Child.dataCtrl.valuechanging(evt);
}

function pub_getConfigCtrl()
{
    return Child.dataCtrl;
}

/**
 * url操作
 * 
 * @author w00131173
 * @since iManager U2000 V2R1,2013-4-28
 * @return
 */
function doClickCustomUrl(evt)
{
    Child.dataCtrl.doCustomUrlOper(evt)(evt);
}

/**
 * Swing操作
 * 
 * @author w00131173
 * @since iManager U2000 V2R1,2013-4-28
 * @return
 */
function doClickVmtToSwing(evt)
{
    Child.dataCtrl.doVmtToSwingOper(evt);
}

/**
 * 执行进度条下发操作
 * 
 * @return
 */
function pub_doProgressOperation()
{
    Child.dataCtrl.doSendConfigForProgress();
}

/**
 * 进度条取消事件处理
 * @returns
 */
function pub_doProgressDlgCancleButton()
{
    Child.dataCtrl.doProgressDlgCancleButton();
}


/**
 * 定义超链接响应事件
 * 
 * @author x64338
 * @since iManager U2000 V2R1,2013-3-13
 */
function showDeitialDialog(evt)
{
    var table = pub_getDataController().getTable();
    var cell = table.getFocusCell();
    var value = table.getCellValue(cell.rowId, cell.colId);

    if (!value)
    {
        return;
    }

    var attrXpath = ConfigUtil.transferColumnIdToXpath(cell.colId);

    // TODO 定义一个全局变量
    clickObj =
    {
        attrXpath : attrXpath,
        value : value,
        rowID : cell.rowId,
        colID : cell.colId
        
    };

    jse.require("jse.widget.dialog");
    var title = jse.getI18nValue("qat:public", "popupmenu.viewdetail_d");
    var widgetDialog = new jse.widget.dialog.Dialog("detail", title);
    widgetDialog.setURL(CommonUtil.getRootPath() + "/vmt/ct/online/view/keyrefdetail/keyrefdetail.html");
    widgetDialog.setPreferSize(800, 600);
    widgetDialog.setTitleImage(CommonUtil.getRootPath() + "/vmt/image/imapclient_nw.gif");
    widgetDialog.setDefaultCloseOperation(jse.DISPOSE_ON_CLOSE);

    widgetDialog.show();
}

/**
 * 右键菜单中的method操作
 * @param evt
 */
function doClickMethod(evt)
{
    Child.dataCtrl.doMethod(evt);
}



/**
 * 获取定制页面的属性值
 */
function pub_setAttrCustomValue(value)
{
    pub_getDataController()._refSelectControler.getAttrCustomViewCtrl().setAttrCustomValue(value);
}

/**
 * 用户右键设置值
 * 
 * @author x64338
 * @since iManager U2000 V2R1,2013-1-9
 */
function doBatchModifyValue(evt)
{
    pub_getDataController().doBatchModifyValue(evt);
}

function getBatchModifyObj()
{
    return pub_getDataController().getBatchModifyObj();
}

/**
 * 用户右键设置combo类型值
 * 
 * @author x64338
 * @since iManager U2000 V2R1,2013-1-8
 */
function doSetComboValue(evt)
{
    pub_getDataController().doSetComboValue(evt);
}


Event.observe(window, "load", init);