/**
 * Method配置界面的控制类
 */
function MethodCfgController(methodViewType)
{
    ActionCfgController.call(this);
    
    this._dangerousOperType = DangerousOperType.METHOD;
    
    this._methodViewType = methodViewType;
}

MethodCfgController.prototype = new ActionCfgController();

/**
 * 获取值列信息,method界面中只支持一列
 */
MethodCfgController.prototype.getValueColNum = function()
{
    var length = 1;
    return length;
}

/**
 * 通过初始化操作初始化method界面中的表格
 */
MethodCfgController.prototype.initTableViewOper = function(newNodeContent, selectRowKeys, colIds)
{
    //和选中行无关
    selectRowKeys = [];

    var featureWin = jse.getFromWin();
    var menuCtrl = featureWin.pub_getDataController().getMenuCtrl();
    this._actionInfo = menuCtrl.getCurrentMethodInfo();
    this.getRefSelectCtrl().getKeyrefViewCtrl().setActionXpath(this._actionInfo);
    var focuseOper = new NoKeyDefaultFocusOper(this._treeTable, this._treeModel, this._refSelectControler,
            this._treeTableStatus);
    this._initTreeTableView = new MethodTreeInitOper(this._treeTable, this._treeModel, this._treeTableStatus,
            this._linkageCtrl, focuseOper, this);
    this._initTreeTableView.initTableTreeView(this._featureData, this._actionInfo, selectRowKeys, colIds);
}


/**
 * 下发数据
 */
MethodCfgController.prototype.clickOkBtnSendConfig = function()
{
    var sendResult = this.sendConfigData();
    if (sendResult)
    {
        var message = jse.getI18nValue("qat:public", "label.action_succeedprompt_d");
        CommonDlgReq.openAlertDialog(message, this.sysActionAllRecords, this);
    }
    
}

/**
 * 下发数据
 */
MethodCfgController.prototype.sendConfigData = function()
{
    if (null == this._sendConfigOperation)
    {
        var modelChecker = this._verifyCtrl.createNullAndKeyChecker();
        var modelNodeCloneStrategy = new CloneAllAttriStrategy(this._treeTable, this._treeModel, null);
        this._sendConfigOperation = new MethodTreeSendOper(this._treeTable, this._treeModel, this._featureData,
                modelNodeCloneStrategy, this._dataCtrl, this._actionInfo, modelChecker);
    }
   
    return this._sendConfigOperation.checkDataAndSendConfig(this._linkageCtrl, null, null);
}

/////////////////////////////////////////////////////////
/**
 * method过滤查询界面处理类
 */
function MethodFilterController(methodViewType)
{
    MethodCfgController.call(this,methodViewType); 
    
    this._modelChecker;
}

MethodFilterController.prototype = new MethodCfgController();


/**
 * 通过初始化操作初始化method界面中的表格
 */
MethodFilterController.prototype.initTableViewOper = function(newNodeContent, selectRowKeys, colIds)
{
    //和选中行无关
    selectRowKeys = [];

    var featureWin = jse.getFromWin();
    var menuCtrl = featureWin.pub_getDataController().getFilterButtonMenuCtrl();
    this._actionInfo = menuCtrl.getCurrentMethodFilterInfo();
    this.getRefSelectCtrl().getKeyrefViewCtrl().setActionXpath(this._actionInfo);
    var focuseOper = new NoKeyDefaultFocusOper(this._treeTable, this._treeModel, this._refSelectControler,
            this._treeTableStatus);
    this._initTreeTableView = new MethodTreeInitOper(this._treeTable, this._treeModel, this._treeTableStatus,
            this._linkageCtrl, focuseOper, this, this._methodViewType);
    this._initTreeTableView.initTableTreeView(this._featureData, this._actionInfo, selectRowKeys, colIds);
}

/**
 * 点击确定按钮事件处理
 */
MethodFilterController.prototype.clickOkBtn = function()
{
    this.clickOkBtnSendConfig();
}

/**
 * 下发数据
 */
MethodFilterController.prototype.clickOkBtnSendConfig = function()
{
    // 获取过滤节点
    var filterNodes = this._getFilterNodes(); 
    if(filterNodes.length > 0)
    {      
        filterNodes = JsonUtil.changJsonList(filterNodes);
        var nodeList = [];
        nodeList.push(filterNodes);
        nodeList = JsonUtil.changJsonListP(nodeList);       
        
        this._dataCtrl.filterTableData("FEATURE", nodeList, "true");
        this.closeSelfView();
    }
}

/**
 * 查询条件设置到过滤对话框中
 * 
 */
MethodFilterController.prototype.setFilterNodeInfos = function(nodeList)
{
    jse.getFromWin().pub_getFilterCtrl().setMethodJsonFilterNodes(nodeList);
}

/**
 * 校验数据
 */
MethodFilterController.prototype._checkModelNodes = function()
{
    if (null == this._modelChecker)
    {
        this._modelChecker = this._verifyCtrl.createLeaglValueChecker();
    }
    var newContents = this._treeModel.getModelNodeContents();
    var checkResult = this._modelChecker.check(newContents, this.getValueColumnId());
    if (!checkResult)
    {
        this._modelChecker.showErrorInfo(this, this.selectChange);
        return false;
    }

    return true;
}

/**
 * 获取值列的ID
 */
MethodFilterController.prototype.getValueColumnId = function()
{
    var colIds = this._treeTable.getAllColumnIds();
    colIds.splice(0, 1);
    return colIds[0];
}

/**
 * 获取要进行过滤的数据
 */
MethodFilterController.prototype._getFilterNodes = function()
{
    if (!this._checkModelNodes())
    {
        return [];
    }
    var modelNodeCloneStrategy = new CloneNoNullAttriStrategy(this._treeTable, this._treeModel,
            this.getValueColumnId());
    var newContents = modelNodeCloneStrategy.getModelCloneNodes();
    var nodeList = [];
    if (null != newContents)
    {
        for ( var index in newContents)
        {
            // 传过来的数据是rowid格式，需要将rowid转换为xpath传给后台
            newContents[index].convertRowIDtoXpath();
            nodeList.push(newContents[index]);
        }
    }
    return nodeList;
}


//////////////////////////////////////////////////////////////////
/**
 * Method界面树表对象
 */
function MethodTreeTable(tableGrid, tableModel)
{
    ActionTreeTable.call(this, tableGrid, tableModel);
}

MethodTreeTable.prototype = new ActionTreeTable();

/**
 * 设置过滤条件值.<br>
 * 
 * @param conditionMap 过滤条件，是后台穿过来的map结构map<String,String>类型
 */
MethodTreeTable.prototype.setFilterConditonValues = function(conditionMap)
{
    if (null == conditionMap)
    {
        return;
    }
    
    // 获取过滤界面中的属性行id信息
    var attributeRowIds = this.getAllRowIds();
    for ( var member in conditionMap)
    {
        var conditionValue = conditionMap[member];
        var rowId = attributeRowIds[member];
        if (null != rowId)
        {
            var cell = this._tableGrid.getCell(rowId, "value");
            if ((null != cell) && (cell.type == jse.USER_DEFINED) && (cell.renderer.type == "DateChooser"))
            {
                var top = jse.topWin;
                conditionValue = gcu_UTCString2LocalString(conditionValue, top.zonePattern.zonePattern);
            }

            this.setCellValue(rowId, "value", conditionValue);
        }
    }
}

/**
 * 获取属性行信息
 */
MethodTreeTable.prototype.getAttributeRowIds = function()
{
    var rowIdsArray = [];
    var nodeContents = this._tableModel.getModelNodeContents();
    for ( var nodeIndex in nodeContents)
    {
        var attributes = nodeContents[nodeIndex].getAttributes();
        for ( var index in attributes)
        {
            var xpath = ConfigUtil.getNodeXpath(attributes[index].getAttributeID(), SEPARATOR_XPATH_LABEL);
            rowIdsArray[xpath] = attributes[index].getAttributeID();
        }
    }

    return rowIdsArray;
}

///////////////////////////////////
/**
 * Method界面数表模型对象
 */
function MethodTreeTableModel(resourceMgr,featureName)
{
    TreeTableModel.call(this, resourceMgr);
    this._featureName = featureName;
}

MethodTreeTableModel.prototype = new TreeTableModel();

/**
 * 获取树表对应的提示信息
 * 
 * @return 提示信息
 */
MethodTreeTableModel.prototype.getLabelInfo = function(rowId)
{
    var xPath = ConfigUtil.getNodeXpath(rowId, SEPARATOR_XPATH_LABEL);
    var info = Resource.getXpathResource(this._featureName ,xPath+"_t");
    return info;
}
