/**
 * 第三段详细信息Dialog控制类，用于显示常规、高级和子界面.<br>
 * 
 * @author z00133566
 * @since iManager U2000 V1R6,  2011-8-2
 */
var KeyRefDetail =
{
    /**
     * viewManager控件
     */
    queryViewManager : null,

    /**
     * 子详细信息控制类
     */
    Ctrl : null,

    /**
     * 公共全局变量
     */
    featureData : null,
    
    /**
     * 第二段数据控制
     */
    dataCtrl : null,
    
	dataTableModel: null
}

/**
 * 映射表.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-14
 */
var signalMap =
{
    on_load_ui :doLoad,
    onViewChanged :doViewChanged,
    doClose :doCloseDiaLog
};

/**
 * 初始化函数，当页面载入时调用load函数将页面定义文件加载进来.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-14
 */
function init()
{
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/configframe/xui/detail/keyrefchilddetail.xui", signalMap);
}

/**
 * 加载页面初始设置.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-14
 */
function doLoad()
{
    // 获得界面控件对象
    KeyRefDetail.queryViewManager = window.xui.getWidget("ViewManager");

    // TODO 通过全局变量，这个地方需要包装一下，使用对象变量
    var clickObj = jse.getFromWin().clickObj;   
    
    // 从父页面获取globalData;
    var configWin = jse.getFromWin();
    
    var tempGlobalData = configWin.pub_getFeaturePubData();
    var featureForm = tempGlobalData.getFeatureForm();

    var globalData = new GlobalData();
    globalData.setDeviceForm(tempGlobalData.getDeviceForm());
    globalData.setFrameParam(tempGlobalData.getFrameParam());
    
    if(clickObj)
    {
        globalData.setFeatureForm(featureForm);
    }
    else
    {
        var tempFeatureForm = new FeatureForm();
        tempFeatureForm.initFeatureForm(featureForm.keyRefFeatureForm);
        globalData.setFeatureForm(tempFeatureForm);
    }
    KeyRefDetail.featureData = globalData;
    KeyRefDetail.dataCtrl = configWin.pub_getDataController();
    
    var table = null;
    if (typeof (configWin.pub_getConfigCtrl) == "function")
    {
    var configCtrl = configWin.pub_getConfigCtrl();
    var keyrefViewCtrl = configCtrl.getRefSelectCtrl().getKeyrefViewCtrl();
    var keyrefData = keyrefViewCtrl.getCurKeyrefData();
        table = keyrefViewCtrl._treeTable;
    }
    else
    {
        table = configWin.pub_getProTableCtrl()._detailTable;
    }
    // 初始化第三段表格
    var normalUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/detail/normal.html";
    var advanceUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/detail/advance.html";
    var childUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/detail/keyrefchild.html";
    var groupUrl =CommonUtil.getRootPath() + "/vmt/ct/online/view/detail/group.html";
    KeyRefDetail.Ctrl = new KeyRefDetailController(KeyRefDetail.queryViewManager);
    KeyRefDetail.Ctrl.initTabUrls(normalUrl, advanceUrl, childUrl, groupUrl);
	KeyRefDetail.Ctrl.setIsKeyRefItem(true);
    
    var globalData = KeyRefDetail.featureData;
    var deviceForm = globalData.getDeviceForm();
  
    var frameForm = globalData.getFrameParam();
    
   
    var operResult;
    if(clickObj)
    {
        featureForm.attributeXpath = clickObj.attrXpath;    
        
        var keyRefFeatureForm = getKeyrefFeatureForm(deviceForm, featureForm, frameForm, table, keyrefData);
        setFeatureFormValue(clickObj.attrXpath, keyRefFeatureForm);
        stopQueryData(deviceForm,keyRefFeatureForm);
        
        var key = clickObj.value;
        operResult = jsonrpc.invokeWithoutMask("normalPropTabFactory", "getItemKeyrefInfo", [ deviceForm, 
                                               keyRefFeatureForm.changJsonForm(), frameForm, key, ""]);
    }
    else
    {
        stopQueryData(deviceForm,featureForm.keyRefFeatureForm);
    	operResult = jsonrpc.invokeWithoutMask("normalPropTabFactory", "getItemKeyrefInfo", [ deviceForm, 
                                 featureForm.keyRefFeatureForm, globalData.getFrameParam(), featureForm]);
    }
    
    globalData.setFeatureForm(operResult.returnObj);
    KeyRefDetail.dataTableModel = operResult.returnObj.dataTableModel;
       
    
    KeyRefDetail.Ctrl.initChildDetail(KeyRefDetail.featureData);
}

function stopQueryData(deviceForm,featureForm)
{
    var operResult = jsonrpc.invoke("dataTableFactory", "stopQuery", [deviceForm,featureForm.changJsonForm()]);
}

/**
 * 获取keyref对应特性的版本,从keyref.js移植过来
 * 
 * @author z00251018
 * @since iManager U2000 V2R1,2013-11-21
 */
function getKeyrefFeatureForm(deviceForm, featureForm, frameForm,table,keyrefData)
{
    var result = jsonrpc.invoke("keyrefDataTableFactory", "getKeyrefFeatureForm", [ deviceForm,
            featureForm.changJsonForm(), frameForm ]);
    if (result.resultType == "OPER_OK")
    {
        g_keyrefForm = result.returnObj;
        
        var keyrefFeatureFormList = result.returnObj.featureForms.list;
        var srcConditions = result.returnObj.srcConditions;
        var index = getSrcConditionIndex(srcConditions,table,keyrefData);
        var keyrefFeatureForm = keyrefFeatureFormList[index];
//        var keyrefFeatureForm = result.returnObj.featureForm;
        var featureForm = new FeatureForm();
        featureForm.initFeatureForm(keyrefFeatureForm);
        return featureForm;
    }
    else
    {
        // 弹出错误对话框
        CommonDlgReq.openRspErrorDialog(result, null, null);
        return;
    }
}

function getSrcConditionIndex (srcConditions,table,keyrefData)
{
    var srcCondtionIndex = 0;
    if(srcConditions != null && srcConditions.list.length > 0)
    {
        var curKeyRefData = keyrefData;
        for(var index in srcConditions.list)
        {
            var conditions = srcConditions.list[index];
            if(null == conditions)
            {
                continue;
            }
            if(conditions.conditionType == "OR")
            {
                for(var i in conditions.conditions.list)
                {
                    var conditionMap = conditions.conditions.list[i].map
                    for(var xpath in conditionMap)
                    {
//                      var label = ConfigUtil.getNodeLabel(curKeyRefData.rowID, SEPARATOR_XPATH_LABEL);
//                      var operRowId = ConfigUtil.getRowId(xpath) + SEPARATOR_XPATH_LABEL + label;
                        var tableType = table.getTableType();
                        var curValue = null;
                        if(TableType.DATA_TABLE == tableType)
                        {
                           var colunmInfo = table.getJonsColumnInfoByXpath(xpath)
                           curValue = table.getCellValue(curKeyRefData.rowID, colunmInfo.columnID);
                        }
                        else if(TableType.TREE_TABLE == tableType)
                        {
                            var operRowId = table.getRowId(xpath);
                            curValue = table.getCellValue(operRowId, curKeyRefData.colID);
                        }
                        else
                        {
                            var select = table.getSelKeyRefInfo();
                            curValue = select.value;
                        }
                        //由于是or关系，只要匹配一条界面上的值与keyref的source中配置的值相等
                        if(curValue == conditionMap[xpath])
                        {
                            srcCondtionIndex = index;
                            return srcCondtionIndex;
                        }
                    }
                }
            }
            else
            {
                var conditionMap = conditions.conditions.list[0].map;
                var isSatisfy = true;
                for(var xpath in conditionMap)
                {
//                  var label = ConfigUtil.getNodeLabel(curKeyRefData.rowID, SEPARATOR_XPATH_LABEL);
//                  var operRowId = ConfigUtil.getRowId(xpath) + SEPARATOR_XPATH_LABEL + label;
                    var tableType = table.getTableType();
                    var curValue = null;
                    if(TableType.DATA_TABLE == tableType)
                    {
                        var colunmInfo = table.getJonsColumnInfoByXpath(xpath)
                        curValue = table.getCellValue(curKeyRefData.rowID, colunmInfo.columnID);
                    }
                    else if(TableType.TREE_TABLE == tableType)
                    {
                        var operRowId = table.getRowId(xpath);
                        curValue = table.getCellValue(operRowId, curKeyRefData.colID);
                    }
                    //由于是and关系，需要匹配所有条件
                    if(curValue != conditionMap[xpath])
                    {
                        isSatisfy = false;
                        break;
                    }
                }
                if(isSatisfy)
                {
                    srcCondtionIndex = index;
                    return srcCondtionIndex;
                }
                else
                {
                    srcCondtionIndex = 0;
                }
            }
        }
    }
    return srcCondtionIndex;
}


/**
 * 
 */
function setFeatureFormValue(attrXpath, keyrefFeatureForm)
{
	keyrefFeatureForm.attributeXpath = attrXpath;
	
	for(var index in keyrefFeatureForm.sourceAttrXpathList)
	{
		var srcAttrXpath = keyrefFeatureForm.sourceAttrXpathList[index];
		if(attrXpath == srcAttrXpath)
		{
			var targetAttrXpath = keyrefFeatureForm.targetAttrXpathList[index];
			keyrefFeatureForm.refAttributeXpath = targetAttrXpath;
			
			break;
		}
	}
}

/**
 * 加载动态信息
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-6-30
 * @param isInitBySelf 区分该方法是内嵌页面还是组件的 show()调用的
 * @return
 */
function onshow(isInitBySelf)
{
    this.doLoad();
}


/**
 * 获取公共全局变量.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-15
 * @return 公共全局变量
 */
function pub_getFeaturePubData()
{
    return  KeyRefDetail.featureData;
}

/**
 * 获取keyRef RowKey.<br>
 * 
 * @author z00133566
 * @since iManager U2000 V1R6,2011-8-10
 * @return keyRef rowKey
 */
function pub_getSelectRowKeys()
{
	var rowKey = null;
	if(null != KeyRefDetail.dataTableModel)
	{
		var jsonRowKeyMap = KeyRefDetail.dataTableModel.nodeMaps.map;
		rowKey = new RowKey(0, jsonRowKeyMap[0]);
	}
	
    return rowKey;
}

/**
 * 获取子详细信息控制类.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-15
 * @return 子详细信息控制类
 */
function pub_getDetailController()
{
    return KeyRefDetail.Ctrl;
}

/**
 * "关闭"按钮事件处理：关闭对话框.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-15
 */
function doCloseDiaLog(evt)
{
    KeyRefDetail.Ctrl.closeAllView();
    jse.closeSelfView();
}

/**
 * 切换Tab页处理事件
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-15
 */
function doViewChanged(evt)
{
    KeyRefDetail.Ctrl.viewChange(evt);
}

/**
 * 获取当前页面横坐标.<br>
 * 
 * @author z00133566
 * @since iManager U2000 V1R6,2011-8-5
 * @return 当前页面横坐标
 */
function pub_getXChildRelative()
{
    // 坐标计算有问题，只返回屏幕大小，根据对话框再计算偏移位置
    return window.screen.availWidth + 30;
}

/**
 * 获取当前页面横坐标.<br>
 * 
 * @author z00133566
 * @since iManager U2000 V1R6,2011-8-5
 * @return 当前页面横坐标
 */
function pub_getYChildRelative()
{
    // 坐标计算有问题，只返回屏幕大小，根据对话框再计算偏移位置
    return window.screen.availHeight + 30;
}

/**
 * 获取第二段数据控制类
 * 
 * @author z00133566
 * @since iManager U2000 V1R6,2010-8-5
 */
function pub_getDataController()
{
   return KeyRefDetail.dataCtrl;
}
Event.observe(window, "load", init);