/*
 * Title:         分页控制_子类_用于控制Keyref三段式第二段的分页处理
 * Description:  [描述文件的功能、作用、使用方法和注意事项]
 * Copyright:     Copyright (c) 1988-2015
 * Company:       Huawei Tech. Co., Ltd
 * @author         l00106357
 * @version        版本  2010-4-14
 */

function KeyrefPageController(pageLabel, pageBar, table, deviceForm, featureForm, frameParam)
{
	PagedController.call(this, pageLabel, pageBar, table, deviceForm, featureForm,
            frameParam);
}

/**
 * 类FeaturePageController继承类PagedController
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-4-7
 */
KeyrefPageController.prototype = new PagedController();

/**
 * 查询某页_子类实现_应处理查询结果，并返回PageInfo<DataTableModel>
 */
KeyrefPageController.prototype.doQueryPageData = function(pageQueryParam)
{
	var tmpFeatureForm = this._featureForm.clone();
	tmpFeatureForm.keyrefXpath = null;
	
    var result = jsonrpc.invoke("keyrefDataTableFactory", "queryDataByPage", [ this._deviceForm,
            tmpFeatureForm.changJsonForm(), this._frameParam, this._table.getJonsColumnInfos(), pageQueryParam ]);

    return result;
}

KeyrefPageController.prototype.doAsynQueryPageData = function(pageQueryParam, callback, refrence, callbackParams)
{
	var tmpFeatureForm = this._featureForm.clone();
	tmpFeatureForm.keyrefXpath = null;
	
    jsonrpc.asynInvokeWaiting("keyrefDataTableFactory", "queryDataByPage", [ this._deviceForm, tmpFeatureForm.changJsonForm(),
            this._frameParam, this._table.getJonsColumnInfos(), pageQueryParam ], callback, refrence, callbackParams);
}

/**
 * 获取分页信息
 */
KeyrefPageController.prototype.doQueryPageInfo = function()
{
   // keyref的FeatureForm与Global中的FeatureForm不同，要进行构造否则无法传递给后台
    var pageFeatureForm = {xpath: this._featureForm.xpath};
    var result = jsonrpc.invokeWithoutMask("keyrefDataTableFactory", "queryPageInfo", [ this._queryId, pageFeatureForm ]);

    return result;
}

///////////////////////////////////

function MultiKeyrefPageController(pageLabel, pageBar, table, deviceForm, featureForm,
        frameParam)
{
    PagedController.call(this, pageLabel, pageBar, table, deviceForm, featureForm,
            frameParam);
}

MultiKeyrefPageController.prototype = new PagedController();

/**
 * 查询某页_子类实现_应处理查询结果，并返回PageInfo<DataTableModel>
 */
MultiKeyrefPageController.prototype.doQueryPageData = function(pageQueryParam)
{
    var tmpFeatureForm = this._featureForm.clone();
//    tmpFeatureForm.keyrefXpath = null;
    
    var result = jsonrpc.invoke("multiKeyrefDataTableFactory", "queryDataByPage", [ this._deviceForm,
            tmpFeatureForm.changJsonForm(), this._frameParam, this._table.getJonsColumnInfos(), pageQueryParam ]);

    return result;
}

MultiKeyrefPageController.prototype.doAsynQueryPageData = function(pageQueryParam, callback, refrence, callbackParams)
{
    var tmpFeatureForm = this._featureForm.clone();
//  tmpFeatureForm.keyrefXpath = null;
    
    jsonrpc.asynInvokeWaiting("multiKeyrefDataTableFactory", "queryDataByPage", [ this._deviceForm, tmpFeatureForm.changJsonForm(),
            this._frameParam, this._table.getJonsColumnInfos(), pageQueryParam ], callback, refrence, callbackParams);
}

/**
 * 获取分页信息
 */
MultiKeyrefPageController.prototype.doQueryPageInfo = function()
{
   // keyref的FeatureForm与Global中的FeatureForm不同，要进行构造否则无法传递给后台
    var pageFeatureForm = {xpath: this._featureForm.xpath};
    var result = jsonrpc.invokeWithoutMask("multiKeyrefDataTableFactory", "queryPageInfo", [ this._queryId, pageFeatureForm ]);

    return result;
}