/*
 * Title:         主要是用于修改配置界面
 * Description:  [描述文件的功能、作用、使用方法和注意事项]
 * Copyright:     Copyright (c) 1988-2015
 * Company:       Huawei Tech. Co., Ltd
 * @author         w00131173
 * @version        iManager U2000 V1R3,2010-4-13
 */

jse.require("jse.widget.dialog");
jse.require("jse.widget.table");
jse.require("vmt.extend.table_prototype");

/**
 * 配置类
 */
var g_config = {};

/**
 * 事件注册
 */
var signalMap =
{
    on_load_ui :doLoad,
    onClickCancelButton :clickCancelBtn,
    onClickOKButton :clickOkBtn,
    onClickExpandAll :expandAll,
    onClickTCollapseAll :collapseAll,
    onAdvancedCheckBoxClick :clickAdvancedCheckBox
};

/**
 * 初始化方法
 */
function init()
{
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/configframe/xui/filter/filter.xui", signalMap);
}

/**
 * js载入函数
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-13
 */
function doLoad()
{
    var iniConfigParaLoader = new InitCfgParaViewLoader();
    
    var urlArray = [];
    urlArray[RefDlgUrlType.KEYREF] = CommonUtil.getRootPath() + "/vmt/ct/online/view/keyref/keyref.html";
    
    // ref关系选择控制类
    var refSelectControler = new RefSelectControler(new KeyrefViewController(), null);

    g_config = new InitCfgParaCfgController();
    
    // 获取当前操作对象的xpath信息
    var batchBindOper = jse.getFromWin().pub_getConfigCtrl().getBatchBindOper();
    var currentOperObjXpath = ConfigUtil.getNodeXpath(batchBindOper.getCurrentChildListId(), SEPARATOR_XPATH_LABEL);
    g_config.setCurrentOperObjXpath(currentOperObjXpath);
    
    iniConfigParaLoader.doLoad(urlArray, g_config, refSelectControler);
}

/**
 * 加载动态信息
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R3,2010-6-30
 * @param isInitBySelf 区分该方法是内嵌页面还是组件的 show()调用的
 * @return
 */
function onshow(isInitBySelf)
{
    this.doLoad();
}

/**
 * 用户点击展开所有行
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-15
 */
function expandAll()
{
    g_config.expandAll();
}

/**
 * 用户收缩所有行
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-13
 */
function collapseAll()
{
    g_config.collapseAll();
}

/**
 * 点击选择高级checkbox
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-13
 * @param evt 事件信息
 */
function clickAdvancedCheckBox(evt)
{
    g_config.clickAdvancedCheckBox(evt);
}

/**
 * 切换选择行
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-13
 * @param evt 事件信息
 */
function onSelChanged(evt)
{
    g_config.selectChange(evt.id);
}

/**
 * 用户改变cell内值时进行校验，如果校验不通过设置单元格背景颜色为红色
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-13
 * @param evt 事件信息
 */
function onValueChanged(evt)
{
    g_config.valueChange(evt);
}

/**
 * TODO 后续需要切换至JSE会提供实时监听键盘输入的事件， 用户正在改变cell内值时的处理
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-8-7
 * @param evt 事件信息
 */
function onValuechanging(evt)
{
    g_config.valuechanging(evt);
}

/**
 * 单元格的变化
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-13
 * @param evt 事件信息
 */
function onCellSelChanged(evt)
{
    // 设置数表可编辑的单元格的多国语言样式
    Preconstraints.setTableCellStype(Preconstraints.NORMAL_OPERATION);
}

/**
 * 处理最后一个单元格的Tab事件
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-4-7
 * @param evt 事件信息
 */
function doLastCellFocus(evt)
{
    g_config.doLastCellFocus(evt);
}

/**
 * 点击取消按钮
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-13
 */
function clickCancelBtn()
{
    // 点击取消按钮时根据是否添加数据成功来刷新数据并关闭对话框
    g_config.closeSelfView();
}

/**
 * 点击确定按钮
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-13
 */
function clickOkBtn()
{
    if (g_config.clickOkBtn())
    {
        return;
    }

}

/**
 * 单击keyref按钮的事件处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-7
 */
function doKeyRefClick(evt)
{
    g_config.doKeyRefClick(evt);
}

/**
 * 用户在keyref输入框中输入值，进行联想
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-7
 */
function doKeyRefFilter(evt)
{
    g_config.doKeyRefFilter(evt);
}

/**
 * 选择父点击按钮
 * 
 * @author j65716
 * @since iManager U2000 V1R5,2010-11-26
 */
function doParentClick(evt)
{
}

/**
 * 用户在parent输入框中输入值，进行联想
 * 
 * @author j65716
 * @since iManager U2000 V1R5,2010-11-26
 */
function doParentFilter(evt)
{
}

/**
 * 获取配置控制对象
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-6-1
 * @return
 */
function pub_getConfigCtrl()
{
    return g_config;
}

Event.observe(window, "load", init);