/*
 * Title:         主要是用于第三段的常规页面
 * Description:  [描述文件的功能、作用、使用方法和注意事项]
 * Copyright:     Copyright (c) 1988-2015
 * Company:       Huawei Tech. Co., Ltd
 * @author         f00145226
 * @version        版本  2010-3-12
 */
/**
 * 第三段常规Tab页初始化控制类.<br>
 */
var g_normalProTableController = null;

var Normal =
{
    /**
     * 全局变量
     */
    featureData : null,
    
    /**
     * 第二段控制类
     */
    dataCtrl : null
}

var signalMap =
{
    on_load_ui :doLoad
};

/**
 * 初始化页面.<br>
 */
function init()
{
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/configframe/xui/detail/detail.xui", signalMap);  
}

/**
 * 用户载入页面.<br>
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 * @return
 */
function doLoad()
{
    var proTable = window.xui.getWidget("PropertyTable");
    
    // 从父窗口中获取公共变量
    var featureData = window.parent.pub_getFeaturePubData();
    var globalData = new GlobalData();
    globalData.setDeviceForm(featureData.getDeviceForm());
	globalData.setFeatureForm(featureData.getFeatureForm());
	globalData.setFrameParam(featureData.getFrameParam());
	
	//当前行ID
	var rowId = null;
	var detail = window.parent.pub_getDetailController();
	var dataController = window.parent.pub_getDataController();
	Normal.dataCtrl = dataController;
    var detailTable = new DatailTable(proTable);   
	if(!detail.getIsKeyRefItem())
	{
		rowId = dataController.getTableModel().getCurrentSelectId();
		 // 常规页面控制类
    	g_normalProTableController = new NormalProTableController(detailTable, globalData.getFeatureForm(),
    	globalData.getFrameParam(), globalData.getDeviceForm());
	}
	else
	{
		rowId = globalData.getFeatureForm().value;
    	globalData.setFeatureForm(globalData.getFeatureForm().keyRefFeatureForm);
    	g_normalProTableController = new KeyRefNormalProTableController(detailTable,
    	globalData.getFeatureForm(), globalData.getFrameParam(), 
    	globalData.getDeviceForm(), window.parent);
	}
    Normal.featureData = globalData;
    
    if (null != rowId)
    {
        g_normalProTableController.initProTable(rowId);
        dataController.setTableFocus();
    }

    // 设置常规页已经不是首次载入，确保只加载一次常规页，提高效率
    detail.setNormalFirst(false);
    proTable.setNameColumnWidth(GlobalConstants.PROPERTY_NAMEWIDTH);    
}

/**
 * 刷新常规页面
 */
function pub_refreshNormalPage(rowId)
{
	if (g_normalProTableController != null)
	{
        g_normalProTableController.initProTable(rowId);
	}	
}

/**
 * 获取常规页面控制类.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-26
 * @return 常规页面控制类
 */
function pub_getProTableCtrl()
{
    return g_normalProTableController;
}

/**
 * 获取第二段控制类.<br>
 * 
 * @author z00133566
 * @since iManager U2000 V1R6,2010-8-6
 */
function pub_getDataController()
{
    return Normal.dataCtrl;
}

/**
 * 获取keyrefModel<br>
 * 
 * @author z00133566
 * @since iManager U2000 V1R6,2011-8-10
 */
function pub_getKeyRefModel()
{
	var keyRefModel = null;
    var selKeyRefInfo = g_normalProTableController.getSelKeyRefInfo();
    if(null != selKeyRefInfo)
    {
    	keyRefModel = selKeyRefInfo.dataTableModel;
    }
    
    return keyRefModel;
}

/**
 * 获取公共全局变量.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-15
 * @return 公共全局变量
 */
function pub_getFeaturePubData()
{
    var globalData = Normal.featureData;
    globalData.setFeatureForm(g_normalProTableController.getSelKeyRefInfo());
    return globalData;
}

/**
 * 
 * @author 陈传雨 c00149107
 * @since iManager U2000 V1R3,2010-10-26
 */
function pub_setNameColWidth()
{
    var proTable = window.xui.getWidget("PropertyTable");
    proTable.setNameColumnWidth(GlobalConstants.PROPERTY_NAMEWIDTH);
}

Event.observe(window, "load", init);