jse.require("vmt.extend.table_prototype");
var KeyRefChild =
{
    /**
     * 第二段控制类
     */
    dataCtrl : new PageTableDataController(),

    /**
     * 第二段控制模型
     */
    dataTable : null,

    /**
     * 全局变量
     */
    featureData : null,

    /**
     * 第三段右键菜单控制
     */
    menuCtrl : null,
    
    /**
     * 筛选控制类
     */
    colFilterCtrl : null,

    /**
     * 第二段控制模型
     */
    tableModel : null,

    /**
     * 子Dialog页面的横坐标
     */
    xChildRelative : null,

    /**
     * 子Dialog页面的纵坐标
     */
    yChildRelative : null,

    /**
     * 联动类
     */
    linkageCtrl : null,

    /**
     * 批量修改界面的节点信息
     */
    batchModifyNodeContent : null,
    
    /**
     * 批量新建条数
     */
    batchAddNum : 0
}

var signalMap =
{
    on_load_ui : doLoad
};

/**
 * 初始化函数
 */
function init()
{
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/configframe/xui/detail/keyrefchild.xui", signalMap);
}

/**
 * 用户载入页面.<br>
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 * @return
 */
function doLoad()
{
	// 从父窗口中获取公共变量
    var featureData = window.parent.pub_getFeaturePubData();
    _initGlobalData(featureData);
    _initParameter();
   	// 初始化联动
    _initLinkageCtrl();
    _initChildRelative();
    
    KeyRefChild.dataCtrl.setRenovatorCtrl(window.parent.pub_getDataController().getRenovatorCtrl());
    var emptyDetailController = new EmptyDetailController(null, null, null, null);
    KeyRefChild.dataCtrl.setDetailCtrl(emptyDetailController);
    
    KeyRefChild.colFilterCtrl = new ColumnFilterController(KeyRefChild.dataTable, KeyRefChild.dataCtrl);
    KeyRefChild.dataCtrl.setColFilterCtrl(KeyRefChild.colFilterCtrl);    

    var configMenu = new ChildConfigMenu(null);
    var perAuthority = new ConfigPreAuthority(KeyRefChild.featureData.getDeviceForm().deviceIp);
    perAuthority.init();
    perAuthority.getAuthority();
    var menuCtrl = new ChildMenuController(configMenu, KeyRefChild.dataTable, perAuthority);
    KeyRefChild.dataCtrl.setMenuController(menuCtrl);
    
    KeyRefChild.dataCtrl.intitTableView("FEATURE");
    KeyRefChild.dataCtrl.initChildTableData("FEATURE", pub_getSelectRowKeys());
     
    KeyRefChild.featureData.getFeatureForm().refAttributeXpath = null;
    window.parent.pub_getDetailController().setViewLoaded(KeyRefChild.featureData.getFeatureForm().xpath);
}

/**
 * 初始化全局属性.<br>
 * 
 * @author z00133566
 * @since iManager U2000 V1R6,2011-8-7
 * @return
 */
function _initGlobalData(featureData)
{
	var globalData = new GlobalData();
	globalData.setDeviceForm(featureData.getDeviceForm().clone());
	globalData.setFrameParam(featureData.getFrameParam().clone());
	var jasonFeatureForm = featureData.getFeatureForm().keyRefFeatureForm;
	globalData.getFeatureForm().initFeatureForm(jasonFeatureForm);
	var tabId = getCurrentTabId();
	globalData.getFeatureForm().xpath = tabId;
	KeyRefChild.featureData = globalData;
}


/**
 * 初始化参数.<br>
 * 
 * @author z00133566
 * @since iManager U2000 V1R6,2011-8-7
 * @return
 */
function _initParameter()
{
	var table = window.xui.getWidget("Table");
    var pagedLabel = window.xui.getWidget("infoLabel");
    var pagedBar = window.xui.getWidget("tableNavigator");    
    _initTableHandler(table);
    _initPagedBarHandler(pagedBar);
    
    // 初始化表格和表格模型，用于构造第二段控制模型
    KeyRefChild.tableModel = new TableModel(null, table);
    KeyRefChild.dataTable = new DataTable(table, KeyRefChild.tableModel, null);
    
    var pageCtrl = new OnlineChildPageController(pagedLabel, pagedBar, KeyRefChild.dataTable, KeyRefChild.featureData.getDeviceForm(),
    KeyRefChild.featureData.getFeatureForm(), KeyRefChild.featureData.getFrameParam());
    var emptyFilterController = new EmptyFilterController(null, null, null);
    
    // 克隆node防止子节点信息覆盖父节点信息
    KeyRefChild.dataCtrl = new KeyRefChildDataController(KeyRefChild.dataTable, KeyRefChild.tableModel, KeyRefChild.featureData.getFeatureForm(),
    KeyRefChild.featureData.getFrameParam(), KeyRefChild.featureData.getDeviceForm(), pageCtrl, emptyFilterController, null);
}

/**
 * 添加列筛选条件
 * @author s00143960
 * @since iManager U2000 V1R7,2011-11-21
 * @return
 */
function doAddColumnFilterCondition(evt)
{
    KeyRefChild.colFilterCtrl.addFilterCondition(evt.target);
}

/**
 * 用户触发筛选操作
 * 
 * @author s00143960
 * @since iManager U2000 V1R7,2011-11-21
 * @return
 */
function doFilter(evt)
{
    KeyRefChild.colFilterCtrl.filterData(evt.target, evt.target.getSelection());
}


/**
 * 初始化子页面偏移.<br>
 * 
 * @author z00133566
 * @since iManager U2000 V1R6,2011-8-7
 * @return
 */
function _initChildRelative()
{
	KeyRefChild._xChildRelative = getXChildRelative();
    KeyRefChild._yChildRelative = getYChildRelative();
}

/**
 * 初始化表格事件.<br>
 * 
 * @author z00133566
 * @since iManager U2000 V1R6,2011-8-7
 * @return
 */
function _initTableHandler(tableWidget)
{
	tableWidget.onsort = doSort;
	//keyref的双击功能暂时屏蔽,z00251018
    //tableWidget.ondblclick = tableDblClick;
    //keyref的右键超链接功能暂时屏蔽,z00133566
    //tableWidget.oncontextmenu = popupContextMenu;
    tableWidget.onselchanged = doTableSelChange;
    tableWidget.setAllColSortable(true);	
}

/**
 * 初始化页面控件事件.<br>
 * 
 * @author z00133566
 * @since iManager U2000 V1R6,2011-8-7
 * @return
 */
function _initPagedBarHandler(pageBarWidget)
{
	pageBarWidget.ondragmove = doNavigate;
    pageBarWidget.onvaluechanged = doNavigate;
}

/**
 * 初始化联动对象
 * 
 * @author j65716
 * @since iManager U2000 V1R5,2010-12-16
 */
function _initLinkageCtrl()
{
    var checkerUseData = new FeatureCheckerUseData(KeyRefChild.dataTable, null);

    var checkerFactory = new FeatureTableCheckerFactory();
    var prosorUseData = new FeatureProsorUserData(KeyRefChild.dataTable, null, null);

    var prosorFactory = new FeatureTableProsorFactory();
    var linkageTransactionCtrl = new FeatureLinkageTransactionCtrl(checkerFactory, prosorFactory);

    KeyRefChild.linkageCtrl = new FeatureLinkageController(checkerUseData, linkageTransactionCtrl, prosorFactory,
            prosorUseData);

    KeyRefChild.dataCtrl.setLinkageCtrl(KeyRefChild.linkageCtrl);
}

/**
 * 用户切换table行,需要处理鉴权的联动
 * 
 * @author j65716
 * @since iManager U2000 V1R5,2010-12-16
 */
function doTableSelChange(evt)
{
    KeyRefChild.dataCtrl.tableSelChange(evt);
}

/**
 * 跳转到指定页
 * 
 * @author l00106357
 * @since iManager U2000 V1R3,2010-4-14
 * @return
 */
function doNavigate(evt)
{
    KeyRefChild.dataCtrl.handleNavigate(evt.value - 1);
}

/**
 * 右键菜单列定制触发事件,弹出查询详细信息对话框.<br>
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-10-12
 */
function doClickCustomColumn()
{
    KeyRefChild.dataCtrl.setAutoRefreshEnable(false);
    Custom.clickCustomColumn(KeyRefChild.featureData);
}

/**
 * 用户创建修改预览界面
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-12-02
 * @return
 */
function pub_createBatchModifyPreview(batchModifyNodeContent)
{
    KeyRefChild.batchModifyNodeContent = batchModifyNodeContent;
    var operation = Resource.getResource("qat:public", "dialog_batchmodifyconfig_d");
    KeyRefChild.dataCtrl.createBathModifyPreviewDialog(operation, "batchnewpreview",
            CommonUtil.getRootPath() + "/vmt/ct/online/view/config/batchmodifypreview/batchmodifypreview.html");
}

/**
 * 排序
 * 
 * @author l00106357
 * @since iManager U2000 V1R3,2010-4-14
 */
function doSort(colId, sortType)
{
    KeyRefChild.dataCtrl.sortRecord(colId, sortType, this._detailController);
}

/**
 * 右键菜单查看详细信息触发事件,弹出查询详细信息对话框.<br>
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-10-12
 */
function doClickDetail()
{
    var detailUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/childdetail/childdetail.html";
    
    var dialogWith = window.screen.availWidth * 0.63;
    var dialogHeight = dialogWith * 3 / 4 - 16;
    
    var xChildRelative = (getXChildRelative() - dialogWith) / 2;
    var yChildRelative = (getYChildRelative() - dialogHeight) / 2;
    
    var nodeName = FeaturesResourceMgr.getSchemaResource(getCurrentTabId());  
    KeyRefChild.dataCtrl.creatDetailDialog(detailUrl, nodeName, dialogWith, dialogHeight, xChildRelative, yChildRelative);
}

/**
 * 用户点击新建菜单
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-9-27
 */
function doClickCreate()
{
    var operation = Resource.getResource("qat:public", "dialog_createconfig_d");
    var createDialogUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/detail/config/add/add.html";
    KeyRefChild.dataCtrl.createRecord(window.parent.pub_getDetailController(), operation, "childnew", createDialogUrl);
}

/**
 * 用户点击修改菜单
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-9-27
 */
function doClickModify()
{
    var modifySingleUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/config/modify/modify.html";
    var modifyMultiUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/config/batchmodify/batchmodify.html";
    KeyRefChild.dataCtrl.modifyRecords(modifySingleUrl, modifyMultiUrl);
}

/**
 * 获取批量修改界面的节点信息
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-12-1
 * @return
 */
function pub_getBatchModifyNodeContent()
{
    return KeyRefChild.batchModifyNodeContent;
}

/**
 * 用户点击删除菜单
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-9-27
 */
function doClickDelete()
{
    var emptyDetailController = new EmptyDetailController(null, null, null, null);
    KeyRefChild.dataCtrl.deleteRecord(emptyDetailController);
}

/**
 * 用户点击同步菜单
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-12-06
 */
function doClickSynchronizeData()
{
    KeyRefChild.dataCtrl.sysSelectedRecord();
}

/**
 * 用户点击克隆菜单
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2010-11-10
 */
function doClickClone()
{
    var operation = Resource.getResource("qat:public", "dialog_cloneconfig_d");
    var cloneViewUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/config/clone/clone.html";
    KeyRefChild.dataCtrl.cloneSingleRecord(KeyRefChild.dataCtrl.getDetailCtrl(), operation, "clone", cloneViewUrl);
}

/**
 * 用户点击批量新建菜单，弹出批量条数界面
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2010-11-10
 */
function doClickBatchAddNum()
{
    KeyRefChild.dataCtrl.showBatchNumDialog();
}

/**
 * 弹出批量新建界面
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2010-12-06
 * @param batchAddNum 批量新建条数
 */
function doClickBatchAdd(batchAddNum)
{
    KeyRefChild.batchAddNum = batchAddNum;
    var operation = Resource.getResource("qat:public", "dialog_batchcreateconfig_d");
    var createDialogUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/config/batchadd/batchadd.html";
    KeyRefChild.dataCtrl.createRecord(KeyRefChild.dataCtrl.getDetailCtrl(), operation, "batchadd", createDialogUrl);
}

/**
 * 获取批量条数
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2010-12-06
 * @return 批量条数
 */
function pub_getBatchAddNum()
{
    return KeyRefChild.batchAddNum;
}

/**
 * 获取父页面中设置的子页面x偏移.<br>
 * 
 * @author z00133566
 * @since iManager U2000 V1R6,2011-8-7
 * @return
 */
function getXChildRelative()
{
    return window.parent.pub_getXChildRelative();
}

/**
 * 获取父页面中设置的子页面y偏移.<br>
 * 
 * @author z00133566
 * @since iManager U2000 V1R6,2011-8-7
 * @return
 */
function getYChildRelative()
{
    return window.parent.pub_getYChildRelative();;
}

/**
 * 获取tabId.<br>
 * 
 * @author 王莉 w00138446
 * @since iManager U2000 V1R3,2010-4-15
 * @return
 */
function getCurrentTabId()
{
    // 通过页面对象来获取ID，由于快速切换时可能此时已经切换到其它tab页，因而不使用原来的getCurrentTabId来获取
    var tabId = window.parent.pub_getDetailController().getTabIdByWin(this);
    return tabId;
}

/**
 * 获取详细信息控制类.<br>
 * 
 * @author 王莉 w00138446
 * @since iManager U2000 V1R3,2010-4-15
 * @return 详细信息控制类
 */
function pub_getChildDetailCtrl()
{
    jse.getFromWin().pub_getChildDetailCtrl()
}

/**
 * 显示弹出菜单.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-13
 */
function popupContextMenu(evt)
{
    KeyRefChild.dataCtrl.popupContextMenu(evt);
}

/**
 * 双击表处理事件.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-15
 */
function tableDblClick(evt)
{
    doClickDetail();
}

/**
 * Action操作处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-10-19
 * @param evt
 * @return
 */
function doClickAction(evt)
{
    KeyRefChild.dataCtrl.doAction(evt);
}

/**
 * 获取选中行Id.<br>
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 * @return 选中行Id.
 */
function pub_getRowId()
{
    return KeyRefChild.tableModel.getCurrentSelectId();
}

/**
 * 获取子节点全局信息，其nodeInfo信息已经在查询处赋值
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 * @return 全局信息
 */
function pub_getFeaturePubData()
{    
    return KeyRefChild.featureData;
}

/**
 * 获取子Dialog页面的横坐标.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-13
 * @return 子Dialog页面的横坐标
 */
function pub_getXChildRelative()
{
    return KeyRefChild.xChildRelative + 30;
}

/**
 * 获取子Dialog页面的纵坐标.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-13
 * @return 子Dialog页面的纵坐标
 */
function pub_getYChildRelative()
{
    return KeyRefChild.yChildRelative + 30;
}

/**
 * 获取选择行的key值<br>
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-4-13
 * @return
 */
function pub_getSelectRowKeys()
{
    return window.parent.pub_getSelectRowKeys();
}

/**
 * 获取第二段控制类<br>
 * 
 * @author z00133566
 * @since iManager U2000 V1R6,2011-8-10
 * @return
 */
function pub_getDataController()
{
    return KeyRefChild.dataCtrl;
}

/**
 * 获取联动控制类
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 * @return 全局信息
 */
function pub_getLinkageCtrl()
{
    return null;
}

/**
 * 列定制后，重新初始化列信息,重新布局和加载数据
 * 
 * @author s00143960
 * @since iManager U2000 V1R3,2010-5-28
 * @return
 */
function pub_column()
{
    KeyRefChild.dataCtrl.initChildTableData("FEATURE", pub_getSelectRowKeys());
}

/**
 * 弹出设置密码对话框
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function doKeyPasswordClick(evt)
{
    
}

/**
 * 单击keyref按钮的事件处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-7
 */
function doKeyRefClick(evt)
{
    
}

/**
 * keyref联想关闭事件处理
 * 
 * @author x00211048
 * @since iManager U2000 V2R1,2013-4-25
 */
function doKeyRefCloseUp(evt)
{

}


/**
 * 用户在keyref输入框中输入值，进行联想
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-7
 */
function doKeyRefFilter(evt)
{
    
}

/**
 * 弹出设置密码对话框
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function doPasswordClick(evt)
{
    
}
Event.observe(window, "load", init);