/*
 * Title:         主要是用于第三段的属性组页面
 * Description:  [描述文件的功能、作用、使用方法和注意事项]
 * Copyright:     Copyright (c) 1988-2015
 * Company:       Huawei Tech. Co., Ltd
 * @author         f00145226
 * @version        版本  2010-3-12
 */
/**
 * 第三段属性组Tab页初始化控制类.<br>
 */
var g_groupProTableController = null;

var Group =
{
    /**
     * 全局变量
     */
    featureData : null,
    
    /**
     * 第二段控制类
     */
    dataCtrl : null
}

var signalMap =
{
    on_load_ui :doLoad
};

/**
 * 初始化页面.<br>
 */
function init()
{
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/configframe/xui/detail/detail.xui", signalMap);  

}

/**
 * 用户载入页面
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 * @return
 */
function doLoad()
{
    var proTable = window.xui.getWidget("PropertyTable");
    
    // 从父窗口中获取公共变量
    
    var globalData = _constructGlobalData();
    
	var rowId = null;
	var detail = window.parent.pub_getDetailController();
	var dataController = window.parent.pub_getDataController();
	Group.dataCtrl = dataController;
	
	if(!detail.getIsKeyRefItem())
    {
	    rowId = dataController.getTableModel().getCurrentSelectId();
    }
    else
    {
    	rowId = globalData.getFeatureForm().value;
    	var featureForm = globalData.getFeatureForm().keyRefFeatureForm;
    	globalData.setFeatureForm(featureForm);
    }
    var detailTable = new DatailTable(proTable);
    var tabId = getCurrentTabId();
    globalData.getFeatureForm().groupXpath = tabId;
    
    // 高级页面控制类
    g_groupProTableController = new GroupProTableController(detailTable, globalData.getFeatureForm(),
    globalData.getFrameParam(), globalData.getDeviceForm());
   
    Group.featureData = globalData;
    
    if(null != rowId)
    {        
    	g_groupProTableController.initProTable(rowId);
    }

    detail.setViewLoaded(tabId);    
    proTable.setNameColumnWidth(GlobalConstants.PROPERTY_NAMEWIDTH);
}

/**
 * 
 */
function _constructGlobalData()
{
	// 从父窗口中获取公共变量
	var featureData = window.parent.pub_getFeaturePubData();
	var globalData = new GlobalData();
	globalData.setDeviceForm(featureData.getDeviceForm().clone());
	globalData.setFrameParam(featureData.getFrameParam().clone());
	var featureForm = featureData.getFeatureForm()
	if((typeof featureForm.clone) != "undefined")
	{
		globalData.setFeatureForm(featureForm.clone());
	}
	else
	{
		globalData.setFeatureForm(featureData.getFeatureForm());
	}
	
	return globalData;
	
}

/**
 * 获取tabId.<br>
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-12-15
 * @return
 */
function getCurrentTabId()
{
    // 通过页面对象来获取ID，由于快速切换时可能此时已经切换到其它tab页，因而不使用原来的getCurrentTabId来获取
    var tabId = window.parent.pub_getDetailController().getTabIdByWin(this);
    return tabId;
}

/**
 * 
 * @author 陈传雨 c00149107
 * @since iManager U2000 V1R3,2010-10-26
 * @return
 */
function pub_setNameColWidth()
{
    var proTable = window.xui.getWidget("PropertyTable");
    proTable.setNameColumnWidth(GlobalConstants.PROPERTY_NAMEWIDTH);
}

/**
 * 获取公共全局变量.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-15
 * @return 公共全局变量
 */
function pub_getFeaturePubData()
{
    var globalData = Group.featureData;
    globalData.setFeatureForm(g_groupProTableController.getSelKeyRefInfo());
    return globalData;
}

/**
 * 获取第二段控制类.<br>
 * 
 * @author z00133566
 * @since iManager U2000 V1R6,2010-8-6
 */
function pub_getDataController()
{
    return Group.dataCtrl;
}

Event.observe(window, "load", init);