/**
 * 在线第三段子页面的分页处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-6-26
 */
function OnlineChildPageController(pageLabel, pageBar, table, deviceForm, featureForm, frameParam)
{
    PagedController.call(this, pageLabel, pageBar, table, deviceForm, featureForm, frameParam);
}

OnlineChildPageController.prototype = new PagedController();

/**
 * 查询某页_子类实现_应处理查询结果，并返回PageInfo<DataTableModel>
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-6-26
 */
OnlineChildPageController.prototype.doQueryPageData = function(pageQueryParam)
{
    var result = jsonrpc.invoke("childDataTableViewFactoryBean", "queryDataByPage", [ this._deviceForm, this._featureForm.changJsonForm(),
            this._frameParam, this._table.getJonsColumnInfos(), pageQueryParam ]);

    return result;
}

OnlineChildPageController.prototype.doAsynQueryPageData = function(pageQueryParam, callback, refrence, callbackParams)
{
    jsonrpc.asynInvokeWaiting("childDataTableViewFactoryBean", "queryDataByPage", [ this._deviceForm, this._featureForm.changJsonForm(),
            this._frameParam, this._table.getJonsColumnInfos(), pageQueryParam ], callback,refrence, callbackParams);
}

/**
 * 获取分页信息
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-6-26
 */
OnlineChildPageController.prototype.doQueryPageInfo = function()
{
    var result = jsonrpc.invokeWithoutMask("childDataTableViewFactoryBean", "queryPageInfo", [this._queryId, this._featureForm.changJsonForm()]);

    return result;
}