/*
 * Title:         主要是用于第三段的高级页面
 * Description:  [描述文件的功能、作用、使用方法和注意事项]
 * Copyright:     Copyright (c) 1988-2015
 * Company:       Huawei Tech. Co., Ltd
 * @author         f00145226
 * @version        版本  2010-3-12
 */
/**
 * 第三段高级Tab页初始化控制类.<br>
 */
var g_advanceProTableController = null;

var Advance =
{
    /**
     * 全局变量
     */
    featureData : null,
    
    /**
     * 第二段控制类
     */
    dataCtrl : null
}

var signalMap =
{
    on_load_ui :doLoad
};

/**
 * 初始化页面.<br>
 */
function init()
{
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/configframe/xui/detail/detail.xui", signalMap);  

}

/**
 * 用户载入页面
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 * @return
 */
function doLoad()
{
    var proTable = window.xui.getWidget("PropertyTable");
    // 从父窗口中获取公共变量
    var featureData = window.parent.pub_getFeaturePubData();
    var globalData = new GlobalData();
    globalData.setDeviceForm(featureData.getDeviceForm());
	globalData.setFeatureForm(featureData.getFeatureForm());
	globalData.setFrameParam(featureData.getFrameParam());

	var rowId = null;
	var detail = window.parent.pub_getDetailController();
    var dataController = window.parent.pub_getDataController();
    Advance.dataCtrl = dataController;
    
    if(!detail.getIsKeyRefItem())
    {
	    rowId = dataController.getTableModel().getCurrentSelectId();
    }
    else
    {
    	rowId = globalData.getFeatureForm().value;
    	var featureForm = globalData.getFeatureForm().keyRefFeatureForm;
    	globalData.setFeatureForm(featureForm);
    }
    
    var detailTable = new DatailTable(proTable);
    // 高级页面控制类
    g_advanceProTableController = new AdvanceProTableController(detailTable, null, 
    globalData.getFeatureForm(), globalData.getFrameParam(), globalData.getDeviceForm());
    Advance.featureData = globalData;
    //若当前有选中行，才进行请求数据
    if(null != rowId)
    {        
        g_advanceProTableController.initProTable(rowId);
    }

    detail.setViewLoaded("advance");  
    proTable.setNameColumnWidth(GlobalConstants.PROPERTY_NAMEWIDTH);
}

/**
 * 
 * @author 陈传雨 c00149107
 * @since iManager U2000 V1R3,2010-10-26
 * @return
 */
function pub_setNameColWidth()
{
    var proTable = window.xui.getWidget("PropertyTable");
    proTable.setNameColumnWidth(GlobalConstants.PROPERTY_NAMEWIDTH);
}

/**
 * 获取高级页面控制类.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-26
 * @return 高级页面控制类
 */
function pub_getProTableCtrl()
{
    return g_advanceProTableController;
}


/**
 * 获取第二段控制类.<br>
 * 
 * @author z00133566
 * @since iManager U2000 V1R6,2010-8-6
 * @return 常规页面控制类
 */
function pub_getDataController()
{
    return Advance.dataCtrl;
}

/**
 * 获取公共全局变量.<br>
 * 
 * @author z00133566
 * @since iManager U2000 V1R6,2010-8-5
 * @return 公共全局变量
 */
function pub_getFeaturePubData()
{
    var globalData = Advance.featureData;
    globalData.setFeatureForm(g_advanceProTableController.getSelKeyRefInfo());
    return globalData;
}

Event.observe(window, "load", init);