jse.require("vmt.extend.table_prototype");

/**
 * 配置类
 */
var g_config = {};

/**
 * 操作函数映射表
 */
var signalMap =
{
    onClickToolButtonExpandAll : doExpandAll,
    onClickToolButtonCollapseAll : doCollapseAll,
    onClickOKButton : clickOkBtn,
    onClickCancelButton : clickCancelBtn,
    onClickApplyButton : clickApplyBtn,
    on_load_ui : doLoad
};

/**
 * 初始化函数，当页面载入时调用，将页面定义文件加载进来
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-9
 * @return
 */
function init()
{
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/configframe/xui/templet/deployment.xui", signalMap);
}

/**
 * 页面载入并加载数据
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-9
 * @return
 */
function doLoad()
{
    var deploymentLoader = new DeploymentViewLoader();

    deploymentLoader
            .setRefObjDataCacheMgr(new KeyrefObjDataCacheMgr(jse.getFromWin().pub_getFeatureData()));
    g_config = new DeploymentController();

    var urlArray = [];
    urlArray[RefDlgUrlType.KEYREF] = CommonUtil.getRootPath() + "/vmt/ct/online/view/keyref/keyref.html";

    // ref关系选择控制类
    var refSelectControler = new RefSelectControler(new DeploymentKeyrefViewController(), null);

    deploymentLoader.doLoad(urlArray, g_config, refSelectControler);
}

/**
 * 用户展开结点行
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-9
 * @param evt 事件信息
 */
function onDblClick(evt)
{
}

/**
 * 单元格的变化
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-9
 * @param evt 事件信息
 */
function onCellSelChanged(evt)
{
    // 设置树表可编辑的单元格的多国语言样式
    Preconstraints.setTableCellStype(Preconstraints.NORMAL_OPERATION);
}

/**
 * 用户点击结点前面的加号展开结点行
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-9
 * @param evt 事件信息
 */
function onExpanding(evt)
{
}

/**
 * 处理最后一个单元格的Tab事件
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-9
 * @param evt 事件信息
 */
function doLastCellFocus(evt)
{
    g_config.doLastCellFocus(evt);
}

/**
 * 加载页面
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-3
 * @param isInitBySelf
 * @return
 */
function onshow(isInitBySelf)
{
    this.doLoad();
}

/**
 * 用户改变cell内值时进行校验，如果校验不通过设置单元格背景颜色为红色
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-3
 * @param evt 事件信息
 */
function onValueChanged(evt)
{
    g_config.valueChange(evt);
}

/**
 * 单击图片操作函数
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2011-01-19
 * @param evt 事件信息
 * @return
 */
function clickImage(evt)
{
    if (evt.imageId == Image.DELETE)
    {
        g_config.deleteNode(evt.rowId);
    }
    else if (evt.imageId == Image.ADD)
    {
        g_config.createNode(evt.rowId);
    }
    else if (evt.imageId == Image.DELETEALL)
    {
        g_config.deleteAllNode(evt.rowId);
    }
    else if (evt.imageId == Image.BATCHBIND)
    {
        g_config.createNode(evt.rowId);
        //g_config.batchBind(evt.rowId, CommonUtil.getRootPath() + "/vmt/ct/online/view/batchbind/batchbind.html");
    }
    else
    {
        // 暂不支持
    }
}

/**
 * TODO 后续需要切换至JSE会提供实时监听键盘输入的事件， 用户正在改变cell内值时的处理
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2011-01-19
 * @param evt 事件信息
 */
function onValuechanging(evt)
{
    g_config.valuechanging(evt);
}

/**
 * 用户点击展开所有行
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-3
 * @return
 */
function doExpandAll()
{
    g_config.expandAll();
}

/**
 * 单元格变化事件
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-3
 * @param evt 事件信息
 */
function onSelChanged(evt)
{
    g_config.selectChange(evt.id);
}

/**
 * 用户收缩所有行
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-3
 * @return
 */
function doCollapseAll()
{
    g_config.collapseAll();
}

/**
 * 点击确定按钮的函数
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-3
 * @return
 */
function clickOkBtn()
{
    g_config.clickOkBtn();
}

/**
 * 单击keyref按钮的事件处理
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-6
 * @param evt 事件信息
 * @return
 */
function doKeyRefClick(evt)
{
    g_config.doKeyRefClick(evt);
}

/**
 * 用户在keyref输入框中输入值，进行联想
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-6
 * @param evt 事件信息
 */
function doKeyRefFilter(evt)
{
    g_config.doKeyRefFilter(evt);
}

/**
 * 点击取消按钮的函数
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-3
 * @return
 */
function clickCancelBtn()
{
	F1HelpUtil.resetF1PageTitle("vmf.template.templatemanager");
    g_config.closeSelfView();
}

/**
 * 点击应用按钮的函数
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-3
 * @return
 */
function clickApplyBtn()
{
    g_config.clickApplyBtn();
}

/**
 * 获取模板控制类
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2011-01-19
 * @return
 */
function pub_getConfigCtrl()
{
    return g_config;
}

/**
 * 单击bitMask按钮的事件处理
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-12-28
 * @param 事件信息
 */
function doBitMaskClick(evt)
{
    g_config.doBitMaskClick(evt);
}

Event.observe(window, "load", init);