jse.require("jse.widget.dialog");

/**
 * textarea对象
 */
var userDefinedStickTextArea = null;

/**
 * 操作行ID
 */
var rowID = null;

/**
 * 批量条数
 */
var batchNumber = null;

/**
 * 表格树对象
 */
var tableGrid = null;

/**
 * 父窗体
 */
var fromWin = null;

/**
 * 确定按钮
 */
var okBtn = null;

/**
 * XUI文件的事件处理函数映射表
 */
var signalMap =
{
    
    on_load_ui :doLoad,
    onClickCancelButton:doClickCancelButton,
    onClickConfirmButton:doClickConfirmButton
};

/**
 * 初始化加载XUI
 */
function init()
{
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    window.xui.load("/vmt/ct/feature/definedstick.xui", signalMap);
}

/**
 * 向界面中添加数据
 */
function doLoad()
{
    fromWin = jse.getFromWin();
    userDefinedStickTextArea = window.xui.getWidget("UserDefinedStickTextArea");
    userDefinedStickTextArea.focus();
    //注册键盘操作
    userDefinedStickTextArea.onkeydown = onKeyDown;
    //确定按钮初始化为不可用
    okBtn = window.xui.getWidget("Button2");
    okBtn.setEnabled(false);
    
    rowID = fromWin.clickCopyImageRowId;
    
    var userDefinedStickBox  = window.xui.getWidget("UserDefinedStickBox");
    userDefinedStickBox.pack();
}

/**
 * 加载动态信息
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R3,2010-6-30
 * @param isInitBySelf 区分该方法是内嵌页面还是组件的 show()调用的
 * @return
 */
function onshow(isInitBySelf)
{
    this.doLoad();
}

/**
 * 键盘事件处理方法
 * @return
 */
function onKeyDown()
{
	//在键盘操作结束后100ms触发一次判断文本框的操作
	setTimeout("enableOkBtn();",100);
}

/**
 * 判断文本框，如果为空，确定按钮不可用
 * @return
 */
function enableOkBtn()
{
	if(0 == userDefinedStickTextArea.getText().length)
	{
		okBtn.setEnabled(false);
	}
	else
	{
		okBtn.setEnabled(true);
	}
}

/**
 * 点击取消按钮处理
 */
function doClickCancelButton()
{
    jse.closeSelfView();
}

/**
 * 点击确定按钮处理方法
 */
function doClickConfirmButton()
{
    var areaContent = userDefinedStickTextArea.getText();
    var index = areaContent.lastIndexOf("\n");

    if (areaContent.length - 1 == index)
    {
        areaContent = areaContent.substring(0, index);
    }

    var areaContents = areaContent.split("\n");
    fromWin.pub_doClickConfirmButton(rowID, areaContents);
    jse.closeSelfView();
}

Event.observe(window, "load", init);