/*
 * Title:         第三段详细信息Dialog控制
 * Description:  主要负责第三段详细信息Dialog加载常规、高级和子页面
 * Copyright:     Copyright (c) 1988-2015
 * Company:       Huawei Tech. Co., Ltd
 * @author         w00138446
 * @version        版本  2010-4-14
 */

/**
 * 第三段详细信息Dialog控制类，用于显示常规、高级和子界面.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3, 2010-4-14
 * @param _queryViewManager 显示常规/高级/子的视图控件
 * @param _xChildRelative Dialog横坐标
 * @param _yChildRelative Dialog纵坐标
 * @param _nodeInfo 子选中行信息
 * @param _Ctrl 子详细信息控制类
 */
var ChildDetail =
{
    /**
     * viewManager控件
     */
    _queryViewManager :null,

    /**
     * Dialog横坐标
     */
    _xChildRelative :null,

    /**
     * Dialog纵坐标
     */
    _yChildRelative :null,

    /**
     * 子详细信息控制类
     */
    _Ctrl :null,

    /**
     * 公共全局变量
     */
    _globalData :null

}

/**
 * 映射表.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-14
 */
var signalMap =
{
    on_load_ui :doLoad,
    onViewChanged :doViewChanged,
    doClose :doCloseDiaLog
};

/**
 * 初始化函数，当页面载入时调用load函数将页面定义文件加载进来.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-14
 */
function init()
{
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/configframe/xui/detail/childdetail.xui", signalMap);
}

/**
 * 加载页面初始设置.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-14
 */
function doLoad()
{
    // 获得界面控件对象
    ChildDetail._queryViewManager = window.xui.getWidget("ViewManager");

    // 从父页面获取globalData;
    ChildDetail._globalData = jse.getFromWin().pub_getFeaturePubData();

    // 初始化第三段表格
    var normalUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/detail/normal.html";
    var advanceUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/detail/advance.html";
    var childUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/multifeature/multichild.html";
    var groupUrl =CommonUtil.getRootPath() + "/vmt/ct/online/view/detail/group.html";
    ChildDetail._Ctrl = new DetailController(ChildDetail._queryViewManager, null, ChildDetail._globalData.getNodeInfo());
    ChildDetail._Ctrl.initTabUrls(normalUrl, advanceUrl, childUrl, groupUrl);
    ChildDetail._Ctrl.setChildDetail(true);
    
    ChildDetail._Ctrl._customChildTabIds = pub_getDataController()._detailCtrl._customChildTabIds;
    ChildDetail._Ctrl.initChildDetail(null, ChildDetail._globalData);

    // 弹出对话框横纵坐标
    ChildDetail._xChildRelative = jse.getFromWin().pub_getXChildRelative();
    ChildDetail._yChildRelative = jse.getFromWin().pub_getYChildRelative();
}

/**
 * 加载动态信息
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-6-30
 * @param isInitBySelf 区分该方法是内嵌页面还是组件的 show()调用的
 * @return
 */
function onshow(isInitBySelf)
{
    this.doLoad();
}

/**
 * 获取当前页面横坐标.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-15
 * @return 当前页面横坐标
 */
function pub_getXChildRelative()
{
    return ChildDetail._xChildRelative + 25;
}

/**
 * 获取当前页面纵坐标.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-15
 * @return 当前页面纵坐标
 */
function pub_getYChildRelative()
{
    return ChildDetail._yChildRelative + 25;
}

/**
 * 获取公共全局变量.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-15
 * @return 公共全局变量
 */
function pub_getFeaturePubData()
{
    return ChildDetail._globalData;
}

/**
 * 获取子详细信息控制类.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-15
 * @return 子详细信息控制类
 */
function pub_getDetailController()
{
    return ChildDetail._Ctrl;
}

/**
 * "关闭"按钮事件处理：关闭对话框.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-15
 */
function doCloseDiaLog(evt)
{
    ChildDetail._Ctrl.closeAllView();
    pub_getDataController().setAutoRefreshEnable(true);
    jse.closeSelfView();
}

/**
 * 用于隐藏对话框的回调函数调用<br>
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-4-15
 */
function clickCancelBtn()
{
    ChildDetail._Ctrl.closeAllView();
    pub_getDataController().setAutoRefreshEnable(true);
    jse.closeSelfView();
}

/**
 * 切换Tab页处理事件
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-15
 */
function doViewChanged(evt)
{
    ChildDetail._Ctrl.viewChange(evt);
}

function pub_getDataController()
{
    var parent = jse.getFromWin();
    return parent.pub_getDataController();
}

/**
* 获取FeatureTabViewCtrl对象
*
* @returns
*/
function pub_getFeatureTabViewCtrl()
{
return parent.pub_getFeatureTabViewCtrl();
}
Event.observe(window, "load", init);