jse.require("vmt.extend.table_prototype");

/**
 * 表格数据控制类。类型为KeyrefDataController
 */
var g_keyrefDataController = {};

/**
 * 全局变量。类型为GlobalData
 */
var g_keyrefFeatureData = {};

/**
 * 公共方法类，供其他类调用。类型为CommonUtil
 */
var g_keyrefResource = {};

/**
 * 分页控制器
 */
var g_pagedController = null;

/**
 * 过滤控制类
 */
var g_filterCtrl = null;

/**
 * 筛选控件
 */
var g_colFilterCtrl = null;

/**
 * 鉴权
 */
var g_perAuthority = null;

/**
 * toolbar控制类
 */
var g_statusController = null;

var g_batchAddNum = null;

/**
 * 联动控制类
 */
 var g_linkageCtrl = null;
 
/**
 * 引用对话框控制类，用来进行对话框的处理
 */
var g_refDlgController = null;

/**
 * keyref信息
 */
var g_keyrefForm = null;

/**
 * 事件注册
 */
var signalMap =
{
    on_load_ui : doLoad,
    onClickOkButton : doOK,
//    doTableDbClick : doDbClick,
    doClickQueryButton : popupFilterDialog,
    doConditionComboValueChanged : comboSelChange,
 onClickCancelButton : clickCancelBtn,
//    doTableDbClick : doTableDbClick,
    doTableSelChanged : doSelChange,
    
    onClickToolButtonNewCollect : doClickCreateCollect,
    onClickToolButtonNew :doClickCreate,
    onClickToolButtonModify :doClickModify,
    onClickToolButtonDelete :doClickDelete,
    //doClickQueryButton :doClickFilterButton,
    //onClickToolButtonRefresh :doClickSynchronizeData,
    onClickToolButtonRefreshAll :doClickSynchronizeAllData,
    onClickToolButtonBatchNew :doClickBatchAddNum,
    //onClickToolButtonCustomColumn :doClickCustomColumn,
    //onClickToolButtonSaveas :doClickSaveas,
    onClickToolButtonClone :doClickClone,
    //onClickUAHelp :doClickUAHelp
// handle_onvaluechanged :doNavigator,
// handle_ondragmove :doDragmoveNavigator
    onSelectAllStateChanged : dockbSelectAllChanged
};

/**
 * 初始化XUI界面
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-29
 * @return
 */
function init()
{
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/configframe/xui/batchbind/batchbind.xui", signalMap);
}

/**
 * 加载页面中的数据
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-7
 * @return
 */
function doLoad()
{
    // 初始化选择框为false
    var ckbSelectAll = window.xui.getWidget("ckbSelectAll");
    ckbSelectAll.setChecked(false);

    var table = window.xui.getWidget("BatchBindTable");
    table.onsort = doSort;
    table.setAllColSortable(true);
    
    initTableHander(table);

    var configWin = jse.getFromWin();

    // 从父窗口中获取公共变量
    var configCtrl = configWin.pub_getConfigCtrl();
    // 获取引用对象的特性信息
    var currentChildListAttribute = configCtrl.getCurrentBatchBindOper().getCurrentChildListAttribute();
    
    var keyrefViewCtrl = configCtrl.getRefSelectCtrl().getKeyrefViewCtrl();
    
    g_keyrefFeatureData = configCtrl.getFeatureData().clone();
    
    var tempFeatureData = configCtrl.getFeatureData().clone();
    var tempFeatureForm =  tempFeatureData.getFeatureForm();
    tempFeatureForm.xpath = ConfigUtil.getNodeXpath(currentChildListAttribute.getAttributeID(), SEPARATOR_XPATH_LABEL);
    var keyrefFeatureForm = getKeyrefFeatureForm(tempFeatureData.getDeviceForm(), tempFeatureForm, tempFeatureData
            .getFrameParam(),keyrefViewCtrl._treeTable);

    var deviceForm = g_keyrefFeatureData.getDeviceForm();

    var featureForm = currentChildListAttribute.getRefFeatureForm().clone();
    // 将第二段中FeatureForm的domain的值 设置到 keyref中FeatureForm中的domain
    featureForm.domain = g_keyrefFeatureData.getFeatureForm().domain;
    
    
    featureForm.funcnodeName = keyrefFeatureForm.funcnodeName;
    featureForm.tabId = keyrefFeatureForm.tabId;
    featureForm.keyrefExtInfo = keyrefFeatureForm.keyrefExtInfo;
    
    var frameForm = g_keyrefFeatureData.getFrameParam();
    var nodeInfo = g_keyrefFeatureData.getNodeInfo();
    frameForm.viewType = "SELECT";

    g_keyrefFeatureData.setFeatureForm(featureForm);
    g_keyrefResource = new FeaturesResourceMgr();

    // 初始化表格和表格模型，用于构造第二段控制模型
    var tableModel = new MultiTableModel(g_keyrefResource, table,featureForm.xpath);
    var vmtTable = new MultiBatchSelectedTable(table, tableModel, g_keyrefResource, ckbSelectAll);

    // 初始化第二段分页模型
    var pagedLabel = window.xui.getWidget("infoLabel");
    var pagedBar = window.xui.getWidget("checkTableNavigator");
    pagedBar.ondragmove = doNavigate;
    pagedBar.onvaluechanged = doNavigate;
    g_pagedController = new MultiKeyrefPageController(pagedLabel, pagedBar, vmtTable, deviceForm, featureForm, frameForm,
            ckbSelectAll);

    var comboObject = window.xui.getWidget("featureConditonComboID");
    var resource = keyrefViewCtrl.getResource();
    g_filterCtrl = new FilterController(vmtTable, comboObject, g_keyrefResource);
    
    //初始化Toolbar控制类
    initStautsCtrl(vmtTable);

    // 数据查询处理调用选择父的处理即可
    g_keyrefDataController = new MultiKeyrefDataController(vmtTable, tableModel, g_keyrefResource, featureForm, frameForm,
            nodeInfo, deviceForm, g_pagedController, g_filterCtrl, g_statusController, g_keyrefForm.historyConditions);
    g_keyrefDataController.setKeyrefViewCtrl(configCtrl);
   
    g_colFilterCtrl = new MultiKeyrefColumnFilterController(vmtTable, g_keyrefDataController);
    g_keyrefDataController.setColFilterCtrl(g_colFilterCtrl);

    // 生成批量绑定引用对话框处理对象
  
    g_refDlgController = new BatchBindRefDlgController(keyrefFeatureForm, g_keyrefDataController, vmtTable, tableModel,
            g_pagedController, configCtrl, false);

    pub_refreshLocalView(vmtTable, resource);
}

/**
 * 初始化表格事件
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 * @param table 第二段表格
 */
function initTableHander(table)
{
    table.onselchanged = doTableSelChange;
    
    table.onvaluechanged = onValueChanged;
    table.onvaluechanging = onValuechanging;
    table.oncontextmenu = popupContextMenu;
    table.ondblclick = doTableDbClick;
    table.setAllColSortable(true);

}

/**
 * 值变化事件处理
 * 
 * @param evt
 */
function onValueChanged(evt)
{
    g_keyrefDataController.valueChangeExtend(evt);
}

/**
 * 值变化事件处理
 * 
 * @param evt
 */
function onValuechanging(evt)
{
    g_keyrefDataController.valuechanging(evt);
}

/**
 * 弹出右键菜单
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 * @param evt
 * @return
 */
function popupContextMenu(evt)
{
    g_keyrefDataController.popupContextMenu(evt);
}

/**
 * 用户点击修改按钮
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 * @return
 */
function doClickModify()
{
    logger.log("start doClickModify");
    g_keyrefDataController.directModifyRecordes();    
}

/**
 * 批量新建条数
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-5-19
 */
function doClickBatchAddNum()
{
	F1HelpUtil.changeF1NeMgrPageTitle("batchnew");
    g_keyrefDataController.showBatchNumDialog();
}

/**
 * 批量新建
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-5-19
 * @param batchAddNum 批量新建条数
 */
function doClickBatchAdd(batchAddNum)
{
    logger.log("start loader.js doClickBatchAdd."); 
    g_batchAddNum = batchAddNum;
    // 在打开树表配置对话框的时候预先请求配置界面数据
    var initTreeTableView = new BatchAddedTreeInitOper();
    g_keyrefDataController.addInitTreeTableViewOper(initTreeTableView); 
    initTreeTableView.preRequestOperResult(g_keyrefDataController, batchAddNum, null);    
    
    var operation = Resource.getResource("qat:public", "dialog_batchcreateconfig_d");
    var createDialogUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/config/batchadd/batchadd.html";
    F1HelpUtil.changeF1NeMgrPageTitle("batchnew");
    
    if(jse.topWin.isPopMaxdiaglogNUM())
    {
    	return;
    }
    var dialogId = jse.topWin.constructDialogId("batchadd");
    jse.topWin.pushDialogId(dialogId);
    
    g_keyrefDataController.createRecord(null, operation, dialogId, createDialogUrl);
}

/**
 * 获取全局公共方法
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 * @return 全局信息
 */
function pub_getBatchAddNum()
{
    return g_batchAddNum;
}


/**
 * 用户切换table行
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 * @return
 */
function doTableSelChange(evt)
{
    // 选择完成才执行，防止调用两次事件
    if (evt.isAdjusting)
    {
        return;
    }
//    this._detailController.tableSelChange(this._featureData.getFeatureForm().xpath);
    g_keyrefDataController.tableSelChange();
    g_keyrefDataController.setTableFocus();
}

/**
 * 初始化Toolbar控制类
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 */
function initStautsCtrl(vmtTable)
{
    var deviceForm = g_keyrefFeatureData.getDeviceForm();
    var featureForm = g_keyrefFeatureData.getFeatureForm();
    var frameForm = g_keyrefFeatureData.getFrameParam();

    // 初始化第一段控制模型
    g_perAuthority = new ConfigPreAuthority(deviceForm.deviceIp);
    g_perAuthority.init();
    var toolbar = new ToolBar();
    var toolbarCtrl = new ToolbarController(toolbar, vmtTable, g_perAuthority);

    var menu = new ConfigMenu(this._resource);
    var menuCtrl = new MenuController(menu, vmtTable, g_perAuthority);
    g_statusController = new StatusController(toolbarCtrl, menuCtrl, g_perAuthority);
}

/**
 * 用户点击同步所有按钮
 * 
 * @author s00143960
 * @since iManager U2000 V1R3,2010-4-17
 * @return
 */
function doClickSynchronizeAllData()
{
    g_keyrefDataController.sysAllRecord(this._detailController);
}

/**
 * 用户点击删除按钮
 * 
 * @author s00143960
 * @since iManager U2000 V1R3,2010-4-13
 * @return
 */
function doClickDelete()
{
    g_keyrefDataController.deleteRecord(null);
}

/**
 * 用户点击新建按钮
 * 
 * @author ywx159756
 * @since iManager U2000 V2R1, 2013-9-14
 */
function doClickCreateCollect(evt)
{

    var moduleName = jse.topWin.moduleName;
    switch(moduleName)
    {
        case ModuleName.V8PTN:
        {
            doClickCreate();
            break;
        }
        case ModuleName.VMF:
        {
            var table = window.xui.getWidget("BatchBindTable");
            g_keyrefDataController.doClickCreateCollect(evt,table);
            break;
        }
        default:
        {
            var table = window.xui.getWidget("BatchBindTable");
            g_keyrefDataController.doClickCreateCollect(evt,table);
            break;
        }
    }  
    
}

/**
 * 用户点击新建按钮
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 */
function doClickCreate()
{
    // 在打开树表配置对话框的时候预先请求配置界面数据
    var initTreeTableView = new AddedTreeInitOper();
    g_keyrefDataController.addInitTreeTableViewOper(initTreeTableView); 
    initTreeTableView.preRequestOperResult(g_keyrefDataController, null);    
    
    var operation = Resource.getResource("qat:public", "dialog_createconfig_d");
    var createDialogUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/config/add/add.html";
    F1HelpUtil.changeF1NeMgrPageTitle("add");
    
    if(jse.topWin.isPopMaxdiaglogNUM())
    {
    	return;
    }
    var dialogId = jse.topWin.constructDialogId("new");
    jse.topWin.pushDialogId(dialogId);
    
    g_keyrefDataController.createRecord(g_keyrefDataController, operation, dialogId, createDialogUrl);
}

/**
 * 拷贝新建
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-5-19
 */
function doClickClone()
{
    // 在打开树表配置对话框的时候预先请求配置界面数据
    var initTreeTableView = new CloneTreeInitOper(); 
    g_keyrefDataController.addInitTreeTableViewOper(initTreeTableView); 
    initTreeTableView.preRequestOperResult(g_keyrefDataController);     
    
    var operation = Resource.getResource("qat:public", "dialog_cloneconfig_d");
    var cloneViewUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/config/clone/clone.html";
    F1HelpUtil.changeF1NeMgrPageTitle("clone");
    
    if(jse.topWin.isPopMaxdiaglogNUM())
    {
    	return;
    }
    var dialogId = jse.topWin.constructDialogId("clone");
    jse.topWin.pushDialogId(dialogId);
    
    g_keyrefDataController.cloneSingleRecord(null, operation, dialogId, cloneViewUrl);
}

/**
 * 用户右键设置combo类型值
 * 
 * @author x64338
 * @since iManager U2000 V2R1,2013-1-8
 */
function doSetComboValue(evt)
{
	g_keyrefDataController.doSetComboValue(evt);
}

/**
 * 用户右键设置值
 * 
 * @author x64338
 * @since iManager U2000 V2R1,2013-1-9
 */
function doBatchModifyValue(evt)
{
	g_keyrefDataController.doBatchModifyValue(evt);
}


function getBatchModifyObj()
{
	return g_keyrefDataController.getBatchModifyObj();
}

/**
 * 区分单元格，是否可编辑，双击不可编辑的单元格为选中
 * 双击可编辑单元，进入编辑状态
 */
function doTableDbClick(evt)
{
	var table = g_keyrefDataController.getTable()._table;
	//不可编辑，则选择
	if(!table._isEditable(evt.rowId, evt.colId))
	{
		doOK();
	}
}

/**
 * 加载动态信息
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R3,2010-6-30
 * @param isInitBySelf 区分该方法是内嵌页面还是组件的 show()调用的
 * @return
 */
function onshow(isInitBySelf)
{
    this.doLoad();
}

/**
 * 获取全局信息
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-5-14
 * @return 全局信息
 */
function pub_getFeaturePubData()
{
    return g_keyrefFeatureData;
}

/**
 * 获取三段式第一段的控制类
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-5-14
 * @return 全局信息
 */
function pub_getDataController()
{
    return g_keyrefDataController;
}

/**
 * 获取全局公共方法
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-5-14
 * @return 全局信息
 */
function pub_getResource()
{
    return g_filterCtrl._resource;
}

/**
 * 获取联动控制类
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 * @return 全局信息
 */
function pub_getFilterCtrl()
{
    return g_filterCtrl;
}

/**
 * 获取keyref对应特性的版本
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-20
 */
function getKeyrefFeatureForm(deviceForm, featureForm, frameForm,table)
{
    var result = jsonrpc.invoke("keyrefDataTableFactory", "getKeyrefFeatureForm", [ deviceForm,
            featureForm.changJsonForm(), frameForm ]);
    if (result.resultType == "OPER_OK")
    {
        g_keyrefForm = result.returnObj;
        var keyrefFeatureFormList = result.returnObj.featureForms.list;
        var srcConditions = result.returnObj.srcConditions;
        var index = getSrcConditionIndex(srcConditions,table,null);
        var keyrefFeatureForm = keyrefFeatureFormList[index];
        var featureForm = new FeatureForm();
        featureForm.initFeatureForm(keyrefFeatureForm);
        return featureForm;
    }
    else
    {
        // 弹出错误对话框
        CommonDlgReq.openRspErrorDialog(result, null, null);
        return;
    }
}
function getSrcConditionIndex (srcConditions,table)
{
    var srcCondtionIndex = 0;
    if(srcConditions != null && srcConditions.list.length > 0)
    {
        var colId = "value";
        for(var index in srcConditions.list)
        {
            var conditions = srcConditions.list[index];
            if(null == conditions)
            {
                continue;
            }
            if(conditions.conditionType == "OR")
            {
                for(var i in conditions.conditions.list)
                {
                    var conditionMap = conditions.conditions.list[i].map
                    for(var xpath in conditionMap)
                    {
                        var tableType = table.getTableType();
                        var operRowId = table.getRowId(xpath);
                        var cell = table.getCell(operRowId,colId);
                        if(null != cell)
                        {
                            var curValue = table.getCellValue(operRowId, colId);
                            //由于是or关系，只要匹配一条界面上的值与keyref的source中配置的值相等
                            if(curValue == conditionMap[xpath])
                            {
                                srcCondtionIndex = index;
                                return srcCondtionIndex;
                            }
                        }
                    }
                }
            }
            else
            {
                var conditionMap = conditions.conditions.list[0].map;
                var isSatisfy = true;
                for(var xpath in conditionMap)
                {
                    var tableType = table.getTableType();
                    var operRowId = table.getRowId(xpath);
                    var cell = table.getCell(operRowId, colId);                   
                    if(null == cell)
                    {
                        continue;
                    }
                     var curValue = table.getCellValue(operRowId, colId);
                     //由于是and关系，需要匹配所有条件
                     if(curValue != conditionMap[xpath])
                     {
                          isSatisfy = false;
                          break;
                     }
                }
                if(isSatisfy)
                {
                    srcCondtionIndex = index;
                }
                else
                {
                    srcCondtionIndex = 0;
                }
            }
        }
    }
    return srcCondtionIndex;
}

/**
 * 跳转到指定页
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-29
 * @return
 */
function doNavigate(evt)
{
    g_keyrefDataController.getTable().clearSavedOperData();
    g_keyrefDataController.handleNavigate(evt.value - 1);
}

/**
 * 排序
 * 
 * @author l00106357
 * @since iManager U2000 V1R3,2010-4-14
 * @return
 */
function doSort(colId, sortType)
{
    // 获取当前选中行
    var rowIds = g_keyrefDataController.getTable().getSelectRowIds();

    g_keyrefDataController.sortColumn(colId, sortType);

    // 重新选中排序前的行
    g_keyrefDataController.getTable().setSelection(rowIds);
}

/**
 * 刷新可变控件的数据和界面.添加表的列和表中的数据
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-7
 * @return
 */
function pub_refreshLocalView(vmtTable, resource)
{
	initLinkageCtrl(vmtTable, resource);
	
    g_keyrefDataController.stopQueryData();
    g_keyrefDataController.updateTable("SELECT");
}

/**
 * 初始化三段式联动控制类
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 */
function initLinkageCtrl(vmtTable, resource)
{
	var checkerUseData = new FeatureCheckerUseData(vmtTable, resource);
	
	var checkerFactory = new FeatureTableCheckerFactory();
	var prosorUseData = new FeatureProsorUserData(vmtTable, g_statusController, null);
	
	var prosorFactory = new FeatureTableProsorFactory();
    var linkageTransactionCtrl = new FeatureLinkageTransactionCtrl(checkerFactory, prosorFactory);
	
	g_linkageCtrl = new FeatureLinkageController(checkerUseData, linkageTransactionCtrl, prosorFactory, prosorUseData);

    prosorUseData.linkageCtrl = g_linkageCtrl;
    
    g_keyrefDataController.setLinkageCtrl(g_linkageCtrl);
//    this._detailController.setLinkageCtrl(this._linkageCtrl);
}

/**
 * 用户点击确定按钮的事件处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-7
 * @return
 */
function doOK()
{
    g_keyrefDataController.stopQueryData();
    g_refDlgController.doOK();
    
    jse.topWin.popDialogId();
}

/**
 * 表格的双击处理
 * 
 * @author j65716
 * @since iManager U2000 V1R5,2011-1-31
 */
function doDbClick()
{
    g_refDlgController.doDbClick();
}

/**
 * 用户点击取消按钮的事件处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-7
 * @return
 */
function clickCancelBtn()
{
    g_keyrefDataController.stopQueryData();
    g_refDlgController.closeSelfView();
    g_keyrefDataController.removeFilterConditionCombos();
    jse.topWin.popDialogId();
}

/**
 * 表中行选择变化时的事件处理
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-5-19
 * @return
 */
function popupFilterDialog(evt)
{
    var xpath = g_keyrefFeatureData.getFeatureForm().xpath;
    g_keyrefDataController.doClickFilterButton(evt,"batchbindKeyRefFilter" + xpath,"batchbindKeyrefMethodFilter");
}
/**
 * 打开默认过滤界面
 */
function doClickNormalFilter()
{
    var xpath = g_keyrefFeatureData.getFeatureForm().xpath;
    g_keyrefDataController.openNormalFilterDialog("batchbindKeyRefFilter" + xpath);
}
/**
 * 打开Method过滤界面
 * @param evt
 */
function doClickMethodFilter(evt)
{   
    g_keyrefDataController.doClickMethodFilter(evt,"batchbindKeyrefMethodFilter");
}

/**
 * 用户触发过滤条件下拉框变化
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-5-19
 * @return
 */
function comboSelChange(evt)
{
    // 设置过滤条件
    var comboObject = window.xui.getWidget("featureConditonComboID");

    // 调用数据过滤接口
    g_keyrefDataController.initTableData("FEATURE");

    g_filterCtrl.doEvaluateCombo(evt.id);
}

/**
 * 表中行选择变化时的事件处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-8
 * @return
 */
function doSelChange()
{
    // 将确定按钮置为可用
    setOKBtnStatus(true);
}

/**
 * 设置确定按钮状态
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-9
 * @param status 状态
 * @return
 */
function setOKBtnStatus(status)
{
    // 设置确定按钮状态
    var okBtn = window.xui.getWidget("OkButton");
    okBtn.setEnabled(status);
}

/**
 * 全选/去全选事件
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-29
 * @return
 */
function dockbSelectAllChanged(evt)
{
    var target = evt.target;
    g_keyrefDataController.getTable().selectAllRowsChanged(target.getChecked());
}

/**
 * 隐藏对话框时的处理方法
 * 
 * @author j65716
 * @since iManager U2000 V1R3,2010-9-7
 */
function pub_doHideDlg()
{
    g_keyrefDataController.stopQueryData();
    g_refDlgController.closeSelfView();
}

/**
 * 添加列筛选条件
 * 
 * @author s00143960
 * @since iManager U2000 V1R7,2011-11-21
 * @return
 */
function doAddColumnFilterCondition(evt)
{
    g_colFilterCtrl.addFilterCondition(evt.target);
}

/**
 * 用户触发筛选操作
 * 
 * @author s00143960
 * @since iManager U2000 V1R7,2011-11-21
 * @return
 */
function doFilter(evt)
{
    g_colFilterCtrl.filterData(evt.target, evt.target.getSelection());
}

/**
 * 执行进度条下发操作
 * 
 * @return
 */
function pub_doProgressOperation()
{
    pub_getDataController().doSendConfigForProgress();
}

/**
 * 进度条取消事件处理
 * @returns
 */
function pub_doProgressDlgCancleButton()
{
    pub_getDataController().doProgressDlgCancleButton();
}


/**
 * keyref联想关闭事件处理
 * 
 * @author x00211048
 * @since iManager U2000 V2R1,2013-4-25
 */
function doKeyRefCloseUp(evt)
{
    pub_getDataController().doKeyRefCloseUp(evt);
}

/**
 * 弹出设置密码对话框
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function doKeyPasswordClick(evt)
{
    pub_getDataController().doKeyPasswordClick(evt);
}

/**
 * 单击keyref按钮的事件处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-7
 */
function doKeyRefClick(evt)
{
    pub_getDataController().doKeyRefClick(evt);
}

/**
 * 用户在keyref输入框中输入值，进行联想
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-7
 */
function doKeyRefFilter(evt)
{
    pub_getDataController().doKeyRefFilter(evt);
}

/**
 * 弹出设置密码对话框
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function doPasswordClick(evt)
{
    pub_getDataController().doPasswordClick(evt);
}

/**
 * 获取当前选中结点的tooltip信息
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-4-1
 */
function pub_getCurNodeTooltip()
{
    return pub_getDataController().getCurNodeTooltip();
}

/**
 * 值变化事件处理
 * @param evt
 */
function onValueChanged(evt)
{
    pub_getDataController().valueChangeExtend(evt);
}

/**
 * 值变化事件处理
 * @param evt
 */
function onValuechanging(evt)
{
    pub_getDataController().valuechanging(evt);
}

/**
 * 单击定制属性列按钮的事件处理
 * 
 * @author x00211048
 * @since iManager U2000 V2R1,2013-5-16
 */
function doCustomAttrClick(evt)
{
    pub_getDataController().doCustomAttrClick(evt);
}

/**
 * 获取密码类型字段属性定义的最大长度
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function pub_getCurPwdMaxLength()
{
    return pub_getDataController().getPwdCellMaxLength();
}

/**
 * 获取密码类型字段属性定义的不支持的正则表达式
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function pub_getUnsupportedPwdSet()
{
    return pub_getDataController().getPwdCellPattern();
}

/**
 * 获取密码类型字段属性定义的支持的正则表达式
 * 
 * @returns
 */
function pub_getSupportedPwdSet()
{
    return null;
}

/**
 * 设置密码类型字段属性的值
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function pub_setPasswordValue(password)
{
    pub_getDataController().setPasswordValue(password);
}

function pub_getConfigCtrl()
{
    return pub_getDataController();
}
Event.observe(window, "load", init);