/*
 * Title:         定时刷新
 * Description:   在线配置自动刷新设置
 * Copyright:     Copyright (c) 1988-2015
 * Company:       Huawei Tech. Co., Ltd
 * @author         王莉 w00138446
 * @version        Manager U2000 V1R3,2010-4-3
 */
/**
 * 封装定时刷新控件属性.<br>
 * 
 * @author 王莉 w00138446
 * @since iManager U2000 V1R3,2010-3-27
 */
function Renovator(renovatorLabel, renovatorCombo)
{
    /**
     * 定时刷新Label控件
     */
    this._renovatorLabel = renovatorLabel;

    /**
     * 定时刷新Combo控件
     */
    this._renovatorCombo = renovatorCombo;

    /**
     * 当前combo所选择的间隔时间
     */
    this.interval = 0;

    /**
     * 触发combo下拉框选择的间隔时间
     */
    this.intervalNew = 0;

    /**
     * 定时器对象的引用
     */
    this.timer = null;

    /**
     * 如果启动定时，定时刷新的最低间隔时间
     */
    this.conditionTime = 25 * 1000;
    
    /**
     * 启动自动刷新的标志
     */
    this.autoFlagCounter = 0;

    /**
     * 自动刷新进行中是否被中断的标志
     */
     this.isRefresh = false;

    /**
     * 排序状态对象 enable 是否排序 attrPath 排序MoType的Xpath type 排序状态-升序/降序
     */
    this.sortInfo = new Object();
    this.sortInfo.enable = false;
    this.sortInfo.attrPath = "";
    this.sortInfo.type = "";

    /**
     * 定位到指定页对象 currentPage 当前页
     */
    this.pageInfo = new Object();
    this.pageInfo.currentPage = 0;

    /**
     * 判断是否启动定时刷新
     */
//    this.whetherRunTask = function()
//    {
//        var currentTime = new Date().getTime();
//        var whether = false;
//        if (currentTime - this.lastManual >= this.conditionTime)
//        {
//            whether = true;
//        }
//        return whether;
//    }

    /**
     * 设置人为中断操作时刻的时间
     */
//    this.setLastManual = function()
//    {
//        this.lastManual = new Date().getTime();
//    }
}

/**
 * 初始化定时刷新控件 Label和Combo控件.<br>
 * 
 * @author w00138446
 * @param window 页面
 */
Renovator.prototype.init = function()
{
    this._renovatorLabel = window.xui.getWidget("IntervalLabel");
    this._renovatorCombo = window.xui.getWidget("IntervalCombo");
}

/**
 * 定时刷新控件Renovator控制类，用于初始化定时刷新的状态.<br>
 * 
 * @author w00138446
 * @param renovator renovator类
 * @param featureForm 全局变量,存储FeatureAction的参数
 * @param frameParam 全局变量,框架的公共信息
 */
function RenovatorController(dataTable, tableModel, renovator, deviceForm, featureForm, frameParam)
{
    this._dataTable = dataTable;
    this._tableModel = tableModel;
    this._renovator = renovator;
    this._featureForm = featureForm;
    this._deviceForm = deviceForm;
    this._frameParam = frameParam;
}

/**
 * 初始化定时刷新初始状态.<br>
 * 
 * @author w00138446
 */
RenovatorController.prototype.initSelectInterval = function()
{
    var independence = top.independence == "true" ? true : false;
    if (independence && !this._featureForm.isWorkspace)
    {
        this._renovator.interval = jsonrpc.invoke("renovatorService", "getInterval", [ this._featureForm,
                this._deviceForm ]);
        this._renovator.intervalNew = this._renovator.interval;
        if(null != this._renovator._renovatorCombo)
        {
            this._renovator._renovatorCombo.setSelection(this._renovator.interval);
        }
        
        //通知活动告警面板
        this.notifyAlarmPanel(this._renovator.intervalNew);
    }
    if (!independence || this._featureForm.isWorkspace)
    {
        window.xui.removeWidget("IntervalCombo");
        window.xui.removeWidget("IntervalLabel");
        var sepa = document.getElementById("IntervalSeparator");
        if (null != sepa)
        {
            sepa.parentNode.removeChild(sepa);
        }
    }
}

/**
 * 设置定时刷新下拉框时间间隔.<br>
 * 
 * @author w00138446
 * @param evt JSE事件触发标识
 */
RenovatorController.prototype.doSelectInterval = function(evt)
{
    this._renovator.intervalNew = evt.id;
    this.selectInterval();
    
    //通知活动告警面板
    this.notifyAlarmPanel(evt.id);
}

/**
 * 确定设置定时刷新间隔并保存时间间隔.<br>
 * 
 * @author w00138446
 */
RenovatorController.prototype.selectInterval = function()
{
    var operResult = jsonrpc.invoke("renovatorService", "saveIntervalToXML", [ this._renovator.intervalNew,
            this._featureForm, this._deviceForm ]);
    if (operResult.resultType != "OPER_OK")
    {
        this._renovator.intervalNew = this._renovator.interval;
        this._renovator._renovatorCombo.setSelection(this._renovator.interval);
        return;
    }
    this.resetTimer();
}

/**
 * 重置定时刷新器.<br>
 * 
 * @author w00138446
 */
RenovatorController.prototype.resetTimer = function()
{
    window.clearInterval(this._renovator.timer);
    this.startTimer();
}

/**
 * 当分页数据查询完毕后再次查询
 * 
 * @author f00145226
 */
RenovatorController.prototype.doAfterQueryComplete = function()
{
    this.resetTimer();
}

/**
 * 启动定时刷新器.<br>
 * 
 * @author w00138446
 */
RenovatorController.prototype.startTimer = function()
{
    var iTime = parseInt(this._renovator.intervalNew) * 1000;
    if (iTime > 0)
    {
        this._renovator.isRefresh = true;
        this._renovator.timer = TimeOperation.doObjSetTimeout(this, this.runTask, [], iTime);
    }
    else
    {
        this._renovator.isRefresh = false;
    }

}

/**
 * 启动定时刷新任务.<br>
 * 
 * @author w00138446
 */
RenovatorController.prototype.runTask = function()
{
    if (this._renovator.isRefresh &&　0 == this._renovator.autoFlagCounter)
    {
        pub_getDataController().initTableData("FEATURE");
    }
    else
    {
        var iTime = parseInt(this._renovator.intervalNew) * 1000;
        if (iTime > 0)
        {     
            this._renovator.timer = TimeOperation.doObjSetTimeout(this, this.runTask, [], iTime);
        }
    }
}

/**
 * 设置手工刷新标识，设置定时刷新中断标识.<br>
 * 
 * @author w00138446
 */
RenovatorController.prototype.setAutoRefreshEnable = function(enabled)
{
	//combo中不刷新的ID
    if (!enabled)
    {
        this._renovator.autoFlagCounter++;
    }
    else
    {
        this._renovator.autoFlagCounter--;            
    }
}

/**
 * 设置自动刷新标识.<br>
 * 
 * @author w00138446
 * @param done 启动定时刷新标识true表示启动
 */
RenovatorController.prototype.setAutoFlag = function(done)
{
    var top = jse.topWin;
    top.autoFlag = done;
}

/**
 * 通知告警板重置告警板刷新定时器.<br>
 * 
 * @author w00138446
 */
RenovatorController.prototype.notifyAlarmPanel = function(selTime)
{
    var top = jse.topWin;
    var alarmPanel = top.pub_getAlarmPanel();

    var iTime = parseInt(selTime) * 1000;
    alarmPanel.resetTimer(pub_getFeaturePubData().getFeatureForm().xpath, iTime);
}
