/**
 * 告警板对象定义
 */
function AlarmPanel()
{
	this.critical_toolbutton = null;
	this.critical_color = "#FF1919"; // red
	this.major_toolbutton = null;
	this.major_color = "#FF9600"; // orange
	this.minor_toolbutton = null;
	this.minor_color = "#FFFF64"; // yellow
	this.warning_toolbutton = null;
	this.warning_color = "#963296"; // purple
	
	this.width = 60;
	this.height = 24;
	this.interval = 30000; // 30s
	this.defaultInterval = 30000; //30s
	this.timer = null;
	//this.xpath = "/fm/activeAlarms/activeAlarm";
	queryAlarmXpath();
	this.isSearchAlarms = true;
}

/**
 * 
 */
function queryAlarmXpath()
{
	var url = CommonUtil.getRootPath() + "/vmt/xpath/queryXpathAction.do?devType="+devType+"&devVersion="+devVersion
	          +"&keys=fm_activeAlarm&xpathType=pnp";
	var req = jse.RpcRequest.create(url);
	req.invoke(callbackQueryAlarmXpath);
}

/**
 * 
 */
function callbackQueryAlarmXpath(errorCode, request)
{
	this.xpath = request.responseText;
}

/**
 * 系统配置文件中告警板时间间隔字符串
 */
AlarmPanel.prototype._SYSCONF_ALARMPANELINTERNAL = "alarmPanelInterval";

/**
 * 告警板设置大小
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-6-1
 */
AlarmPanel.prototype.setPreferSizes = function()
{
	this.critical_toolbutton.setPreferSize(this.width,this.height);
	this.major_toolbutton.setPreferSize(this.width,this.height);
	this.minor_toolbutton.setPreferSize(this.width,this.height);
	this.warning_toolbutton.setPreferSize(this.width,this.height);
	this.critical_toolbutton.setTextAlign(jse.CENTER);
	this.major_toolbutton.setTextAlign(jse.CENTER);
	this.minor_toolbutton.setTextAlign(jse.CENTER);
	this.warning_toolbutton.setTextAlign(jse.CENTER);
}

/**
 * 告警板设置颜色
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-6-1
 */
AlarmPanel.prototype.setBackgroundColors = function()
{
	this.critical_toolbutton.setBackgroundColor(this.critical_color);
	this.major_toolbutton.setBackgroundColor(this.major_color);
	this.minor_toolbutton.setBackgroundColor(this.minor_color);
	this.warning_toolbutton.setBackgroundColor(this.warning_color);

}

/**
 * 告警板设置文字
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-6-1
 */
AlarmPanel.prototype.setTexts = function(txts)
{
	this.critical_toolbutton.setText(txts[0]+"");
	this.major_toolbutton.setText(txts[1]+"");
	this.minor_toolbutton.setText(txts[2]+"");
	this.warning_toolbutton.setText(txts[3]+"");
}

/**
 * 告警板获取自动刷新时间
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-6-1
 */
AlarmPanel.prototype.setAlarmPanelInterval = function()
{
    // 调用系统配置管理对象的获取方法
    var internalString = pub_getSystemConfigDataMgr().getProperty(this._SYSCONF_ALARMPANELINTERNAL);
    if(null != internalString)
    {
        this.interval = parseInt(internalString);
    }
}

/**
 * 查询最新活动告警统计信息和设置定时器
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-6-1
 */
AlarmPanel.prototype.searcherAndTimer = function()
{
    return;
}

/**
 * 查询最新活动告警统计信息
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-6-1
 */
AlarmPanel.prototype.searchActiveAlarms = function()
{
	if ("true" != independence) 
	{
		return;
	}
	
	var deviceForm = new DeviceForm();
	deviceForm.deviceIp = deviceIP;
	deviceForm.vrId = deviceIP;
	deviceForm.type = "LR";
	deviceForm.deviceType = devType;
	deviceForm.deviceVersion = devVersion;
	deviceForm.pnpForm = jse.topWin.pub_getClonePnpForm();

	if(null != deviceForm.type && this.isSearchAlarms)
	{
		jsonrpc.asynInvoke("alarmViewFactory", "queryAlarmCounts",[deviceForm], this.doGetAlarmCounts, this);
	}
}

/**
 * 查询最新活动告警统计信息请求的回调函数
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-6-1
 */
AlarmPanel.prototype.doGetAlarmCounts = function(operResult)
{
	if(null != operResult)
	{
	    if(operResult.resultType != GlobalConstants.OPER_OK)
	    {
	        this.isSearchAlarms = false;
	    }  
        if(operResult.resultType == GlobalConstants.OPER_OK)
        {
            var alarmCounts = operResult.returnObj;
            var statistic = new Array();
            statistic.push(alarmCounts.criticalCount);
            statistic.push(alarmCounts.majorCount);
            statistic.push(alarmCounts.minorCount);
            statistic.push(alarmCounts.warningCount);
            this.setTexts(statistic);
        }
        this.timer = TimeOperation.doObjSetTimeout(this, this.searchActiveAlarms, [], this.interval);
	}	
}

/**
 * 重置告警面板定时刷新
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-6-2
 */
AlarmPanel.prototype.resetTimer = function(xpath,interval)
{
	if(this.xpath == xpath && interval > 0)
	{
		this.interval = interval;
		window.clearInterval(this.timer);
		this.timer = TimeOperation.doObjSetTimeout(this, this.searchActiveAlarms, [], this.interval);
	}
	else if(this.xpath == xpath && interval == 0)
	{
        this.interval = this.defaultInterval;
        window.clearInterval(this.timer);
		this.timer = null;
	}
}

/**
 * 停止告警面板定时刷新
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-6-2
 */
AlarmPanel.prototype.stopAlarmPanelTimer = function()
{
    if ("true" != independence) 
    {
        return;
    }
    window.clearInterval(this.timer);
    this.timer = null;
}

/**
 * 设置查询告警信息开关
 * 
 * @author s00143960
 * @since iManager U2000 V1R3,2010-9-10
 */
AlarmPanel.prototype.stopAlarmPanelTimer = function(isSearchAlarms)
{
    this.isSearchAlarms = isSearchAlarms;
}

/**
 * 如果当前选中的是左树上的活动告警结点的话，就主动刷新一下告警板
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-11
 */
AlarmPanel.prototype.freshAlarmPanel = function(currentXpath)
{
    if(this.xpath == currentXpath)
    {
        this.searcherAndTimer();
    }
}