/**
 * 在线基于模板配置界面的keyref处理
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-2-29
 * @return
 */
function ActionKeyrefViewController()
{
    KeyrefViewController.call(this);
}

ActionKeyrefViewController.prototype = new KeyrefViewController();

/**
 * 获取MOType的Xpath
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-6-19
 */
ActionKeyrefViewController.prototype.setActionXpath = function(actionInfo)
{
	var actionXpath = actionInfo.actionXpath;
	if(null != actionInfo.popValue)
	{
		this._featureForm.actionXpath = actionXpath.substring(0,actionXpath.lastIndexOf("/"));
	}
	else
	{
	 	this._featureForm.actionXpath = actionXpath;
	}
}
/**
 * 获取MOType的Xpath
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-6-19
 */
ActionKeyrefViewController.prototype.getKeyRefXpath = function()
{
    var rowId = this._treeTableModel.getModelNodeContents()[0].getNodeRowId();
    // 通过结点ID获取该结点对应的xpath
    var nodeXpath = ConfigUtil.getNodeXpath(rowId, SEPARATOR_XPATH_LABEL);
    return nodeXpath;
}

/**
 * 获取xpath信息
 * 
 * @author x00211048
 * @since iManager U2000 V2R1,2013-8-13
 * @param xpath 行ID
 */
ActionKeyrefViewController.prototype._getFeatureFromXpath = function(featureForm,xpath)
{
	return featureForm.xpath;
}
