/**
 * Action配置界面的控制类
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-6-19
 */
function ActionCfgController()
{
    BatchModifyPreviewController.call(this);

    /**
     * 当前action信息
     */
    this._actionInfo = {};
    
    this._dangerousOperType = DangerousOperType.ACTION;
}
/**
 * 继承BatchModifyPreviewController
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-6-19
 */
ActionCfgController.prototype = new BatchModifyPreviewController();

/**
 * 获取value列的列个数
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-7-27
 * @override
 */
ActionCfgController.prototype.getValueColNum = function()
{
    var selectRowKeys = this._dataCtrl.getTableModel().getSelectRowKeys();
    var length = selectRowKeys.length;
    length = length == 0 ? 1 : length;
    return length;
}

/**
 * 通过初始化操作初始化action表格
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-6-19
 */
ActionCfgController.prototype.initTableViewOper = function(newNodeContent, selectRowKeys, colIds)
{
    var featureWin = jse.getFromWin();
    var menuCtrl = featureWin.pub_getDataController().getMenuCtrl();
    this._actionInfo = menuCtrl.getCurrActionInfo();
    this.getRefSelectCtrl().getKeyrefViewCtrl().setActionXpath(this._actionInfo);
    var focuseOper = new NoKeyDefaultFocusOper(this._treeTable, this._treeModel, this._refSelectControler,
            this._treeTableStatus);
    this._initTreeTableView = new ActionTreeInitOper(this._treeTable, this._treeModel, this._treeTableStatus,
            this._linkageCtrl, focuseOper, this);
    this._initTreeTableView.initTableTreeView(this._featureData, this._actionInfo, selectRowKeys, colIds);
}

/**
 * 设置值的颜色
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-6-28
 * @param rowId 行ID
 */
ActionCfgController.prototype.setRowFontColor = function(rowId, colId)
{
}

/**
 * 点击确定按钮进行下发
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-6-28
 * @param isShow 为true时显示进度条，为false时不显示进度条
 */
ActionCfgController.prototype.clickOkBtn = function()
{
    // 若是危险操作需要弹出确认对话框       
    var dangerousOperInfo = this._dataCtrl.getDangerousOperInfoByOperType(this._dangerousOperType,this._actionInfo.getActionXpath());
    if(null != dangerousOperInfo)
    {       
        var message = "";      
        var isCustomMessage = dangerousOperInfo.customMessage;
        if(isCustomMessage )
        {
            var featureForm= this._featureData.getFeatureForm();
            var key = featureForm.xpath + "_"  + this._actionInfo.getActionXpath() + "_"+ this._dangerousOperType.toLowerCase();
            
            message = Resource.getDangerousOperResource(key);
        }
        else
        {
            var messageBegin = jse.getI18nValue("qat:public", "label.actiondangerousoperation1_d");
            
            var featureName = this._actionInfo.featureName;
            var xpath = this._actionInfo.getActionXpath();           
            var messageMid = Resource.getXpathResource(featureName, xpath+"_d");
            var messageEnd = jse.getI18nValue("qat:public", "label.actiondangerousoperation2_d");
            
            message = messageBegin + messageMid + messageEnd;
        }
        var title = jse.getI18nValue("qat:public:", "label.tip_d");

        VMTWarning(message, this.clickOkBtnSendConfig, 300, 150, title, [], this);
    }             
    else
    {
        this.clickOkBtnSendConfig();
    }
}

/**
 * 下发配置数据
 */
ActionCfgController.prototype.clickOkBtnSendConfig = function()
{
    var sendResult = this.sendConfigData();
    if (sendResult)
    {
        if (this._actionInfo.actionType == "MOType_NOKEYREF")
        {
            var message = jse.getI18nValue("qat:public", "action_sychronizeall_d");
            CommonDlgReq.openYesNoDialog(message, this.sysActionAllRecords, this, [], this.closeSelfView, this, []);
        }
        else
        {
            sendResult = this._dataCtrl.sysActionSelectedRecord();
            if (sendResult)
            {
                var message = jse.getI18nValue("qat:public", "label.action_succeedprompt_d");
                CommonDlgReq.openAlertDialog(message, this.closeSelfView, this);
            }
        }
    }
}

/**
 * 全量同步数据，关闭action窗口
 * 
 * @author z00133566
 * @since iManager U2000 V1R8,2010-6-6
 */
ActionCfgController.prototype.sysActionAllRecords = function()
{
    this._dataCtrl.sysActionAllRecords();
    this.closeSelfView();
}

/**
 * 下发数据
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-6-19
 * @param featureData
 */
ActionCfgController.prototype.sendConfigData = function()
{
    if (null == this._sendConfigOperation)
    {
        var modelChecker = this._verifyCtrl.createNullAndKeyChecker();
        var modelNodeCloneStrategy = new CloneAllAttriStrategy(this._treeTable, this._treeModel, null);
        this._sendConfigOperation = new ActionTreeSendOper(this._treeTable, this._treeModel, this._featureData,
                modelNodeCloneStrategy, this._dataCtrl, this._actionInfo, modelChecker);
    }
    return this._sendConfigOperation.checkDataAndSendConfig(this._linkageCtrl, null, null);
}


ActionCfgController.prototype.getFirstValueColName = function()
{
    var colIds = this._treeTable.getAllColumnIds();
    // action返回第2列的列名（值列）
    return colIds[1];
}

/**
 * 关闭对话框调用方法,关闭前重置控件状态
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-9-29
 */
ActionCfgController.prototype.closeSelfView = function()
{
    // 重置控件状态
    this._treeTableStatus.resetWidgetState();

    // 批量是动态添加列的，需要在退出时删除所有列
    var columnIds = this._treeTable.getAllColumnIds();
    var delColumnIds = columnIds.slice(1, columnIds.length);
    this._treeTable.removeColumns(delColumnIds);

    this._dataCtrl.setAutoRefreshEnable(true);
    jse.closeSelfView();
}

/**
 * 初始化树表
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-8-3
 * @override
 */
ActionCfgController.prototype.initTableTree = function()
{
    var selectRowKeys = [];
    //如果有选中行，将返回选中行对应的key信息；如果没有选中行时，返回选中的父对象的key信息
    var selectRowIds = this._dataCtrl.getTable().getSelection();
    if(null != selectRowIds && selectRowIds.length > 0)
    {
        selectRowKeys = this._dataCtrl.getTableModel().getSelectRowKeys();
    }
    else
    {
        var parentObj = jse.getFromWin();
        if ((null != parentObj) && ('undefined' != typeof parentObj.pub_getSelectRowKeys))
        {
            var parentRowKeys = parentObj.pub_getSelectRowKeys();
            if(null != parentRowKeys)
            {
                var rowKeysLst = [];
                rowKeysLst.push(parentRowKeys.getNodeKey());
                selectRowKeys = rowKeysLst; 
            }                      
        }
    }  

    var valueColNum = this.getValueColNum();

    var featureForm = this._featureData.getFeatureForm();
    this._treeNodeName = FeaturesResourceMgr.getSchemaResource(featureForm.xpath);

    var colIds = [];
    var colNames = [];
    if (valueColNum == 1)
    {
        colIds.push(this.BASICCOLUMNNAME + 1);
        colNames.push(this._treeNodeName);
    }
    else if (valueColNum > 1)
    {
        for ( var i = 1; i <= valueColNum; i++)
        {
            colIds.push(this.BASICCOLUMNNAME + i);
            colNames.push(this._treeNodeName + i);
        }
    }

    this._treeTable.addColumns(colIds, colNames, true);
    this.initTableViewOper(this._batchModifyNodeContent, selectRowKeys, colIds)
}