/*
 * Title:         主要是用于action配置界面
 * Description:  [描述文件的功能、作用、使用方法和注意事项]
 * Copyright:     Copyright (c) 1988-2015
 * Company:       Huawei Tech. Co., Ltd
 * @author        l00133618
 * @since         iManager U2000 V1R3,2010-6-28
 */

jse.require("jse.widget.dialog");
jse.require("jse.widget.table");
jse.require("vmt.extend.table_prototype");

/**
 * 配置类
 */
var g_config = {};

/**
 * 事件注册
 */
var signalMap =
{
    on_load_ui : doLoad,
    onClickCancelButton : clickCancelBtn,
    onClickOKButton : clickOkBtn
};

/**
 * 初始化方法
 */
function init()
{
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/configframe/xui/action/action.xui", signalMap);
}

/**
 * js载入函数
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-6-28
 */
function doLoad()
{
    var actionLoader = new ActionViewLoader();

    var urlArray = [];
    urlArray[RefDlgUrlType.KEYREF] = CommonUtil.getRootPath() + "/vmt/ct/online/view/keyref/keyref.html";
    urlArray[RefDlgUrlType.KEY] = CommonUtil.getRootPath() + "/vmt/ct/common/dialog/keydialog/keydialog.html";
    urlArray[RefDlgUrlType.PASSWORD] = CommonUtil.getRootPath() + "/vmt/ct/common/dialog/passworddialog/passworddialog.html";
    
    // ref关系选择控制类
    var refSelectControler = new RefSelectControler(new ActionKeyrefViewController(), null, new KeyPasswordViewCtrl(),new PasswordViewCtrl());

    g_config = new ActionCfgController();
    actionLoader.doLoad(urlArray, g_config, refSelectControler);
}

/**
 * 加载动态信息
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R3,2010-6-30
 * @param isInitBySelf 区分该方法是内嵌页面还是组件的 show()调用的
 * @return
 */
function onshow(isInitBySelf)
{
    this.doLoad();
}

/**
 * 切换选择行
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-6-28
 * @param evt 事件信息
 */
function onSelChanged(evt)
{
    g_config.selectChange(evt.id);
}

/**
 * 用户改变cell内值时进行校验，如果校验不通过设置单元格背景颜色为红色
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-6-28
 * @param evt 事件信息
 */
function onValueChanged(evt)
{
    g_config.valueChange(evt);
}

/**
 * TODO 后续需要切换至JSE会提供实时监听键盘输入的事件， 用户正在改变cell内值时的处理
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-8-7
 * @param evt 事件信息
 */
function onValuechanging(evt)
{
    g_config.valuechanging(evt);
}

/**
 * 单元格的变化
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-6-28
 * @param evt 事件信息
 */
function onCellSelChanged(evt)
{
    // 设置数表可编辑的单元格的多国语言样式
    Preconstraints.setTableCellStype(Preconstraints.NORMAL_OPERATION);
}

/**
 * 处理最后一个单元格的Tab事件
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-6-28
 * @param evt 事件信息
 */
function doLastCellFocus(evt)
{
    g_config.doLastCellFocus(evt);
}

/**
 * 点击取消按钮
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-6-28
 */
function clickCancelBtn()
{
    // 点击取消按钮时根据是否添加数据成功来刷新数据并关闭对话框
    g_config.closeSelfView();
}

/**
 * 点击确定按钮
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-6-28
 */
function clickOkBtn()
{
    g_config.clickOkBtn();
}
/**
 * 单击keyref按钮的事件处理
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-6-28
 */
function doKeyRefClick(evt)
{
    g_config.doKeyRefClick(evt);
}

/**
 * 用户在keyref输入框中输入值，进行联想
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-6-28
 */
function doKeyRefFilter(evt)
{
    g_config.doKeyRefFilter(evt);
}

/**
 * 用户在keyref输入框中输入值后，联想控件的select关闭后触发
 * 
 * @author x64338
 * @since iManager U2000 V2R1,2013-3-7
 */
function doKeyRefCloseUp(evt)
{
    g_config.doKeyRefCloseUp(evt);
}

/**
 * 获取配置控制对象
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-6-28
 * @return
 */
function pub_getConfigCtrl()
{
    return g_config;
}

/**
 * 获取当前选中结点的tooltip信息
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-4-1
 */
function pub_getCurNodeTooltip()
{
    return g_config.getCurNodeTooltip();
}

/**
 * 弹出设置密码对话框
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function doKeyPasswordClick(evt)
{
    g_config.doKeyPasswordClick(evt);
}

/**
 * 弹出设置密码对话框
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function doPasswordClick(evt)
{
    g_config.doPasswordClick(evt);
}

/**
 * 获取密码类型字段属性定义的最小长度
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function pub_getCurPwdMinLength()
{
    return g_config.getPwdCellMinLength();
}

/**
 * 获取密码类型字段属性定义的最大长度
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function pub_getCurPwdMaxLength()
{
    return g_config.getPwdCellMaxLength();
}

/**
 * 获取密码类型字段属性定义的不支持的正则表达式
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function pub_getUnsupportedPwdSet()
{
    return g_config.getPwdCellPattern();
}

/**
 * 获取密码类型字段属性定义的支持的正则表达式
 * 
 * @returns
 */
function pub_getSupportedPwdSet()
{
    return null;
}
/**
 * 设置密码类型字段属性的值
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function pub_setPasswordValue(password)
{
    g_config.setPasswordValue(password);
}

Event.observe(window, "load", init);