/**
 * 处理另存为操作
 * @param featureVersion 特性版本
 * @param featureName 特性名称
 * @param vrId VRID
 * @param xpath 当前的XPath
 * @param neName neName
 */
function saveasHandle(globalData, pageCtrl, filterCtrl)
{
	var sortInfo = pageCtrl.getSortInfo();
	var deviceForm = globalData.getDeviceForm();
	var featureForm = globalData.getFeatureForm();
	var frameParam = globalData.getFrameParam();
	var nodeInfo = globalData.getNodeInfo();
	
	var top = jse.topWin;
    deviceForm.deviceName = top.devName;
    
    var zoneInfo = 
    {
    	tzOffset: top.tzOffset,
    	tzId: top.tzId,
    	zonePattern: top.zonePattern.zonePattern
    }
    
    var conditions = filterCtrl.getCurrentCondtion();
    var resultObj = jsonrpc.invoke("tableDataSaveAsBean", "saveAs", [ deviceForm, featureForm, frameParam, sortInfo, zoneInfo, conditions, top.lang]);
    openSaveDialog(resultObj);
}

/**
 * export特性列表的回调函数.
 */
function openSaveDialog(operResult)
{
	if (operResult.resultType == GlobalConstants.OPER_OK)
	{
		var exportTmpFileName = operResult.returnObj;
	    var dailogTitle = jse.getI18nValue("qat:public", "dailog.downloadfile_d");
	    VMTExport(exportTmpFileName, dailogTitle);
	}
}
