jse.require("jse.widget.dialog");
jse.require("jse.widget.table");
jse.require("vmt.extend.table_prototype");

/**
 * 结果表格
 */
var resultGrid = null;

/**
 * 状态标签
 */
var stateLabel = null;

/**
 * 中止按钮
 */
var stopBtn = null;

var neName = null;

var vrId = null;

var xPath = null;

var deviceIP = null;

var featureVersion = null;

var featureName = null;

var isWorkspace = null;

/**
 * 进度条
 */
var progressbar = null;

var completNum = 0;

var signalMap =
{
    on_load_ui :doLoad,
    onClickStopButton :onStopButtonClick,
    onClickCancelButton :onCancelButtonClick
};

/**
 * 初始化加载xui
 */
function init()
{
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/online/transfer/pingtrace/traceresult/traceresult.xui", signalMap);
}

/**
 * 后台生成的js函数，包括参数赋值
 */
function doLoad()
{
    opertionType = PopDialogKeyName.TRACERESULT;

    // 初始化参数信息
    var paraMap = analyseURLPara2map();

    initFeaturePara(paraMap);

    // 结果表格对象
    resultGrid = window.xui.getWidget("TableResult");
    stateLabel = window.xui.getWidget("LabelState");
    stopBtn = window.xui.getWidget("ButtonStop");

    // 设置add对话框已经加载过
    var win = jse.getFromWin();
    win.pub_setDialogIsLoad(PopDialogKeyName.TRACERESULT, true);

    queryTreeTableInfo();

}

/**
 * 切换特性显示方法（外部调用）
 */
function pub_loadSpecialFeature(paraMap)
{
    // 清除表数据
    resultGrid.removeAllRows();

    // 初始化参数
    initFeaturePara(paraMap);

    // 到后台查询权限信息
    queryTreeTableInfo();
}

/**
 * 初始化特性参数到各个变量中
 */
function initFeaturePara(paraMap)
{
    neName = paraMap.get("neName");
    vrId = paraMap.get("vrId");
    xPath = paraMap.get("xPath");
    deviceIP = paraMap.get("deviceIP");
    featureVersion = paraMap.get("featureVersion");
    featureName = paraMap.get("featureName");
    isWorkspace = paraMap.get("isWorkspace");
}

/**
 * 查询树表动态数据
 */
function queryTreeTableInfo()
{
    var pnpForm = jse.topWin.pub_getClonePnpForm();
    var req = jse.RpcRequest
            .create(CommonUtil.getRootPath() + "/vmt/ct/featuremgr/pingtraceaction.do?methodID=handleGetTraceResultXUIRequest"
                    + "&neName=" + neName + "&vrId=" + vrId + "&xPath=" + xPath + "&deviceIP=" + deviceIP
                    + "&featureName=" + featureName + "&isWorkspace="
                    + isWorkspace + "&primaryIP=" + deviceIP + "&pnpDeviceType=" + pnpForm.deviceType
                    + "&pnpDeviceVersion=" + pnpForm.deviceVersion + "&compatible=" + pnpForm.compatible);

    // 设备列表数据后的回调处理函数
    req.invoke(handleResult, [ "callback_queryTreeTableInfo(request);" ]);
}

/**
 * 查询树表动态数据的回调方法
 */
function callback_queryTreeTableInfo(req)
{
    var text = req.responseText;
    var doc1 = jse.loadXML(text);

    var xmlNode = null;

    // 处理查询错误的情况
    xmlNode = jse.base.xpath.selectSingleNode("//operResultType", doc1);
    var result = xmlNode.getAttribute("resultType");
    if ("OPER_NOK" == result)
    {
        VMTError("win.errorClose();@fun_fun@errorClose()");
        return;
    }

    var resultcolInfo = null;

    // 获得进度表格的列信息
    xmlNode = jse.selectSingleNode("/response/data/guiinfo/traceResultTableCol", doc1);
    if (null != xmlNode)
    {
        resultcolInfo = decodeURIComponent(xmlNode.getAttribute("value"));
    }

    // 初始化结果表格列
    initTableCol(resultGrid, resultcolInfo);
    progressbar = xui.getWidget("ProgressbarState");
    progressbar.start(
    {
        increment :5,
        interval :100,
        text :""
    });
    // 下发ping/trace命令
    sendPingTrace();
}

/**
 * 查询结果的方法，查询内容包括结果数据，多条 如果结果数据不为空，则表示操作已经完成，停止定时器
 */
function queryResult()
{
    if(!queryFlag)
    {
        return;
    }
    // var pingtraceaddWin = jse.getFromWin();
    var pingtraceaddWin = getParentWin();
    if(null == pingtraceaddWin)
    {
    	return;
    }
    var pnpForm = jse.topWin.pub_getClonePnpForm();
    var url = CommonUtil.getRootPath() + "/vmt/ct/featuremgr/pingtraceaction.do?methodID=handleQueryTraceResultRequest" + "&neName="
            + pingtraceaddWin.neName + "&vrId=" + pingtraceaddWin.vrId + "&xPath=" + pingtraceaddWin.xPath
            + "&deviceIP=" + pingtraceaddWin.deviceIP + "&featureName=" + pingtraceaddWin.featureName + "&parentKeyInfo=" + parentKeyInfo + "&pnpDeviceType="
            + pnpForm.deviceType + "&pnpDeviceVersion=" + pnpForm.deviceVersion + "&compatible="
            + pnpForm.compatible;

    var req = jse.RpcRequest.create(handleEncodingUrl(url));
    req.setWaiting(false);
    req.invoke(handleResult, [ "queryResultCallBack(request);" ]);
}

/**
 * 查询结果的回调方法
 */
function queryResultCallBack(request)
{
    var text = request.responseText;
    var doc1 = jse.base.util.loadXML(text);

    var node = jse.base.xpath.selectSingleNode("//operResultType", doc1);
    var result = node.getAttribute("resultType");
    if ("OPER_NOK" == result)
    {
        doc = doc1;
        // 如果某次查询失败，停止查询，并且报错
        stopQuery("error");
        VMTError("win.errorClose();");
        return;
    }

    var node1 = jse.base.xpath.selectSingleNode("//isComplet", doc1);
    var isComplet = node1.getAttribute("complet");
    // 设置进度数据,由于在trace表中resultGrid显示过程数据
    setProgressTableData(doc1, resultGrid);
    if ("true" == isComplet && queryFlag)
    {
        completNum = completNum + 1;
        if(completNum > 1)
        {
            completNum = 0;
            // 设置结果数据同时结束定时器
            stopQuery("finished");	       
        }
        else
        {
            //trace完成后再查最后一次trace结果。
            setTimeout("queryResult();",2000);
        }
        return;
    }
    if (queryFlag)
    {
        setTimeout("queryResult();", 2000);
    }
}

/**
 * 隐藏本对话框的方法
 */
function pub_procHideDlg()
{
    stopQuery("finished");
    // 清除表数据
    resultGrid.removeAllRows();

    // 定时器对象
    queryFlag = true;

    // 恢复控件状态
    // applyButton.setEnabled(true);
    stopBtn.setEnabled(true);

    var text = jse.getI18nValue("qat:public", "lable_state_d");
    stateLabel.setText(text);

    // 放到顶层页面中
    var win = jse.topWin;
    win.pub_hideSpecialDialog(PopDialogKeyName.TRACERESULT);
}

Event.observe(window, "load", init);