/**
* ping trace右键菜单的相关支持方法
*/

//保存右键菜单的信息
var popupMenuExMap = new Map();

/**
 * keyref的map，key为ping trace的xpath value为对应当前mo的xpath
 */
var keyRefMap = new Map();
/**
 * 定义菜单的结构体
 * @param id 菜单id
 * @param title 菜单标题
 * @param lrvr 菜单是基于lr或者vr
 * @param type 菜单类型，ping或者trace
 * @param parentid 菜单的父id
 * @param action 菜单对应的action操作
 * @return
 */
function MenuInfo(id,title,lrvr,type,parentid,action)
{
	this.id = id;
	this.title = title;
	this.lrvr = lrvr;
	this.type = type;
	this.parentid = parentid;
	this.action = action;
}

var initPingTraceUrl = null;
/**
 * 增加右键菜单,从后台查询右键菜单的信息
 */
function initPingTracePopupMenuInfo()
{
	popupMenuExMap.removeAll();
	keyRefMap.removeAll();
	var req = jse.RpcRequest.create(handleEncodingUrl(initPingTraceUrl));
			
	req.invoke(handleResult,["queryPopupMenuCallBack(request);"]);  
}

/**
 * 请求右键菜单信息的回调方法 
 * @param request
 * @return
 */
function queryPopupMenuCallBack(request)
{
	var text = request.responseText; 
    var doc1 = jse.base.util.loadXML(text); 
    //处理右键菜单，将右键菜单的信息增加到map表中
    var menus = jse.selectNodes("//popupmenus//MENU",doc1);
    if(null != menus)
    {
        var menuNum = menus.length;
        var key = null;
		var menuInfo = null;
		//将所有的菜单信息保存到菜单信息表中
        for(var j = 0;j < menuNum;j++ )
        {
            var menuNode = menus[j];
            key = menuNode.getAttribute("id");
            menuInfo= new MenuInfo(menuNode.getAttribute("id"),menuNode.getAttribute("title"),menuNode.getAttribute("lrvr"),
					         menuNode.getAttribute("type"),menuNode.getAttribute("parentid"),menuNode.getAttribute("action"));
            popupMenuExMap.put(key,menuInfo);
		}
	}
    
    //处理keyref信息
    var keyrefs = jse.selectNodes("//keyrefs//row",doc1);
    if(null != keyrefs)
    {
        var keyrefNum = keyrefs.length;
        var key = null;
		var value = null;
		//将所有的菜单信息保存到菜单信息表中
        for(var j = 0;j < keyrefNum;j++ )
        {
            var keyref = keyrefs[j];
            key = keyref.getAttribute("srcxpath");
            value = keyref.getAttribute("targetxpath");
            keyRefMap.put(key,value);
		}
	}
}

/**
 * 右键菜单ping trace响应的响应方法
 * @param evt
 * @return
 */
function onPingTrace(evt)
{
	var menuid = evt.id;
	var keyrefInfo = getKeyrefValues(menuid);
	var windowWin = window.parent;
    var _url = CommonUtil.getRootPath() + "/vmt/ct/feature/pingtrace/pingtrace.html?neName=" + windowWin.g_NeFlag
              + "&vrId=" + windowWin.g_VRID 
              + "&isSupportPartition=" + windowWin.g_IsSupportPartition 
              + "&menuLrvr=" + popupMenuExMap.get(evt.id).lrvr
              + "&menuTitle=" + popupMenuExMap.get(evt.id).title
              + "&menuType=" + popupMenuExMap.get(evt.id).type
              + "&xPath=" + evt.id
              + "&paremtxPath=" + parentxPath 
              + "&deviceIP=" + windowWin.deviceIP
              + "&deviceType=" + windowWin.deviceType
              + "&deviceVersion=" + windowWin.deviceVersion
              + "&ispopupmenu=true" + "&keyrefInfo=" + keyrefInfo;
    
    var paraMap = new Map();
    paraMap.put("neName", windowWin.g_NeFlag);
    paraMap.put("vrId", windowWin.g_VRID );
    paraMap.put("isSupportPartition", windowWin.g_IsSupportPartition);
    paraMap.put("menuLrvr", popupMenuExMap.get(evt.id).lrvr);
    paraMap.put("menuTitle", popupMenuExMap.get(evt.id).title);
    paraMap.put("menuType", popupMenuExMap.get(evt.id).type);
    paraMap.put("xPath", evt.id);
    paraMap.put("paremtxPath", parentxPath);
    paraMap.put("deviceIP", windowWin.deviceIP);
    paraMap.put("deviceType", windowWin.deviceType);
    paraMap.put("deviceVersion", windowWin.deviceVersion);
    paraMap.put("ispopupmenu", "true");
    paraMap.put("keyrefInfo", keyrefInfo);
    paraMap.put("isHidedlg", "true"); 

	var dialogWith = screen.width * 0.6;
	var dialogHeight =  dialogWith * 3 / 4;
	var dialogTitle = jse.getI18nValue("qat:public", "dialog_createconfig_d");
	var title = popupMenuExMap.get(menuid).title;
	var paths = title.split(":");
	var file = paths[0]+ ":" + paths[1];
	var resid = paths[2];
	title = jse.getI18nValue(file,resid);
	dialogTitle = dialogTitle + title;
	
    var creatDlgInfo = new CreatDlgInfo("pingtrace", dialogTitle, handleEncodingUrl(_url), paraMap, dialogWith, dialogHeight);
    
    //ping/trace对话框维护信息放在顶层页面中
    var topWindow = jse.topWin;
    topWindow.pub_showDlgByHide("pingtrace", dialogTitle, handleEncodingUrl(_url), paraMap, dialogWith, dialogHeight,
            false, null);
}

/**
 * 获得所有keyref的值,组织成一个字符串
 * @return
 */
function getKeyrefValues(xpath)
{
	var colIds = table.getAllColumnIds();
	var rowId = table.getCurrentSelection();
	var keyrefNum = keyRefMap.getItems().length;
	var srcxpath = null;
	var targetxpath = null;
	var targetcol =null;
	var keyrefInfo = "";
	for(var i = 0 ; i < keyrefNum; i++)
	{
		srcxpath = keyRefMap.getKeys()[i];
		targetxpath = keyRefMap.getItems()[i];
		targetcol = targetxpath.replaceAll("/","_0");
		if(srcxpath.indexOf(xpath) != -1 && arrayContains(colIds,targetcol))
		{
			keyrefInfo = keyrefInfo + srcxpath+"@val@"+table.getCell(rowId,targetcol).value + "@keyref@";
		}
	}
	return keyrefInfo;
}

/**
 * 增加ping trace的右键菜单
 * @return
 */
function addPingTracePopupMenu(menu)
{
	
	var items = popupMenuExMap.getItems();
	var dynamicMenuCount = items.length;
	if(0 == dynamicMenuCount)
	{
		return;
	}


	//对每一个菜单进行处理
	for(var i = 0 ; i < dynamicMenuCount; i++)
	{
		if(null == items[i].id || "null" == items[i].id)
		{
			continue;
		}
		var res = menu._hasItem(items[i].id);
		if(!res)
		{
			var title = items[i].title;
			if("-" != title)
			{
				var paths = title.split(":");
				var file = paths[0]+ ":" + paths[1];
			    var resid = paths[2];
			    title = jse.getI18nValue(file,resid);
			}
			if(null != items[i].action && "null" != items[i].action)
			{
				
				var itemStr = "menu.addItem(null,items[i].id,{text:title,action:"+items[i].action+"})";
				eval(itemStr);
			}
			else
			{
				menu.addItem(parent,items[i].id,
				{
					text:title
				});		
			}
		}
	}
	//增加一个分隔条 
	menu.addItem(null,"seperatorpingtrace",
			{
				text:"-"
			});	
}
