/**
 * 参数联动数据信息
 */
var events = null;


/**
 * 初始化联动事件Array(Event)
 */
function initEvents(tempEvents)
{
    events = new Array();
    events.length = 0;

    var temp = tempEvents.split(Constants.AREA_SEPARATOR);
    if(temp.length == 0)
    {
    	temp[0] = tempEvents;
    	temp.length = 1;
    }
    else
    {
    	temp.length = temp.length - 1;
    }
    
    var widget = null;
    var method = null;
    var conditions = null;
    var event = null;
    var tempNum = temp.length;
    for ( var int = 0; int < tempNum; int++)
    {
        var tempEvent = temp[int].split(Constants.CLUSTER_SEPARATOR);
        widget = tempEvent[0];
        method = tempEvent[1];
        var tempConditions = tempEvent[2].split(Constants.PILE_SEPARATOR);
        tempConditions.length = tempConditions.length - 1;
        conditions = parseConditions(tempConditions);
        event = new EventObj(widget, method, conditions);
        events[int] = event;
    }
}

/**
 * 解析联动事件的条件列表
 */
function parseConditions(tempConditions)
{
    var conditions = new Array();
    var condition = null;
    var expression = null;
    var mains = null;
    var inverses = null;
    var tempConNum = tempConditions.length;
    for ( var int = 0; int < tempConNum; int++)
    {
        var temp = tempConditions[int].split(Constants.BLOCK_SEPARATOR);
        temp.length = temp.length - 1;
        expression = temp[0];
        mains = parseBranches(temp[1]);

        if (temp.length > 2)
        {
            inverses = parseBranches(temp[2]);
        }
        condition = new Condition(expression, mains, inverses);
        conditions[int] = condition;
    }
    return conditions;
}

/**
 * 解析联动事件的条件分支
 */
function parseBranches(brancesStr)
{
    var branches = new Array();
    var branch = null;
    var temp = brancesStr.split(Constants.VALUE_SEPARATOR);
    temp.length = temp.length - 1;
    var tempNum = temp.length;
    for ( var i = 0, j = 0; i < tempNum; i += 3)
    {
        branch = new Branch(temp[i], temp[i + 1], temp[i + 2]);
        branches[j] = branch;
        j++;
    }
    return branches;
}

/**
 * 联动事件处理函数
 */
function doEvents(rowidStr, value, method)
{
	var xpathEx = rowidStr.replace(/@xp_la@_0/g,"");
    var xpath = xpathEx.replaceAll("_0","/");
    var validEventObj = null;
    var eventNum = events.length;
    for ( var i = 0, j = 0; i < eventNum; i++)
    {
        if (events[i].widget == xpath && events[i].method == method)
        {
            validEventObj = events[i];
            break;
        }
    }

    if (null == validEventObj)
    {
        return;
    }
    
    var ridStr = null;
    var allRowIds = tableGrid.getAllRowIds();
    for(var i = 0; i < allRowIds.length; i++)
    {
    	ridStr = allRowIds[i];
    	if(rowidStr != ridStr)
    	{
    		doEvent(ridStr, validEventObj, value);
    	}    	
    }   

}

/**
 * 处理联动事件
 */
function doEvent(ridStr, validEventObj, value)
{
	var xpathEx = ridStr.replace(/@xp_la@_0/g,"");
    var xpath = xpathEx.replaceAll("_0","/");
    var conditions = validEventObj.conditions;
    var expression = null;
    var mains = null;
    var inverses = null;
    var conditionsNum = conditions.length;
    for ( var i = 0; i < conditionsNum; i++)
    {
        expression = conditions[i].getXpath();
        mains = conditions[i].getContents();
        inverses = conditions[i].getType();
        var is = null;
        if("" == expression)
        {
        	if(expression == value)
        	{
        		is = true;
        	}
        }
        else
        {
        	var regexp = new RegExp(expression);
        	is = regexp.test(value);
        }
        if (is && branchContains(mains, xpath))
        {
            doBranches(xpath, mains);
        }
        else if (!is && branchContains(inverses, xpath))
        {
            doBranches(xpath, inverses);
        }
    }
}

/**
 * 联动事件条件分支是否包含所给定的XPath
 */
function branchContains(branches, xpath)
{
    var branchNum = branches.length;
    for ( var i = 0; i < branchNum; i++)
    {
        if (xpath == branches[i].widget)
        {
            return true;
        }
    }
    return false;
}

/**
 * 处理联动事件的条件分支
 */
function doBranches(ridStr, branches)
{
    var branchNum = branches.length;
    for ( var i = 0; i < branchNum; i++)
    {
    	if (ridStr == branches[i].widget)
        {
            var enable = branches[i].enable;
            var valuetmp = branches[i].evaluation;
            var rowIdStr = ridStr.replaceAll("/","_0");
            rowIdStr = rowIdStr + "@xp_la@_0";
            var ableInfo = ("false" ==enable)? false:true;
            if(!ableInfo)
            {
            	//该行不生效，需要加入array中
            	 tableGrid.hideRow(rowIdStr);
            	
            	if(!arrayContains(disableRows,rowIdStr))
            	{
            		arrayAdd(disableRows,rowIdStr);
            	}
            }
            else
            {
            	//该行设为生效，如果arrya中包含它，需要去除
            	tableGrid.showRow(rowIdStr);	
            	if(arrayContains(disableRows,rowIdStr))
            	{
            		arrayRemove(disableRows,rowIdStr);
            	}
            }
            break;
        }
    }
}
