jse.require("jse.widget.dialog");
jse.require("jse.widget.table");
jse.require("vmt.extend.table_prototype");

/**
 * 结果对话框
 */
var dialog = null;

/**
 * 表格对象
 */
var tableGrid = null;

/**
 * 高级选项对象
 */
var normalCheckBox = null;

// 所有的attribute对象
var totalAttributes = null;

/**
 * 父对象
 */
var parentObj = null;

// 特性名称
var featureName = null;

// 特性节点id
var nodeId = null;

// 设备ip
var deviceIP = null;

// vrId
var vrId = null;

// lrvr
var neName = null;

var isSupportPartition = false;

// ping/trace 的xpath
var xPath = null;

// 在点击ok时获得配置的信息
var originXML = null;

// ping trace的关键属性key信息xml
var keyInfoXml = null;

// 高级是否已经被添加过。只要触发一次显示高级后，就为真
var isAdvanceShowed = false;

/**
 * 所有的属性map key为rowid，value为值
 */
var allAttMap = new Map();

// 当前无效的行，由于在ping trace操作时，可能在同一时间并非所有的行生效，因而在校验时，不需要校验这些无效的行
var disableRows = new Array();

/**
 * keyref的信息 key为源xpath value为目标xpath
 */
var keyrefMap = new Map();

/**
 * vrId 对应的行id
 */
var rowIdOfVrId = null;

/**
 * 第一个可编辑的单元格rowid
 */
var firstEditCellRowid = null;

// 操作类型
var operation = null;

var g_PingTraceInfo = new PingTraceInfo();

// ref关系选择控制类
var g_refSelectControler = null;

/**
 * pingtrace控制处理对象，为使用新代码继承,暂时放在这里处理，后续如果优化都需要提取出去
 */
function PingTraceConfigCtrl()
{
    ConfigController.call(this);
}
PingTraceConfigCtrl.prototype = new ConfigController();

/**
 * 配置控制对象
 */
var g_configCtrl = new PingTraceConfigCtrl();

var g_expandAll = false;

/**
 * 响应表
 */
var signalMap =
{
    on_load_ui :doLoad,
    onClickToolButtonExpandAll :onExpandAllClick,
    onClickToolButtonCollapseAll :onCollapseAllClick,
    onClickCancelButton :onCancelButtonClickHide,
    onClickExcuteButton :onExcuteButtonClick,
    doStateChanged :onCheckBoxClick
};

function expandAllNode()
{

}

/**
 * 初始化方法
 */
function init()
{
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/online/transfer/pingtrace/pingtraceadd.xui", signalMap);
}

/**
 * 后台生成的js函数，包括参数赋值
 */
function doLoad()
{
	
    // 初始化参数信息
    var paraMap = analyseURLPara2map();

    initFeaturePara(paraMap);
    g_refSelectControler = new RefSelectControler(new KeyrefViewController(), null, new KeyPasswordViewCtrl(),new PasswordViewCtrl());

    g_configCtrl.setRefSelectCtrl(g_refSelectControler);
    
    // 获取树表对象
    tableGrid = window.xui.getWidget("TreeTable");
    tableGrid.onselchanged = onTableSelChanged;
    tableGrid.oncellselchanged = onCellSelChanged;
    tableGrid.onlastcell = doLastcell;

    // 注册表格对象，对其中的文本框进行前置限制
    Preconstraints.registTable(tableGrid);
    // 左下角的label控件对象
    gridLabel = window.xui.getWidget("TooltipLabel");
    // 获取常规/高级checkBox
    normalCheckBox = window.xui.getWidget("CheckBox");
    columnId[0] = "operation";
    columnId[1] = "property";
    columnId[2] = "value";

    validate = PARAM_VERIFY;
    tableGrid.onvaluechanged = onValueChangedEx;

    // 注册进度条加载处理对象
    var progressBarObj = window.xui.getWidget("Progressbar");
    g_progressLoadTreeTbl = new ProgressLoadTreeTbl("RootGrid", progressBarObj);

    // okButton控件对象
    var ExcuteButton = window.xui.getWidget("ExcuteButton");
    var CancelButton = window.xui.getWidget("CancelButton");
    // 注册tab键切换事件
    Tabkeyprocess.registKeyDown(ExcuteButton, Tabkeyprocess.BUTTON, CancelButton, Tabkeyprocess.BUTTON);
    // CancelButton.focus();

    // 设置add对话框已经加载过
    var win = jse.getFromWin();
    win.pub_setDialogIsLoad(PopDialogKeyName.PINGTRACE, true);

    queryTreeTableInfo();

}

/**
 * 切换特性显示方法（外部调用）
 */
function pub_loadSpecialFeature(paraMap)
{
    // 清除表数据
    removeAllTableRowIds(tableGrid);

    // 初始化参数
    initFeaturePara(paraMap);

    // 到后台查询权限信息
    queryTreeTableInfo();
}

/**
 * 查询树表动态数据
 */
function queryTreeTableInfo()
{
    var pnpForm = jse.topWin.pub_getClonePnpForm();
    var req = jse.RpcRequest
            .create(CommonUtil.getRootPath() + "/vmt/ct/featuremgr/pingtraceaction.do?methodID=handleGetPingTraceAddXUIRequest"
                    + "&neName="
                    + g_PingTraceInfo.neName
                    + "&vrId="
                    + g_PingTraceInfo.vrId
                    + "&isSupportPartition="
                    + g_PingTraceInfo.isSupportPartition
                    + "&menuLrvr="
                    + g_PingTraceInfo.menuLrvr
                    + "&menuTitle="
                    + g_PingTraceInfo.menuTitle
                    + "&menuType="
                    + g_PingTraceInfo.menuType
                    + "&xPath="
                    + g_PingTraceInfo.xPath
                    + "&parentxPath="
                    + g_PingTraceInfo.parentxPath
                    + "&deviceIP="
                    + g_PingTraceInfo.deviceIP
                    + "&deviceType="
                    + g_PingTraceInfo.deviceType
                    + "&deviceVersion="
                    + g_PingTraceInfo.deviceVersion
                    + "&ispopupmenu="
                    + g_PingTraceInfo.ispopupmenu
                    + "&keyrefInfo="
                    + g_PingTraceInfo.keyrefInfo
                    + "&primaryIP="
                    + g_PingTraceInfo.deviceIP
                    + "&pnpDeviceType="
                    + pnpForm.deviceType
                    + "&pnpDeviceVersion="
                    + pnpForm.deviceVersion
                    + "&compatible="
                    + pnpForm.compatible);

    // 设备列表数据后的回调处理函数
    req.invoke(handleResult, [ "callback_queryTreeTableInfo(request);" ]);
}

/**
 * 查询树表动态数据的回调方法
 */
function callback_queryTreeTableInfo(req)
{
    var text = req.responseText;
    var doc1 = jse.loadXML(text);

    var xmlNode = null;

    // 处理查询错误的情况
    xmlNode = jse.base.xpath.selectSingleNode("//operResultType", doc1);
    var result = xmlNode.getAttribute("resultType");
    if ("OPER_NOK" == result)
    {
        VMTError("win.errorClose();@fun_fun@errorClose()");
        return;
    }

    // 赋值
    xmlNode = jse.selectSingleNode("/response/data/guiinfo/nodeInfo", doc1);
    g_PingTraceInfo.nodeInfo = decodeURIComponent(xmlNode.getAttribute("value"));

    xmlNode = jse.selectSingleNode("/response/data/guiinfo/verifyXml", doc1);
    g_PingTraceInfo.verifyXml = decodeURIComponent(xmlNode.getAttribute("value"));

    xmlNode = jse.selectSingleNode("/response/data/guiinfo/nodeId", doc1);
    g_PingTraceInfo.nodeId = xmlNode.getAttribute("value");
    nodeId = g_PingTraceInfo.nodeId;

    xmlNode = jse.selectSingleNode("/response/data/guiinfo/featureName", doc1);
    g_PingTraceInfo.featureName = xmlNode.getAttribute("value");

    // 设备IP
    featureName = g_PingTraceInfo.featureName;

    // xmlNode = jse.selectSingleNode("/response/data/guiinfo/deviceIP", doc1);
    // g_PingTraceInfo.deviceIP = xmlNode.getAttribute("value");
    //    
    // xmlNode = jse.selectSingleNode("/response/data/guiinfo/deviceType", doc1);
    // g_PingTraceInfo.deviceType = xmlNode.getAttribute("value");

    // xmlNode = jse.selectSingleNode("/response/data/guiinfo/deviceVersion", doc1);
    // g_PingTraceInfo.deviceVersion = xmlNode.getAttribute("value");

    xmlNode = jse.selectSingleNode("/response/data/guiinfo/keyinfoxml", doc1);
    g_PingTraceInfo.keyInfoXml = decodeURIComponent(xmlNode.getAttribute("value"));

    keyInfoXml = g_PingTraceInfo.keyInfoXml;

    xmlNode = jse.selectSingleNode("/response/data/guiinfo/linkInfo", doc1);
    g_PingTraceInfo.linkageInfo = decodeURIComponent(xmlNode.getAttribute("value"));

    xmlNode = jse.selectSingleNode("/response/data/guiinfo/defauleValInfo", doc1);
    g_PingTraceInfo.defvalInfo = decodeURIComponent(xmlNode.getAttribute("value"));

    xmlNode = jse.selectSingleNode("/response/data/guiinfo/keyrefInfowithoutval", doc1);
    g_PingTraceInfo.keyrefInfo = decodeURIComponent(xmlNode.getAttribute("value"));

    // 设置默认焦点
    setDefaultFocus();

    // 增加当前的新增界面的根结点（根结点的所有信息通过后台获取）
    analyseNodeXml(g_PingTraceInfo.nodeInfo, NOTEXAPND_ALL);

    // verifyInfo通过后台获取
    analyseVerifyXml(verifications, g_PingTraceInfo.verifyXml);
    // 初始化events
    initEvents(g_PingTraceInfo.linkageInfo);
    initKeyRefMap(g_PingTraceInfo.keyrefInfo)

    // 增加了行之后，要设置其默认值
    // 设置默认值的同时，需要修改隐藏状态
    setDefValue(g_PingTraceInfo.defvalInfo);

    initKeyrefParameter();
}

function PingTraceInfo()
{
    // 获取当前是LRVR
    this.neName = null;

    // 获取设备的vrId
    this.vrId = null;

    // 获得菜单的类型，是LR型或者VR型
    this.menuLrvr = null;

    // 获得菜单的标题
    this.menuTitle = null;

    // 获得菜单的类型，是ping还是trace
    this.menuType = null;

    // 获取ping/trace的xPath
    this.xPath = null;
    this.parentxPath = null;
    this.deviceIP = null;
    this.deviceType = null;
    this.deviceVersion = null;
    this.ispopupmenu = null;
    this.keyrefInfo = null;

    // 获取节点信息
    this.nodeInfo = null;

    // 获取校验信息
    this.verifyXml = null;

    // 获得节点id
    this.nodeId = null;

    // 获得特性名称
    this.featureName = null;

    // 获得设备ip
    this.deviceIP = null;

    // 获得设备类型
    this.deviceType = null;

    // 获得设备版本
    this.deviceVersion = null;

    // keyref信息
    this.keyInfoXml = null;

    // 获得参数关联信息
    this.linkageInfo = null;

    // 获得默认值信息，包括vrId，特性右键菜单操作时还包括类型，keyref关联的值
    this.defvalInfo = null;
}

/**
 * 初始化特性参数到各个变量中
 */
function initFeaturePara(paraMap)
{
    operation = "pingtrace";

    // 该记录的xPath
    deviceIP = paraMap.get("deviceIP");

    // 操作类型
    vrId = paraMap.get("vrId");

    // 特性的版本和名字
    neName = paraMap.get("neName");
    isSupportPartition = paraMap.get("isSupportPartition");
    xPath = paraMap.get("xPath");

    // nodeId = paraMap.get("neName");

    g_PingTraceInfo.neName = neName;
    g_PingTraceInfo.vrId = vrId;
    g_PingTraceInfo.isSupportPartition = isSupportPartition;
    g_PingTraceInfo.menuLrvr = paraMap.get("menuLrvr");
    g_PingTraceInfo.menuTitle = paraMap.get("menuTitle")
    g_PingTraceInfo.menuType = paraMap.get("menuType");
    g_PingTraceInfo.xPath = paraMap.get("xPath");
    g_PingTraceInfo.parentxPath = paraMap.get("paremtxPath");
    g_PingTraceInfo.deviceIP = paraMap.get("deviceIP");
    g_PingTraceInfo.deviceType = paraMap.get("deviceType");
    g_PingTraceInfo.deviceVersion = paraMap.get("deviceVersion");
    g_PingTraceInfo.ispopupmenu = paraMap.get("ispopupmenu");
    g_PingTraceInfo.keyrefInfo = paraMap.get("keyrefInfo");

    if (paraMap.get("menuType") == "ping")
    {
        document.title = "icmpping";
    }
    else if (paraMap.get("menuType") == "trace")
    {
        document.title = "icmptrace";
    }
}

/**
 * 设置默认焦点
 */
function setDefaultFocus()
{
    if (null != firstEditCellRowid)
    {
        // 设置焦点
        tableGrid.cellFocus(firstEditCellRowid, "value");
        // 设置数表可编辑的单元格的多国语言样式
        // Preconstraints.setTableCellStype(Preconstraints.NORMAL_OPERATION);
        // 设备设置默认焦点--l00133618 第二次设置焦点是为了触发设置多国语言事件
        // tableGrid.cellFocus(rowId, columnId[2]);
        // tableGrid.clearFocusCell();
    }
}

/**
 * 从keyref字符串中获得keyref的列表信息
 */
function initKeyRefMap(text)
{
    var doc = jse.base.util.loadXML(text);

    var nodes = jse.base.xpath.selectNodes("//keyref", doc);

    if (null != nodes)
    {
        var len = nodes.length;
        var node = null;
        var src = null;
        var dst = null;
        for ( var i = 0; i < len; i++)
        {
            node = nodes[i];
            src = node.getAttribute("src");
            dst = node.getAttribute("dst");
            keyrefMap.put(src, dst);
            
        	var devType = g_PingTraceInfo.deviceType;
        	var devVersion = g_PingTraceInfo.deviceVersion;
        	var url = CommonUtil.getRootPath() + "/vmt/xpath/queryXpathAction.do?devType="+devType+"&devVersion="+devVersion
        	          +"&keys=vrId&xpathType=pnp"
        	var req = jse.RpcRequest.create(url);
        	req.invoke(callbackInitKeyrefMap,[dst]);
        }
    }
}

/**
 * 
 * @param errorCode
 * @param request
 */
function callbackInitKeyrefMap(errorCode, request, dst)
{
	// 如果目标是vrId,获得ping trace自身的vrid行的id
	var vrIdXpath = request.responseText;
	if (vrIdXpath == dst)
    {
        var rowId = src.replaceAll("/", "_0");
        rowIdOfVrId = rowId + "@xp_la@_0";
    }
}


/**
 * 用户改变cell内值时进行校验，如果校验不通过设置单元格背景颜色为红色
 */
function onValueChangedEx(evt)
{
    if (validate == PARAM_VERIFY)
    {
        var xpath = tableGrid.getCellXpath(evt.rowId, evt.colId);
        var result = verifications.verify(evt.rowId, evt.colId, evt.value, xpath);

        if (false == result)
        {
            tableGrid.setCellBackgroundColor(evt.rowId, evt.colId, NOTLEGAL_COLOR);
        }
        else
        {
            tableGrid.setCellBackgroundColor(evt.rowId, evt.colId, Constants.WHITECOLOUR);
        }
    }
    var rowidStr = evt.rowId;
    colIdStr = evt.colId;
    var method = "onvaluechanged";
    var value = evt.value;
    doEvents(rowidStr, value, method);

    // 在根据enable状态处理隐藏后，需要处理高级隐藏
    // onClickCheckBox();
    if (rowIdOfVrId == evt.rowId)
    {
        clearKeyRefCell();
    }
}

/**
 * 在vrId发生变化的时候清空所有keyref的单元格的值
 */
function clearKeyRefCell()
{
    var len = keyrefMap.getItems().length;
    var rowId = null;
    for ( var i = 0; i < len; i++)
    {
        // 获得行的id
        rowId = keyrefMap.getKeys()[i].replaceAll("/", "_0") + "@xp_la@_0";
        if (rowIdOfVrId != rowId)
        {
            setCellValue(rowId, "value", "");
        }
    }
}

/**
 * 表格行选择变化，更新描述
 */
function onTableSelChanged(evt)
{
    // 从父窗口中获取公共变量
    var parentWin = jse.getFromWin();

    var proPath = getNodeXpath(evt.id, SEPARATOR_XPATH_LABEL);
    proPath = proPath.replace(/_0/g, "/") + "_t";
    var info = Resource.getXpathResource(featureName, proPath);
    var cell = tableGrid.getCell(evt.id, "value");
    var tooltip = cell.tooltip;
    if ("undefined" == tooltip || null == tooltip || "null" == tooltip)
    {
        tooltip = "";
    }
    var gridLabelText = info + " " + tooltip;

    setGridLabelTextOnDoLoad(gridLabelText);
}

/**
 * 高级选项复选框的事件响应
 */
function onStateChanged()
{

}

function trim(str)
{
    return str.replace(/(^\s*)|(\s*$)/g, "");
}

/**
 * 解析节点信息
 */
function analyseNodeXml(nodeXml, isExapndAll)
{
    var doc = jse.base.util.loadXML(nodeXml);

    var node = jse.base.xpath.selectSingleNode("//rootnode", doc);

    if (null != node)
    {
        // 当前控件的ID
        var rootId = node.getAttribute("id");

        var rowobject = node.getAttribute("rowobject");
        parentObj = rowobject;
        addTreeGrid(rowobject);
        tableGrid.setRowBackgroundColor(rootId, UNENABLE_COLOR);

        var attributeNodes = jse.base.xpath.selectNodes("//attribute", doc);
        var childNodes = jse.base.xpath.selectNodes("//childnode", doc);

        // 检查是否有高级属性
        var hasAdvaceAttri = new Boolean(false);

        // 存储所有属性列表
        totalAttributes = new Array();

        var attributeNodeNum = attributeNodes.length;
        for ( var i = 0; i < attributeNodeNum; i++)
        {
            // 获取单个属性的信息
            var node = attributeNodes[i];
            var parentRowId = node.getAttribute("parentid");
            var attributeRowId = node.getAttribute("rowid");
            var attributeNormal = node.getAttribute("normalflag");
            var attributeGroup = node.getAttribute("groupkey");
            var attributeValue = node.getAttribute("value");
            var attributeRowObj = node.getAttribute("rowobject");
            var attributeTootip = node.getAttribute("tooltip");
            var attributeType = node.getAttribute("type");

            // 获取是否有高级属性
            if (attributeNormal == ADVANCE_ATTRIBUTE)
            {
                hasAdvaceAttri = true;
            }

            attribute = new Attribute(parentRowId, attributeRowId, attributeNormal, attributeGroup, attributeValue,
                    attributeRowObj, attributeTootip, attributeType);

            totalAttributes.push(attribute);
        }

        if (null != rootId && "" != rootId)
        {
            // 存储高级属性结点的rowID
            if (true == hasAdvaceAttri)
            {
                nodeHasAdvance.push(rootId);
            }

            // 是否插入高级属性
            var advance = ADVANCE_NODE_NOTINSERT;
            if (true == normalCheckBox.isChecked())
            {
                advance = ADVANCE_NODE_INSERT;
            }

            nodeContent = new NodeContent(rootId, OPERATION_CREATE, advance, totalAttributes);

            // 当为新建结点时添加到新建结点列表
            nodeNewContents.push(nodeContent);
            // 将所有属性添加到界面
            addTotalAttributesRow(totalAttributes);
        }

        // 通过结点ID获取该结点对应的xpath
        var nodeXpath = getNodeXpath(rootId, SEPARATOR_XPATH_LABEL);

        // 将当前同一个xpath结点的索引加一
        nodeIndexs.addNodeIndex(nodeXpath);

        // 通过结点ID获取该结点对应的label
        var nodeLabel = getNodeLabel(rootId, SEPARATOR_XPATH_LABEL);

        // 将该结点的标签增加到xpath类型结点的标签列表中
        nodeLabels.addNodeLabel(nodeXpath, nodeLabel);

        tableGrid.expandRow(rootId);
    }
}

/**
 * 向界面中添加高级属性行
 * 
 * @param attributes 所有属性的信息
 */
function addAdvanceAttributesRow(attributes)
{
    // 获取是否选中显示高级
    var groupFlag = null;
    var noramlFlag = null;
    var attributeRowId = null;
    var attributeNum = attributes.length;
    for ( var i = 0; i < attributeNum; i++)
    {
        groupFlag = attributes[i].getGroupFlag();
        noramlFlag = attributes[i].getNormalFlag();
        attributeRowId = attributes[i].getAttributeID();

        if (NORMAL_ATTRIBUTE != noramlFlag)
        {
            addTreeGrid(attributes[i].getRowObj());
            var cell = tableGrid.getCell(attributes[i].getAttributeID(), columnId[2]);
            var type = cell.type;
            if (jse.TEXT_EDITABLE == type)
            {
                setToolTip(attributes[i]);
            }
            if (GROUP_ATTRIBUTE == groupFlag)
            {
                tableGrid.setRowBackgroundColor(attributeRowId, UNENABLE_COLOR);
            }
        }
    }
    // 扩展gruop对话框
    attributeNum = attributes.length;
    for ( var i = 0; i < attributeNum; i++)
    {
        groupFlag = attributes[i].getGroupFlag();
        attributeRowId = attributes[i].getAttributeID();
        if (GROUP_ATTRIBUTE == groupFlag)
        {
            tableGrid.expandRow(attributeRowId);
        }
    }
}

/**
 * 向界面中添加所有属性行
 * 
 * @param attributes 所有属性的信息
 */
function addTotalAttributesRow(attributes)
{
    // 是否是第一个可编辑的单元格
    var isFirstEditCell = false;

    // 获取是否选中显示高级
    var checked = normalCheckBox.isChecked();
    var groupFlag = null;
    var noramlFlag = null;
    var attributeRowId = null;
    var attributeNum = attributes.length;
    for ( var i = 0; i < attributeNum; i++)
    {
        groupFlag = attributes[i].getGroupFlag();
        noramlFlag = attributes[i].getNormalFlag();
        attributeRowId = attributes[i].getAttributeID();

        // if (NORMAL_ATTRIBUTE == noramlFlag)
        // {
        addTreeGrid(attributes[i].getRowObj());
        var cell = tableGrid.getCell(attributes[i].getAttributeID(), columnId[2]);
        var type = cell.type;
        if (jse.TEXT_EDITABLE == type)
        {
            setToolTip(attributes[i]);
        }
        if (GROUP_ATTRIBUTE == groupFlag)
        {
            tableGrid.setRowBackgroundColor(attributeRowId, UNENABLE_COLOR);
        }
        else
        {
            if (!isFirstEditCell)
            {
                firstEditCellRowid = attributeRowId;
                isFirstEditCell = true;
            }
        }
    }
    // 修改为先全部增加行，然后再根据选择状态隐藏高级行
    onClickCheckBox();
    // 扩展gruop对话框
    attributeNum = attributes.length;
    for ( var i = 0; i < attributeNum; i++)
    {
        groupFlag = attributes[i].getGroupFlag();
        attributeRowId = attributes[i].getAttributeID();
        if (GROUP_ATTRIBUTE == groupFlag)
        {
            tableGrid.expandRow(attributeRowId);
        }
    }
}

/**
 * 获得下发的数据字符串
 */
function getOriginXml()
{
    // 获得新建ping/trace 的数据头
    var originXml = g_PingTraceInfo.nodeId + "@el_in@create@no_at@";

    // 获得每一行的数据
    var rowids = tableGrid.getAllRowIds();
    var rowInfo = "";
    for ( var i = 0; i < rowids.length; i++)
    {
        // 如果不是父行，即第一行 将数据字符串加入
        if (rowids[i] != g_PingTraceInfo.nodeId)
        {
            // 行数据格式未 rowid@el_in@value
            rowInfo = rowids[i] + "@el_in@" + getCellValue(rowids[i], "value");
            originXml = originXml + rowInfo + "@at_at@";
        }
    }
    return originXml;
}

/**
 * 在执行按钮点击后，把选中的行单元格的焦点放置在属性行上面，避免在最后一个单元格时ip控件时无法正常读取其值
 */
function focusColumnProperty()
{
    var selectRowId = tableGrid.getCurrentSelection();

    if (null != selectRowId)
    {
        tableGrid.cellFocus(selectRowId, "property");
    }
}

/**
 * 执行按钮的响应方法
 */
function onExcuteButtonClick()
{
    // 在执行按钮点击后，把选中的行单元格的焦点放置在属性行上面，避免在最后一个单元格时ip控件时无法正常读取其值
    focusColumnProperty();

    // 首先需要进行验证，验证输入内容是否符合条件
    var legalContent = getAllAttributeValue();
    if (null == legalContent)
    {
        // 获得未加密的数据信息
        originXML = getOriginXml();
        // 显示结果表格
        var menutype = g_PingTraceInfo.menuType;
        var _url = "";

        var opertionType = null;

        if ("ping" == trim(menutype))
        {
            opertionType = PopDialogKeyName.PINGRESULT;
            _url = CommonUtil.getRootPath() + "/vmt/ct/online/transfer/pingtrace/pingresult/pingresult.html";
        }
        else
        {
            opertionType = PopDialogKeyName.TRACERESULT;
            _url = CommonUtil.getRootPath() + "/vmt/ct/online/transfer/pingtrace/traceresult/traceresult.html";
        }
        // 新建页面为0.6，结果页面布局为0.58，界面美观
        var dialogWith = screen.width * 0.6;
        
        if ("undefined" != typeof (this.outerWidth))
        {
            dialogWith = this.outerWidth * 0.58;
        }
        var dialogHeight = dialogWith * 0.75;
        var params = "?featureName=" + featureName + "&deviceIP=" + deviceIP
                + "&isWorkspace=false" + "&vrId=" + vrId + "&neName=" + neName + "&xPath=" + xPath;

        var paraMap = new Map();
        paraMap.put("featureName", featureName);
        paraMap.put("deviceIP", deviceIP);
        paraMap.put("isWorkspace", "false");
        paraMap.put("vrId", vrId);
        paraMap.put("neName", neName);
        paraMap.put("xPath", xPath);

        _url = _url + params;
        var title = g_PingTraceInfo.menuTitle;
        var paths = title.split(":");
        var file = paths[0] + ":" + paths[1];
        var resid = paths[2];
        title = jse.getI18nValue(file, resid);
        var dialogTitle = jse.getI18nValue("qat:public", "button.execute_d") + title;

        // ping/trace对话框维护信息放在顶层页面中
        var topWindow = jse.topWin;
        topWindow.pub_showDlgByHide(opertionType, dialogTitle, handleEncodingUrl(_url), paraMap, dialogWith,
                dialogHeight, true, "dialog");
    }

}

function onCloseResult(evt)
{
    dialog.getContentWin().onCancelButtonClick();
    return true;
}

/**
 * 提示对话框的回掉函数
 */
function alertClose()
{
    // vmtalert.dispose();

    // 设置焦点
    tableGrid.cellFocus(g_errorRowId, columnId[2]);
}

function alertColseEx()
{
    // vmtalert.dispose();
}

/**
 * 收集所有结点属性控件值的变化，并设置结点操作类型
 */
function getAllAttributeValue()
{
    var rowId = "";
    var value = "";
    var advance = "";
    var groupFlag = "";
    var cell = null;
    var attributes = null;

    // 非法行的名称
    var legalContent = null;
    // 更新所有的属性值map
    getAllAttMap();
    // 遍历所有新增结点的属性
    var nodeNewContentNum = nodeNewContents.length;
    for ( var i = 0; i < nodeNewContentNum; i++)
    {
        advance = nodeNewContents[i].getAdvance();
        attributes = nodeNewContents[i].getAttributes();

        // 遍历结点所有属性检查属性控件的内容是否被修改
        var attributeNum = attributes.length;
        for ( var j = 0; j < attributeNum; j++)
        {
            rowId = attributes[j].getAttributeID();
            value = attributes[j].getValue();
            normalFlag = attributes[j].getNormalFlag();
            groupFlag = attributes[j].getGroupFlag();

            // 从map表中取出值，如果为 null，表示高级属性没有被展开过，不需要校验
            var cellValue = allAttMap.get(rowId);
            // 如果高级没有展开，如果该行当前没有生效，则都不校验
            if (arrayContains(disableRows, rowId) || null == cellValue)
            {
                continue;
            }

            // 检查是否进行校验
            if (validate == PARAM_VERIFY)
            {
                // 检查必填属性行的值是否为空
                if (("" == cellValue || null == cellValue)
                        && (NOKEY_MANDATORY == groupFlag || KEY_ATTRIBUTE == groupFlag))
                {
                    tableGrid.setCellBackgroundColor(rowId, columnId[2], NOTLEGAL_COLOR);
                    tableGrid.setCurrentSelection(rowId);
                    // 取出不合法的行名
                    var cell = tableGrid.getCell(rowId, columnId[1]);
                    legalContent = cell.content[2].text;

                    g_errorRowId = rowId;
                    // 设置焦点
                    // tableGrid.cellFocus(rowId, columnId[2]);

                    var errorStr = legalContent + jse.getI18nValue("qat:public", "label.contentempty_d");
                    VMTAlert(errorStr, "win.alertClose();", PROMPTDIALOG_HEIGHT, PROMPTDIALOG_WIDTH);
                    return legalContent;
                }

                // 检查属性行的值是否符合校验规则
                var xpath = tableGrid.getCellXpath(rowId, evt.columnId[2]);
                var result = verifications.verify(rowId, columnId[2], cellValue,xpath);
                if (false == result)
                {
                    tableGrid.setCellBackgroundColor(rowId, columnId[2], NOTLEGAL_COLOR);
                    tableGrid.setCurrentSelection(rowId);
                    // 取出不合法的行名称
                    var cell = tableGrid.getCell(rowId, columnId[1]);
                    legalContent = cell.content[2].text;

                    g_errorRowId = rowId;
                    // 设置焦点
                    // tableGrid.cellFocus(rowId, columnId[2]);

                    var errorStr = legalContent + jse.getI18nValue("qat:public", "label.contenterror_d");
                    VMTAlert(errorStr, "win.alertClose();", PROMPTDIALOG_HEIGHT, PROMPTDIALOG_WIDTH);

                    return legalContent;
                }
            }

            // 控件内容为空时value的值是null还是""
            if (null != cellValue && cellValue != value)
            {
                // 如果为IP地址，需要转换为大写。
                if (verifications.isIPAddressByRowId(rowId))
                {
                    cellValue = cellValue.toUpperCase();
                }

                attributes[j].setValue(cellValue);
            }
        }
    }
    return legalContent;
}

/**
 * 高级选项
 */
function onClickCheckBox()
{

    // 获取是否选中显示高级
    var checked = normalCheckBox.isChecked();
    // 如果高级属性还没有显示过，那么增加高级属性行
    // if(!isAdvanceShowed && checked)
    // {
    // addAdvanceAttributesRow(totalAttributes);
    // isAdvanceShowed = true;
    // }
    // else
    // {
    // 如果已经显示过，那么设置隐藏或显示
    if (checked)
    {
        showAdvanceRows(true);
    }
    else
    {
        showAdvanceRows(false);
    }
    // }
    // 给所有的value列设置值
    tableGrid.expandAll();

}

/**
 * 获得所有的值map表
 */
function getAllAttMap()
{
    var rowIds = tableGrid.getAllRowIds();
    var rowCount = rowIds.length;
    var value = null;
    var attribute = null;
    for ( var i = 0; i < rowCount; i++)
    {
        attribute = getAttributeByRowId(rowIds[i]);
        if (attribute != null && attribute.getNormalFlag() == "false" && normalCheckBox.isChecked() == false)
        {
            value = null;
        }
        else
        {
            value = getCellValue(rowIds[i], columnId[2]);
        }
        // value = getCellValue(rowIds[i],columnId[2]);
        allAttMap.put(rowIds[i], value);
    }
}

function getAttributeByRowId(rowId)
{
    var attributeID = null;
    var attribute = null;
    for ( var i = 0, n = totalAttributes.length; i < n; i++)
    {
        attribute = totalAttributes[i];
        attributeID = attribute.getAttributeID();
        if (attributeID == rowId)
        {
            return attribute;
        }
    }

    return null;
}

/**
 * 显示或者隐藏高级属性,注意，不显示无效的行 即disableRows中包含的
 */
function showAdvanceRows(beshow)
{
    var noramlFlag = null;
    var attributeRowId = null;
    var attributeNum = totalAttributes.length;
    for ( var i = 0; i < attributeNum; i++)
    {
        noramlFlag = totalAttributes[i].getNormalFlag();
        attributeRowId = totalAttributes[i].getAttributeID();
        if (NORMAL_ATTRIBUTE != noramlFlag)
        {
            if (beshow && !arrayContains(disableRows, attributeRowId))
            {
                tableGrid.showRow(attributeRowId);
            }
            else
            {
                tableGrid.hideRow(attributeRowId);
            }
        }

    }
}

function doKeyRefClick(evt)
{
    g_refSelectControler.getKeyrefViewCtrl().doKeyRefClick(evt);
}

function doKeyRefFilter(evt)
{
    g_refSelectControler.getKeyrefViewCtrl().doKeyRefFilter(evt);
}

/**
 * 
 * @author 王莉 w00138446
 * @since iManager U2000 V1R3,2010-6-26
 * @return
 */
function initKeyrefParameter()
{
    // 初始化联动控制类

    var featureData = new GlobalData();
    var featureForm = featureData.getFeatureForm();
    featureForm.featureName = g_PingTraceInfo.featureName;
    featureForm.xpath = g_PingTraceInfo.xPath;
    featureForm.isWorkspace = "false";
    featureForm.condition = null;
    featureForm.parentXpath = g_PingTraceInfo.xPath;
    featureForm.isAppearOnce = null;
    featureData.setFeatureForm(featureForm);

    var deviceForm = featureData.getDeviceForm();
    deviceForm.vrId = g_PingTraceInfo.vrId;
    deviceForm.deviceType = g_PingTraceInfo.deviceType;
    deviceForm.deviceVersion = g_PingTraceInfo.deviceVersion;
    deviceForm.deviceIp = g_PingTraceInfo.deviceIP;
    deviceForm.type = "LR";
    deviceForm.pnpForm= jse.topWin.pub_getClonePnpForm();
    featureData.setDeviceForm(deviceForm);

    var treeTableModel = new TreeTableModel(null);
    var treeTable = new PingTraceTable(tableGrid, treeTableModel);
    
    var urlArray = [];
    urlArray[RefDlgUrlType.KEYREF] = CommonUtil.getRootPath() + "/vmt/ct/online/view/keyref/keyref.html";
    urlArray[RefDlgUrlType.KEY] = CommonUtil.getRootPath() + "/vmt/ct/common/dialog/keydialog/keydialog.html";
    urlArray[RefDlgUrlType.PASSWORD] = CommonUtil.getRootPath() + "/vmt/ct/common/dialog/passworddialog/passworddialog.html";
    g_refSelectControler.initParam(treeTable, featureData, urlArray, null, null, false);
}

function PingTraceTable(tableGrid, treeTableModel)
{
    TreeTable.call(this, tableGrid, treeTableModel);
}

PingTraceTable.prototype = new TreeTable();
PingTraceTable.prototype.getKeyRefXpath = function(rowId, separator)
{
    var parentId = this._tableGrid.getParentRowId(rowId);
    var nodeXpath = ConfigUtil.getNodeXpath(parentId, separator);
    return nodeXpath;
}

/**
 * 设置keyref属性的值
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-8
 * @param keyInfo key信息
 * @param rowId 行ID
 * @param colId 列ID
 * @param targetAttrXpath 目标keyref属性Xpath
 */
PingTraceTable.prototype.setKeyrefValue = function(keyInfo, rowId, colId, targetAttrXpath)
{
    var keyList = keyInfo.list;
    var attrList = null;
    var findAttr = false;
    for ( var keyNum = 0; keyNum < keyList.length; keyNum++)
    {
        attrList = keyList[keyNum].attributes.list;
        for ( var attrNum = 0; attrNum < attrList.length; attrNum++)
        {
            if (attrList[attrNum].rowId == targetAttrXpath)
            {
                findAttr = true;
                if (null != attrList[attrNum].value)
                {
                    this.setCellValue(rowId, colId, attrList[attrNum].value);
                }
                else
                {
                    this.setCellValue(rowId, colId, "");
                }
                break;
            }
        }
        if (findAttr)
        {
            break;
        }
    }
}

function pub_getConfigCtrl()
{
    return g_configCtrl;
}

/**
 * 设置默认的值，这些值在xui信息中传入，包括当前的vrId，如果为右键菜单操作，还包括特性的类型，keyref值
 */
function setDefValue(defValStr)
{
    var doc = jse.base.util.loadXML(defValStr);
    var nodes = jse.base.xpath.selectNodes("//defaultVals//row", doc);

    var rowIds = tableGrid.getAllRowIds();
    if (null != nodes)
    {
        var length = nodes.length;
        var xpath = null;
        var value = null;
        var rowId = null;
        for ( var i = 0; i < length; i++)
        {
            xpath = nodes[i].getAttribute("xpath");
            value = nodes[i].getAttribute("value");
            // 把xpath转化为rowid
            rowId = xpath.replaceAll("/", "_0");
            rowId = rowId + "@xp_la@_0";
            if (arrayContains(rowIds, rowId))
            {
                // 判断获得的vrId是否正确
                if (rowIdOfVrId == rowId && value == deviceIP)
                {
                    var errorStr = jse.getI18nValue("qat:public", "lable.error_deivce_offline");
                    VMTAlert(errorStr, "win.alertColseEx();", PROMPTDIALOG_HEIGHT, PROMPTDIALOG_WIDTH);
                    return;
                }
                setCellValue(rowId, "value", value);
                // 设置默认值之后需要处理 隐藏，因为可能涉及到类型
                var method = "onvaluechanged";
                doEvents(rowId, value, method);
            }
        }
    }
}

/**
 * 点击取消按钮的处理事件，可以统一处理，暂时只处理新建对话框
 */
function onCancelButtonClickHide()
{
    pub_procHideDlg();
}

/**
 * 隐藏本对话框的方法
 */
function pub_procHideDlg()
{
    // 停止定时任务
    g_progressLoadTreeTbl.stopRowInterval();

    tableGrid.clearSelection();
    removeAllTableRowIds(tableGrid);

    // 恢复控件状态
    // applyButton.setEnabled(true);
    normalCheckBox.setEnabled(true);
    normalCheckBox.setChecked(false);
    setGridLabelTextOnDoLoad("");

    g_PingTraceInfo = new PingTraceInfo();
    isAdvanceShowed = false;
    allAttMap = new Map();
    disableRows = new Array();
    keyrefMap = new Map();

    // 清除全局保存的数据
    clearGlobalData();
    
    var win = jse.getFromWin();
    win.pub_hideSpecialDialog(PopDialogKeyName.PINGTRACE);
}

/**
 * 获取当前选中结点的tooltip信息
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-4-1
 */
function pub_getCurNodeTooltip()
{
    return g_config.getCurNodeTooltip();
}

/**
 * 弹出设置密码对话框
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function doKeyPasswordClick(evt)
{
    g_config.doKeyPasswordClick(evt);
}

/**
 * 弹出设置密码对话框
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function doPasswordClick(evt)
{
    g_config.doPasswordClick(evt);
}

/**
 * 获取密码类型字段属性定义的最小长度
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function pub_getCurPwdMinLength()
{
    return g_config.getPwdCellMinLength();
}

/**
 * 获取密码类型字段属性定义的最大长度
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function pub_getCurPwdMaxLength()
{
    return g_config.getPwdCellMaxLength();
}

/**
 * 获取密码类型字段属性定义的不支持的正则表达式
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function pub_getUnsupportedPwdSet()
{
    return g_config.getPwdCellPattern();
}

/**
 * 获取密码类型字段属性定义的支持的正则表达式
 * @returns
 */
function pub_getSupportedPwdSet()
{
    return null;
}

/**
 * 设置密码类型字段属性的值
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function pub_setPasswordValue(password)
{
    g_config.setPasswordValue(password);
}


Event.observe(window, "load", init);