jse.require("jse.widget.dialog");
jse.require("jse.widget.table");
jse.require("vmt.extend.table_prototype");

/**
 * 进度表格
 */
var progressGrid = null;

/**
 * 结果表格
 */
var resultGrid = null;
/**
 * 状态标签
 */
var stateLabel = null;

/**
 * 中止按钮
 */
var stopBtn = null;

/**
 * 保存属性，key为行id，值为属性列对应的值
 */
var resultProperties = new Map();

/**
 * 进度条
 */
var progressbar = null;

var neName = null;

var vrId = null;

var xPath = null;

var deviceIP = null;

var featureVersion = null;

var featureName = null;

var isWorkspace = null;

var completNum = 0;

var signalMap =
{
    on_load_ui :doLoad,
    onClickStopButton :onStopButtonClick,
    onClickCancelButton :onCancelButtonClick
};

function init()
{
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/online/transfer/pingtrace/pingresult/pingresult.xui", signalMap);
}

/**
 * 后台生成的js函数，包括参数赋值
 */
function doLoad()
{
    opertionType = PopDialogKeyName.PINGRESULT;

    // 初始化参数信息
    var paraMap = analyseURLPara2map();

    initFeaturePara(paraMap);

    // 进度表格对象
    progressGrid = window.xui.getWidget("TableProgress");
    // 结果表格对象
    resultGrid = window.xui.getWidget("TableResult");
    stateLabel = window.xui.getWidget("LabelState");
    stopBtn = window.xui.getWidget("ButtonStop");

    // 设置add对话框已经加载过
    var win = jse.getFromWin();
    win.pub_setDialogIsLoad(PopDialogKeyName.PINGRESULT, true);

    queryTreeTableInfo();
}

/**
 * 初始化特性参数到各个变量中
 */
function initFeaturePara(paraMap)
{
    neName = paraMap.get("neName");
    vrId = paraMap.get("vrId");
    xPath = paraMap.get("xPath");
    deviceIP = paraMap.get("deviceIP");
    featureVersion = paraMap.get("featureVersion");
    featureName = paraMap.get("featureName");
    isWorkspace = paraMap.get("isWorkspace");
}

/**
 * 切换特性显示方法（外部调用）
 */
function pub_loadSpecialFeature(paraMap)
{
    // 清除表数据
    progressGrid.removeAllRows();
    resultGrid.removeAllRows();

    // 初始化参数
    initFeaturePara(paraMap);

    // 到后台查询权限信息
    queryTreeTableInfo();
}

/**
 * 查询树表动态数据
 */
function queryTreeTableInfo()
{
    var pnpForm = jse.topWin.pub_getClonePnpForm();
    var req = jse.RpcRequest
            .create(CommonUtil.getRootPath() + "/vmt/ct/featuremgr/pingtraceaction.do?methodID=handleGetPingResultXUIRequest"
                    + "&neName=" + neName + "&vrId=" + vrId + "&xPath=" + xPath + "&deviceIP=" + deviceIP
                    + "&featureName=" + featureName + "&isWorkspace="
                    + isWorkspace + "&primaryIP=" + deviceIP + "&pnpDeviceType=" + pnpForm.deviceType
                    + "&pnpDeviceVersion=" + pnpForm.deviceVersion + "&compatible=" + pnpForm.compatible);

    // 设备列表数据后的回调处理函数
    req.invoke(handleResult, [ "callback_queryTreeTableInfo(request);" ]);
}

/**
 * 查询树表动态数据的回调方法
 */
function callback_queryTreeTableInfo(req)
{
    var text = req.responseText;
    var doc1 = jse.loadXML(text);

    var xmlNode = null;

    // 处理查询错误的情况
    xmlNode = jse.base.xpath.selectSingleNode("//operResultType", doc1);
    var result = xmlNode.getAttribute("resultType");
    if ("OPER_NOK" == result)
    {
        VMTError("win.errorClose();@fun_fun@errorClose()");
        return;
    }

    var progresscolInfo = null;
    var resultcolInfo = null;

    // 获得进度表格的列信息
    xmlNode = jse.selectSingleNode("/response/data/guiinfo/pingProgressTableCol", doc1);
    if (null != xmlNode)
    {
        progresscolInfo = decodeURIComponent(xmlNode.getAttribute("value"));
    }

    // 获得结果表格的列信息
    xmlNode = jse.selectSingleNode("/response/data/guiinfo/pingResultTableRow", doc1);
    if (null != xmlNode)
    {
        resultcolInfo = decodeURIComponent(xmlNode.getAttribute("value"));
    }

    progressbar = xui.getWidget("ProgressbarState");
    progressbar.start(
    {
        increment :5,
        interval :100,
        text :""
    });

    // 初始化进度表格列
    initTableCol(progressGrid, progresscolInfo);

    // 初始化结果表格列
    initResultTable(resultcolInfo);

    // 下发ping/trace命令
    sendPingTrace();
}

/**
 * 初始化结果列
 */
function initResultTable(colInfo)
{
    var proStr = jse.getI18nValue("qat:public", "tablecolumn.property_d");
    var valStr = jse.getI18nValue("qat:public", "lable_property_value");
    var column1 =
    {
        id :"property",
        name :proStr,
        style :jse.LEFT | jse.ASCEND
    };
    var column2 =
    {
        id :"value",
        name :valStr,
        style :jse.LEFT | jse.ASCEND
    };
    resultGrid.setColumns( [ column1, column2 ]);
    resultGrid.setColumnsWidth([["property","100"],["value","100"]]);
    
    var docCol = jse.base.util.loadXML(colInfo);
    var cols = jse.selectNodes("//tablecolumns//column", docCol);
    // 构建警告信息
    if (null != cols)
    {
        var colNum = cols.length;
        var colid = null;
        var coltitle = null;
        var colresfile = null;
        var colresid = null;
        for ( var j = 0; j < colNum; j++)
        {
            var colNode = cols[j];
            // 获得列id
            colid = colNode.getAttribute("id");
            colresfile = colNode.getAttribute("resfile");
            colresid = colNode.getAttribute("resid");
            // 获得列标题
            coltitle = jse.getI18nValue(colresfile, colresid);
            resultProperties.put(colid, coltitle);
            resultGrid.addRow(colid,
            {
                property :coltitle,
                value :""
            });
        }
    }
}

/**
 * 查询结果的方法，查询内容包括过程数据和结果数据 如果结果数据不为空，则表示操作已经完成，停止定时器
 */
function queryResult()
{
    if(!queryResult)
    {
        return;
    }
    var pingtraceaddWin = getParentWin();
    if (null == pingtraceaddWin ||("neName" in pingtraceaddWin) == false)
    {
        return;
    }

    var pnpForm = jse.topWin.pub_getClonePnpForm();
    var url = CommonUtil.getRootPath() + "/vmt/ct/featuremgr/pingtraceaction.do?methodID=handleQueryPingResultRequest" + "&neName="
            + pingtraceaddWin.neName + "&vrId=" + pingtraceaddWin.vrId + "&xPath=" + pingtraceaddWin.xPath
            + "&deviceIP=" + pingtraceaddWin.deviceIP + "&featureName=" + pingtraceaddWin.featureName + "&parentKeyInfo=" + parentKeyInfo + "&pnpDeviceType="
            + pnpForm.deviceType + "&pnpDeviceVersion=" + pnpForm.deviceVersion + "&compatible="
            + pnpForm.compatible;
    var req = jse.RpcRequest.create(handleEncodingUrl(url));
    req.setWaiting(false);
    req.invoke(handleResult, [ "queryResultCallBack(request);" ]);
}

/**
 * 查询结果的回调方法
 */
function queryResultCallBack(request)
{
    var text = request.responseText;
    var doc1 = jse.base.util.loadXML(text);

    var node = jse.base.xpath.selectSingleNode("//operResultType", doc1);
    var result = node.getAttribute("resultType");
    if ("OPER_NOK" == result)
    {
        doc = doc1;
        // 如果某次查询失败，停止查询，并且报错
        stopQuery("error");
        VMTError("win.errorClose();");
        return;
    }

    var node1 = jse.base.xpath.selectSingleNode("//isComplet", doc1);
    var isComplet = node1.getAttribute("complet");
    // 设置进度数据
    setProgressTableData(doc1, progressGrid);
    if ("true" == isComplet && queryFlag)
    {
         completNum = completNum + 1;
         if(completNum > 1)
         {
             completNum = 0;
           //设置结果数据同时结束定时器
            stopQuery("finished");
            setResultTableData(doc1,resultGrid);
         }
         else
         {
            //trace完成后再查最后一次trace结果。
            setTimeout("queryResult();",2000);
         }
        return;
    }
    if (queryFlag)
    {
        setTimeout("queryResult();", 2000);
    }
    // 设置进度数据
    setProgressTableData(doc1, progressGrid);
}

/**
 * 设置结果数据
 */
function setResultTableData(docIn, table)
{
    // table.removeAllRows();
    // 显示过程数据
    var rows = jse.selectNodes("//data//result//rows//row", docIn);
    var columns = resultGrid.getAllColumnIds();
    var rowIds = resultGrid.getAllRowIds();
    if (null != rows)
    {
        for ( var i = 0; i < rows.length; i++)
        {
            var rowId = rows[i].getAttribute("id");
            var value = rows[i].getAttribute("value");
            // table.setItemValue(rowId, value);
            // var rowNode = rows[i];
            // valueStr = rowNode.getAttribute("value");
            // proStr = resultProperties.get(rowId);
            // table.addRow(rowId,{property:proStr,value:valueStr});
            // var valueCell = resultGrid.getCell(rowId, columns[0]);
            resultGrid.setCell(rowId, columns[1], value);
        }
    }

}

/**
 * 隐藏本对话框的方法
 */
function pub_procHideDlg()
{
    stopQuery("finished");
    // 清除表数据
    progressGrid.removeAllRows();
    resultGrid.removeAllRows();

    // 恢复控件状态
    stopBtn.setEnabled(true);

    // 定时器对象
    queryFlag = false;

    resultProperties = new Map();

    var text = jse.getI18nValue("qat:public", "lable_state_d");
    stateLabel.setText(text);

    // 放到顶层页面中
    var win = jse.topWin;
    win.pub_hideSpecialDialog(PopDialogKeyName.PINGRESULT);
}

Event.observe(window, "load", init);