/**
 * Comment: link.js
 * Author: f00145226
 * Date: 2009-3-30
 */

/**
 * 区分数据联动信息的字符串内部变量
 */
var SEPARATOR_EVENT_INNER = "@ev_in@";

/**
 * 区分单个数据联动信息
 */
var SEPARATOR_EVENT_EVENT = "@ev_ev@";

/**
 * 区分联动配置的条件实体类信息的内部变量
 */
var SEPARATOR_CONDITION_INNER = "@co_in@";

/**
 * 区分单个联动配置的条件实体类信息
 */
var SEPARATOR_CONDITION_CONDITION = "@co_co@";
   
/**
 * 区分动配置条件分支的实体类内部变量
 */
var SEPARATOR_BRANCH_INNER = "@br_in@";

/**
 * 区分单个配置条件分支的实体类
 */
var SEPARATOR_BRANCH_BRANCH = "@br_br@";
    
/**
 * 联动事件对象
 * @param widget 控件的xpath
 * @param method 控件的方法
 * @param conditions 控件的条件列表
 * @return 联动事件对象
 */
function EventObj(widget,method,conditions)
{
    this.widget = widget;
    this.method = method;
    this.conditions = conditions;
}

/**
 * 联动事件的条件对象
 * @param expression
 * @param mains
 * @param inverses
 * @return
 */
function Condition(expression,mains,inverses)
{
    this.expression = expression;
    this.mains = mains;
    this.inverses = inverses;
}

/**
 * 联动事件的执行分支对象
 * @param widget
 * @param enable
 * @param evaluation
 * @return
 */
function Branch(widget,enable,evaluation)
{
    this.widget = widget;
    this.enable = enable;
    this.evaluation = evaluation;
}

/**
 * 将数据信息联动字符串解析成信息类
 * @param linkInfo 数据联动信息字符串
 * @return
 */
function anaylseEventObj(linkInfo)
{
	var events = new Array();
	
	var eventStrs = parseSubString(linkInfo, SEPARATOR_EVENT_EVENT);
	
	for (var i = 0; i < eventStrs.length && "" != eventStrs[i]; i++)
	{
		var event = new EventObj();
		var params = parseSubString(eventStrs[i], SEPARATOR_EVENT_INNER);
		if (params.length >= 0)
		{
			event.widget = params[0];
		}
		
		if (params.length >= 1 )
		{
			event.method = params[1];
		}
		
		if (params.length >= 2)
		{
			event.conditions = anaylseCondition(params[2]);
		}

		events.push(event);
	}
	
	return events;
}

/**
 * 将联动事件的条件对象字符串解析成信息类
 * @param linkInfo 联动事件的条件对象
 * @return
 */
function anaylseCondition(conditionInfo)
{
	var conditaions = new Array();
	
	var conditionStrs = parseSubString(conditionInfo, SEPARATOR_CONDITION_CONDITION);
	
	for (var i = 0; i < conditionStrs.length && "" != conditionStrs[i]; i++)
	{
		var condition = new Condition();
		var params = parseSubString(conditionStrs[i], SEPARATOR_CONDITION_INNER);
		if (params.length >= 0)
		{
			condition.expression = params[0];
		}
		
		if (params.length >= 1)
		{
			condition.mains = anaylseBranch(params[1]);
		}
		
		if (params.length >= 2)
		{
			condition.inverses = anaylseBranch(params[2]);
		}
		
		conditaions.push(condition);
	}
	
	return conditaions;
}


/**
 * 将联动事件的执行分支对象字符串解析成信息类
 * @param linkInfo 联动事件的执行分支对象
 * @return
 */
function anaylseBranch(branchInfo)
{
	var branchs = new Array();
	
	var branchStrs = parseSubString(branchInfo, SEPARATOR_BRANCH_BRANCH);
	
	for (var i = 0; i < branchStrs.length && "" != branchStrs[i]; i++)
	{
		var branch = new Branch();
		var params = parseSubString(branchStrs[i], SEPARATOR_BRANCH_INNER);
		if (params.length >= 0)
		{
			branch.widget = params[0];
		}
		
		if (params.length >= 1)
		{
			branch.enable = params[1];
		}
		
		if (params.length >= 2)
		{
			branch.evaluation = params[2];
		}
		
		branchs.push(branch);
	}
	
	return branchs;
}