/**
 * 存储当前界面的所有列ID
 */
var columnId = new Array();

var PARAM_VERIFY = "on";

//结点列表是否被用户点击全部展开结点展开的
var EXAPND_ALL = 1;
var NOTEXAPND_ALL = 0;

//校验值不合法的颜色
var NOTLEGAL_COLOR = "#DE9522";

// 属性行不可用时的颜色
var UNENABLE_COLOR = "#EFEFEF";

//属性是常规还是高级
var NORMAL_ATTRIBUTE = "true";
var ADVANCE_ATTRIBUTE = "false";

/**
 * 存储有高级属性的结点的rowId
 */
var nodeHasAdvance = new Array();

/**
 * 存储树表中内容发生改变的单元格
 */
var pub_modifyCells = null;

//高级属性是否插入界面
var ADVANCE_NODE_INSERT = 1;
var ADVANCE_NODE_NOTINSERT = 0;

//结点的操作类型
var OPERATION_MERGE = "merge";
var OPERATION_REPLACE = "replace";
var OPERATION_DELETE = "delete";
var OPERATION_CREATE = "create";

//属性行的标识： 0 - 非键值属性行 1 - 键值属性行 2 - 分组父行 3 - 非键值必填属性行
var NOKEY_MANDATORY = 3;
var GROUP_ATTRIBUTE = 2;
var KEY_ATTRIBUTE = 1;
var NONE_ATTRIBUTE = 0;
var NODE_LIST = 4; // 子节点列表行
var NODE_SELF = 5; // 节点自身的行

//校验类型
var NUMBER = "digital"
var STRING = "string";
var DATE = "date";
var TIME = "time";
var DATETIME = "datetime";
var IPV4_ADDRESS = "ipv4Address";
var IPV6_ADDRESS = "ipv6Address";
var IPV6_4_ADDRESS = "ipAddress";

//提示对话框大小
var PROMPTDIALOG_HEIGHT = 320;
var PROMPTDIALOG_WIDTH = 150;

/**
 * 存储当前界面的所有新建结点的信息，用于组装下发的xml报文
 */
var nodeNewContents = new Array();

/**
 * 存储当前界面的同一个xpath结点的最大索引，用于组装控件ID
 */
var nodeIndexs = new NodeIndexs();

/**
 * 存储当前修改界面的同一个xpath结点的所有标签，用于组装下发报文时判断结点父子关系制
 */
var nodeLabels = new NodeLabels();

/**
 * 用于存储校验信息
 */
var verifications = new Verifications();

/**
 * 存储当前界面的所有下查出结点的信息，用于组装下发的xml报文
 */
var nodeOriginContents = new Array();
var nodeOriginMappingContents = new Array();
var nodeNewMappingContents = new Array();
var mappingNodeLabels = new NodeLabels();

/*
 * 弹出的对话框的名称ID，放在这里统一管理，以免重复add，modify，clone，batchadd，batchmodify，filter，column
 */
var PopDialogKeyName =
{
    COLUMN :"column",
    ACTION :"action",
    PINGTRACE :"pingtrace",
    PINGRESULT :"pingresult",
    TRACERESULT :"traceresult"
}

/**
 * 用于存储校验信息
 */
function Verifications()
{
    this.verifications = new Array();

    this.addVerification = addVerification;
    this.verify = verify;
//    this.verifyBatchNew = verifyBatchNew;
//    this.verifyBatchNewTwo = verifyBatchNewTwo;
    this.getVerification = getVerification;
    this.isIPAddressByRowId = isIPAddressByRowId;
}

/**
 * 添加校验信息类
 * 
 * @param xpath 结点的xpath
 * @param type 校验信息类型
 * @param paramOne 校验参数
 * @param paramTwo 校验参数
 * @param regex 正则表达式
 */
function addVerification(xpath, type, paramOne, paramTwo, regex)
{
    var verification = new Verification(xpath, type, paramOne, paramTwo, regex);
    this.verifications.push(verification);
}

/**
 * 根据xpath获取校验信息类
 * 
 * @param xpath
 * @return 校验信息类
 */
function getVerification(xpath)
{
    for ( var i = 0; i < this.verifications.length; i++)
    {
        if (xpath == this.verifications[i].getXpath())
        {
            return this.verifications[i];
        }
    }
    return null;
}

/**
 * 判断是否为IP地址
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-6-28
 * @return true：是，false：不是
 */
function isIPAddressByRowId(rowId)
{
    var xPath = getNodeXpath(rowId, "@xp_la@");
    for ( var i = 0; i < this.verifications.length; i++)
    {
        if (this.verifications[i].getXpath() == xPath)
        {
            if(isIPAddress(this.verifications[i].type))
            {
                return true;
            }
        }
    }
    return false;
}

/**
 * 对单元格输入的内容进行校验
 * 
 * @param rowID 行ID
 * @param colId 列ID
 */
function verify(rowId, colId, value)
{
    var result = new Boolean(true);
    if ((null == value) || ("" == value))
    {
        return result;
    }

    var xPath = getNodeXpath(rowId, SEPARATOR_XPATH_LABEL);

    for ( var i = 0; i < this.verifications.length; i++)
    {
        if (this.verifications[i].getXpath() == xPath)
        {
            switch (this.verifications[i].getType())
            {
                //TODO 这里的校验以后需要统一调用verification
                case IPV4_ADDRESS:
                {
                    result = verifyIPAddress(value, IPV4_ADDRESS);
                    break;
                }
                case IPV6_ADDRESS:
                {
                    result = verifyIPAddress(value, IPV6_ADDRESS);
                    break;
                }
                case IPV6_4_ADDRESS:
                {
                    result = verifyIPAddress(value, IPV6_4_ADDRESS);
                    break;
                }
                case NUMBER:
                {
                    var paramOne = this.verifications[i].getParamOne();
                    var paramTwo = this.verifications[i].getParamTwo();

                    var number = parseInt(value);
                    var isNumber = isNaN(parseInt(value));

                    var numberStr = number + "";
                    if (numberStr.length < value.length || true == isNumber)
                    {
                        result = false;
                        break;
                    }
                    else if (number < paramOne || number > paramTwo)
                    {
                        result = false;
                        break;
                    }

                    break;
                }
                case STRING:
                {
                    var paramOne = this.verifications[i].getParamOne();
                    var paramTwo = this.verifications[i].getParamTwo();

                    if (-1 != paramOne || -1 != paramTwo)
                    {
                        if (value.length < paramOne || value.length > paramTwo)
                        {
                            result = false;
                            break;
                        }
                    }

                    var regex = this.verifications[i].getRegex();
                    if ("" != regex)
                    {
                        var re = new RegExp(regex);
                        if (!re.test(value))
                        {
                            result = false;
                            break;
                        }
                    }

                    break;
                }
                case DATE:
                {
                    result = true;// isDate(value);
                    break;
                }
                case TIME:
                {
                    result = true;// isTime(value);
                    break;
                }
                case DATETIME:
                {
                    result = true;// isDateTime(value);
                    break;
                }
                default:
                {
                }
            }

            break;
        }
    }
    return result;
}

/**
 * 用户点击展开所有行
 */
function onExpandAllClick()
{
    if (!g_expandAll)
    {
        expandAllNode();
        g_expandAll = true;
    }

    tableGrid.expandAll();
}

/**
 * 用户收缩所有行
 */
function onCollapseAllClick()
{
    tableGrid.collapseAll();
    g_expandAll = false;
}


/**
 * 用于checkbox点击响应，新增高级属性或者隐藏高级属性
 */
function onCheckBoxClick(evt)
{    
    // 如果显示高级
    if (normalCheckBox.isChecked())
    {
        // 首先获取所有的结点信息
        var allRowInfo = new Array();
        addNodeContent(allRowInfo, nodeOriginContents);
        addNodeContent(allRowInfo, nodeNewContents);
        addNodeContent(allRowInfo, nodeOriginMappingContents);
        addNodeContent(allRowInfo, nodeNewMappingContents);
        if ('undefined' != typeof operation && null != operation)
        {

            // advanceAttrIndex = 0;
            advanceAttrInfos = getAdvanceAttributes(allRowInfo, true);
            var allAdvanceAttrNumber = advanceAttrInfos.length;

            // 调用统一的进度条处理入口进行插入行的处理
            g_progressLoadTreeTbl.progressLoadTotalRows(true, allAdvanceAttrNumber, advanceAttrInfos,
                    addAdvanceAttrRow, null, null);

        }
        else
        {
            showAdvanceAttributes(nodeOriginContents);
            showAdvanceAttributes(nodeNewContents);

            showAdvanceAttributes(nodeOriginMappingContents);
            showAdvanceAttributes(nodeNewMappingContents);
        }
    }
    else
    {
        // 首先获取所有的结点信息
        var allRowInfo = new Array();
        addNodeContent(allRowInfo, nodeOriginContents);
        addNodeContent(allRowInfo, nodeNewContents);
        addNodeContent(allRowInfo, nodeOriginMappingContents);
        addNodeContent(allRowInfo, nodeNewMappingContents);

        advanceAttrInfos = getAdvanceAttributes(allRowInfo, false);

        if ('undefined' != typeof operation && null != operation)
        {
            hideAdvanceAttributes(null);
        }
        else
        {
            hideAdvanceAttributes(nodeOriginContents);
            hideAdvanceAttributes(nodeNewContents);

            hideAdvanceAttributes(nodeOriginMappingContents);
            hideAdvanceAttributes(nodeNewMappingContents);
        }
    }
}

var operation_Preconstraints = "NORMAL_OPERATION";
/**
 * 单元格的变化
 */
function onCellSelChanged(evt)
{
    if (evt.colId == columnId[2])
    {
        cellFlag = true;
    }
    else
    {
        cellFlag = false;
    }
    // 设置数表可编辑的单元格的多国语言样式
    Preconstraints.setTableCellStype(operation_Preconstraints);

    currRowId = evt.rowId;

    // 父信息，注释此行，会引起联想框 + 按钮需要两次点击才可编辑的问题，张宝军于2010-4-3日修改
    // checkIsParent(evt.rowId);
}


function doLastcell(evt)
{
    Event.stop(Tabkeyprocess.gerBrowserEvtObj(evt));
    // 显示高级
    if (normalCheckBox.isEnabled())
    {
        normalCheckBox.focus();
    }
    else if ("undefined" != typeof (checkBoxBatchstraight) && null != checkBoxBatchstraight
            && checkBoxBatchstraight.isEnabled())
    {
        checkBoxBatchstraight.focus();
    }
    else
    {
        okButton.focus();
    }
}

/**
 * 新增属性表的一行
 */
function addTreeGrid(rowObj)
{
    // 替换引号
    rowObj = rowObj.replace(/@quo@/g, "\\\"");
    var rowData = 'tableGrid.addRow(' + rowObj + ')';
    eval(rowData);
}

/**
 * 构造Attribute类，存储属性控件的ID以及属性控件的值
 * 
 * @param parentId 属性控件的父控件的ID
 * @param attributeID 属性控件的ID
 * @param normalFlag 属性是否为常规
 * @param groupFlag 该属性是否为group
 * @param value 用户输入属性控件的值
 * @param rowObj 插入属性行所需的字符串
 */
function Attribute(parentId, attributeID, normalFlag, groupFlag, value, rowObj, toolTip, type, ishide, xpath,
        mapTargetXpath)
{
    this.parentId = parentId;
    this.attributeID = attributeID;
    this.normalFlag = normalFlag;
    this.groupFlag = groupFlag;
    this.value = value;
    this.dispatchValue = value;
    this.rowObj = rowObj;
    this.toolTip = toolTip;
    this.type = type;
    this.keyRefType = 0;
    this.xpath = xpath;
    this.mapTargetXpath = mapTargetXpath;
    this.strategyInfo = null;
    this.comboItems = "";
    this.ishide = ishide;
    this.isNeedResetValue = false;

    this.getAttributeID = getAttributeID;
    this.getRowObj = getRowObj;
    this.getNormalFlag = getNormalFlag;
    this.getGroupFlag = getGroupFlag;
    this.getParentId = getParentId;
    this.getXpath = getXpath;
    this.getMapTargetXpath = getMapTargetXpath;
    this.getValue = getValue;
    this.getToolTip = getToolTip;
    this.getType = getType;
    this.getKeyRefType = getKeyRefType;
    this.cloneAttribute = cloneAttribute;
    this.isHide = isHide;

    this.setValue = setValue;
    this.setAttributeID = setAttributeID;
    this.composeAttributeString = composeAttributeString;
    this.setKeyRefType = setKeyRefType;
    this.setComboItems = setComboItems;
    this.setStrategyInfo = setStrategyInfo;
    this.getDispatchValue = getDispatchValue;
    setValue(value);
}


function getXpath()
{
    return this.xpath;
}

function getMapTargetXpath()
{
    return this.mapTargetXpath;
}
/**
 * 设置策略信息
 */
function setStrategyInfo(strategy, prefix, baseValue, increment)
{
    this.strategyInfo = new StrategyInfo(strategy, prefix, baseValue, increment);
}

/**
 * 设置策略信息
 */
function setComboItems(comboItems)
{
    this.comboItems = comboItems;
}

/**
 * Attribute克隆方法
 * 
 * @return Attribute属性
 */
function cloneAttribute()
{

    var tmp = new Attribute(this.parentId, this.attributeID, this.normalFlag, this.groupFlag, this.value, this.rowObj,
            this.toolTip, this.type, this.ishide, this.xpath, this.mapTargetXpath);

    tmp.setKeyRefType(this.keyRefType);
    tmp.setComboItems(this.comboItems);
    tmp.setStrategyInfo(this.strategyInfo.strategy, this.strategyInfo.prefix, this.strategyInfo.baseValue,
            this.strategyInfo.increment);
    return tmp;
}

/**
 * 获取属性控件信息组装的字符串
 * 
 * @return 属性控件的ID和值组成的字符串
 */
function composeAttributeString()
{
    var str = "";

    // 替换为特殊字符
    // var text = this.value.replace(/\\/g, "\\\\");

    /**
    if (this.type == DATETIME || this.type == DATE || this.type == TIME)
    {
        this.value = gcu_transformDateTime(this.value, this.type);
        if (this.type != DATE)
        {
            this.value = gcu_LocalString2UTCString(this.value, "yyyy-MM-dd HH:mm:ss");
        }
        this.value = gcu_getConfigureDateTime(this.value, this.type);
    }
    str = this.attributeID + SEPARATOR_ELEMENT_INNER + this.value;

    return str;
    */ 
    
    if (this.type == DATETIME || this.type == DATE || this.type == TIME)
    {
        this.dispatchValue = gcu_transformDateTime(this.dispatchValue, this.type);
        if (this.type != DATE)
        {
            this.dispatchValue = gcu_LocalString2UTCString(this.dispatchValue, "yyyy-MM-dd HH:mm:ss");
        }
        this.dispatchValue = gcu_getConfigureDateTime(this.dispatchValue, this.type);
    }
    str = this.attributeID + SEPARATOR_ELEMENT_INNER + this.dispatchValue;

    return str;  
     
}

/**
 * 获取属性控件的ID
 * 
 * @return 属性控件的ID
 */
function getAttributeID()
{
    return this.attributeID;
}

/**
 * 获取插入属性行所需的字符串
 * 
 * @return 插入属性行所需的字符串
 */
function getRowObj()
{
    return this.rowObj;
}

/**
 * 获取属性是否为常规
 * 
 * @return 属性是否为常规
 */
function getNormalFlag()
{
    return this.normalFlag;
}

/**
 * 获取属性是否为group
 * 
 * @return 属性是否为group
 */
function getGroupFlag()
{
    return this.groupFlag;
}

/**
 * 获取属性控件的父控件的ID
 * 
 * @return 属性控件的父控件的ID
 */
function getParentId()
{
    return this.parentId;
}

function isHide()
{
    return this.ishide;
}

/**
 * 获取用户输入属性控件的值
 * 
 * @return 用户输入属性控件的值
 */
function getValue()
{
    return this.value;
}

/**
 * 获取要下发给后台的value
 */
function getDispatchValue()
{
    return this.dispatchValue;
}

/**
 * 获取属性参数校验范围
 * 
 * @return
 */
function getToolTip()
{
    return this.toolTip;
}

/**
 * 获取属性参数校验类型
 * 
 * @return
 */
function getType()
{
    return this.type;
}

/**
 * 获取keyref类型
 * 
 * @return
 */
function getKeyRefType()
{
    return this.keyRefType;
}

/**
 * 设置keyrefType
 */
function setKeyRefType(keyRefType)
{
    this.keyRefType = keyRefType;
}

/**
 * 设置属性控件的值
 */
function setValue(value)
{
    /*
    this.value = value;
    */
    this.dispatchValue = value; 
    this.value = getEnumValueFromParent(this.xpath, value); 
}

/**
 * 设置属性控件的值
 */
function setAttributeID(attributeID)
{
    this.attributeID = attributeID;
}

/**
 * 获取从父窗体重获取Enum值，如果父窗体中不存在，则直接返回传入的参数值。
 */
function getEnumValueFromParent(xpath, value)
{
    var parentWin = jse.getFromWin();
    if (("undefined" != typeof(parentWin)) && (null != parentWin) && ("undefined" != typeof(parentWin.convertEnumValue)))
    {
        return parentWin.convertEnumValue(xpath, value);  
    }
    else
    {
        return value;
    }
}

/**
 * 设置一行的属性tooltip.
 */
function setToolTip(attribute, colId)
{

    var column = null;
    if (("undefined" == typeof (colId)) || (null == colId))
    {
        column = columnId[2];
    }
    else
    {
        column = colId;
    }

    var attributeID = attribute.getAttributeID();
    var tooltip = attribute.getToolTip();
    if ("null" == tooltip)
    {
        return;
    }

    // 目前只有可编辑文本有tooltip.
    var dateTimeIdentifier = false;
    var cell = tableGrid.getCell(attributeID, column);
    var type = attribute.getType();
    var period = jse.getI18nValue("qat:public", "label.period_d");
    var prefix = "";
    switch (type)
    {
        case NUMBER:
        {
            prefix = jse.getI18nValue("qat:public", "tooltip.number_d");
            break;
        }
        case STRING:
        {
            prefix = jse.getI18nValue("qat:public", "tooltip.string_d");
            // if (cell.type == jse.USER_DEFINED)
            // {
            // return;
            // }
            var changeTip = "";
            var length = jse.getI18nValue("qat:public", "tooltip.string_d");
            var iPos = tooltip.search("],");
            if (-1 != iPos)
            {
                var tips = tooltip.split("],");

                // 获取正则表达式资源对应的键值，因为tooltip中的逗号后面有空格所以为2
                var text = tooltip.substring(iPos + 2, iPos + 2 + tips[1].length);
                var regex = jse.getI18nValue("qat:regex", text);
                changeTip = tips[0] + "], " + regex;
            }
            else
            {
                changeTip = tooltip;
            }
            tooltip = changeTip;
            break;
        }
        case DATE:
        {
            prefix = "";
            tooltip = "";
            break;
        }
        case TIME:
        {
            prefix = "";
            tooltip = "";
            break;
        }
        case DATETIME:
        {
            // prefix = jse.getI18nValue("qat:public", "tooltip.format_d");
            prefix = "";
            tooltip = "";
            dateTimeIdentifier = true;
            break;
        }
        default:
        {
        }
    }

    // 增加判断，如果单元格为空，则直接返回，张宝军于2010-2-3增加
    if (null == cell)
    {
        return;
    }

    if (!dateTimeIdentifier && "" != tooltip && "undefined" != typeof(tooltip))
    {
        cell.tooltip = prefix + tooltip + period;
        tableGrid.setCell(attributeID, column, cell);
    }
}

/**
 * 通过结点ID获取该结点对应的xpath
 * 
 * @param nodeID 结点的行id
 * @param separator 分割符
 */
function getNodeXpath(nodeID, separator)
{
    var result = "";

    // 增加对空值的判断，张宝军于2010-4-3日修改
    if (null == nodeID)
    {
        return result;
    }

    var begin = nodeID.indexOf(separator);
    if (-1 != begin)
    {
        result = nodeID.substr(0, begin);
    }
    else
    {
        result = nodeID;
    }

    return result;
}

/**
 * 通过结点ID获取该结点对应的label
 * 
 * @param nodeID 结点的行id
 * @param separator 分割符
 */
function getNodeLabel(nodeID, separator)
{
    var result = "";
    var strs = nodeID.split(separator);
    if (strs.length >= 2)
    {
        result = strs[1];
    }

    return result;
}

/**
 * 获取单元格是否修改过
 * @param rowId 行ID
 * @param colId 列ID
 * @return 修改与否
 */
function getCellModified(rowId, colId)
{
	// 当克隆时不获取所有改变的单元格，认为所有的单元格都下发给后台
	if (null == pub_modifyCells)
	{
		return true;
	}
	
	for (var i = 0; i < pub_modifyCells.length; i++)
	{
		if ((pub_modifyCells[i].rowId == rowId) && (pub_modifyCells[i].colId == colId))
		{
			return true;
		}
	}

	return false;
}

function analyseVerifyXml(verifications, verifyInfo)
{
    var doc = jse.base.util.loadXML(verifyInfo);
    var node = jse.base.xpath.selectSingleNode("//verifyXml", doc);
    if (null != node)
    {
        var verifys = jse.base.xpath.selectNodes("//verify", doc);
        for ( var i = 0; i < verifys.length; i++)
        {
            var xpath = verifys[i].getAttribute("xpath");
            var type = verifys[i].getAttribute("type");
            var param1 = verifys[i].getAttribute("param1");
            var param2 = verifys[i].getAttribute("param2");
            var param3 = verifys[i].getAttribute("param3");
            verifications.addVerification(xpath, type, param1, param2, param3);
        }
    }
}

/**
 * 设置单元格的内容
 */
function setCellValue(rowId, colId, value)
{

    // 获取结点属性的值
    var cell = tableGrid.getCell(rowId, colId);
    if (null == cell)
    {
        return;
    }
    if (cell.type == jse.CHECKBOX)
    {
        if (value == "true")
        {
            cell.checked = true;
        }
        else if (value == "false")
        {
            cell.checked = false;
        }
        
        tableGrid.setCell(rowId, colId, cell);
    }
    else if (cell.type == jse.USER_DEFINED)
    {
        var attribute = getAttributeByID(rowId);
        var displayValue = getEnumValueFromParent(attribute.xpath, value);          
        cell.renderer.setValue(displayValue);
        tableGrid.setCell(rowId, colId, cell);
    }
    else
    {
        cell.value = value;
        tableGrid.setCell(rowId, colId, cell);
    }
}

function getAttributeByID(attributeID)
{       
    var attributes = null;
    var attribute = null;
    for(var i=0,n=nodeNewContents.length;i<n;i++)
    {
        attributes = nodeNewContents[i].getAttributes();
        if(attributes == null || attributes.length == 0)
        {
            continue;
        }
        
        for(var j=0,m=attributes.length;j<m;j++)
        {
            attribute = attributes[j];
            if(attribute.attributeID == attributeID)
            {
                return attribute;
            }
        }
    }   
}

/**
 * 汇总结点信息
 */
function addNodeContent(allNodeContents, nodeContents)
{
    if (nodeContents != null && nodeContents.length > 0)
    {
        for ( var i = 0, n = nodeContents.length - 1; i <= n; i++)
        {
            allNodeContents.push(nodeContents[i]);
        }
    }
}

/**
 * 获取高级属性行信息
 */
function getAdvanceAttributes(nodeContents, isUpdateAdvanceState)
{
    var advanceAttrInfo = [];

    var rowId = "";
    var value = "";
    var advance = "";
    var rowObj = "";
    var parentId = "";
    var beforeRowId = "";
    var beforeParentId = "";
    var groupFlag = null;
    var cell = null;
    var attributes = null;
    var advanceAttr = null;

    // 遍历所有下查结点的属性
    for ( var i = 0; null != nodeContents && i < nodeContents.length; i++)
    {
        // 如果结点为删除的则不读取控件内容
        if (OPERATION_DELETE == nodeContents[i].getOperation())
        {
            continue;
        }

        advance = nodeContents[i].getAdvance();
        attributes = nodeContents[i].getAttributes();

        // 遍历结点所有属性检查属性控件的内容是否被修改
        for ( var j = 0; j < attributes.length; j++)
        {
            if (j > 0)
            {
                // 获取前一个属性的rowID
                beforeRowId = attributes[j - 1].getAttributeID();
                beforeParentId = attributes[j - 1].getParentId();
            }

            parentId = attributes[j].getParentId();
            rowId = attributes[j].getAttributeID();
            value = attributes[j].getValue();
            rowObj = attributes[j].getRowObj();
            normalFlag = attributes[j].getNormalFlag();
            groupFlag = attributes[j].getGroupFlag();
            // 没有插入高级时属性时，要插入高级属性
            if (ADVANCE_ATTRIBUTE == normalFlag && ADVANCE_NODE_NOTINSERT == advance)
            {
                // 同一父就插入到前一个属性后，不是同一个父直接新增一个
                if (0 == j || parentId != beforeParentId)
                {
                    advanceAttr = new AdvanceAttrContent(attributes[j], beforeRowId, beforeParentId, advance, j);
                    advanceAttrInfo.push(advanceAttr);
                }
                else if (parentId == beforeParentId)
                {
                    advanceAttr = new AdvanceAttrContent(attributes[j], beforeRowId, beforeParentId, advance, j);
                    advanceAttrInfo.push(advanceAttr);
                }
            }

            if (ADVANCE_ATTRIBUTE == normalFlag && ADVANCE_NODE_INSERT == advance)
            {
                advanceAttr = new AdvanceAttrContent(attributes[j], beforeRowId, beforeParentId, advance, j);
                advanceAttrInfo.push(advanceAttr);
            }
        }

        if (isUpdateAdvanceState)
        {
            // 设置结点的高级属性为已插入
            nodeContents[i].setAdvance(ADVANCE_NODE_INSERT);
        }

    }

    return advanceAttrInfo;
}

/**
 * 添加高级属性行
 */
function addAdvanceAttrRow(advanceAttr, index, margs)
{
    if (advanceAttr != null)
    {
        var index = advanceAttr.getIndex();
        var advance = advanceAttr.getAdvance();
        var beforeRowId = advanceAttr.getBeforeRowID();
        var beforeParentId = advanceAttr.getBeforeParentID();
        var attr = advanceAttr.getAttributeInfo();

        var parentId = attr.getParentId();
        var rowId = attr.getAttributeID();
        var value = attr.getValue();
        var rowObj = attr.getRowObj();
        var normalFlag = attr.getNormalFlag();
        var groupFlag = attr.getGroupFlag();

        // 没有插入高级时属性时，要插入高级属性
        if (ADVANCE_ATTRIBUTE == normalFlag && ADVANCE_NODE_NOTINSERT == advance)
        {
            // 同一父就插入到前一个属性后，不是同一个父直接新增一个
            if (0 == index || parentId != beforeParentId)
            {
                var nextRowId = getFisrtListRow(parentId);
                insertBeforeTreeGrid(nextRowId, rowObj)
                setToolTip(attr);
                tableGrid.showRow(rowId);
                if (GROUP_ATTRIBUTE == groupFlag)
                {
                    tableGrid.setRowBackgroundColor(rowId, UNENABLE_COLOR);
                }
            }
            else if (parentId == beforeParentId)
            {
                insertAfterTreeGrid(beforeRowId, rowObj);
                tableGrid.showRow(rowId);
                setToolTip(attr);
                if (GROUP_ATTRIBUTE == groupFlag)
                {
                    tableGrid.setRowBackgroundColor(rowId, UNENABLE_COLOR);
                }
            }

            // 判断是否需要重置
            if (attr.isNeedResetValue)
            {
                setCellValue(rowId, columnId[2], value);
            }
        }

        if (ADVANCE_ATTRIBUTE == normalFlag && ADVANCE_NODE_INSERT == advance)
        {
            if (tableGrid._isExpanded(parentId))
            {
                tableGrid.showRow(rowId);
            }
        }
    }
}

/**
 * 插入属性表的一行
 */
function insertAfterTreeGrid(afterId, rowObj)
{
    rowObj = rowObj.replace(/@quo@/g, "\\\"");
    rowObj = '"' + afterId + '"' + ',' + rowObj;
    var rowData = 'tableGrid.insertAfter(' + rowObj + ')';
    eval(rowData);
}

/**
 * 隐藏结点的所有高级属性，如果没有则插入高级属性
 */
function hideAdvanceAttributes(nodeContents)
{
    var rowId = "";
    if ('undefined' != typeof operation && null != operation)
    {
        // JSE提供table.hideRows()接口之后如下代码作废：start
        var hideNodeId = new Array;
        for ( var i = 0; i < advanceAttrInfos.length; i++)
        {
            var attr = advanceAttrInfos[i].getAttributeInfo();
            var parentID = attr.getParentId();
            if (!arrayContains(hideNodeId, parentID))
            {
                var rowId = attr.getAttributeID();
                tableGrid.hideRow(rowId);
                hideNodeId.push(rowId);
            }
        }  //end
    }
    else
    {
        var attributes = null;
        var normalFlag = -1;

        // 遍历所有下查结点的属性
        for ( var i = 0; null != nodeContents && i < nodeContents.length; i++)
        {
            // 如果结点为删除的则不读取控件内容
            if (OPERATION_DELETE == nodeContents[i].getOperation())
            {
                continue;
            }

            attributes = nodeContents[i].getAttributes();

            // 遍历结点所有属性检查属性控件的内容是否被修改
            for ( var j = 0; j < attributes.length; j++)
            {
                rowId = attributes[j].getAttributeID();
                normalFlag = attributes[j].getNormalFlag();

                // 隐藏高级时属性
                if (ADVANCE_ATTRIBUTE == normalFlag)
                {
                    tableGrid.hideRow(rowId);
                }
            }
        }
    }
}

function setGridLabelTextOnDoLoad(gridLabelText)
{
	gridLabelText = gridLabelText.procReturn();
    var len = jse.topWin.lang == "zh_CN"?47:100;
    if (gridLabelText.length > len)
    {
        gridLabel.setText(gridLabelText.substring(0, len) + "...");
        gridLabel.setTooltip(gridLabelText);
    }
    else
    {
        gridLabel.setText(gridLabelText);
        gridLabel.setTooltip("");
    }
}

/**
 * 获取单元格的内容
 */
function getCellValue(rowId, colId)
{
    var cellValue = "";

    // 获取结点属性的值
    var cell = tableGrid.getCell(rowId, colId);

    // 增加判断，如果单元格为空，则直接返回，张宝军于2010-2-3增加
    if (null == cell)
    {
        return cellValue;
    }

    if (cell.type == jse.CHECKBOX)
    {
        cellValue = cell.renderer.checked;

        // 修改在复选框单元格用户没有操作时不进行下发数据，张宝军于2010-4-12日修改
        // checkbox所在单元格没有被操作且不是key或者mandatory属性，则根据Schema中default取默认值，即进入第一个if分支。
        var propertyCell = tableGrid.getCell(rowId, "property");
        if (!getCellModified(rowId, colId) && propertyCell.content[3].text.indexOf("*") == -1)
        {
            // 获取复选框的默认值进行下发数据，张宝军于2010-4-15日修改
            cellValue = getCheckBoxDefaultValue(rowId);
        }
        else if (true == cell.renderer.checked)
        {
            cellValue = "true";
        }
        else if (false == cell.renderer.checked)
        {
            cellValue = "false";
        }
        else
        {
            cellValue = "";
        }
    }
    else if (cell.type == jse.USER_DEFINED)
    {
        cellValue = cell.renderer._value;
        cellValue = null == cellValue || "" == cellValue ? cell.renderer._td.innerHTML : cellValue;
        cellValue = cellValue == "filter" ? "" : cellValue;

        cellValue = null != cellValue ? cellValue.trim() : cellValue;
        if ("undefined" != typeof (cell.renderer._datechooser) && null != cell.renderer._datechooser)
        {
            cellValue = cell.renderer._datechooser.isInDST() ? cellValue + "@dst_dst@true" : cellValue
                    + "@dst_dst@false"
        }
    }
    else if (cell.type == jse.COMBO)
    {
        for ( var i = 0; i < cell.items.length; i++)
        {
            if (cell.items[i].text == cell.value)
            {
                cellValue = cell.items[i].id;
                break;
            }
        }
    }
    else
    {
        cellValue = cell.value;
        cellValue = cellValue.trim();
    }

    cellValue = cellValue != "&nbsp;" ? cellValue : "";
    return cellValue;
}

/**
 * 清除表格中的所有记录，jse的table.removeAllRows()方法有问题，临时实现。
 * 
 * @param {} tableObj
 */
function removeAllTableRowIds(tableObj)
{
    tableObj.removeAllRows();
}

/**
 * 编辑对话框退出时，清除全局变量保存的数据，增加全局变量时一定要考虑
 */
function clearGlobalData()
{
    parentRowIds = new Array();
    // 记录新增的行id
    addRowIds = new Array();
    allRowColorsMap = new Map();

    // 记录删除的行的原始状态 key为行id,value 为preState
    deletedRowsMap = new Map();

    /**
     * 存储当前界面的所有新建结点的信息，用于组装下发的xml报文
     */
    nodeNewContents = new Array();

    /**
     * 存储当前界面的同一个xpath结点的最大索引，用于组装控件ID
     */
    nodeIndexs = new NodeIndexs();

    /**
     * 存储当前修改界面的同一个xpath结点的所有标签，用于组装下发报文时判断结点父子关系制
     */
    nodeLabels = new NodeLabels();

    /**
     * 存储结点列表的控件的ID以及该列表是否被用户点击
     */
    nodeLists = new NodeLists();

    /**
     * 子节点信息列表
     */
    childNodes = new Array();

    /**
     * 用于存储校验信息
     */
    verifications = new Verifications();

    /**
     * 存储新建界面中选择父的结点的信息，选择父对话框时进行赋值
     */
    parentNodeKeyInfo = "";

    /**
     * 存储当前界面的所有下查出结点的信息，用于组装下发的xml报文
     */
    nodeOriginContents = new Array();

    /**
     * 存储当前界面的所有结点ID，结点的所有关键属性和关键属性值！！！！
     */
    nodeKeyContents = new Array();

    /**
     * 存储查询上来的所有keyref的所有值
     */
    keyRefInfos = new Array();

    /**
     * 存储后台传递的数据联动信息
     */
    eventObjs = new Array();

    /**
     * 存储schema的版本号，用于获取左下角label显示信息
     */
    featureVersion = "";

    /**
     * 存储当前选择keyref的rowid
     */
    keyRefRowId = "";

    /**
     * 存储当前选择keyref的查询值
     */
    currentKrefInfo = null;

    /**
     * 存储树表中内容发生改变的单元格
     */
    pub_modifyCells = null;

    /**
     * 记录用户是否编辑数据成功
     */
    pub_editResult = "";

    /**
     * 提示对话框对象
     */
    errorDlg = null;

    /**
     * 提示对话框对象
     */
    vmtalert = null;

    /**
     * 返回报文解析成DOM对象
     */
    doc = null;

    /**
     * 存储有高级属性的结点的rowId
     */
    nodeHasAdvance = new Array();

    // 检查是否有高级属性
    hasAdvaceAttri = new Boolean(false);

    /**
     * 用户点击的cell是否是第三列
     */
    cellFlag = new Boolean(false);

    /**
     * 错误行的Id
     */
    g_errorRowId = null;

    /**
     * 错误列的Id
     */
    g_errorColId = null;

    /**
     * 返回结果类型
     */
    resultType = null;

    /**
     * keyref对话框
     */
    keyRefDialog = null;

    /**
     * 用户点击过全部展开按钮
     */
    g_expandAll = false;

    // 等待对话框对象
    waitDialog = null;

    // start:mapping方案添加
    isMappingMap = new Map();
    isTargetAttrMap = new Map();
    nodeOriginMappingContents = new Array();
    nodeNewMappingContents = new Array();
    mappingNodeLabels = new NodeLabels();
    mappingXpath = null;
}