jse.topWin.lang = "zh_CN";

var pingtraceParams = 
{
    deviceID: "",
    deviceIP: "",
    deviceType: "",
    deviceVersion: "",
    vrID: "",
    language: "",
    pingtraceID: "",
    initParamInfo: "",
	type: "",
	lrRole: ""
};

function init()
{
    var urlParaMap = analyseURLPara2map();
    initParams(urlParaMap);
    pub_getDevSupportPkg();
}

function initParams(urlParaMap)
{
    pingtraceParams.deviceID = urlParaMap.get("deviceID");
    pingtraceParams.deviceIP = urlParaMap.get("deviceIP");
    pingtraceParams.deviceType = urlParaMap.get("deviceType");
    pingtraceParams.deviceVersion = urlParaMap.get("deviceVersion");
    pingtraceParams.vrID = urlParaMap.get("vrID");
    pingtraceParams.language = urlParaMap.get("language");
    pingtraceParams.pingtraceID = urlParaMap.get("pingtraceID");
    pingtraceParams.initParamInfo = urlParaMap.get("initParamInfo");
	pingtraceParams.type = urlParaMap.get("Type");
	pingtraceParams.lrRole = urlParaMap.get("lrRole");
	jse.topWin.lang = pingtraceParams.language;
}

/**
 * 获取设备支持包
 *
 */
function pub_getDevSupportPkg()
{
    logger.log("enter pub_getDevSupportPkg()");
    jsonrpc.asynInvoke("pnpService", "existPnpPackage", [pingtraceParams.deviceType, pingtraceParams.deviceVersion, pingtraceParams.deviceIP], doExistDevPkgCallBack, this, []);
}

/**
 * 处理是否存在设备支持包后台返回结果
 *
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-11
 */
function doExistDevPkgCallBack(operResult)
{
    logger.log("enter doExistDevPkgCallBack()");
    if ("OPER_OK" != operResult.resultType) 
    {
        // 弹出错误对话框
        CommonDlgReq.openRspErrorDialog(operResult, null, null);
        return;
    }
    
    var pnpModel = operResult.returnObj;
    var isExist = pnpModel.exist;
    if (isExist) 
    {
        // 调用支持包下载后的统一处理方法
        doPingTrace();
    }
    else 
    {
        displayWaitingDlg();
    }
}

/**
 * 显示等待对话框
 *
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-11
 */
function displayWaitingDlg()
{
    var waitingDialogTip = jse.getI18nValue("qat:public:", "dialog.update_d");
    var message = jse.getI18nValue("qat:public", "label.wait_d");
    
    var length = 400;
    if (jse.topWin.lang == "en_US") 
    {
        length = 650;
    }
    
    waitingDialog = CommonDlgReq.openWaitDialogWithPos(length, 200, waitingDialogTip, message, "waiting_bar", null, null);
    waitingDialog.show();
    
    jsonrpc.asynInvokeWaiting("pnpService", "loadPnpPackage", [pingtraceParams.deviceType, pingtraceParams.deviceVersion, pingtraceParams.deviceIP], getDevPkgCallBack, this, []);
}

/**
 * 获取设备支持包回调函数
 *
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-11
 */
function getDevPkgCallBack(operResult)
{
    // 关闭等待对话框
    waitingDialog.dispose();
    waitingDialog = null;
    
    // 如果获取失败，则直接弹出错误信息,点击确定后关闭当前网元管理器
    if (operResult.resultType != GlobalConstants.OPER_OK) 
    {
        CommonDlgReq.openRspErrorDialog(operResult, exitWindow, this);
        return;
    }
    
    var pnpForm = operResult.returnObj.pnpForm;
    if (pnpForm.compatible) 
    {
        // 如果是兼容的支持包，则需要提示用户是否继续操作
        var compatibleReasonID = pnpForm.compatibleReasonId;
        var currentNEinfoText = jse.getI18nValue("qat:public", "label.currentneinfo_d");
        var loadFailedReasonText = CommonDlgReq.getResponseErrorReason(operResult);//jse.getI18nValue("qat:errorcode", pnpForm.compatibleReasonId);
        var compatibleText = jse.getI18nValue("qat:public", "lable.pnpcompatibleprompt_d");
        
        // 动态替换版本信息
        compatibleText = compatibleText.replace("%1", pnpForm.deviceVersion);
        currentNEinfoText = currentNEinfoText + pingtraceParams.deviceType + "-" + pingtraceParams.deviceVersion
        var showText = loadFailedReasonText + Constants.HTML_NEWLINE_TAG + currentNEinfoText +
        Constants.HTML_NEWLINE_TAG +
        compatibleText;
        
        CommonDlgReq.openYesNoDialog(showText, doPingTrace, this, [], exitWindow, this, []);
    }
    else 
    {
        // 打开pingtrace界面
        doPingTrace();
    }
}

/**
 * 下载完设备支持包后的统一处理方法
 *
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-11
 */
function doPingTrace()
{
    var _url = CommonUtil.getRootPath() + "/vmt/ct/online/view/pingtrace/pingtrace.html?deviceID=" + pingtraceParams.deviceID +
    "&deviceIP=" +
    pingtraceParams.deviceIP +
    "&deviceType=" +
    pingtraceParams.deviceType +
    "&deviceVersion=" +
    pingtraceParams.deviceVersion +
    "&vrID=" +
    pingtraceParams.vrID +
    "&language=" +
    pingtraceParams.language +
    "&id=" +
    pingtraceParams.pingtraceID +
    "&initParamInfo=" +
    pingtraceParams.initParamInfo +
	"&type=" +
	pingtraceParams.type +
	"&lrRole=" +
	pingtraceParams.lrRole;
    
    var paraMap = new Map();
    paraMap.put("deviceID", pingtraceParams.deviceID);
    paraMap.put("deviceIP", pingtraceParams.deviceIP);
    paraMap.put("deviceType", pingtraceParams.deviceType);
    paraMap.put("deviceVersion", pingtraceParams.deviceVersion);
    paraMap.put("vrID", pingtraceParams.vrID);
    paraMap.put("language", pingtraceParams.language);
    paraMap.put("id", pingtraceParams.pingtraceID);
    paraMap.put("initParamInfo", pingtraceParams.initParamInfo);
	paraMap.put("type", pingtraceParams.type);
	paraMap.put("lrRole", pingtraceParams.lrRole);
    
    var dialogWidth = screen.width * 0.6;
    var dialogHeight = dialogWidth * 3 / 4;
    var encodeUrl = handleEncodingUrl(_url);
    pub_showDlgByHide("pingtrace", "", encodeUrl, paraMap, dialogWidth, dialogHeight, false, null);
	//去掉dialog的边框并重新设置位置
	document.body.removeChild(document.getElementById("pingtrace"));
	var iframe = document.getElementById("pingtrace___iframe");
	iframe.style.top = "0px";
	iframe.style.left = "0px";
	iframe.style.height = "567px";
	iframe.style.width = "692px";
}

/**
 * 关闭当前网元管理窗口(不做提示，直接关闭窗口)
 *
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R5,2010-11-17
 * @return
 */
function exitWindow()
{
    window.onbeforeunload = null;
    window.close();
}

function pub_getClonePnpForm()
{
	var resPnpForm = new PnpForm();
	resPnpForm.deviceType = pingtraceParams.deviceType;
	resPnpForm.deviceVersion = pingtraceParams.deviceVersion;
	return resPnpForm;
}

Event.observe(window, "load", init);
