jse.require("jse.widget.dialog");
jse.require("jse.widget.menu");
jse.require("jse.widget.table");
jse.require("vmt.extend.table_prototype");

/* 全局RPC代理对象 */
var g_jsonrpc = ("undefined" == typeof(jsonrpc) || null == jsonrpc) ? new VmtJsonRPC() : jsonrpc;

var g_global = null;
var g_pnpForm = null;
var g_verifyInfo = null;

var g_xpathMappingOperobjInfo = null;

var preLoadFlag = false;

/**
 * 定位到的node，tab
 */
 var toTabId = "";
 
/**
 * VR划分
 */
//var g_IsSupportPartition = false;

var g_VRID = 0;

var g_VRName = null;


/**
 * 三段式第三段tab页的id，以@分隔
 */
var tabIds = "";

/**
 * 获取常量对象
 */
var Constants = new Constants();

/**
 * 硬件规格差异数据缓存管理对象
 */
var g_HardSpecDiffDataCacheMgr = new DataCacheMgr();

/**
 * 全局配置选项数据管理对象
 */
var g_SystemConfigDataMgr = new SystemConfigDataMgr();

/**
 * 特性Tab页view控制类
 */
var g_featureTabViewCtrl ;

/**
 * 视图管理对象
 */
var g_ViewsManager = null;

	
/**
 * 转换后的过滤条件
 */
var g_filterCondition = null;

var g_E2E_iniFocus = false;

/**
 * 使用栈方式，保存dialogId
 * 
 */
var g_dialogIds = [];

//记录最近一个操作的特性Tab信息，删除缓存用
var Current_FeatureID_Info = null;

/**
 * 当前选中的功能树节点的ID
 */
var curFeatureNodeID = null;

var g_viewTabIds = [];

var g_tabNum = 0;

var signalMap =
{
    on_load_ui :doLoad,
    onviewchanged:onviewchanged
};


/**
 * 初始化函数
 */
function init()
{
    logger.log("enter feature init()");
    
    //设置语言
    jse.setLanguage(lang);
    
    // 通过JSON获取控件的Handler
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/online/xui/e2e/window.xui", signalMap);
    
    logger.log("exit feature init()");
}

/**
 * 用户载入页面
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return
 */
function doLoad()
{
    logger.log("enter e2e index doLoad()");

    // 获得界面控件对象
    viewManager = window.xui.getWidget("ViewManager");
    g_featureTabViewCtrl = new TabViewCtrl(viewManager, new FeaturesResourceMgr(), null, Constants.FEATURE_VIEWID);    

    viewManager.setViewMinimumSize("feature",
    	    {
    	        width : 150,
    	        height : 50
    	    });
    
    g_ViewsManager = new ViewsManager(viewManager);
    var featureUrl = Constants.URL_MULTIFEATURE_HTML + "?preLoadPage=true";
    g_ViewsManager.loadSpecialView(Constants.FEATURE_VIEWID, "", featureUrl); 
 
        
    initGlobalData();

    var featureForm = g_global.getFeatureForm();    
    var treeNodeID = featureForm.funcnodeName;
    if(null == treeNodeID || "" == treeNodeID)
    {
        treeNodeID = featureForm.featureName + "]" + featureForm.xpath;
    }
    pub_locateTo(treeNodeID, featureForm.tabId);   

    logger.log("exit e2e index doLoad()");
}

//GlobalData为单例
function pub_getPubData()
{    
    var currentFeatureId = g_featureTabViewCtrl.getCurrentTabId();
    var funcnodeTabList = g_featureTabViewCtrl.getFuncnodeTabList();
    if((currentFeatureId == Constants.FEATURE_VIEWID) || (currentFeatureId == null) || ( funcnodeTabList == null) || (funcnodeTabList.length == 0))
    {
        return g_global.clone();
    }
    
    // 获取Tab页定制信息
    var customTabInfo = g_featureTabViewCtrl.getTabInfo(currentFeatureId);
    var currentTabType = g_featureTabViewCtrl.getCurrentTabType(currentFeatureId);
    var xpaths = customTabInfo.xpath.split("/");    
    var featureName = xpaths[1];
    var featureForm = g_global.getFeatureForm();
    featureForm.featureName = featureName;
    featureForm.featureNodeType = currentTabType;
    featureForm.tabId = currentFeatureId;
    if(currentTabType == "ATTRIBUTEGROUP")
    {
        featureForm.xpath = customTabInfo.moXpath;
        featureForm.groupXpath = customTabInfo.xpath;
        featureForm.isAppearOnce = true;
    }
    else  if(currentTabType == "OBJECT") 
    {
        featureForm.xpath = customTabInfo.xpath;
        featureForm.groupXpath = null;
        featureForm.isAppearOnce = false;
    }
    
    return g_global.clone();     
}
/**
 * 获取全局参数
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
/*
function pub_getPubData()
{
    return g_global;
}
*/

/**
 * 初始化全局参数
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
function initGlobalData()
{
   // 从后台获取初始化参数需要的信息:该特性操作对象的对应的所有的Xpath，全局属性需要的参数，
    var featureForm = new FeatureForm();
    featureForm.featureName = g_E2E_featureName;
    featureForm.isWorkspace = "false";
    featureForm.domain = g_E2E_domain;
    featureForm.condition = g_E2E_filterCondition;
    featureForm.guiType = "QUERY";

    var deviceForm = new DeviceForm();
    deviceForm.deviceType = g_E2E_deviceType;
    deviceForm.deviceVersion = g_E2E_deviceVersion;
    deviceForm.deviceIp = g_E2E_deviceIp;
    deviceForm.vrId = g_E2E_vrId;
    deviceForm.devId = g_E2E_devId;
    deviceForm.lrRole = g_E2E_lrRole;
    deviceForm.type = g_E2E_type;
    
    deviceForm.pnpForm.deviceType = g_E2E_deviceType;
    deviceForm.pnpForm.deviceVersion = g_E2E_deviceVersion;    
    
    var keyInfoMap = new Map();
    var keyInfos = g_E2E_filterCondition.split("@nmsname_value@");
    for ( var num = 0; num < keyInfos.length; num+=2)
    {
        var nmsname = keyInfos[num];
        var value = keyInfos[num + 1];
        if (nmsname != null && nmsname != "")
        {
            keyInfoMap.put(nmsname,value);
        }       
    }
    
    // 从后台获取全局参数
  var operResult = jsonrpc.invoke("e2eGlobalParamProcess", "getGlobalParam", [ deviceForm.changJsonForm(), featureForm.changJsonForm(),g_E2E_operObjNmsname,JsonUtil.changeJsonMap(keyInfoMap)
                                                                                        ]);
  if (null == operResult)
  {
      return;
  }
  
  if(GlobalConstants.OPER_OK == operResult.resultType)
  {
      var globalFeatureForm = operResult.returnObj.featureForm;
      var globalDeviceForm = operResult.returnObj.deviceForm;
      g_xpathMappingOperobjInfo = operResult.returnObj.xpathMappingOperobjInfo;      
      g_filterCondition = operResult.returnObj.nodeKeyMap;
      
      var newDeviceForm = new DeviceForm();
      newDeviceForm.deviceType = globalDeviceForm.deviceType;
      newDeviceForm.deviceVersion = globalDeviceForm.deviceVersion;
      newDeviceForm.deviceIp = globalDeviceForm.deviceIp;
      newDeviceForm.vrId = globalDeviceForm.vrId;
      newDeviceForm.devId = globalDeviceForm.devId;
      newDeviceForm.lrRole = globalDeviceForm.lrRole;
      newDeviceForm.isSupportPartition = globalDeviceForm.isSupportPartition;
      newDeviceForm.type = globalDeviceForm.type;
      
      var pnpForm = new PnpForm();
      pnpForm.deviceType = globalDeviceForm.pnpForm.deviceType;
      pnpForm.deviceVersion = globalDeviceForm.pnpForm.deviceVersion;
      pnpForm.compatible = globalDeviceForm.pnpForm.compatible;

      newDeviceForm.pnpForm = pnpForm;      
      g_pnpForm = pnpForm;
      
      var newFeatureForm = new FeatureForm();
      newFeatureForm.featureName = globalFeatureForm.featureName;
      newFeatureForm.xpath = globalFeatureForm.xpath;
      newFeatureForm.isWorkspace = globalFeatureForm.isWorkspace;
      newFeatureForm.domain = globalFeatureForm.domain;
      newFeatureForm.guiType = globalFeatureForm.guiType;
      newFeatureForm.condition = globalFeatureForm.condition;
      newFeatureForm.parentXpath = globalFeatureForm.parentXpath;
      newFeatureForm.isAppearOnce = globalFeatureForm.appearOnce;
      newFeatureForm.funcnodeName = globalFeatureForm.funcnodeName;
      newFeatureForm.tabId = globalFeatureForm.tabId;

      var global = new GlobalData();
      global.setDeviceForm(newDeviceForm);
      global.setFeatureForm(newFeatureForm);
      
      var frameParam = new FrameParam();
      global.setFrameParam(frameParam);
      
      //全局参数
      g_global = global;
            
  }
  else
  {
      CommonDlgReq.openRspErrorDialog(operResult, null, null);
  }
}


/**
 * 获取需要的校验信息值
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-31
 * @returns
 */
function pub_getVerification()
{
    var deviceForm = g_global.getDeviceForm();
    var featureForm = g_global.getFeatureForm();
    var frameParam = g_global.getFrameParam();

    var operResult = jsonrpc.invokeWithoutMask("dataTableFactory", "getFeatureVerificationInfo", [
            deviceForm.changJsonForm(), featureForm.changJsonForm(), frameParam ]);
    if (null == operResult)
    {
        return;
    }

    if (null != operResult)
    {
        var verifications = new Verifications();
        verifications.init(operResult.list);
        g_verifyInfo = verifications;
    }

    return g_verifyInfo;
}

/**
 * 获取硬件规格差异
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @returns {DataCacheMgr}
 */
function pub_getHardSpecDiffDataCacheMgr()
{
    return g_HardSpecDiffDataCacheMgr;
}

/**
 * 初始化全局配置数据
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function initSystemConfigDataMgr()
{
    g_SystemConfigDataMgr.init();
}

/**
 * 获取全局配置选项信息
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function pub_getSystemConfigDataMgr()
{
    return g_SystemConfigDataMgr;
}


/**
 * 第三段第一次弹出详细信息对话框初始位置的横坐标.<br>
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function pub_getXChildRelative()
{
    // 坐标计算有问题，只返回屏幕大小，根据对话框再计算偏移位置
    return window.screen.availWidth - 10;

}

/**
 * 第三段第一次弹出详细信息对话框初始位置的纵坐标.<br>
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function pub_getYChildRelative()
{
    // 坐标计算有问题，只返回屏幕大小，根据对话框再计算偏移位置
    return window.screen.availHeight - 30;
}

/**
 * 获取json对象接口
 * @author w00131173
 */
function pub_getJsonRpcObj()
{
    if(null == g_jsonrpc)
    {
        g_jsonrpc = new VmtJsonRPC();
    }
    
    return g_jsonrpc;
}

/**
 * 重新初始化json对象接口（无论之前是否初始化过，进行重新初始化操作，
 * 提供给预加载打开网元管理器时重新注册json对象，防止后台重启出错）
 * @author w00131173
 */
function reInitJsonRpcObj()
{
    g_jsonrpc = new VmtJsonRPC();
}

/**
*定位到指定节点的具体tab
*/
function pub_locateTo(nodeId, tabId)
{
	//要定位到的TabId，初始化时激活该tab页
	this.toNodeId = nodeId;
	this.toTabId = tabId;

	//加载节点和tab
	setSelNodeAddFeatureView(toNodeId);
}

/**
 * 设置选中节点并加载特性Tab 提供给主窗体调用
 */
function setSelNodeAddFeatureView(nodeid)
{
    // 根据已经选中的结点，加载对应的特性Tab页
    if (!preLoadFlag)
    {
        setTreeSelectedNode(nodeid);
    }
    
    logger.log("end setSelNodeAddFeatureView");
}

/**
 * 根据已经选中的树结点，加载对应的特性Tab页 去掉选中相同节点返回条件分支的原因是：告警板跳转时，节点相同但查询条件不同
 * 
 */
function setTreeSelectedNode(treeNodeID, condition)
{
        var deviceForm = g_global.getDeviceForm();
        var featureForm = g_global.getFeatureForm();
        var pnpForm = g_pnpForm;

        var isFeatureNode = true;
        var queryType = featureForm.guiType;
        var queryCondition = typeof (featureForm.condition) != "undefined" ? featureForm.condition : "";
        var fileName = "treeinfo:" + pnpForm.deviceType + "_" + pnpForm.deviceVersion + "_treeinfo";
        var groupMOtypeXpath = featureForm.groupXpath;
        var appearOnce = featureForm.isAppearOnce;        

        //只支持特性页面,不支持面板及定制URL页面
        var nodeType = "CONTENT";
        if (nodeType == "CONTENT")
        {
            var xpath = featureForm.xpath;
            jsonrpc.invoke("typeCustomJudgement", "setChoosedTreeNode", [xpath]);

            //添加feature视图
            pub_addFeatureViewWithCondition(featureForm.domain, treeNodeID, "", null, fileName,
                            isFeatureNode, queryType, queryCondition, groupMOtypeXpath, appearOnce, deviceForm.deviceVersion,
                            deviceForm.deviceType);            
    }
}

/**
 * Tab页切换事件处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2011-5-7
 * @param evt 事件对象
 * @return
 */
function onviewchanged(evt)
{
    if ("stencil" == evt.id)
    {
    	logger.log("switch template tab");
    	//E2E调用界面不处理这种事件
    	return;
    }
    else
    {
        g_featureTabViewCtrl.viewChange(evt);
    }
}

/**
 * 对外接口：供视图设置是否已经加载完毕
 * 
 * @author 蒋英茹 65716
 * @since iManager U2000 V1R3,2010-4-1
 * @param viewName ViewID
 * @return
 */
function pub_setSpecialViewIsLoad(viewName)
{
    g_ViewsManager.setSpecialViewIsLoad(viewName)
}

function pub_getFeatureTabViewCtrl()
{
    return g_featureTabViewCtrl;
}

/**
 * 操作记录信息
 * 
 * @param deviceIP 操作设备的唯一标识，目前只有一个设备，暂时不用，后面用的话再放开。
 * @param vrid 操作的VRID信息
 * @param vrName 操作的VR节点名称（即文本text）---这个是否需要？？要确认一下
 * @param operViewID 操作的视图ID（模板("stencil")/功能(工作区固定为"capability"，主窗体为"capability"+VRID)）
 * @param featureNodeID 特性节点ID（对应树节点信息）//nodeid
 * @param featureNodeText 特性名称（对应树节点ID）//nodeid
 */
function operRecord(vrid, vrName, operViewID, featureNodeID, featureNodeText)
{
    this.vrid = vrid;
    this.vrName = vrName;
    this.operViewID = operViewID;
    this.featureNodeID = featureNodeID;
    this.featureNodeText = featureNodeText;
}

/**
 * 处理设备功能树和配置区之间的交互
 * 
 * @param neType 特性所属域 LR VR
 * @param capabilityTreeNodeID 功能树节点ID
 * @param parentNodeTexts 特性节点的所属特性的父的节点名，直至根
 * @param capabilityTreeNodeText 功能树节点内容
 * @param nodeVersion 节点版本
 * @param isFeatureNode 是否特性节点
 * @param queryType 查询类型
 * @param condition 查询条件
 * @param groupMOtypeXpath 属性组xpath
 * @param appearOnce
 * @param deviceVersion 网元版本
 * @param deviceType 网元类型
 */
function pub_addFeatureViewWithCondition(neType, capabilityTreeNodeID, parentNodeTexts,
        capabilityTreeNodeText, nodeVersion, isFeatureNode, queryType,
        condition, groupMOtypeXpath, appearOnce, deviceVersion, deviceType)
{

    // logger.log("enter pub_addFeatureViewWithCondition");
	g_VRID = g_E2E_vrId;
    if (null == g_ViewsManager)
    {
        g_ViewsManager = new ViewsManager(viewManager);
    }

    curFeatureNodeID = capabilityTreeNodeID;
    
    var capabilityViewID = isWorkspace? Constants.FUNCTION_VIEWID : Constants.FUNCTION_VIEWID + g_VRID;
    if(null != toTabId && "" != toTabId)
    {
        g_featureTabViewCtrl.setToTabId(toTabId);
        toTabId = null;
    } 
    var title = null;
    if (null == capabilityTreeNodeID)
    {
        title = jse.getI18nValue(Constants.LOCALRESFILE_PATH,
                Constants.KEY_FOR_FEATURETITLE);
    }
    else
    {
        var nodeIDSplits = capabilityTreeNodeID.split("]");
        var nodeLength = nodeIDSplits.length;
        var xpath = nodeIDSplits[nodeLength - 1];
        title = ""; 
        if(null != parentNodeTexts)
        {
            for(var i = parentNodeTexts.length-1; i>=0; i--)
            {
                title = title + parentNodeTexts[i] + "-";
            }
        }
        title = title + Resource.getTreeInfoResource(xpath + "_d");
    }      
    
    var url = null;
    if (!isFeatureNode)
    {// 非特性节点加载空页面
        url = "";
        g_ViewsManager.loadSpecialView("blank", title, url);
    }
    else
    {
        var vrId = g_VRID;       
        //url = Constants.URL_MULTIFEATURE_HTML;
        url = CommonUtil.getRootPath() + "/vmt/ct/online/externalview/e2e/multifeature/multifeature.html";
        // 获取Tab页定制信息
        var customTabInfo = pub_functionExtInfo(capabilityTreeNodeID);
        if (customTabInfo == null)
        {
	        var nodeIDSplits = capabilityTreeNodeID.split("]");
	        var nodeLength = nodeIDSplits.length;
	        var featureName = nodeIDSplits[nodeLength - 2];
	
	        var xpath = nodeIDSplits[nodeLength - 1];
	        var featureForm = g_global.getFeatureForm();
	        featureForm.featureName = featureName;
	        featureForm.xpath = xpath;
	        featureForm.isWorkspace = isWorkspace;
	        featureForm.domain = neType;
	        featureForm.condition = condition;
	        featureForm.parentXpath = groupMOtypeXpath;
	        featureForm.isAppearOnce = appearOnce;
	        featureForm.featureNodeType = "OBJECT";
	        featureForm.funcnodeName = capabilityTreeNodeID;
	        featureForm.tabId = Constants.FEATURE_VIEWID;
	        //featureForm.chassis = pub_getDeviceWin().pub_getChassis();
	        //featureForm.slot = pub_getDeviceWin().pub_getSlot();
	        featureForm.card = null; 
	        
	        g_viewTabIds[g_tabNum++] = Constants.FEATURE_VIEWID;
	        
	        var deviceForm = g_global.getDeviceForm();
	        deviceForm.deviceType = deviceType;
	        deviceForm.deviceVersion = deviceVersion;
	        deviceForm.deviceIp = g_E2E_deviceIp;
	        //deviceForm.isSupportPartition = jse.topWin.g_IsSupportPartition;
	        deviceForm.pnpForm = pub_getClonePnpForm();
	        deviceForm.lrRole = g_E2E_lrRole;
	        
	        g_global.setDeviceForm(deviceForm);
	        g_featureTabViewCtrl.setCurrentTabId(Constants.FEATURE_VIEWID);
	        loadThirdView(title, url);
            
		    // 特性有常规tab页，需要显示
		    //viewManager.showView(Constants.NORMAL_VIEWID);
		
			isDevicePanel = false;
			
			// 将上次打开的第三段TAB页关闭
			clearTabPages();
			g_featureTabViewCtrl.removeAllTabs();
			g_featureTabViewCtrl.setLastFirstViewId(Constants.FEATURE_VIEWID);
		    if (isFeatureNode)
		    {
		        // 更新为当前操作的特性信息
		        Current_FeatureID_Info = new operRecord(g_VRID, g_VRName,
		                capabilityViewID, capabilityTreeNodeID, capabilityTreeNodeText);
            }
        }
        else
        {
            var featureForm = g_global.getFeatureForm();
            featureForm.isWorkspace = isWorkspace;
            featureForm.domain = neType;
            featureForm.featureNodeType = "OBJECT";
            featureForm.funcnodeName = capabilityTreeNodeID;            
            var deviceForm = g_global.getDeviceForm();
            deviceForm.deviceType = deviceType;
            deviceForm.deviceVersion = deviceVersion;
            deviceForm.deviceIp = g_E2E_deviceIp;
            //deviceForm.isSupportPartition = jse.topWin.g_IsSupportPartition;
            deviceForm.pnpForm = pub_getClonePnpForm();
            deviceForm.lrRole = g_E2E_lrRole;
            g_global.setDeviceForm(deviceForm);
            // 移除原有的Tab页
            g_featureTabViewCtrl.removeAllTabs();
            g_featureTabViewCtrl.setFuncnodeExtInfo(customTabInfo);
            var funcnodeTabList = customTabInfo.funcnodeTabList.list ;
            if(null == funcnodeTabList || funcnodeTabList.length == 0)
            {
                var xpath = nodeIDSplits[nodeLength - 1];
                var nodeIDSplits = capabilityTreeNodeID.split("]");
                var nodeLength = nodeIDSplits.length;                
                var featureName = nodeIDSplits[nodeLength - 2];
                
                featureForm.featureName = featureName;
                featureForm.xpath = xpath;
                featureForm.condition = condition;
                featureForm.parentXpath = groupMOtypeXpath;
                featureForm.isAppearOnce = appearOnce;
                
                var tabId = "vmt]" + xpath;
                featureForm.tabId = "vmt]" + xpath;
                
                g_viewTabIds[g_tabNum++]  = tabId;
                
                g_featureTabViewCtrl.setCurrentTabId(tabId);
                g_featureTabViewCtrl.setFirstViewId(tabId);
                g_featureTabViewCtrl.addTabType(tabId,"OBJECT");

                var title = Resource.getTabInfoResource(xpath);
                
                //url = Constants.URL_MULTIFEATURE_HTML;
                url = CommonUtil.getRootPath() + "/vmt/ct/online/externalview/e2e/multifeature/multifeature.html";
                
                var beforeViewId = g_featureTabViewCtrl.getBeforeViewId();
                g_featureTabViewCtrl.insertAfterView(beforeViewId,tabId,title,url);
                g_featureTabViewCtrl.setLastFirstViewId(tabId);
                // 隐藏Feature的Tab页
                viewManager.hideView(Constants.FEATURE_VIEWID);
                // 隐藏面板Tab页
                viewManager.hideView(Constants.PANEL_VIEWID);
                // 隐藏
                viewManager.hideView(Constants.CUSTOMURL_VIEWID);
                if(beforeViewId != Constants.FEATURE_VIEWID && beforeViewId != Constants.PANEL_VIEWID
                        && beforeViewId != Constants.CUSTOMURL_VIEWID)
                {
                    viewManager.hideView(beforeViewId);
                    viewManager.closeView(beforeViewId);
                }   
//              g_featureTabViewCtrl.addView(tabId, title, url);                                             
            }
            else if(funcnodeTabList.length > 0)
            {                
                //url = Constants.URL_MULTIFEATURE_HTML;
                url = CommonUtil.getRootPath() + "/vmt/ct/online/externalview/e2e/multifeature/multifeature.html";
                g_featureTabViewCtrl.initTabUrls(url);
                // 添加Tab页信息
                g_featureTabViewCtrl.setLastFirstViewId(g_featureTabViewCtrl.getBeforeViewId());
                g_featureTabViewCtrl.initTabData();  
                
                for(var tabIdNum in funcnodeTabList)
                {
                    g_viewTabIds[g_tabNum++] = funcnodeTabList[tabIdNum];                  
                }
            }            
        }        
    }

    // logger.log("exit pub_addFeatureViewWithCondition");
}

/**
 * 在页面切换时，将常规TAB页设置为空白页，将高级和孩子TAB页关闭
 */
function clearTabPages()
{
    // 点击功能树的节点时，将刚才的常规属性页设置为空白
    if (!viewManager.isHide(Constants.NORMAL_VIEWID))
    {
        var normalTitle = jse.getI18nValue("qat:public", "viewtitle.normal_d");
        viewManager.setViewTitle(Constants.NORMAL_VIEWID, normalTitle);
        viewManager.setViewURL(Constants.NORMAL_VIEWID, GlobalConstants.EMPTY_PAGE);
        viewManager.activateView(Constants.NORMAL_VIEWID);
    }
    if (tabIds != "")
    {
        var tabId = tabIds.split("@");
        for ( var i = 0; i < tabId.length; i++)
        {
            viewManager.closeView(tabId[i]);
        }
        tabIds = "";
    }
    if (isDevicePanel)
    {
        viewManager.hideView(Constants.NORMAL_VIEWID);
    }
}
/**
 * 当无任何选中节点时，加载空白Feature页面方法，切换VR时会主动调用
 * 
 */
function loadBlankFeatureView(ViewID)
{
    // //通知前进后退，特性Tab页变化
    // procFeatureTabChange(null, null, null, false);

    // 更新当前特性页是否为空白页标识
    Flag_CurrentFeatureView_IsBlankTab = true;

    var FeatureViewTitle = null;
    if (Constants.PROFILE_VIEWID == ViewID)
    {
        FeatureViewTitle = jse.getI18nValue(Constants.LOCALRESFILE_PATH,
                Constants.KEY_FOR_TEMPLETTITLE);
    }
    else
    {
        FeatureViewTitle = jse.getI18nValue(Constants.LOCALRESFILE_PATH,
                Constants.KEY_FOR_FEATURETITLE);
    }

    var reg = new RegExp("\\d+\.\\d+\.\\d+$");
    if (reg.test(CurrentVR_ID))
    {
        return;
    }
    loadFeatureView(FeatureViewTitle, "");
}

function loadFeatureView(TitleName, url)
{
    viewManager.setViewTitle(Constants.FEATURE_VIEWID, TitleName);
    viewManager.setViewURL(Constants.FEATURE_VIEWID, url);
    viewManager.activateView(Constants.FEATURE_VIEWID);
}

function loadThirdView(titleName, url)
{
    g_ViewsManager.loadSpecialView(Constants.FEATURE_VIEWID, titleName, url);
// g_ViewsManager.this._currentViewName = Constants.FEATURE_VIEWID;
}

var g_funcnodeExtInfoMap = null;
var pub_getFuncnodeExtInfoFlag = false;
function initFuncnodeExtInfo(operResult)
{
    if (null != operResult)
    {
        if(null != operResult.returnObj)
        {
            g_funcnodeExtInfoMap = operResult.returnObj.map;
        }
        else
        {
            g_funcnodeExtInfoMap = null;
        }
        pub_getFuncnodeExtInfoFlag = true;
    }
}

function pub_functionExtInfo(funcnodeName)
{
    if (!pub_getFuncnodeExtInfoFlag)
    {
        var operResult = jsonrpc.invoke("funcnodeExtInfoProcess", "getFuncnodeExtInfo",
                [ pub_getCurDeviceType(), pub_getCurDeviceVersion() ]);
        initFuncnodeExtInfo(operResult);
    }
    if(null == g_funcnodeExtInfoMap)
    {
        return null;
    }
    return g_funcnodeExtInfoMap[funcnodeName];
}

/*
function getFuncnodeExtInfo()
{
    jsonrpc.asynInvoke("funcnodeExtInfoProcess", "getFuncnodeExtInfo", [ this.pnpForm.deviceType, this.pnpForm.deviceVersion ],
            this.initFuncnodeExtInfo, this, []);
}
*/

/**
 * 获取支持包信息
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-11-11
 */
function pub_getClonePnpForm()
{
    return g_global.getDeviceForm().pnpForm.clone();
}


/**
 * 获取当前设备类型
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2011-5-26
 * @return
 */
function pub_getCurDeviceType()
{
    return g_global.getDeviceForm().pnpForm.deviceType;
}

/**
 * 获取当前设备版本
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2011-5-26
 * @return
 */
function pub_getCurDeviceVersion()
{
    return g_global.getDeviceForm().pnpForm.deviceVersion;
}

/**
 * 存放dialogId
 * 
 * @author x64338
 * @since iManager U2000 V2R1,2013-2-20
 * @param dialogId 
 */
function pushDialogId(dialogId)
{
	g_dialogIds.push(dialogId)
}
/**
 * 删除dialogId
 * 
 * @author x64338
 * @since iManager U2000 V2R1,2013-2-20 
 */
function popDialogId()
{
	g_dialogIds.pop();
}
/**
 * 获取父dialog的ID
 * 
 * @author x64338
 * @since iManager U2000 V2R1,2013-2-20
 * @param dialogId
 */
function getParentDialogId()
{
	var maxDialogNum = parseInt(pub_getSystemConfigDataMgr().getProperty("maxDialogNum"));
	if(g_dialogIds.length > 0 && g_dialogIds.length <= maxDialogNum)
	{
		return g_dialogIds[g_dialogIds.length-1];
	}
	return "";
}

/**
 * 弹出的对话框是否已经达到最大值
 * 最大值可以在system.ini中进行配置
 * 
 * @author x64338
 * @since iManager U2000 V2R1,2013-2-20
 * @param dialogId
 */
function isPopMaxdiaglogNUM()
{
	var maxDialogNum = parseInt(pub_getSystemConfigDataMgr().getProperty("maxDialogNum"))
	if(g_dialogIds.length >= maxDialogNum)
	{
        var message = Resource.getReplacedResource(maxDialogNum,"","label.dialognumber_d");
		CommonDlgReq.openAlertDialog(message, null, null);
		return true;
	}
	return false;
}

/**
 * 构造即将弹出dialogId，由于JSE的实现，有相同的dialogid存在，就不在弹出
 * 所有针对接口创建与keyref这种可以嵌套弹出对话框，需要代码构造dialogId
 * dialogID = parentdialogId + curdialogId
 * 
 * @author x64338
 * @since iManager U2000 V2R1,2013-2-20
 * @param dialogId
 */
function constructDialogId(dialogId)
{
	var parentDialogId = getParentDialogId();
	return parentDialogId + dialogId;
}

/**
 * 获取从界面上获取的返回值
 */
function pub_getReturnValues()
{
    var returnValues = ""; 
    
    //获取当前view中的Tab页信息
    for(i = 0;i < g_tabNum;i++)
    {
        var tabId =  g_viewTabIds[i];
        var viewObj = viewManager.getWindowById(tabId);
        if((null != viewObj) &&  typeof (viewObj.pub_getReturnValues) == "function")
        {
            returnValues = returnValues + viewObj.pub_getReturnValues();
        }
        
    }    
   return returnValues;
    
}

Event.observe(window, "load", init);