jse.require("jse.widget.dialog");
jse.require("jse.widget.menu");
jse.require("jse.widget.table");
jse.require("vmt.extend.table_prototype");


var signalMap =
{
    on_load_ui : doLoad,
    onClickToolButtonNew : doClickCreate,
    onClickToolButtonNewCollect : doClickCreateCollect,
    onClickToolButtonModify : doClickModify,
    onClickToolButtonDelete : doClickDelete,
    doClickQueryButton : doClickFilterButton,
    onClickToolButtonRefresh : doClickSynchronizeData,
    onClickToolButtonRefreshAll : doClickSynchronizeAllData,
    //doIntervalComboValueChanged : doIntervalComboSelChange,
    doConditionComboValueChanged : comboSelChange,
    onClickToolButtonClone : doClickClone,
    onClickToolButtonBatchNew : doClickBatchAddNum,
    //onClickToolButtonCustomColumn : doClickCustomColumn,
    onClickToolButtonSaveas : doClickSaveas,
    onClickUAHelp : doClickUAHelp
};

/**
 * 三段式页面载入类
 */
var g_featureLoader = null;

var g_E2E_returnNmsnames ;

/**
 * 初始化函数
 */
function init()
{
    logger.log("enter feature init()");
        
    // 通过JSON获取控件的Handler
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
	
	//获取Tab页定义中是否支持过滤功能
    var tabId = getCurrentTabId();
    var isSupportFilter = pub_getFeatureTabViewCtrl().isTabSupportFilterView(tabId);
    if(isSupportFilter)
    {
        window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/online/xui/e2e/multifeature.xui", signalMap);
    }   
    else
    {
        window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/configframe/xui/nofilterfeature.xui", signalMap);
    }
	    
    logger.log("exit feature init()");
}

/**
 * 用户载入页面
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return
 */
function doLoad()
{
    logger.log("enter e2e feature doLoad()");    
          
    g_featureLoader = new E2EMultiFeatureLoader();
    g_E2E_returnNmsnames = jse.topWin.g_E2E_returnNmsnames;
    var urlArray = [];
    urlArray[RefDlgUrlType.KEYREF] = CommonUtil.getRootPath() + "/vmt/ct/online/view/keyref/keyref.html";
    urlArray[RefDlgUrlType.KEY] = CommonUtil.getRootPath() + "/vmt/ct/common/dialog/keydialog/keydialog.html";
    urlArray[RefDlgUrlType.PASSWORD] = CommonUtil.getRootPath() + "/vmt/ct/common/dialog/passworddialog/passworddialog.html";

    // ref关系选择控制类
    var refSelectControler = new RefSelectControler(new KeyrefViewController(), null, new KeyPasswordViewCtrl(),
            new PasswordViewCtrl(), new AttrCustomInfoCtrl());

    g_featureLoader.doLoad(urlArray, refSelectControler);
    
    getFeatureLoader().getDataCtrl().setXpathMappingInfo(jse.topWin.g_xpathMappingOperobjInfo);
    
    pub_refreshLocalView();
    
    //TODO
    if((null != jse.topWin.g_E2E_filterCondition) && ("null" != jse.topWin.g_E2E_filterCondition) && ("" != jse.topWin.g_E2E_filterCondition))
    {
        getFeatureLoader().filterTableData("FEATURE", jse.topWin.g_filterCondition.list[0], "true");
    }
    else
    {
        doClickSynchronizeAllData();
    }
    
}

/**
 * 刷新特性界面
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 * @return
 */
function pub_refreshLocalView()
{
    getFeatureLoader().refreshFeatureView();
    //TimeOperation.doObjSetTimeout(this, this.doClickSynchronizeAllData, [], 300);
}


/**
 * 跳转到指定页
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return
 */
function doNavigate(evt)
{
    getFeatureLoader().doNavigate(evt);
}

/**
 * 排序
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function doSort(colId, sortType)
{
    getFeatureLoader().doSort(colId, sortType);
}

/**
 * 用户双击一条记录时触发修改操作
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 * @return
 */
function doDBClick()
{
    logger.log("start doDBClick");
    getFeatureLoader().doDBClick();
}

/**
 * 用户点击修改按钮
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function doClickModify()
{
    logger.log("start doClickModify");
    //getFeatureLoader().doClickModify();
    pub_getDataController().directModifyRecordes();
}

/**
 * 用户创建修改预览界面
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 * @return
 */
function pub_createBatchModifyPreview(batchModifyNodeContent)
{
    getFeatureLoader().createBathModifyPreviewDialog(batchModifyNodeContent);
}

/**
 * 拷贝新建
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-5-19
 */
function doClickClone()
{
    logger.log("start doClickClone");
    getFeatureLoader().doClickClone();
}

/**
 * 批量新建
 */
function doClickBatchAddOper()
{
    var keyType = pub_getDataController().getKeyType();
    if (keyType == BatchAddCustom.KEYTYPE_BATCHNUM)
    {
        doClickBatchAddNum();
    }
    else if (keyType == BatchAddCustom.KEYTYPE_KEYREF)
    {
        doClickBatchAddCustomView();
    }
    else if (keyType == BatchAddCustom.KEYTYPE_INTEGER)
    {
        doClickBatchAddCustomView();
    }
}

/**
 * 批量新建
 */
function doClickBatchAddCustomView()
{
    getFeatureLoader().doClickBatchAddCustomView();
}

/**
 * 批量新建条数
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-5-19
 */
function doClickBatchAddNum()
{
    getFeatureLoader().doClickBatchAddNum();
}

/**
 * 根据条数进行批量新建
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-5-19
 * @param batchAddNum 批量新建条数
 */
function doClickBatchAdd(batchAddNum)
{
    getFeatureLoader().doClickBatchAdd(batchAddNum);
}


/**
 * 列定制
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-5-19
 * @return
 */
function doClickCustomColumn()
{
    getFeatureLoader().doClickCustomColumn();
}

/**
 * 另存为
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-5-19
 * @return
 */
function doClickSaveas()
{
//   var value = pub_getReturnValues();
    getFeatureLoader().doClickSaveas();
}
/**
 * 为部分配置较复杂的特性（如ISIS等）提供帮助按钮，显示配置帮助信息
 * 
 * @author z00139319
 * @since iManager U2000 V1R3,2010-9-16
 * @return
 */
function doClickUAHelp()
{
    getFeatureLoader().doClickUAHelp();
}

/**
 * action操作
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-6-28
 * @return
 */
function doClickAction(evt)
{
    getFeatureLoader().doClickAction(evt);
}


/**
 * 用户点击新建按钮
 * 
 * @author ywx159756
 * @since iManager U2000 V2R1, 2013-8-27
 */
function doClickCreateCollect(evt)
{
	var deviceType = jse.topWin.pub_getPubData().getDeviceForm().deviceType;
	if(deviceType.indexOf("PTN") >= 0 || deviceType.indexOf("ptn") >= 0){
		doClickCreate();
	}else
	{
		logger.log("start doClickCreateCollect");
	    getFeatureLoader().doClickCreateCollect(evt);
	}
    
}

/**
 * 用户点击新建按钮
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 * @return
 */
function doClickCreate()
{
    logger.log("start doClickCreate");
    getFeatureLoader().doClickCreate();
}

/**
 * 用户点击删除按钮
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function doClickDelete()
{
    getFeatureLoader().doClickDelete();
}


/**
 * 用户点击同步按钮
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function doClickSynchronizeData()
{
    getFeatureLoader().doClickSynchronizeData();
}

/**
 * 用户点击同步所有按钮
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function doClickSynchronizeAllData()
{
    getFeatureLoader().doClickSynchronizeAllData();
}

/**
 * 用户点击过滤按钮
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function doClickFilterButton()
{
    logger.log("start doClickFilterButton");
    getFeatureLoader().doClickFilterButton();
}


/**
 * 打开默认过滤界面
 */
function doClickNormalFilter()
{
    getFeatureLoader().doClickNormalFilter();
}

/**
 * 打开Method过滤界面
 * @param evt
 */
function doClickMethodFilter(evt)
{
    getFeatureLoader().doClickMethodFilter(evt);
}

/**
 * 用户触发过滤条件下拉框变化
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function comboSelChange(evt)
{
    getFeatureLoader().comboSelChange(evt);
}


/**
 * 用户选择自动刷新时间.<br>
 * 
 * @author w00138446
 * @since iManager U2000 V1R3,2010-4-6
 * @param evt JSE事件标识
 */
function doIntervalComboSelChange(evt)
{
    getFeatureLoader().doIntervalComboSelChange(evt);
}

/**
 * 弹出右键菜单
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function popupContextMenu(evt)
{
    getFeatureLoader().popupContextMenu(evt);
}

/**
 * 第三段Tab切换的触发事件
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function doViewChanged(evt)
{
    getFeatureLoader().doViewChanged(evt);
}

/**
 * 用户切换table行
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function doTableSelChange(evt)
{
    getFeatureLoader().doTableSelChange(evt);
}


function doClickForTable(evt)
{
    getFeatureLoader().doClickForTable(evt);
}

function doDblClickTable(evt)
{
    getFeatureLoader().doDblClickTable(evt);
}

/**
 * 右键菜单中的method操作
 * 
 * @param evt
 */
function doClickMethod(evt)
{
    getFeatureLoader().doClickMethod(evt);
}

/**
 * url操作
 * 
 * @author x00211048
 * @since iManager U2000 V2R1,2013-4-28
 * @return
 */
function doClickCustomUrl(evt)
{
    getFeatureLoader().doClickCustomUrl(evt);
}

/**
 * 获取三段式第一段的控制类
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return 全局信息
 */
function pub_getDataController()
{
    return getFeatureLoader().getDataCtrl();
}

/**
 * 获取三段式第三段的控制类
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return 全局信息
 */
function pub_getDetailController()
{
    return getFeatureLoader().getDetailCtrl();
}

/**
 * 获取全局信息
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return 全局信息
 */
function pub_getFeaturePubData()
{
    return getFeatureLoader().getFeatureData();
}

/**
 * 获取过滤控制类
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return 全局信息
 */
function pub_getFilterCtrl()
{
    return getFeatureLoader().getFilterCtrl();
}

/**
 * 获取联动控制类
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return 全局信息
 */
function pub_getLinkageCtrl()
{
    return getFeatureLoader().getLinkageCtrl();
}


/**
 * 获取全局公共方法
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 * @return 全局信息
 */
function pub_getBatchAddNum()
{
    return getFeatureLoader().getBatchNum();
}

/**
 * 获取批量修改界面的节点信息
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 * @return 批量修改界面的节点信息
 */
function pub_getBatchModifyNodeContent()
{
    return getFeatureLoader().getBatchModifyNodeContent();
}

/**
 * 获取全局公共方法
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return 全局信息
 */
function pub_getResource()
{
    return getFeatureLoader().getResource();
}

/**
 * 获取三段式展现类对象
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return 三段式展现类对象
 */
function getFeatureLoader()
{
    if(null != g_featureLoader)
    {
        return g_featureLoader;
    }
    
    g_featureLoader = new E2EMultiFeatureLoader();
    
    var urlArray = [];
    urlArray[RefDlgUrlType.KEYREF] = CommonUtil.getRootPath() + "/vmt/ct/online/view/keyref/keyref.html";
    urlArray[RefDlgUrlType.KEY] = CommonUtil.getRootPath() + "/vmt/ct/common/dialog/keydialog/keydialog.html";
    urlArray[RefDlgUrlType.PASSWORD] = CommonUtil.getRootPath() + "/vmt/ct/common/dialog/passworddialog/passworddialog.html";

    // ref关系选择控制类
    var refSelectControler = new RefSelectControler(new KeyrefViewController(), null, new KeyPasswordViewCtrl(),
            new PasswordViewCtrl(), new AttrCustomInfoCtrl());

    g_featureLoader.doLoad(urlArray, refSelectControler);
    
    getFeatureLoader().getDataCtrl().setXpathMappingInfo(g_xpathMappingOperobjInfo);
    
    return g_featureLoader; 
}

/**
 * 获取子详细信息控制类.<br>
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return 子详细信息控制类
 */
function pub_getDetailController()
{
    return pub_getDataController().getDetailCtrl(); 
}

/**
 * 添加列筛选条件
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @param evt
 */
function doAddColumnFilterCondition(evt)
{
    getFeatureLoader().doAddColumnFilterCondition(evt);
}

/**
 * 根据筛选条件进行数据筛选
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @param evt
 */
function doFilter(evt)
{
    getFeatureLoader().doFilter(evt);
}

/**
 * 值变化事件处理
 * 
 * @param evt
 */
function onValueChanged(evt)
{
    pub_getDataController().valueChangeExtend(evt);
}

/**
 * 值变化事件处理
 * 
 * @param evt
 */
function onValuechanging(evt)
{
    pub_getDataController().valuechanging(evt);
}

/**
 * 单击keyref按钮的事件处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-7
 */
function doKeyRefClick(evt)
{
    pub_getDataController().doKeyRefClick(evt);
}

/**
 * 单击定制属性列按钮的事件处理
 * 
 * @author x00211048
 * @since iManager U2000 V2R1,2013-5-16
 */
function doCustomAttrClick(evt)
{
    pub_getDataController().doCustomAttrClick(evt);
}

/**
 * 用户在keyref输入框中输入值，进行联想
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-7
 */
function doKeyRefFilter(evt)
{
    pub_getDataController().doKeyRefFilter(evt);
}

/**
 * 用户在keyref输入框中输入值后，联想控件的select关闭后触发
 * 
 * @param evt
 */
function doKeyRefCloseUp(evt)
{
    pub_getDataController().doKeyRefCloseUp(evt);
}

/**
 * 获取当前选中结点的tooltip信息
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-4-1
 */
function pub_getCurNodeTooltip()
{
    return pub_getDataController().getCurNodeTooltip();
}

/**
 * 弹出设置密码对话框
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function doKeyPasswordClick(evt)
{
    pub_getDataController().doKeyPasswordClick(evt);
}

/**
 * 弹出设置密码对话框
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function doPasswordClick(evt)
{
    pub_getDataController().doPasswordClick(evt);
}

/**
 * 获取密码类型字段属性定义的最小长度
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function pub_getCurPwdMinLength()
{
    return pub_getDataController().getPwdCellMinLength();
}

/**
 * 获取密码类型字段属性定义的最大长度
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function pub_getCurPwdMaxLength()
{
    return pub_getDataController().getPwdCellMaxLength();
}

/**
 * 获取密码类型字段属性定义的不支持的正则表达式
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function pub_getUnsupportedPwdSet()
{
    return pub_getDataController().getPwdCellPattern();
}

/**
 * 获取密码类型字段属性定义的支持的正则表达式
 * 
 * @returns
 */
function pub_getSupportedPwdSet()
{
    return null;
}

/**
 * 设置密码类型字段属性的值
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2012-3-17
 */
function pub_setPasswordValue(password)
{
    pub_getDataController().setPasswordValue(password);
}

function pub_getConfigCtrl()
{
    return pub_getDataController();
}

/**
 * 单击bitMask按钮的事件处理
 * 
 * @author z00133566
 * @since iManager U2000 V1R5,2010-12-28
 */
function doBitMaskClick(evt)
{
    pub_getDataController().doBitMaskClick(evt);
}

/**
 * 用户右键设置combo类型值
 * 
 * @author x64338
 * @since iManager U2000 V2R1,2013-1-8
 */
function doSetComboValue(evt)
{
    pub_getDataController().doSetComboValue(evt);
}

/**
 * 用户右键设置值
 * 
 * @author x64338
 * @since iManager U2000 V2R1,2013-1-9
 */
function doBatchModifyValue(evt)
{
    pub_getDataController().doBatchModifyValue(evt);
}

function getBatchModifyObj()
{
    return pub_getDataController().getBatchModifyObj();
}


/**
 * 获取当前Tab页的ID
 * 
 * @returns
 */
function getCurrentTabId()
{
    // 通过页面对象来获取ID，由于快速切换时可能此时已经切换到其它tab页，因而不使用原来的getCurrentTabId来获取
    var tabId = window.parent.pub_getFeatureTabViewCtrl().getTabIdByWin(this);
    return tabId;
}

/**
 * 获取FeatureTabViewCtrl对象
 * @returns
 */
function pub_getFeatureTabViewCtrl()
{
    return window.parent.pub_getFeatureTabViewCtrl();
}

/**
 * 执行进度条下发操作
 * 
 * @return
 */
function pub_doProgressOperation()
{
    pub_getDataController().doSendConfigForProgress();
}

/**
 * 进度条取消事件处理
 * @returns
 */
function pub_doProgressDlgCancleButton()
{
    pub_getDataController().doProgressDlgCancleButton();
}

/**
 * 定义超链接响应事件
 * 
 * @author x64338
 * @since iManager U2000 V2R1,2013-3-13
 */
function showDeitialDialog(evt)
{
    var table = pub_getDataController().getTable();
    var cell = table.getFocusCell();
    var value = table.getCellValue(cell.rowId, cell.colId);

    if (!value)
    {
        return;
    }

    var attrXpath = ConfigUtil.transferColumnIdToXpath(cell.colId);

    // TODO 定义一个全局变量
    clickObj =
    {
        attrXpath : attrXpath,
        value : value,
        rowID : cell.rowId,
        colID : cell.colId
    };
        
    jse.require("jse.widget.dialog");
    var title = jse.getI18nValue("qat:public", "popupmenu.viewdetail_d");
    var widgetDialog = new jse.widget.dialog.Dialog("detail", title);
    widgetDialog.setURL(CommonUtil.getRootPath() + "/vmt/ct/online/view/keyrefdetail/keyrefdetail.html");
    widgetDialog.setPreferSize(800, 600);
    widgetDialog.setTitleImage(CommonUtil.getRootPath() + "/vmt/image/imapclient_nw.gif");
    widgetDialog.setDefaultCloseOperation(jse.DISPOSE_ON_CLOSE);

    widgetDialog.show();
}

/**
 * 获取定制页面的属性值
 */
function pub_setAttrCustomValue(value)
{
    pub_getDataController()._refSelectControler.getAttrCustomViewCtrl().setAttrCustomValue(value);
}

/**
 *获取定制页面的属性值
 */
function pub_getAttrCustomValue()
{
    return pub_getDataController()._refSelectControler.getAttrCustomViewCtrl().getAttrCustomValue();
}

/**
 * 获取全局信息
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 * @return 全局信息
 */
function pub_getFeaturePubData()
{
    return getFeatureLoader().getFeatureData();
}

/**
 * 获取E2E需要的返回值
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-31
 * @returns
 */
function pub_getReturnValues()
{
   return getFeatureLoader().getDataCtrl().getReturnNmsnameValues();
}

Event.observe(window, "load", init);