/**
 * 封装实例表界面中Toolbar内所有按钮
 * 
 * @author w00131173
 * @since iManager U2000 V1R6,2011-5-12
 */
function E2EToolbar()
{
    ToolBar.call(this);

}

E2EToolbar.prototype = new ToolBar();

/**
 * 设置菜单项
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-5-17
 * @param init 可用的默认值
 * @param visible 设置按钮可见性的值
 * @param widget 控件
 */
E2EToolbar.prototype._setVisible = function(init, visible, widget)
{
    if (widget != null)
    {
        if (init == BtnViewValue.MODIFY)
        {
            // 修改按钮隐藏后，拷贝新建按钮因为修改按钮导致前部分不好用的问题，由于按钮容器没有隐藏导致的问题
            var toolbarPane = document.getElementById("ToolbarPane_toolbar_4");
            if ((null != toolbarPane) && ((init & visible) == 0))
            {
                toolbarPane.style.display = "none";
            }
            else
            {
                toolbarPane.style.display = "";
            }

        }
        if ((init & visible) == 0)
        {
            widget.setVisible(false);
        }
        else if ((init & visible) == init)
        {
            widget.setVisible(true);
        }
    }
}