/**
 * E2E调用的新建配置页面的初始化类
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
function E2EFeatureLoader()
{
    OnLineFeatureLoader.call(this);

}

E2EFeatureLoader.prototype = new OnLineFeatureLoader();

/**
 * 载入三段式更新数据
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 * @param table 第二段表格
 */
E2EFeatureLoader.prototype.doLoad = function()
{
    this._initDataTable();
    this._initPagedCtrl();
    this._initStautsCtrl();
    this._initDataCtrl();

    this._setUrlAndinitDetail();

    this._initColFilterCtrl();

    this._dataController.setColFilterCtrl(this._colFilterCtrl);

}

/**
 * 初始化表格事件
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 * @param table 第二段表格
 */
E2EFeatureLoader.prototype._initTableHander = function(table)
{
    table.onselchanged = doTableSelChange;
    table.onsort = doSort;
    // table.ondblclick = doDBClick;
    table.oncontextmenu = popupContextMenu;
    table.setAllColSortable(true);
}

/**
 * 初始化表格事件
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 * @param table 第二段表格
 */
E2EFeatureLoader.prototype._initDataTable = function()
{
    var table = window.xui.getWidget("DataTable");
    this._initTableHander(table);

    // 从父窗口中获取公共变量
    this._featureData = pub_getPubData();

    this._resource = new FeaturesResourceMgr();

    // 初始化表格和表格模型，用于构造第二段控制模型
    this._tableModel = new TableModel(this._resource, table);
    this._vmtTable = new DataTable(table, this._tableModel, this._resource);
}

/**
 * 初始化第一段控制类
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
E2EFeatureLoader.prototype._initStautsCtrl = function()
{
    var deviceForm = this._featureData.getDeviceForm();
    var featureForm = this._featureData.getFeatureForm();
    var frameParam = this._featureData.getFrameParam();

    // 初始化第一段控制模型
    this._perAuthority = new ConfigPreAuthority(deviceForm.deviceIp);
    this._perAuthority.init();
    var toolbar = new E2EToolbar();
    var toolbarCtrl = new ToolbarController(toolbar, this._vmtTable, this._perAuthority);

    var menu = new E2EConfigMenu(this._resource);
    var menuCtrl = new E2EMenuController(menu, this._vmtTable, this._perAuthority);
    this._statusController = new StatusController(toolbarCtrl, menuCtrl, this._perAuthority);
}

/**
 * 初始化自动刷新控制类
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
E2EFeatureLoader.prototype._initRenovatorCtrl = function()
{
}

/**
 * 刷新可变控件的数据和界面
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
E2EFeatureLoader.prototype.refreshLocalView = function()
{
    this._dataController.stopQueryData();
    
    // 初始化联动信息，防止有冗余数据
    this._initLinkageCtrl();

    // 清除原有信息并设置新的信息
    this._detailController.updateDetail();

    this._dataController.updateTable("FEATURE");
}

/**
 * 初始化第二段控制类
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
E2EFeatureLoader.prototype._initDataCtrl = function()
{
    var comboObject = window.xui.getWidget("featureConditonComboID");
    this._filterCtrl = new FilterController(this._vmtTable, comboObject, this._resource);

    var deviceForm = this._featureData.getDeviceForm();
    var featureForm = this._featureData.getFeatureForm();
    var frameParam = this._featureData.getFrameParam();
    var nodeInfo = this._featureData.getNodeInfo();
    this._dataController = new E2EDataController(this._vmtTable, this._tableModel, this._resource, featureForm,
            frameParam, nodeInfo, deviceForm, this._pagedController, this._filterCtrl, this._statusController);

    // 第二段在线需要预查询一次配置页面，解决性能问题
    this._dataController.setIsNeedPreLoadCreatePageInfo(true);
}

/**
 * 更新表格数据
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
E2EFeatureLoader.prototype.updateTableAndStatus = function(dataModel)
{
    logger.log("start datactrl updateTableAndStatus");
    // 更新表格
    this._dataTable.updateDataTable(dataModel);
    logger.log("end datactrl updateTableAndStatus");

    this._setFilterCtrlConditionsAndValue(dataModel.historyConditons);
    logger.log("end datactrl _setFilterCtrlConditionsAndValue");

}

/**
 * 初始化第三段控制类
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
E2EFeatureLoader.prototype._setUrlAndinitDetail = function()
{
    var normalUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/detail/normal.html";
    var advanceUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/detail/advance.html";
    var childUrl = CommonUtil.getRootPath() + "/vmt/ct/online/externalview/e2e/feature/child/child.html";
    var groupUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/detail/group.html";

    this._initDetailCtrl(normalUrl, advanceUrl, childUrl, groupUrl);
}

/**
 * 按条件过滤
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
E2EFeatureLoader.prototype.filterTableData = function(viewType, filterCondition, isFilterView)
{
    var nodeList = [];
    nodeList.push(filterCondition);
    nodeList = JsonUtil.changJsonListP(nodeList);
    this._dataController.filterTableData(viewType, nodeList, isFilterView);
}