jse.require("jse.widget.dialog");
jse.require("jse.widget.menu");
jse.require("jse.widget.table");
jse.require("vmt.extend.table_prototype");

/* 全局RPC代理对象 */
var g_jsonrpc = ("undefined" == typeof(jsonrpc) || null == jsonrpc) ? new VmtJsonRPC() : jsonrpc;

var g_global = null;

var g_verifyInfo = null;

var g_xpathMappingOperobjInfo = null;

/**
 * 硬件规格差异数据缓存管理对象
 */
var g_HardSpecDiffDataCacheMgr = new DataCacheMgr();

/**
 * 全局配置选项数据管理对象
 */
var g_SystemConfigDataMgr = new SystemConfigDataMgr();

/**
 * 支持包信息
 */
var g_pnpForm = null;

/**
 * 转换后的过滤条件
 */
var g_filterCondition = null;

var g_E2E_iniFocus = false;

var signalMap =
{
    on_load_ui :doLoad,
    onClickToolButtonNew :doClickCreate,
    onClickToolButtonModify :doClickModify,
    onClickToolButtonDelete :doClickDelete,
    doClickQueryButton :doClickFilterButton,
    onClickToolButtonRefresh :doClickSynchronizeData,
    onClickToolButtonRefreshAll :doClickSynchronizeAllData,
    onClickToolButtonCustomColumn :doClickCustomColumn,
    doConditionComboValueChanged :comboSelChange
};

/**
 * 三段式页面载入类
 */
var g_featureLoader = null;

/**
 * 初始化函数
 */
function init()
{
    logger.log("enter feature init()");
    
    //设置语言
    jse.setLanguage(g_E2E_lang);
    
    // 通过JSON获取控件的Handler
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/online/xui/e2e/feature.xui", signalMap);
    
    logger.log("exit feature init()");
}

/**
 * 用户载入页面
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return
 */
function doLoad()
{
    logger.log("enter feature doLoad()");
    
    // 初始化全局配置参数，3s后起个线程初始化，以免后续使用时消耗时间
    setTimeout("initSystemConfigDataMgr()", 3000);
    initGlobalData();
    
   
    
    g_featureLoader = new E2EFeatureLoader();
    g_featureLoader.doLoad(); 
    getFeatureLoader().getDataCtrl().setXpathMappingInfo(g_xpathMappingOperobjInfo);
    pub_refreshLocalView();
    
    if((null != g_E2E_filterCondition) && ("null" != g_E2E_filterCondition) && ("" != g_E2E_filterCondition))
    {
        getFeatureLoader().filterTableData("FEATURE", g_filterCondition, "true");
    }
    else
    {
        doClickSynchronizeAllData();
    }
    
}

/**
 * 刷新特性界面
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return
 */
function pub_refreshLocalView()
{
    getFeatureLoader().refreshFeatureView();
}
/**
 * 获取全局参数
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function pub_getPubData()
{
    return g_global;
}

/**
 * 获取全局信息
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 * @return 全局信息
 */
function pub_getFeaturePubData()
{
    return getFeatureLoader().getFeatureData();
}

/**
 * 初始化全局参数
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
function initGlobalData()
{
   // 从后台获取初始化参数需要的信息:该特性操作对象的对应的所有的Xpath，全局属性需要的参数，
    var featureForm = new FeatureForm();
    featureForm.featureName = g_E2E_featureName;
    featureForm.isWorkspace = "false";
    featureForm.domain = g_E2E_domain;
    featureForm.condition = g_E2E_filterCondition;
    featureForm.guiType = "QUERY";

    var deviceForm = new DeviceForm();
    deviceForm.deviceType = g_E2E_deviceType;
    deviceForm.deviceVersion = g_E2E_deviceVersion;
    deviceForm.deviceIp = g_E2E_deviceIp;
    deviceForm.vrId = g_E2E_vrId;
    deviceForm.devId = g_E2E_devId;
    deviceForm.lrRole = g_E2E_lrRole;
    deviceForm.type = g_E2E_type;
    deviceForm.pnpForm.deviceType = g_E2E_deviceType;
    deviceForm.pnpForm.deviceVersion = g_E2E_deviceVersion;
    
    var keyInfoMap = new Map();
    var keyInfos = g_E2E_filterCondition.split("@nmsname_value@");
    for ( var num = 0; num < keyInfos.length; num+=2)
    {
        var nmsname = keyInfos[num];
        var value = keyInfos[num + 1];
        if(nmsname != null && nmsname != "")
        {
            keyInfoMap.put(nmsname,value);
        }       
    }
    
    // 从后台获取全局参数
  var operResult = jsonrpc.invoke("e2eGlobalParamProcess", "getGlobalParam", [ deviceForm.changJsonForm(), featureForm.changJsonForm(),g_E2E_operObjNmsname,JsonUtil.changeJsonMap(keyInfoMap)]);    
  if (null == operResult)
  {
      return;
  }
  
  if(GlobalConstants.OPER_OK == operResult.resultType)
  {
      var globalFeatureForm = operResult.returnObj.featureForm;
      var globalDeviceForm = operResult.returnObj.deviceForm;
      g_xpathMappingOperobjInfo = operResult.returnObj.xpathMappingOperobjInfo;      
      g_filterCondition = operResult.returnObj.nodeKeyMap;
      
      var newDeviceForm = new DeviceForm();
      newDeviceForm.deviceType = globalDeviceForm.deviceType;
      newDeviceForm.deviceVersion = globalDeviceForm.deviceVersion;
      newDeviceForm.deviceIp = globalDeviceForm.deviceIp;
      newDeviceForm.vrId = globalDeviceForm.vrId;
      newDeviceForm.devId = globalDeviceForm.devId;
      newDeviceForm.lrRole = globalDeviceForm.lrRole;
      newDeviceForm.isSupportPartition = globalDeviceForm.isSupportPartition;
      newDeviceForm.type = globalDeviceForm.type;
      
      var pnpForm = new PnpForm();
      pnpForm.deviceType = globalDeviceForm.pnpForm.deviceType;
      pnpForm.deviceVersion = globalDeviceForm.pnpForm.deviceVersion;
      pnpForm.compatible = globalDeviceForm.pnpForm.compatible;

      newDeviceForm.pnpForm = pnpForm;
      g_pnpForm = pnpForm;
      
      var newFeatureForm = new FeatureForm();
      newFeatureForm.featureName = globalFeatureForm.featureName;
      newFeatureForm.xpath = globalFeatureForm.xpath;
      newFeatureForm.isWorkspace = globalFeatureForm.isWorkspace;
      newFeatureForm.domain = globalFeatureForm.domain;
      newFeatureForm.guiType = globalFeatureForm.guiType;
      newFeatureForm.condition = globalFeatureForm.condition;
      newFeatureForm.parentXpath = globalFeatureForm.parentXpath;
      newFeatureForm.isAppearOnce = globalFeatureForm.isAppearOnce;

      var global = new GlobalData();
      global.setDeviceForm(newDeviceForm);
      global.setFeatureForm(newFeatureForm);
      var frameParam = new FrameParam();
      global.setFrameParam(frameParam);
      g_global = global;
      
      jsonrpc.invoke("typeCustomJudgement", "setChoosedTreeNode", [globalFeatureForm.xpath]);
  }
  else
  {
      CommonDlgReq.openRspErrorDialog(operResult, null, null);
  }

}

/**
 * 跳转到指定页
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return
 */
function doNavigate(evt)
{
    getFeatureLoader().doNavigate(evt);
}

/**
 * 排序
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function doSort(colId, sortType)
{
    getFeatureLoader().doSort(colId, sortType);
}

/**
 * 用户点击修改按钮
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function doClickModify()
{
    logger.log("start doClickModify");
    getFeatureLoader().doClickModify();
}

/**
 * 用户点击新建按钮
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function doClickCreate()
{
    logger.log("start doClickCreate");
    getFeatureLoader().doClickCreate();
}

/**
 * 用户点击删除按钮
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function doClickDelete()
{
    getFeatureLoader().doClickDelete();
}

/**
 * 列定制
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2010-5-19
 * @return
 */
function doClickCustomColumn()
{
    getFeatureLoader().doClickCustomColumn();
}

/**
 * 用户点击同步按钮
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function doClickSynchronizeData()
{
    getFeatureLoader().doClickSynchronizeData();
}

/**
 * 用户点击同步所有按钮
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function doClickSynchronizeAllData()
{
    getFeatureLoader().doClickSynchronizeAllData();
}

/**
 * 用户点击过滤按钮
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function doClickFilterButton()
{
    logger.log("start doClickFilterButton");
    getFeatureLoader().doClickFilterButton();
}

/**
 * 用户触发过滤条件下拉框变化
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function comboSelChange(evt)
{
    getFeatureLoader().comboSelChange(evt);
}


/**
 * 弹出右键菜单
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function popupContextMenu(evt)
{
    getFeatureLoader().popupContextMenu(evt);
}

/**
 * 第三段Tab切换的触发事件
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function doViewChanged(evt)
{
    getFeatureLoader().doViewChanged(evt);
}

/**
 * 用户切换table行
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function doTableSelChange(evt)
{
    getFeatureLoader().doTableSelChange(evt);
}

/**
 * 获取三段式第一段的控制类
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return 全局信息
 */
function pub_getDataController()
{
    return getFeatureLoader().getDataCtrl();
}

/**
 * 获取三段式第三段的控制类
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return 全局信息
 */
function pub_getDetailController()
{
    return getFeatureLoader().getDetailCtrl();
}

/**
 * 获取全局信息
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return 全局信息
 */
function pub_getFeaturePubData()
{
    return getFeatureLoader().getFeatureData();
}

/**
 * 获取联动控制类
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return 全局信息
 */
function pub_getFilterCtrl()
{
    return getFeatureLoader().getFilterCtrl();
}

/**
 * 获取联动控制类
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return 全局信息
 */
function pub_getLinkageCtrl()
{
    return getFeatureLoader().getLinkageCtrl();
}


/**
 * 获取全局公共方法
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return 全局信息
 */
function pub_getResource()
{
    return getFeatureLoader().getResource();
}

/**
 * 获取三段式展现类对象
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return 三段式展现类对象
 */
function getFeatureLoader()
{
    if(null != g_featureLoader)
    {
        return g_featureLoader;
    }
    
    g_featureLoader = new E2EFeatureLoader();
    g_featureLoader.doLoad();
    
    return g_featureLoader; 
}

/**
 * 获取子详细信息控制类.<br>
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return 子详细信息控制类
 */
function pub_getDetailController()
{
    return pub_getDataController().getDetailCtrl(); 
}

/**
 * 添加列筛选条件
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @param evt
 */
function doAddColumnFilterCondition(evt)
{
    getFeatureLoader().doAddColumnFilterCondition(evt);
}

/**
 * 根据筛选条件进行数据筛选
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @param evt
 */
function doFilter(evt)
{
    getFeatureLoader().doFilter(evt);
}

/**
 * 获取E2E需要的返回值
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-31
 * @returns
 */
function pub_getReturnValues()
{
   return getFeatureLoader().getDataCtrl().getReturnNmsnameValues();
}

/**
 * 获取需要的校验信息值
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-31
 * @returns
 */
function pub_getVerification()
{
    var deviceForm = g_global.getDeviceForm();
    var featureForm = g_global.getFeatureForm();
    var frameParam = g_global.getFrameParam();

    var operResult = jsonrpc.invokeWithoutMask("dataTableFactory", "getFeatureVerificationInfo", [
            deviceForm.changJsonForm(), featureForm.changJsonForm(), frameParam ]);
    if (null == operResult)
    {
        return;
    }

    if (null != operResult)
    {
        var verifications = new Verifications();
        verifications.init(operResult.list);
        g_verifyInfo = verifications;
    }

    return g_verifyInfo;
}

/**
 * 获取硬件规格差异
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @returns {DataCacheMgr}
 */
function pub_getHardSpecDiffDataCacheMgr()
{
    return g_HardSpecDiffDataCacheMgr;
}

/**
 * 初始化全局配置数据
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function initSystemConfigDataMgr()
{
    g_SystemConfigDataMgr.init();
}

/**
 * 获取全局配置选项信息
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function pub_getSystemConfigDataMgr()
{
    return g_SystemConfigDataMgr;
}

/**
 * 获取支持包信息
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function pub_getClonePnpForm()
{
    return g_pnpForm;
}

/**
 * 第三段第一次弹出详细信息对话框初始位置的横坐标.<br>
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function pub_getXChildRelative()
{
    // 坐标计算有问题，只返回屏幕大小，根据对话框再计算偏移位置
    return window.screen.availWidth - 10;

}

/**
 * 第三段第一次弹出详细信息对话框初始位置的纵坐标.<br>
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function pub_getYChildRelative()
{
    // 坐标计算有问题，只返回屏幕大小，根据对话框再计算偏移位置
    return window.screen.availHeight - 30;
}

/**
 * 获取json对象接口
 * @author w00131173
 */
function pub_getJsonRpcObj()
{
    if(null == g_jsonrpc)
    {
        g_jsonrpc = new VmtJsonRPC();
    }
    
    return g_jsonrpc;
}

/**
 * 重新初始化json对象接口（无论之前是否初始化过，进行重新初始化操作，
 * 提供给预加载打开网元管理器时重新注册json对象，防止后台重启出错）
 * @author w00131173
 */
function reInitJsonRpcObj()
{
    g_jsonrpc = new VmtJsonRPC();
}

Event.observe(window, "load", init);