/*
 * Title:         主要负责三段式第三段常规，高级和子界面的显示
 * Description:  [描述文件的功能、作用、使用方法和注意事项]
 * Copyright:     Copyright (c) 1988-2015
 * Company:       Huawei Tech. Co., Ltd
 * @author         f00145226
 * @version        版本  2010-3-12
 */

/**
 * 第二段的控制类，用于显示滑窗和分页信息
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 * @param viewManager 显示常规高级的视图控件
 * @param featureForm 全局变量
 * @param rowKeys 用户选择的行数据的所有节点关键值
 * @param pagedCtrl 分页处理器
 */
function E2EDataController(dataTable, tableModel, resource, featureForm, frameParam, nodeInfo, deviceForm, pagedCtrl,
        filterCtrl, statusCtrl)
{
    DataController.call(this, dataTable, tableModel, resource, featureForm, frameParam, nodeInfo, deviceForm,
            pagedCtrl, filterCtrl, statusCtrl);
    this._xpathMappingInfo = null;
}

E2EDataController.prototype = new DataController();

E2EDataController.PREVIEW_DIALOG_WIDTH = screen.width * 0.65;

E2EDataController.PREVIEW_DIALOG_HEIGHT = E2EDataController.PREVIEW_DIALOG_WIDTH * 3 / 4 - 8;

E2EDataController.CONFIG_DIALOG_WITH = screen.width * 0.65;

E2EDataController.CONFIG_DIALOG_HEIGHT = E2EDataController.CONFIG_DIALOG_WITH * 3 / 4 - 8;

/**
 * 设置XpathMapping信息
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EDataController.prototype.setXpathMappingInfo = function(xpathMappingInfo)
{
    this._xpathMappingInfo = xpathMappingInfo;
}

/**
 * 初始化action信息
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @param tableInfo 表信息
 */
E2EDataController.prototype._initActionInfo = function(tableInfo)
{

}

/**
 * 更新表格数据
 */
E2EDataController.prototype.updateTableAndStatus = function(dataModel)
{
    // 获取表格中是否有选中行，有选中行的话需要设置焦点
    var selectRows = this._dataTable.getSelection();
    logger.log("start datactrl updateTableAndStatus");
    // 更新表格
    this._dataTable.updateDataTable(dataModel);
    logger.log("end datactrl updateTableAndStatus");
    
    this._initHisConditionColumns(dataModel.historyConditionColumnList);
    this._setFilterCtrlConditionsAndValue(dataModel.historyConditons);
    logger.log("end datactrl _setFilterCtrlConditionsAndValue");

    // 设置焦点
    if (g_E2E_iniFocus)
    {
        this._setRefreshFocus();
    }
    else
    {
        g_E2E_iniFocus = true;
    }

    // 根据表格选中行刷新工具栏状态（因可能会造成选中行变化，所以调用这个接口）
    this.tableSelChange();

    // 处理加载三段式联动事件
    this.processDoLoadLinkage();
}

/**
 * 处理告警板是否需要主动刷新
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-11
 */
E2EDataController.prototype.freshAlarmPanel = function()
{

}

/**
 * 获取返回值
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @param tableInfo 表信息
 */
E2EDataController.prototype.getReturnNmsnameValues = function()
{
    var returnValue = "";

    if ("" != g_E2E_returnNmsnames)
    {
        var returnNmsnams = g_E2E_returnNmsnames.split("@nmsname_value@");

        // 获取当前选中行
        var selectRows = this._dataTable.getSelection();
        if ((null == selectRows) || (selectRows.length == 0))
        {
            return returnValue;
        }

        for ( var num = 0; num < returnNmsnams.length - 1; num++)
        {
            // 获取nmsname对应的Xpath
            var returnNmsname = returnNmsnams[num];
            var xpath = this.getXpathByNmsname(returnNmsname);
            var tempreturnValue = returnNmsname + "@nmsname@";

            // 根据Xpath获取列ID
            var jsonColumnInfo = this._dataTable.getJonsColumnInfoByXpath(xpath);
            if (null == jsonColumnInfo)
            {
                tempreturnValue = tempreturnValue + "" + "@nmsname_value@";
                returnValue = returnValue + tempreturnValue + "@nmsname_valueList@";
                continue;
            }
            var colId = jsonColumnInfo.columnID;

            for ( var selectRowNum = 0; selectRowNum < selectRows.length; selectRowNum++)
            {
                var selectRowId = selectRows[selectRowNum];

                var value = this._dataTable.getSelCellValue(selectRowId, colId);
                // 判断是否是枚举类型的字段，
                if ((null != value) && jsonColumnInfo.isChoice)
                {
                    value = this.getEnumNmsnameByXpath(value, returnNmsname);
                }

                if (null == value)
                {
                    value = "";
                }

                tempreturnValue = tempreturnValue + value + "@nmsname_value@";
            }
            returnValue = returnValue + tempreturnValue + "@nmsname_valueList@";
        }
    }

    return returnValue;
}

/**
 * 根据nmsName获取Xpath
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EDataController.prototype.getXpathByNmsname = function(nmsname)
{
    var xpathMappingAttribues = this._xpathMappingInfo.attributeInfos.list;

    var xpath = "";

    for ( var index in xpathMappingAttribues)
    {
        if (xpathMappingAttribues[index].nmsname == nmsname)
        {
            xpath = xpathMappingAttribues[index].xpath;
            return xpath;
        }
    }
    return xpath;
}

/**
 * 根据nmsName获取Xpath
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EDataController.prototype.getEnumNmsnameByXpath = function(value, attributeNmsname)
{
    var xpathMappingAttribues = this._xpathMappingInfo.attributeInfos.list;

    var enumNmsName = "";

    for ( var index in xpathMappingAttribues)
    {
        if (xpathMappingAttribues[index].nmsname == attributeNmsname)
        {
            var enumInfoMap = xpathMappingAttribues[index].enumInfos.map;

            for ( var key in enumInfoMap)
            {
                var enumXpath = enumInfoMap[key];
                var enumValues = enumXpath.split("/");
                var enumValue = enumValues[2];
                if (value == enumValue)
                {
                    enumNmsName = key;
                    break;
                }
            }

        }
    }
    return enumNmsName;
}

/**
 * 创建配置对话框
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-3-17
 * @param operation 配置操作类型
 * @param dialogId 对话框ID
 * @param url 页面路径
 */
E2EDataController.prototype.createDialog = function(operation, dialogId, url)
{
    var nodeName = FeaturesResourceMgr.getSchemaResource(this._featureForm.xpath);
    var dialogTitle = nodeName + " " + "[" + operation + "]";
    this._createBasicDialog(dialogTitle, dialogId, url, E2EDataController.CONFIG_DIALOG_WITH,
            E2EDataController.CONFIG_DIALOG_HEIGHT);
}
