/*
 * Title:        配置操作的右键菜单，用于三段式的第三段
 * Description:   
 * Copyright:     Copyright (c) 1988-2015
 * Company:       Huawei Tech. Co., Ltd
 * @author        l00133618
 * @version       iManager U2000 V1R3,2010-10-12
 */

// ////////////////////////////////////////////////////////////////////////
/**
 * 三段式第三段的右键配置菜单
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-10-12
 */
function E2EConfigMenu(resource)
{
    ConfigMenu.call(this, resource);
}

E2EConfigMenu.prototype = new ConfigMenu();

/**
 * 向右键菜单中添加新建、拷贝新建、批量新建
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-5-18
 */
E2EConfigMenu.prototype.addCreateMenu = function(operLevel)
{
    var object = this;
    var popuTitle = jse.getI18nValue("qat:public", "popupmenu.add_d");
    this._menu.addItem(null, MenuItemID.NEW,
    {
        text : popuTitle + "...",
        image : CommonUtil.getRootPath() + "/vmt/image/new.gif",
        action : doClickCreate
    });
    this._menu.addItem(null, MenuItemID.NEWSP,
    {
        text : "-"
    });
}


// ////////////////////////////////////////////////////////////////

function E2EMenuController(configMenu, table, preAuthority)
{
    MenuController.call(this, configMenu, table, preAuthority);
}

E2EMenuController.prototype = new MenuController();

/**
 * 初始化右键菜单的内容
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-5-18
 */
E2EMenuController.prototype.initMenu = function()
{
    // 初始化右键菜单对象
    this._configMenu.initMenuObj();

    var operLevel = this._menuStatusFactory.getOperLevel();
    this._addConfigMenu(operLevel);
    this._addFeatureMenu(operLevel);
}

/**
 * 向右键菜单中添加同步单条记录
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-5-18
 * @param operLevel
 */
E2EMenuController.prototype._addFeatureMenu = function(operLevel)
{
    // 添加同步单条记录
    this._configMenu.addRefeshMenu();

    // 添加列定制
    if (operLevel.canCustomColumn)
    {
        this._configMenu.addColumnMenu();
    }
}