/*
 * Title:        配置操作的右键菜单，用于三段式的第三段
 * Description:   
 * Copyright:     Copyright (c) 1988-2015
 * Company:       Huawei Tech. Co., Ltd
 * @author        l00133618
 * @version       iManager U2000 V1R3,2010-10-12
 */

// ////////////////////////////////////////////////////////////////////////
/**
 * 三段式第三段的右键配置菜单
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function E2EChildConfigMenu(resource)
{
    E2EConfigMenu.call(this, resource);
}

E2EChildConfigMenu.prototype = new E2EConfigMenu();

/**
 * 设置详细信息的状态
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
E2EChildConfigMenu.prototype.setDetailStatus = function(status)
{
    if (this._menu.isItemVisible(MenuItemID.DETAIL))
    {
        this._menu.setItemEnabled(MenuItemID.DETAIL, status);
    }
}


/**
 * 在右键菜单中添加详细信息的菜单
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
E2EChildConfigMenu.prototype.addDetailMenu = function()
{
    var object = this;
    var popuTitle = jse.getI18nValue("qat:public", "popupmenu.viewdetail_d");
    this._menu.addItem(null, MenuItemID.DETAIL,
    {
        text : popuTitle + "...",
        image : CommonUtil.getRootPath() + "/vmt/image/srvcView.gif",
        action : doClickDetail
    });
    this._menu.addItem(null, MenuItemID.DETAILSP,
    {
        text : "-"
    });
}
// ////////////////////////////////////////////////////////////////////////
/**
 * 三段式第三段的右键配置菜单
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function E2EChildMenuController(configMenu, table, preAuthority)
{
    E2EMenuController.call(this, configMenu, table, preAuthority);
    
    this._operLevel = null;
    /**
     * 右键菜单状态控制类
     */
    this._menuStatusFactory = new ChildMenuStatusFatory(table);
}

E2EChildMenuController.prototype = new E2EMenuController();

/**
 * 设置操作权限数据类<br>
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
E2EChildMenuController.prototype.setOperLevel = function(operLevel)
{
    this._operLevel = operLevel;
}

/**
 * 初始化右键菜单的内容
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @override
 */
E2EChildMenuController.prototype.initMenu = function()
{
    // 初始化右键菜单对象
    this._configMenu.initMenuObj();
    this._configMenu.addDetailMenu();
    this._menuStatusFactory.setOperLevel(this._operLevel);
    var operLevel = this._menuStatusFactory.getOperLevel();
    this._addConfigMenu(operLevel);
    this._addFeatureMenu(operLevel);

}

/**
 * 向右键菜单中添加同步单条记录
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @param operLevel
 */
E2EChildMenuController.prototype._addFeatureMenu = function(operLevel)
{
    // 添加同步单条记录
    this._configMenu.addRefeshMenu();
    
    // 添加列定制
    if (operLevel.canCustomColumn)
    {
        this._configMenu.addColumnMenu();
    }
}

/**
 * 设置菜单各项的状态
 * 
 * @author l00133618
 * @since iManager U2000 V1R3,2010-10-12
 * @param customState 用户自定义状态值
 * @override
 */
E2EChildMenuController.prototype.setMenuStatus = function(customState)
{
    var status = this._menuStatusFactory.getMenuStatus(customState);
    this._configMenu.setMenuStatus(status);

    var columnStatus = this._menuStatusFactory.getColumnStatus();
    this._configMenu.setColumnStatus(columnStatus);
    this._configMenu.setDetailStatus(this._menuStatusFactory.getDetailStatus());

    // 根据鉴权设置右键菜单中的状态
    if (null != this._preAuthority)
    {
        var menu = this._configMenu.getPopMenuObj();
        this._preAuthority.setPopmenuEnableByAuthority(menu);
    }
}
