jse.require("jse.widget.dialog");
jse.require("jse.widget.menu");
jse.require("jse.widget.table");
jse.require("vmt.extend.table_prototype");

var Child =
{
    /**
     * 第二段控制类
     */
    dataCtrl : new PageTableDataController(),

    /**
     * 第二段控制模型
     */
    dataTable : null,

    /**
     * 全局变量
     */
    featureData : null,

    /**
     * 第三段右键菜单控制
     */
    menuCtrl : null,

    /**
     * 第二段控制模型
     */
    tableModel : null,

    /**
     * 子Dialog页面的横坐标
     */
    xChildRelative : null,

    /**
     * 子Dialog页面的纵坐标
     */
    yChildRelative : null,

    /**
     * 联动类
     */
    linkageCtrl : null,

    /**
     * 筛选控制类
     */
    colFilterCtrl : null,

    /**
     * 父页面的第二段控制类
     */
    parentDataCtrl : null
}

var signalMap =
{
    on_load_ui : doLoad
};

/**
 * 初始化函数
 */
function init()
{
    logger.log("enter child init()");

    // 通过JSON获取控件的Handler
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/configframe/xui/detail/child.xui", signalMap);

    logger.log("exit child init()");
}

/**
 * 用户载入页面.<br>
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return
 */
function doLoad()
{
    logger.log("enter child doLoad()");
    var table = window.xui.getWidget("Table");
    table.onsort = doSort;
    table.ondblclick = tableDblClick;
    table.oncontextmenu = popupContextMenu;
    table.onselchanged = doTableSelChange;
    table.setAllColSortable(true);

    // 从父窗口中获取公共变量
    Child.featureData = window.parent.pub_getFeaturePubData().clone();
    var featureForm = Child.featureData.getFeatureForm();
    var frame = Child.featureData.getFrameParam()
    var node = Child.featureData.getNodeInfo();
    var deviceForm = Child.featureData.getDeviceForm();

    // 初始化表格和表格模型，用于构造第二段控制模型
    Child.tableModel = new TableModel(null, table);
    Child.dataTable = new DataTable(table, Child.tableModel, null);
    var tabId = getCurrentTabId();
    featureForm.xpath = tabId;

    var pagedLabel = window.xui.getWidget("infoLabel");
    var pagedBar = window.xui.getWidget("tableNavigator");
    pagedBar.ondragmove = doNavigate;
    pagedBar.onvaluechanged = doNavigate;
    var pageCtrl = new OnlineChildPageController(pagedLabel, pagedBar, Child.dataTable, deviceForm, featureForm, frame);
    var emptyFilterController = new EmptyFilterController(null, null, null);

    // 克隆node防止子节点信息覆盖父节点信息
    Child.dataCtrl = new PageTableDataController(Child.dataTable, Child.tableModel, null, featureForm, frame, node
            .clone(), deviceForm, pageCtrl, emptyFilterController, null);

    Child.dataCtrl.setRenovatorCtrl(null);

    Child.colFilterCtrl = new ColumnFilterController(Child.dataTable, Child.dataCtrl);
    Child.dataCtrl.setColFilterCtrl(Child.colFilterCtrl);

    // 初始化联动
    _initLinkageCtrl();

    var emptyDetailController = new EmptyDetailController(null, null, null, null);
    Child.dataCtrl.setDetailCtrl(emptyDetailController);

    var isWorkspace = featureForm.isWorkspace;
    if (!isWorkspace)
    {
        // 子右键菜单和详细信息查询Dialog横纵坐标
        Child.xChildRelative = getXChildRelative();
        Child.yChildRelative = getYChildRelative();
    }

    var configMenu = new E2EChildConfigMenu(null);
    logger.log("start child doLoad() ConfigPreAuthority");
    var perAuthority = new ConfigPreAuthority(deviceForm.deviceIp);
    perAuthority.init();
    // perAuthority.getAuthority();
    var menuCtrl = new E2EChildMenuController(configMenu, Child.dataTable, perAuthority);
    Child.dataCtrl.setMenuController(menuCtrl);

    logger.log("start child doLoad() intitTableView");
    Child.dataCtrl.intitTableView("FEATURE");

    logger.log("start child doLoad() initChildTableData");
    Child.dataCtrl.initChildTableData("FEATURE", pub_getSelectRowKeys(), true);
    window.parent.pub_getDetailController().setViewLoaded(tabId);

    logger.log("exit child doLoad()");
}

/**
 * 初始化联动对象
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function _initLinkageCtrl()
{
    var checkerUseData = new FeatureCheckerUseData(Child.dataTable, null);

    var checkerFactory = new FeatureTableCheckerFactory();
    var prosorUseData = new FeatureProsorUserData(Child.dataTable, null, null);

    var prosorFactory = new FeatureTableProsorFactory();
    var linkageTransactionCtrl = new FeatureLinkageTransactionCtrl(checkerFactory, prosorFactory);

    Child.linkageCtrl = new FeatureLinkageController(checkerUseData, linkageTransactionCtrl, prosorFactory,
            prosorUseData);

    Child.dataCtrl.setLinkageCtrl(Child.linkageCtrl);
}

/**
 * 用户切换table行,需要处理鉴权的联动
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function doTableSelChange(evt)
{
    Child.dataCtrl.tableSelChange(evt);
}

/**
 * 跳转到指定页
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return
 */
function doNavigate(evt)
{
    Child.dataCtrl.handleNavigate(evt.value - 1);
}

/**
 * 排序
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function doSort(colId, sortType)
{
    Child.dataCtrl.sortRecord(colId, sortType, this._detailController);
}

/**
 * 右键菜单查看详细信息触发事件,弹出查询详细信息对话框.<br>
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function doClickDetail()
{
    var detailUrl = CommonUtil.getRootPath() + "/vmt/ct/online/externalview/e2e/feature/childdetail/childdetail.html";

    var dialogWith = window.screen.availWidth * 0.63;
    var dialogHeight = dialogWith * 3 / 4 - 16;

    // var xChildRelative = (getXChildRelative() - dialogWith) / 2;
    // var yChildRelative = (getYChildRelative() - dialogHeight) / 2;
    var xChildRelative = null;
    var yChildRelative = null;

    var nodeName = FeaturesResourceMgr.getSchemaResource(getCurrentTabId());
    Child.dataCtrl.creatDetailDialog(detailUrl, nodeName, dialogWith, dialogHeight, xChildRelative, yChildRelative);
}

/**
 * 用户点击新建菜单
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function doClickCreate()
{
    // 在打开树表配置对话框的时候预先请求配置界面数据
    var parentRowKeys = pub_getSelectRowKeys();
    var nodekey = parentRowKeys.getNodeKey();

    var initTreeTableView = new AddedTreeInitOper();
    Child.dataCtrl.addInitTreeTableViewOper(initTreeTableView);
    initTreeTableView.preRequestOperResult(Child.dataCtrl, nodekey);

    var operation = Resource.getResource("qat:public", "dialog_createconfig_d");
    var createDialogUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/config/add/add.html";
    Child.dataCtrl.createRecord(window.parent.pub_getDetailController(), operation, "new", createDialogUrl);
}

/**
 * 用户点击修改菜单
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function doClickModify()
{
    // 在打开树表配置对话框的时候预先请求配置界面数据
    var initTreeTableView = (1 == Child.dataCtrl.getSelection().length) ? new ModifiedTreeInitOper()
            : new BatchModifyTreeInitOper();
    Child.dataCtrl.addInitTreeTableViewOper(initTreeTableView);
    initTreeTableView.preRequestOperResult(Child.dataCtrl);

    var modifySingleUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/config/modify/modify.html";
    var modifyMultiUrl = CommonUtil.getRootPath() + "/vmt/ct/online/view/config/batchmodify/batchmodify.html";
    Child.dataCtrl.modifyRecords(modifySingleUrl, modifyMultiUrl);
}

/**
 * 用户点击删除菜单
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function doClickDelete()
{
    var emptyDetailController = new EmptyDetailController(null, null, null, null);
    Child.dataCtrl.deleteRecord(emptyDetailController);
}

/**
 * 用户点击同步菜单
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function doClickSynchronizeData()
{
    Child.dataCtrl.sysSelectedRecord();
}

/**
 * 右键菜单列定制触发事件,弹出查询详细信息对话框.<br>
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-10-12
 */
function doClickCustomColumn()
{
    Child.dataCtrl.setAutoRefreshEnable(false);
    Custom.clickCustomColumn(Child.featureData);
}

/**
 * 获取横坐标.<br>
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return 弹出详细信息查询子页面的横坐标
 */
function getXChildRelative()
{
    var xChildRelative = null;

    if (null != window.parent.jse.getFromWin())
    {
        xChildRelative = window.parent.jse.getFromWin().pub_getXChildRelative();
    }
    else
    {
        xChildRelative = window.parent.parent.pub_getXChildRelative();
    }
    return xChildRelative;
}

/**
 * 获取纵坐标.<br>
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return 弹出详细信息查询子页面的横坐标
 */
function getYChildRelative()
{
    var yChildRelative = null;

    if (null != window.parent.jse.getFromWin())
    {
        yChildRelative = window.parent.jse.getFromWin().pub_getYChildRelative();
    }
    else
    {
        yChildRelative = window.parent.parent.pub_getYChildRelative();
    }
    return yChildRelative;
}

/**
 * 获取tabId.<br>
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return
 */
function getCurrentTabId()
{
    // 通过页面对象来获取ID，由于快速切换时可能此时已经切换到其它tab页，因而不使用原来的getCurrentTabId来获取
    var tabId = window.parent.pub_getDetailController().getTabIdByWin(this);
    return tabId;
}

/**
 * 获取详细信息控制类.<br>
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return 详细信息控制类
 */
function pub_getChildDetailCtrl()
{
    jse.getFromWin().pub_getChildDetailCtrl()
}

/**
 * 显示弹出菜单.<br>
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function popupContextMenu(evt)
{
    Child.dataCtrl.popupContextMenu(evt);
}

/**
 * 双击表处理事件.<br>
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 */
function tableDblClick(evt)
{
    doClickDetail();
}

/**
 * 获取选中行Id.<br>
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return 选中行Id.
 */
function pub_getRowId()
{
    return Child.tableModel.getCurrentSelectId();
}

/**
 * 获取子节点全局信息，其nodeInfo信息已经在查询处赋值
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return 全局信息
 */
function pub_getFeaturePubData()
{
    var childGlobalData = Child.featureData.clone();
    childGlobalData.setNodeInfo(Child.dataCtrl.getNodeInfo());
    return childGlobalData;
}

/**
 * 获取子Dialog页面的横坐标.<br>
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return 子Dialog页面的横坐标
 */
function pub_getXChildRelative()
{
    return Child.xChildRelative + 30;
}

/**
 * 获取子Dialog页面的纵坐标.<br>
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return 子Dialog页面的纵坐标
 */
function pub_getYChildRelative()
{
    return Child.yChildRelative + 30;
}

/**
 * 获取选择行的key值<br>
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return
 */
function pub_getSelectRowKeys()
{
    var dataController = window.parent.pub_getDataController();
    var rowKey = dataController.getTableModel().getCurrentSelectRowKey();
    return rowKey;
}

/**
 * 获取控制类<br>
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return
 */
function pub_getDataController()
{
    return Child.dataCtrl;
}

/**
 * 获取联动控制类
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return 全局信息
 */
function pub_getLinkageCtrl()
{
    return Child.linkageCtrl;
}

/**
 * 添加列筛选条件
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return
 */
function doAddColumnFilterCondition(evt)
{
    Child.colFilterCtrl.addFilterCondition(evt.target);
}

/**
 * 用户触发筛选操作
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-26
 * @return
 */
function doFilter(evt)
{
    Child.colFilterCtrl.filterData(evt.target, evt.target.getSelection());
}

/**
 * 列定制后，重新初始化列信息,重新布局和加载数据
 * 
 * @author s00143960
 * @since iManager U2000 V1R3,2010-5-28
 * @return
 */
function pub_column()
{
    Child.dataCtrl.initChildTableData("FEATURE", pub_getSelectRowKeys(), false);
}

Event.observe(window, "load", init);