/**
 * E2E调用界面新建树表初始化表格操作类
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
function E2EQueryAddedTreeInitOper(treeTable, treeModel, treeTableStatus, linkageCtrl, focusOper, guiCustomizeProcessor,
        dataCtrl, configCtrl, verifyCtrl)
{
    E2EAddedTreeInitOper.call(this, treeTable, treeModel, treeTableStatus, linkageCtrl, focusOper, guiCustomizeProcessor,
            dataCtrl, configCtrl,verifyCtrl);
}

/**
 * 继承E2EAddedTreeInitOper
 */
E2EQueryAddedTreeInitOper.prototype = new E2EAddedTreeInitOper();

/**
 * 加载树表结束后的操作
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-9-4
 */
E2EQueryAddedTreeInitOper.prototype.postDoGetTreeTable = function()
{
    // 设置后续的操作为非初始化界面操作
    this._linkageCtrl.setIsDoloadInitOper(false);

    this._treeTable.refreshTableEditStatus(false);
    
//    //防止设置焦点时错行，解决DTS2012080607751
//    TimeOperation.doObjSetTimeout(this, this.setDefaultFocus, [], 100);
}

///////////////////////////////////////////////////////////////////////////////////
/**
 * 树表点击显示高级/隐藏高级属性按钮
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-9-4
 */
function E2EQueryAddTreeShowAdvanceOper(treeTable, treeModel, treeTableStatus, linkageCtrl, advancedAttriChecker)
{
    TreeShowAdvanceOper.call(this, treeTable, treeModel, treeTableStatus, linkageCtrl, advancedAttriChecker);
}

/**
 * 继承TreeShowAdvanceOper
 */
E2EQueryAddTreeShowAdvanceOper.prototype = new TreeShowAdvanceOper();

/**
 * 显示高级完毕后的处理（包括处理联动，颜色等）
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-9-4
 */
E2EQueryAddTreeShowAdvanceOper.prototype.procAfterShowAdvance = function(allAdvAttrs)
{
    // 设置表列不可编辑以及列表结点前的图片灰化
    this._treeTable.refreshTableEditStatus(false);
}

///**
// * 设置值列不可编辑以及列表结点前的图片灰化
// * 
// * @author w00131173
// * @since iManager U2000 V1R8,2012-9-4
// */
//E2EQueryAddTreeShowAdvanceOper.prototype.refreshTableEditStatus = function(status)
//{
//    var allRowIds = this._treeTable.getAllRowIds();
//    for ( var i = 0; i < allRowIds.length; i++)
//    {
//        var rowId = allRowIds[i];
//        this._treeTable.setCellEditable(rowId, this._treeTable.VALUECOLID, status);
//
//        // 是否是列表结点，如果是列表结点，将图片灰化掉
//        var cell = this._treeTable.getCell(rowId, this._treeTable.OPERATIONCOLID);
//        if ((null == cell) || (0 == cell.content.length))
//        {
//            continue;
//        }
//        this._treeTable.changeImage(1, rowId, CommonUtil.getRootPath() + "/vmt/image/unclear.gif");
//        this._treeTable.changeImage(2, rowId, CommonUtil.getRootPath() + "/vmt/image/unclear.gif");
//    }
//}