/*
 * Title:         主要是用于修改配置、拷贝新建配置界面的各种操作
 * Description:  [描述文件的功能、作用、使用方法和注意事项]
 * Copyright:     Copyright (c) 1988-2015
 * Company:       Huawei Tech. Co., Ltd
 * @author        w00131173
 * @version        版本  2010-4-13
 */

/**
 * E2E调用的新建界面中的事件控制处理类
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-9-4
 */
function E2EQueryAddCfgController()
{
    E2EAddCfgController.call(this);
}

/**
 * E2EQueryAddCfgController继承类E2EAddCfgController
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-9-4
 */
E2EQueryAddCfgController.prototype = new E2EAddCfgController();

/**
 * 点击确定按钮直接关闭对话框
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-9-4
 */
E2EQueryAddCfgController.prototype.clickOkBtn = function()
{
    var url = E2EBUTTONURL.OKURL;
    document.location = url;
}

/**
 * 初始化树表
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-9-4
 */
E2EQueryAddCfgController.prototype.initTableTree = function()
{
    var focuseOper = new DefaultFocusOper(this._treeTable, this._treeModel, this._refSelectControler,
            this._treeTableStatus, this._treeTable.VALUECOLID);

    this._initTreeTableView = new E2EQueryAddedTreeInitOper(this._treeTable, this._treeModel, this._treeTableStatus,
            this._linkageCtrl, focuseOper, this._guiCustomizeProcessor);
    this._initTreeTableView.setHardDiffCtrl(this.getHardDiffCtrl());
    this._initTreeTableView.setProgressBarCtrl(this._advProgressBarCtrl);
    this._initTreeTableView.setInitParamInfo(this._initParamInfo, this._xpathMappingInfo);

    this._initTreeTableView.initTableTreeView(this._featureData);

    // 设置表列不可编辑以及列表结点前的图片灰化
    this._treeTable.refreshTableEditStatus(false);
    
}

///**
// * 设置值列不可编辑以及列表结点前的图片灰化
// * 
// * @author w00131173
// * @since iManager U2000 V1R8,2012-9-4
// */
//E2EQueryAddCfgController.prototype.refreshTableEditStatus = function(status)
//{
//    var allRowIds = this._treeTable.getAllRowIds();
//    for ( var i = 0; i < allRowIds.length; i++)
//    {
//        var rowId = allRowIds[i];
//        this._treeTable.setCellEditable(rowId, this._treeTable.VALUECOLID, status);
//        
//        //是否是列表结点，如果是列表结点，将图片灰化掉
//        var cell = this._treeTable.getCell(rowId, this._treeTable.OPERATIONCOLID);
//        if ((null == cell)||(0 == cell.content.length))
//        {
//            continue;
//        }
//        this._treeTable.changeImage(1, rowId, CommonUtil.getRootPath() + "/vmt/image/unclear.gif");
//        this._treeTable.changeImage(2, rowId, CommonUtil.getRootPath() + "/vmt/image/unclear.gif");
//    }
//}

/**
 * 点击选择高级checkbox
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-9-4
 */
E2EQueryAddCfgController.prototype.clickAdvancedCheckBox = function(evt)
{
    if (null == this._showAdvanceOperation)
    {
        var modelChecker = this._verifyCtrl.createNullLegalAdvancedChecker();
        this._showAdvanceOperation = new E2EQueryAddTreeShowAdvanceOper(this._treeTable, this._treeModel, this._treeTableStatus,
                this._linkageCtrl, modelChecker);
    }
    this._showAdvanceOperation.showAdvanceAttributes(this._advProgressBarCtrl, [ this._treeTable.VALUECOLID ], this,
            this.selectChange);
}