/*
 * Title:         主要是用于E2E调用的新建配置界面
 * Description:  
 * Copyright:     Copyright (c) 1988-2015
 * Company:       Huawei Tech. Co., Ltd
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */

jse.require("jse.widget.dialog");
jse.require("jse.widget.table");
jse.require("vmt.extend.table_prototype");

/* 全局RPC代理对象 */
var g_jsonrpc = ("undefined" == typeof(jsonrpc) || null == jsonrpc) ? new VmtJsonRPC() : jsonrpc;

/**
 * 配置类
 */
var g_config = {};

var g_xpathMappingOperobjInfo = null;

var g_global = null;

var g_verifyInfo = null;

/**
 * 硬件规格差异数据缓存管理对象
 */
var g_HardSpecDiffDataCacheMgr = new DataCacheMgr();

/**
 * 全局配置选项数据管理对象
 */
var g_SystemConfigDataMgr = new SystemConfigDataMgr();

var g_pnpForm = null;

var signalMap =
{
    on_load_ui : doLoad,
    onClickCancelButton : clickCancelBtn,
    onClickOKButton : clickOkBtn,
    onClickExpandAll : expandAll,
    onClickTCollapseAll : collapseAll,
    onClickFilterButton : doResearch,
    onAdvancedCheckBoxClick : clickAdvancedCheckBox
};

/**
 * 初始化方法
 */
function init()
{
    logger.log("start child init().");
    
    //设置语言
    jse.setLanguage(g_E2E_lang);
    
    window.xui = new jse.XUI();
	window.xui.setResReplaceRule("/nemgr_vmf", CommonUtil.getRootPath());
    window.xui.load(CommonUtil.getRootPath() + "/vmt/ct/online/xui/e2e/queryadd.xui", signalMap);
}

/**
 * js载入函数
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
function doLoad()
{
    logger.log("start child doLoad().");
    var addLoader = new E2EQueryAddViewLoader();
    addLoader.setRefObjDataCacheMgr(new KeyrefObjDataCacheMgr(pub_getFeaturePubData()));

    var urlArray = [];
    urlArray[RefDlgUrlType.PARENT] = CommonUtil.getRootPath() + "/vmt/ct/online/view/parent/parent.html";
    urlArray[RefDlgUrlType.KEYREF] = CommonUtil.getRootPath() + "/vmt/ct/online/view/keyref/keyref.html";
    urlArray[RefDlgUrlType.KEY] = CommonUtil.getRootPath() + "/vmt/ct/common/dialog/keydialog/keydialog.html";
    urlArray[RefDlgUrlType.PASSWORD] = CommonUtil.getRootPath() + "/vmt/ct/common/dialog/passworddialog/passworddialog.html";

    // ref关系选择控制类
    var refSelectControler = new RefSelectControler(new KeyrefViewController(), new ParentViewController(),
            new KeyPasswordViewCtrl(), new PasswordViewCtrl());

    // 初始化全局配置参数，3s后起个线程初始化，以免后续使用时消耗时间
    setTimeout("initSystemConfigDataMgr()", 3000);

    initGlobalData();

    var parentWin = jse.getFromWin();
    // var hasParentRowKeys = (null != parentWin && "undefined" != typeof(parentWin.pub_getSelectRowKeys));
    g_config = new E2EQueryAddCfgController();
    g_config.setInitParamInfo(g_E2E_initParamInfo);
    g_config.setXpathMappingInfo(g_xpathMappingOperobjInfo);
    addLoader.doLoad(urlArray, g_config, refSelectControler);

}

/**
 * 加载动态信息
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 * @param isInitBySelf 区分该方法是内嵌页面还是组件的 show()调用的
 * @return
 */
function onshow(isInitBySelf)
{
    this.doLoad();
}

/**
 * 获取全局参数
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
function pub_getFeaturePubData()
{
    return g_global;
}

/**
 * 初始化全局参数
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
function initGlobalData()
{
    // 从后台获取初始化参数需要的信息:该特性操作对象的对应的所有的Xpath，全局属性需要的参数，
    var featureForm = new FeatureForm();
    featureForm.featureName = g_E2E_featureName;
    featureForm.isWorkspace = "false";
    featureForm.domain = g_E2E_domain;
    featureForm.guiType = "CREATE";

    var deviceForm = new DeviceForm();
    deviceForm.deviceType = g_E2E_deviceType;
    deviceForm.deviceVersion = g_E2E_deviceVersion;
    deviceForm.deviceIp = g_E2E_deviceIp;
    deviceForm.vrId = g_E2E_vrId;
    deviceForm.devId = g_E2E_devId;
    deviceForm.lrRole = g_E2E_lrRole;
    deviceForm.type = g_E2E_type;
    var pnpForm = new PnpForm();
	pnpForm.deviceType = g_E2E_deviceType;
	pnpForm.deviceVersion = g_E2E_deviceVersion;
	deviceForm.pnpForm = pnpForm;

    // 从后台获取全局参数
    var operResult = jsonrpc.invoke("e2eGlobalParamProcess", "getGlobalParam", [ deviceForm.changJsonForm(),
            featureForm.changJsonForm(), g_E2E_operObjNmsname, null ]);
    if (null == operResult)
    {
        return;
    }

    if (GlobalConstants.OPER_OK == operResult.resultType)
    {
        var globalFeatureForm = operResult.returnObj.featureForm;
        var globalDeviceForm = operResult.returnObj.deviceForm;
        g_xpathMappingOperobjInfo = operResult.returnObj.xpathMappingOperobjInfo;

        var newDeviceForm = new DeviceForm();
        newDeviceForm.deviceType = globalDeviceForm.deviceType;
        newDeviceForm.deviceVersion = globalDeviceForm.deviceVersion;
        newDeviceForm.deviceIp = globalDeviceForm.deviceIp;
        newDeviceForm.vrId = globalDeviceForm.vrId;
        newDeviceForm.devId = globalDeviceForm.devId;
        newDeviceForm.lrRole = globalDeviceForm.lrRole;
        newDeviceForm.isSupportPartition = globalDeviceForm.isSupportPartition;
        newDeviceForm.type = globalDeviceForm.type;
        
        var pnpForm = new PnpForm();
        pnpForm.deviceType = globalDeviceForm.pnpForm.deviceType;
        pnpForm.deviceVersion = globalDeviceForm.pnpForm.deviceVersion;
        pnpForm.compatible = globalDeviceForm.pnpForm.compatible;

        newDeviceForm.pnpForm = pnpForm;
        g_pnpForm = pnpForm;
        
        var newFeatureForm = new FeatureForm();
        newFeatureForm.featureName = globalFeatureForm.featureName;
        newFeatureForm.xpath = globalFeatureForm.xpath;
        newFeatureForm.isWorkspace = globalFeatureForm.isWorkspace;
        newFeatureForm.domain = globalFeatureForm.domain;
        newFeatureForm.guiType = globalFeatureForm.guiType;
        newFeatureForm.condition = globalFeatureForm.condition;
        newFeatureForm.parentXpath = globalFeatureForm.parentXpath;
        newFeatureForm.isAppearOnce = globalFeatureForm.isAppearOnce;

        var global = new GlobalData();
        global.setDeviceForm(newDeviceForm);
        global.setFeatureForm(newFeatureForm);
        var frameParam = new FrameParam();
        global.setFrameParam(frameParam);
        g_global = global;
        jsonrpc.invoke("typeCustomJudgement", "setChoosedTreeNode", [globalFeatureForm.xpath]);
    }
    else
    {
        CommonDlgReq.openRspErrorDialog(operResult, null, null);
    }

}

/**
 * 点击取消按钮
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
function clickCancelBtn()
{
    g_config.clickCancelBtn();
}

/**
 * 点击确定按钮
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
function clickOkBtn()
{
    g_config.clickOkBtn();
}

/**
 * 用户点击新增、删除和删除所有结点的图片的处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 * @param evt 事件信息
 */
function clickImage(evt)
{
//    if (evt.imageId == Image.DELETE)
//    {
//        g_config.deleteNode(evt.rowId);
//    }
//    else if (evt.imageId == Image.ADD)
//    {
//        g_config.createNode(evt.rowId);
//    }
//    else if (evt.imageId == Image.DELETEALL)
//    {
//        g_config.deleteAllNode(evt.rowId);
//    }
//    else if (evt.imageId == Image.BATCHBIND)
//    {
//        g_config.batchBind(evt.rowId, CommonUtil.getRootPath() + "/vmt/ct/online/view/batchbind/batchbind.html");
//    }
//    else
//    {
//        // 暂不支持
//    }
}

/**
 * 用户展开结点行
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
function onDblClick(evt)
{
    g_config.onDblClick(evt.rowId);
}

/**
 * 用户点击结点前面的加号展开结点行
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 * @param evt 事件信息
 */
function onExpanding(evt)
{
}

/**
 * 用户点击展开所有行
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
function expandAll()
{
    g_config.expandAll();
}

/**
 * 用户收缩所有行
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
function collapseAll()
{
    g_config.collapseAll();
}

/**
 * 点击选择高级checkbox
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 * @param evt 事件信息
 */
function clickAdvancedCheckBox(evt)
{
    g_config.clickAdvancedCheckBox(evt);
}

/**
 * 点击选择高级checkbox
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 * @param evt 事件信息
 */
function onSelChanged(evt)
{
    g_config.selectChange(evt.id);
}

/**
 * 用户改变cell内值时进行校验，如果校验不通过设置单元格背景颜色为红色
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 * @param evt 事件信息
 */
function onValueChanged(evt)
{
    g_config.valueChange(evt);
}

/**
 * TODO 后续需要切换至JSE会提供实时监听键盘输入的事件， 用户正在改变cell内值时的处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 * @param evt 事件信息
 */
function onValuechanging(evt)
{
    g_config.valuechanging(evt);
}

/**
 * 单元格的变化
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 * @param evt 事件信息
 */
function onCellSelChanged(evt)
{
    // 设置数表可编辑的单元格的多国语言样式
    Preconstraints.setTableCellStype(Preconstraints.NORMAL_OPERATION);
}

/**
 * 处理最后一个单元格的Tab事件
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 * @param evt 事件信息
 */
function doLastCellFocus(evt)
{
    g_config.doLastCellFocus(evt);
}

/**
 * 查找按钮事件处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 * @param evt
 * @return
 */
function doResearch(evt)
{
    g_config.openSearchDlg();

}

/**
 * 单击keyref按钮的事件处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
function doKeyRefClick(evt)
{
    g_config.doKeyRefClick(evt);
}

/**
 * 单击bitMask按钮的事件处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
function doBitMaskClick(evt)
{
    g_config.doBitMaskClick(evt);
}

/**
 * 用户在keyref输入框中输入值，进行联想
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
function doKeyRefFilter(evt)
{
    g_config.doKeyRefFilter(evt);
}

/**
 * 单击选择父按钮的事件处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
function doParentClick(evt)
{
    g_config.doParentClick(evt);
}

/**
 * 用户在parent输入框中输入值，进行联想
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
function doParentFilter(evt)
{
    g_config.doParentFilter(evt);
}

/**
 * 获取配置控制对象
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 * @return
 */
function pub_getConfigCtrl()
{
    return g_config;
}

/**
 * 获取当前选中结点的tooltip信息
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
function pub_getCurNodeTooltip()
{
    return g_config.getCurNodeTooltip();
}

/**
 * 弹出设置密码对话框
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
function doKeyPasswordClick(evt)
{
    g_config.doKeyPasswordClick(evt);
}

/**
 * 弹出设置密码对话框
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
function doPasswordClick(evt)
{
    g_config.doPasswordClick(evt);
}

/**
 * 获取密码类型字段属性定义的最小长度
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
function pub_getCurPwdMinLength()
{
    return g_config.getPwdCellMinLength();
}

/**
 * 获取密码类型字段属性定义的最大长度
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
function pub_getCurPwdMaxLength()
{
    return g_config.getPwdCellMaxLength();
}

/**
 * 获取密码类型字段属性定义的不支持的正则表达式
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
function pub_getUnsupportedPwdSet()
{
    return g_config.getPwdCellPattern();
}

/**
 * 获取密码类型字段属性定义的支持的正则表达式
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 * @returns
 */
function pub_getSupportedPwdSet()
{
    return null;
}

/**
 * 设置密码类型字段属性的值
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-21
 */
function pub_setPasswordValue(password)
{
    g_config.setPasswordValue(password);
}

/**
 * 获取E2E需要的返回值
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-31
 * @returns
 */
function pub_getReturnValues()
{
    return g_config.getReturnNmsnameValues();
}

/**
 * 获取需要的校验信息值
 * 
 * @author w00131173
 * @since iManager U2000 V1R8,2012-5-31
 * @returns
 */
function pub_getVerification()
{
    var deviceForm = g_global.getDeviceForm();
    var featureForm = g_global.getFeatureForm();
    var frameParam = g_global.getFrameParam();

    var operResult = jsonrpc.invokeWithoutMask("dataTableFactory", "getFeatureVerificationInfo", [
            deviceForm.changJsonForm(), featureForm.changJsonForm(), frameParam ]);
    if (null == operResult)
    {
        return;
    }

    if (null != operResult)
    {
        var verifications = new Verifications();
        verifications.init(operResult.list);
        g_verifyInfo = verifications;
    }

    return g_verifyInfo;
}

/**
 * 获取硬件规格差异
 * 
 * @returns {DataCacheMgr}
 */
function pub_getHardSpecDiffDataCacheMgr()
{
    return g_HardSpecDiffDataCacheMgr;
}

/**
 * 初始化全局配置数据
 */
function initSystemConfigDataMgr()
{
    g_SystemConfigDataMgr.init();
}

/**
 * 获取全局配置选项信息
 * 
 */
function pub_getSystemConfigDataMgr()
{
    return g_SystemConfigDataMgr;
}

/**
 * 获取支持包信息
 */
function pub_getClonePnpForm()
{
    return g_pnpForm;
}

/**
 * 获取json对象接口
 * @author w00131173
 */
function pub_getJsonRpcObj()
{
    if(null == g_jsonrpc)
    {
        g_jsonrpc = new VmtJsonRPC();
    }
    
    return g_jsonrpc;
}

/**
 * 重新初始化json对象接口（无论之前是否初始化过，进行重新初始化操作，
 * 提供给预加载打开网元管理器时重新注册json对象，防止后台重启出错）
 * @author w00131173
 */
function reInitJsonRpcObj()
{
    g_jsonrpc = new VmtJsonRPC();
}

Event.observe(window, "load", init);