/**
 * 修改树表初始化表格操作类
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-5-14
 * @param treeTable
 * @param tableModel
 * @param checkBox
 */
function E2EModifiedTreeInitOper(treeTable, treeModel, treeTableStatus, linkageCtrl, focusOper, guiCustomizeProcessor,
        dataCtrl, configCtrl)
{
    this._dataCtrl = dataCtrl;
    this._configCtrl = configCtrl;
    ModifiedTreeInitOper.call(this, treeTable, treeModel, treeTableStatus, linkageCtrl, focusOper,
            guiCustomizeProcessor);
    this._viewType = OperViewType.MODIFY_VIEW;

    this._xpathMappingInfo = null;
}

E2EModifiedTreeInitOper.prototype = new ModifiedTreeInitOper();

/**
 * 设置初始化参数的值
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EModifiedTreeInitOper.prototype.setXpathMappingInfo = function(xpathMappingInfo)
{
    this._xpathMappingInfo = xpathMappingInfo;
}
//
// /**
// * 设置初始化参数的值
// *
// * @author w00131173
// * @since iManager U2000 V1R7,2012-5-23
// */
// E2EModifiedTreeInitOper.prototype.setInitParamInfo = function(initParamInfo, xpathMappingInfo)
// {
// this._xpathMappingInfo = xpathMappingInfo;
//
// var xpathMappingAttribues = xpathMappingInfo.attributeInfos.list;
//
// var initInfo = new Map();
// var initParams = initParamInfo.split("@nmsname_value@");
// for ( var num = 0; num < initParams.length; num += 2)
// {
// var nmsname = initParams[num];
// var value = initParams[num + 1];
//
// if ((null == nmsname) || ("" == nmsname))
// {
// continue;
// }
// var xpath = null;
// for ( var index in xpathMappingAttribues)
// {
// var xpathMappingAttribue = xpathMappingAttribues[index];
// if (xpathMappingAttribue.nmsname == nmsname)
// {
// xpath = xpathMappingAttribue.xpath;
//
// if ("true" == xpathMappingAttribue.isEnum)
// {
// var enumInfos = xpathMappingAttribue.enumInfos.map;
// value = enumInfos[value];
// }
// }
// }
// initInfo.put(xpath, value);
//
// }
//
// this._initParamInfo = initInfo;
// }

/**
 * 根据nmsName获取Xpath
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EModifiedTreeInitOper.prototype.getXpathByNmsname = function(nmsname)
{
    var xpathMappingAttribues = this._xpathMappingInfo.attributeInfos.list;

    var xpath = "";

    for ( var index in xpathMappingAttribues)
    {
        if (xpathMappingAttribues[index].nmsname == nmsname)
        {
            xpath = xpathMappingAttribues[index].xpath;
            return xpath;
        }
    }
    return xpath;
}

/**
 * 根据nmsName获取Xpath
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EModifiedTreeInitOper.prototype.getEnumNmsnameByXpath = function(value, attributeNmsname)
{
    var xpathMappingAttribues = this._xpathMappingInfo.attributeInfos.list;

    var enumNmsName = "";

    for ( var index in xpathMappingAttribues)
    {
        if (xpathMappingAttribues[index].nmsname == attributeNmsname)
        {
            var enumInfoMap = xpathMappingAttribues[index].enumInfos.map;
            for ( var key in enumInfoMap)
            {
                var enumXpath = enumInfoMap[key];
                var enumValues = enumXpath.split("/");
                var enumValue = enumValues[2];
                if (value == enumValue)
                {
                    enumNmsName = key;
                    break;
                }
            }

        }
    }
    return enumNmsName;
}

/**
 * 初始化树表
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EModifiedTreeInitOper.prototype.initTableTreeView = function(featureData, jsonRowKey)
{
    logger.log("enter ModifiedTreeInitOper initTableTreeView()");

    this._treeTable.removeAllRows();
    this._treeTable.setTableWidth();
    this.setValueColumnIds();
    
    var featureForm = featureData.getFeatureForm();
    var frameForm = featureData.getFrameParam();
    var deviceForm = featureData.getDeviceForm();
    this.jsonInitTreeTableView(deviceForm, featureForm, frameForm, jsonRowKey);
}

/**
 * 在打开树表配置对话框的时候预先初始化树表界面
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EModifiedTreeInitOper.prototype.preJsonInitTreeTableView = function(paramMap)
{
    logger.log("start treeoperation.js preJsonInitTreeTableView.");
    this._timeOut = this._timeOut - 1;

    this.requestOperResult(paramMap);
    this.doOperResult(this._operResult);
    var parentIntTreeTableViewOper = new ModifiedTreeInitOper();

    var isAlreadyStartGetOperResult = (null != parentIntTreeTableViewOper);
    if ((!isAlreadyStartGetOperResult) || (this._timeOut < 0))
    {
        this.requestOperResult(paramMap);
        this.doOperResult(this._operResult);
        return;
    }
    this._operResult = parentIntTreeTableViewOper.getOperResult();
    if (null != this._operResult)
    {
        this.doOperResult(this._operResult);
        logger.log("end treeoperation.js preJsonInitTreeTableView.");
        return;
    }
}

/**
 * 请求树表界面初始化操作对象,采用同步请求
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 * @param paramMap 参数映射表
 */
E2EModifiedTreeInitOper.prototype.requestOperResult = function(paramMap)
{
    logger.log("start ModifiedTreeInitOper jsonInitTreeTableView()");
    var deviceForm = paramMap.get("deviceForm");
    var featureForm = paramMap.get("featureForm");
    var frameForm = paramMap.get("frameForm");
    var rowKey = paramMap.get("rowKey");
    this._operResult = jsonrpc.invoke("rmodifyTreeTableFactory", "generateInitView", [ deviceForm, featureForm,
            frameForm, rowKey, null ]);
}

/**
 * 处理获取到的内容
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EModifiedTreeInitOper.prototype.doOperResult = function(operResult)
{
    logger.log("end ModifiedTreeInitOper jsonInitTreeTableView()");

    if (operResult != null && operResult.resultType != GlobalConstants.OPER_OK)
    {
        CommonDlgReq.openRspErrorDialog(operResult, this.clickCancelBtn, this);
    }
    else
    {
        this.doSuccessResult(operResult);
    }
}

/**
 * 点击取消按钮事件处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EModifiedTreeInitOper.prototype.clickCancelBtn = function()
{
    // 重置URL，通知关闭对话框
    var url = E2EBUTTONURL.CANCELURL;
    document.location = url;

}

// ///////////////////////////////////////////
/**
 * E2E修改配置表格的下发操作类
 */
function E2EModifiedTreeSendOper(treeTable, treeModel, featureData, modelNodeCloneStrategy, modelChecker, dataCtrl,
        currentSelection)
{
    ModifiedTreeSendOper.call(this, treeTable, treeModel, featureData, modelNodeCloneStrategy, modelChecker,
            currentSelection);
}

/**
 * 继承TreeTableSendOper
 */
E2EModifiedTreeSendOper.prototype = new ModifiedTreeSendOper();

/**
 * 将数据下发给后台
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EModifiedTreeSendOper.prototype.sendJsonDataToServer = function(deviceForm, featureForm, frameForm, jNodes, jLabels)
{
    var operResult = jsonrpc.invoke("modifyConfigProcessor", "commitConfig", [ deviceForm, featureForm, frameForm,
            this._currentSelection, jNodes, jLabels, null, null ]);
    return operResult;
}

/**
 * 下发数据
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EModifiedTreeSendOper.prototype.sendConfigData = function()
{
    var operResult = this.jsonCommitConfig();
    if (operResult != null && operResult.resultType != GlobalConstants.OPER_OK)
    {
        CommonDlgReq.openRspErrorDialog(operResult, null, null);
        return false;
    }

    return true;
}

// //////////////////////////////////////////////////////////////////
/**
 * 树表查询操作类
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-5-14
 */
function E2ETreeTableQueryNode(treeTable, treeModel, treeTableStatus, createOper, featureData, linkageCtrl,
        guiCustomizeProcessor)
{
    TreeTableQueryNode.call(this, treeTable, treeModel, treeTableStatus, createOper, featureData, linkageCtrl,
            guiCustomizeProcessor);
}

/**
 * 继承TreeTableQueryNode
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-13
 */
E2ETreeTableQueryNode.prototype = new TreeTableQueryNode();

/**
 * 从设备上查询该条记录所有的子
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-13
 * @param 行ID
 */
E2ETreeTableQueryNode.prototype.queryNode = function(nodeListId, rowKeys)
{
    var featureForm = this._featureData.getFeatureForm().clone();
    var deviceForm = this._featureData.getDeviceForm();
    var frameForm = this._featureData.getFrameParam();
    this._dealQueryNode(deviceForm, featureForm, frameForm, nodeListId, rowKeys);
}

// ////////////////////////////////////////////////////
/**
 * 树表查询操作类
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-5-14
 * @param treeTable
 * @param tableModel
 * @param checkBox
 */
function E2ETreeTableQueryAllNode(treeTable, treeModel, treeTableStatus, linkageCtrl, guiCustomizeProcessor)
{
    TreeTableQueryAllNode.call(this, treeTable, treeModel, treeTableStatus, linkageCtrl, guiCustomizeProcessor);
}

/**
 * 继承TreeTableQueryOperation
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-4-13
 */
E2ETreeTableQueryAllNode.prototype = new TreeTableQueryAllNode();

/**
 * 向后台查询所有未展开过的结点
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-4-19
 */
E2ETreeTableQueryAllNode.prototype.queryAllNode = function(featureData, rowKey)
{
    var deviceForm = featureData.getDeviceForm()
    var featureForm = featureData.getFeatureForm();
    var frameForm = featureData.getFrameParam();
    this._dealQueryAllNode(deviceForm, featureForm, frameForm, rowKey);
}