/*
 * Title:         主要是用于修改配置配置界面的各种操作
 * Description:  [描述文件的功能、作用、使用方法和注意事项]
 * Copyright:     Copyright (c) 1988-2015
 * Company:       Huawei Tech. Co., Ltd
 * @author        w00131173
 * @version        版本  2010-4-13
 */

/**
 * E2E调用的修改界面中的事件控制处理类
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
function E2EModifyCfgController()
{
    ModifyCfgController.call(this);

    this._xpathMappingInfo = null;
}

/**
 * E2EModifyCfgController继承类ModifyCfgController
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EModifyCfgController.prototype = new ModifyCfgController();

/**
 * 设置行key信息
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EModifyCfgController.prototype.setRowKeys = function(rowKey)
{
    this._rowKey = rowKey;
}

/**
 * 设置XpathMapping信息
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EModifyCfgController.prototype.setXpathMappingInfo = function(xpathMappingInfo)
{
    this._xpathMappingInfo = xpathMappingInfo;
}

/**
 * 初始化树表
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-4-13
 * @override
 */
E2EModifyCfgController.prototype.initTableTree = function()
{
    logger.log("enter ModifyCfgController initTableTree()");
    // this._rowKey = this._dataCtrl.getTableModel().getCurrentSelectRowKey();
    var focuseOper = new NoKeyDefaultFocusOper(this._treeTable, this._treeModel, this._refSelectControler,
            this._treeTableStatus, this._treeTable.VALUECOLID);
    this._initTreeTableView = new E2EModifiedTreeInitOper(this._treeTable, this._treeModel, this._treeTableStatus,
            this._linkageCtrl, focuseOper, this._guiCustomizeProcessor, this._dataCtrl, this);
    this._initTreeTableView.setHardDiffCtrl(this.getHardDiffCtrl());
    this._initTreeTableView.setProgressBarCtrl(this._advProgressBarCtrl);
    this._initTreeTableView.setXpathMappingInfo(this._xpathMappingInfo);
    this._initTreeTableView.initTableTreeView(this._featureData, this._rowKey);
}

/**
 * 获取界面返回值
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EModifyCfgController.prototype.getReturnNmsnameValues = function()
{
    var returnValue = "";
    if ("" != g_E2E_returnNmsnames)
    {
        var returnNmsnams = g_E2E_returnNmsnames.split("@nmsname_value@");

        var allRowIds = this._treeTable.getAllRowIds();
        var colId = "value";
        var returnkey = "";
        for ( var num = 0; num < returnNmsnams.length - 1; num++)
        {
            // 获取nmsname对应的Xpath
            var returnNmsname = returnNmsnams[num];
            var xpath = this._initTreeTableView.getXpathByNmsname(returnNmsname);
            var tempreturnValue = returnNmsname + "@nmsname@";
            var isFind = false;
            for ( var rowNum = 0; rowNum < allRowIds.length; rowNum++)
            {
                var rowId = allRowIds[rowNum];
                var rowXpath = ConfigUtil.getNodeXpath(rowId, SEPARATOR_XPATH_LABEL);

                if (xpath == rowXpath)
                {
                    var value = this._treeTable.getCellValue(rowId, colId);
                    var cell = this._treeTable.getCell(rowId, colId);

                    if (cell.type == jse.COMBO)
                    {
                        value = this._initTreeTableView.getEnumNmsnameByXpath(value, returnNmsname);
                    }
                    tempreturnValue = tempreturnValue + value + "@nmsname_value@";
                    isFind = true;
                }
            }
            if (isFind)
            {
                returnValue = returnValue + tempreturnValue + "@nmsname_valueList@";
            }
        }
    }

    return returnValue;
}

/**
 * 关闭对话框调用方法
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EModifyCfgController.prototype.closeSelfView = function()
{
    if (null != this._initTreeTableView && "undefine" != this._initTreeTableView.stopWorkFlow)
    {
        this._initTreeTableView.stopWorkFlow();
    }

    // 重置URL，并将用户需要的数据返回去
    var url = E2EBUTTONURL.OKURL;
    document.location = url;
}

/**
 * 点击"确定"按钮时的事件处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-13
 * @param featureData 特性信息
 * @override
 */
E2EModifyCfgController.prototype.clickOkBtn = function()
{
    // 下发数据
    if (this.sendConfigData())
    {
        this.closeSelfView();
    }
}

/**
 * 点击取消按钮事件处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EModifyCfgController.prototype.clickCancelBtn = function()
{
    // 重置URL，通知关闭对话框
    var url = E2EBUTTONURL.CANCELURL;
    document.location = url;

}

/**
 * 下发数据
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EModifyCfgController.prototype.sendConfigData = function()
{
    if (null == this._sendConfigOperation)
    {
        var modelChecker = this._verifyCtrl.createModifyNullAndKeyChecker();
        var modelNodeCloneStrategy = new CloneModifidAndKeyAttriStrategy(this._treeTable, this._treeModel,
                this._treeTable.VALUECOLID);
        this._sendConfigOperation = new E2EModifiedTreeSendOper(this._treeTable, this._treeModel, this._featureData,
                modelNodeCloneStrategy, modelChecker, this._dataCtrl, this._rowKey);
    }

    return this._sendConfigOperation.checkDataAndSendConfig(this._linkageCtrl, this, this.selectChange);
}

/**
 * 全部展开事件处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R3,2010-4-18
 */
E2EModifyCfgController.prototype.expandAll = function()
{
    if (null == this._queryAllOperation)
    {
        this._queryAllOperation = new E2ETreeTableQueryAllNode(this._treeTable, this._treeModel, this._treeTableStatus,
                this._linkageCtrl, this._guiCustomizeProcessor);
        this._queryAllOperation.setHardDiffCtrl(this.getHardDiffCtrl());
        this._queryAllOperation.setProgressBarCtrl(this._advProgressBarCtrl);
    }

    this._queryAllOperation.queryAllNode(this._featureData, this._rowKey)
}

/**
 * 初始化查询节点操作类
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-4-13
 * @param nodeListId 节点列表ID
 */
E2EModifyCfgController.prototype.initQueryNodeOper = function(nodeListId,isSearch)
{
    if (null == this._queryOperation)
    {
        if (null == this._createOperation)
        {
            this._createOperation = new ModifiedTreeCreateOper(this._treeTable, this._treeModel, this._treeTableStatus,
                this._linkageCtrl, this._guiCustomizeProcessor);
            this._createOperation.setHardDiffCtrl(this.getHardDiffCtrl());
        }
        this._queryOperation = new E2ETreeTableQueryNode(this._treeTable, this._treeModel, this._treeTableStatus,
                this._createOperation, this._featureData, this._linkageCtrl, this._guiCustomizeProcessor);
        this._queryOperation.setHardDiffCtrl(this.getHardDiffCtrl());
    }
    if(isSearch)
    {
        this._queryOperation.setProgressBarCtrl(null);
    }
    else
    {
        //如果不是，使用进度条
        this._queryOperation.setProgressBarCtrl(this._advProgressBarCtrl);   
    }
    this._queryOperation.queryNode(nodeListId, this._rowKey);
}