/**
 * E2E调用界面新建树表初始化表格操作类
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
function E2EAddedTreeInitOper(treeTable, treeModel, treeTableStatus, linkageCtrl, focusOper, guiCustomizeProcessor,
        dataCtrl, configCtrl, verifyCtrl)
{
    AddedTreeInitOper.call(this, treeTable, treeModel, treeTableStatus, linkageCtrl, focusOper, guiCustomizeProcessor,
            dataCtrl, configCtrl);
    this._verifyCtrl = verifyCtrl;
    this._jsonQueridNodes = null;

    this._initParamInfo = null;
    this._xpathMappingInfo = null;
}

/**
 * 继承AddedTreeInitOper
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EAddedTreeInitOper.prototype = new AddedTreeInitOper();

/**
 * 设置初始化参数的值
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EAddedTreeInitOper.prototype.setInitParamInfo = function(initParamInfo, xpathMappingInfo)
{
    this._xpathMappingInfo = xpathMappingInfo;

    var xpathMappingAttribues = xpathMappingInfo.attributeInfos.list;

    var initInfo = new Map();
    var initParams = initParamInfo.split("@nmsname_value@");
    for ( var num = 0; num < initParams.length; num += 2)
    {
        var nmsname = initParams[num];
        var value = initParams[num + 1];

        if ((null == nmsname) || ("" == nmsname))
        {
            continue;
        }
        var xpath = null;
        for ( var index in xpathMappingAttribues)
        {
            var xpathMappingAttribue = xpathMappingAttribues[index];
            if (xpathMappingAttribue.nmsname == nmsname)
            {
                xpath = xpathMappingAttribue.xpath;

                if ("true" == xpathMappingAttribue.isEnum)
                {
                    var enumInfos = xpathMappingAttribue.enumInfos.map;
                    value = enumInfos[value];
                }
            }
        }
        initInfo.put(xpath, value);
    }
    this._initParamInfo = initInfo;

}

/**
 * 根据nmsName获取Xpath
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EAddedTreeInitOper.prototype.getXpathByNmsname = function(nmsname)
{
    var xpathMappingAttribues = this._xpathMappingInfo.attributeInfos.list;

    var xpath = "";

    for ( var index in xpathMappingAttribues)
    {
        if (xpathMappingAttribues[index].nmsname == nmsname)
        {
            xpath = xpathMappingAttribues[index].xpath;
            return xpath;
        }
    }
    return xpath;
}

/**
 * 根据nmsName获取Xpath
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EAddedTreeInitOper.prototype.getEnumNmsnameByXpath = function(value, attributeNmsname)
{
    var xpathMappingAttribues = this._xpathMappingInfo.attributeInfos.list;

    var enumNmsName = "";

    for ( var index in xpathMappingAttribues)
    {
        if (xpathMappingAttribues[index].nmsname == attributeNmsname)
        {
            var enumInfoMap = xpathMappingAttribues[index].enumInfos.map;

            for ( var key in enumInfoMap)
            {
                var enumXpath = enumInfoMap[key];
                var enumValues = enumXpath.split("/");
                var enumValue = enumValues[2];
                if (value == enumValue)
                {
                    enumNmsName = key;
                    break;
                }
            }

        }
    }
    return enumNmsName;
}

/**
 * 初始化结点属性可见性,此方法仅供E2E调用页面进行覆盖实现
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EAddedTreeInitOper.prototype._initViewParamValue = function()
{
    // 对表中数据执行以下赋值操作
    var xpaths = this._initParamInfo.getKeys();
    var allRowIds = this._treeTable.getAllRowIds();
    var columnIds = this._treeTable.getAllColumnIds();
    columnIds.splice(0, 2);
    var colId = columnIds[0];
    for ( var rowNum = 0; rowNum < allRowIds.length; rowNum++)
    {
        var rowId = allRowIds[rowNum];
        var xpath = ConfigUtil.getNodeXpath(rowId, SEPARATOR_XPATH_LABEL);
        var value = this._initParamInfo.get(xpath);
        if (null != value)
        {
            // 初始化设置单元格的值
            var cell = this._treeTable.getCell(rowId, colId);
            if (cell.type == jse.COMBO)
            {
                var values = value.split("/");
                this._treeTable.setCellValue(rowId, colId, values[2]);
            }
            else
            {
                this._treeTable.setCellValue(rowId, colId, value);
            }
        }
    }
}

/**
 * 加载树表结束后的操作
 * 
 * @author z00133566
 * @since iManager U2000 V2R2,2014-3-18
 */
E2EAddedTreeInitOper.prototype.postDoGetTreeTable = function()
{    
    if (null != this._focusOper) 
    {
        this._focusOper.setDefaultFocus();
    }
    // 设置后续的操作为非初始化界面操作
    this._linkageCtrl.setIsDoloadInitOper(false);

}

/**
 * 在打开树表配置对话框的时候预先初始化树表界面
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EAddedTreeInitOper.prototype.preJsonInitTreeTableView = function(paramMap)
{
    logger.log("start treeoperation.js preJsonInitTreeTableView.");
    this._timeOut = this._timeOut - 1;
    this.requestOperResult(paramMap);
    this.doOperResult(this._operResult);

    var parentIntTreeTableViewOper = new AddedTreeInitOper();

    var isAlreadyStartGetOperResult = (null != parentIntTreeTableViewOper);
    if ((!isAlreadyStartGetOperResult) || (this._timeOut < 0))
    {
        this.requestOperResult(paramMap);
        this.doOperResult(this._operResult);
        return;
    }
    this._operResult = parentIntTreeTableViewOper.getOperResult();
    if (null != this._operResult)
    {
        this.doOperResult(this._operResult);
        logger.log("end treeoperation.js preJsonInitTreeTableView.");
        return;
    }

}

// ////////////////////////////////////////////////////////////////////////////////
/**
 * E2E树表查询操作类
 */
function E2EAddedTreeSendOper(treeTable, treeModel, featureData, modelNodeCloneStrategy, modelChecker, dataCtrl,columnInfos)
{
    TreeTableSendOper.call(this, treeTable, treeModel, featureData, modelNodeCloneStrategy, modelChecker);
    this._dataCtrl = dataCtrl;
    this._columnInfos = columnInfos;
}

/**
 * 继承TreeTableSendConfig
 */
E2EAddedTreeSendOper.prototype = new TreeTableSendOper();

/**
 * E2E新建下发数据
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EAddedTreeSendOper.prototype.sendConfigData = function()
{
    var operResult = this.jsonCommitConfig();
    if (operResult != null && operResult.resultType != GlobalConstants.OPER_OK
            && operResult.resultType != GlobalConstants.OPER_POK)
    {
        CommonDlgReq.openRspErrorDialog(operResult, null, null);
        return false;
    }

    if (operResult.resultType == GlobalConstants.OPER_POK)
    {
        CommonDlgReq.openRspErrorDialog(operResult, null, null);
        return false;
    }

    return true;
}

/**
 * E2E新建配置表格的下发操作
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EAddedTreeSendOper.prototype.jsonCommitConfig = function()
{
    var nodes = this._modelNodeCloneStrategy.getModelCloneNodes();
    var jNodes = JsonUtil.changJsonList(nodes);
    var jLabels = JsonUtil.changJsonList(this._commitLabels.getNodeLabels());
    var featureForm = this._featureData.getFeatureForm();
    var frameForm = this._featureData.getFrameParam();
    var deviceForm = this._featureData.getDeviceForm();
    return jsonrpc.invoke("createConfigProcessor", "commitConfigWithRelatedTable", [ deviceForm, featureForm, deviceForm, null, jNodes,
            jLabels, null, this._columnInfos ]);
}
