/*
 * Title:         主要是用于修改配置、拷贝新建配置界面的各种操作
 * Description:  [描述文件的功能、作用、使用方法和注意事项]
 * Copyright:     Copyright (c) 1988-2015
 * Company:       Huawei Tech. Co., Ltd
 * @author        w00131173
 * @version        版本  2010-4-13
 */

/**
 * E2E调用的新建界面中的事件控制处理类
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
function E2EAddCfgController()
{
    ConfigController.call(this);

    this._initParamInfo = null;

    this._xpathMappingInfo = null;
    
    this._columnInfos = null;
}

/**
 * E2EAddCfgController继承类ConfigController
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EAddCfgController.prototype = new ConfigController();

/**
 * 设置初始化参数的值
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EAddCfgController.prototype.setInitParamInfo = function(initParamInfo)
{
    // TODO 需要将信息转换成一个Map：xpath以及对应值的处理

    this._initParamInfo = initParamInfo;
}

/**
 * 设置列信息
 */
E2EAddCfgController.prototype.setColumnInfos = function(columnInfos)
{
    this._columnInfos = columnInfos;
}

/**
 * 设置XpathMapping信息
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EAddCfgController.prototype.setXpathMappingInfo = function(xpathMappingInfo)
{
    this._xpathMappingInfo = xpathMappingInfo;
}

/**
 * 点击取消按钮事件处理
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EAddCfgController.prototype.clickCancelBtn = function()
{
    // 重置URL，通知关闭对话框
    var url = E2EBUTTONURL.CANCELURL;
    document.location = url;

}

/**
 * 关闭对话框调用方法
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EAddCfgController.prototype.closeSelfView = function()
{
    if (null != this._initTreeTableView && "undefine" != this._initTreeTableView.stopWorkFlow)
    {
        this._initTreeTableView.stopWorkFlow();
    }

    // 获取用户需要的返回值
    var returnValue = this.getReturnNmsnameValues();

    // 重置URL，并将用户需要的数据返回去
    var url = E2EBUTTONURL.OKURL + returnValue;
    document.location = url;
}

/**
 * 获取界面返回值
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EAddCfgController.prototype.getReturnNmsnameValues = function()
{
    var returnValue = "";
    if ("" != g_E2E_returnNmsnames)
    {
        var returnNmsnams = g_E2E_returnNmsnames.split("@nmsname_value@");

        var allRowIds = this._treeTable.getAllRowIds();
        var colId = "value";
        var returnkey = "";
        for ( var num = 0; num < returnNmsnams.length - 1; num++)
        {
            // 获取nmsname对应的Xpath
            var returnNmsname = returnNmsnams[num];
            var xpath = this._initTreeTableView.getXpathByNmsname(returnNmsname);
            var tempreturnValue = returnNmsname + "@nmsname@";
            var isFind = false;
            for ( var rowNum = 0; rowNum < allRowIds.length; rowNum++)
            {
                var rowId = allRowIds[rowNum];
                var rowXpath = ConfigUtil.getNodeXpath(rowId, SEPARATOR_XPATH_LABEL);

                if (xpath == rowXpath)
                {
                    var value = this._treeTable.getCellValue(rowId, colId);
                    var cell = this._treeTable.getCell(rowId, colId);

                    if (cell.type == jse.COMBO)
                    {
                        value = this._initTreeTableView.getEnumNmsnameByXpath(value, returnNmsname);
                    }
                    tempreturnValue = tempreturnValue + value + "@nmsname_value@";
                    isFind = true;
                }
            }
            if (isFind)
            {
                returnValue = returnValue + tempreturnValue + "@nmsname_valueList@";
            }
        }
    }

    return returnValue;
}

/**
 * 初始化树表
 * 
 * @author w00131173
 * @since iManager U2000 V1R7,2012-5-23
 */
E2EAddCfgController.prototype.initTableTree = function()
{
    var focuseOper = new DefaultFocusOper(this._treeTable, this._treeModel, this._refSelectControler,
            this._treeTableStatus, this._treeTable.VALUECOLID);

    this._initTreeTableView = new E2EAddedTreeInitOper(this._treeTable, this._treeModel, this._treeTableStatus,
            this._linkageCtrl, focuseOper, this._guiCustomizeProcessor);
    this._initTreeTableView.setHardDiffCtrl(this.getHardDiffCtrl());
	this._initTreeTableView.setAutofillCtrl(this.getAutofillCtrl());
    this._initTreeTableView.setProgressBarCtrl(this._advProgressBarCtrl);
    this._initTreeTableView.setInitParamInfo(this._initParamInfo, this._xpathMappingInfo);

    this._initTreeTableView.initTableTreeView(this._featureData);

}

/**
 * 树表内属性行的值发生变化
 * 
 * @author f00145226
 * @since iManager U2000 V1R3,2010-4-6
 * @param rowId 值发生变化的行Id
 */
E2EAddCfgController.prototype.sendConfigData = function()
{
    if (null == this._sendConfigOperation)
    {
        var modelChecker = this._verifyCtrl.createNullAndKeyChecker();
        var modelNodeCloneStrategy = new SingleModelCreateStrategy(this._treeTable, this._treeModel,
                this._treeTable.VALUECOLID);
        this._sendConfigOperation = new E2EAddedTreeSendOper(this._treeTable, this._treeModel, this._featureData,
                modelNodeCloneStrategy, modelChecker, this._dataCtrl,this._columnInfos);
    }

    return this._sendConfigOperation.checkDataAndSendConfig(this._linkageCtrl, this, this.selectChange);
}